package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 *  Contains information describing the full power supply state.
 *
 *  Sent on the status bus upon request.
 *
 *  @author Owen Saxton
 */
public class UtilityFullState implements Serializable {
    
    private final UtilityState utilityState;
    private final MonitorFullState monitorState;

    public UtilityFullState(UtilityState uState, MonitorFullState mState) {
        utilityState = uState;
        monitorState = mState;
    }

    public UtilityState getUtilityState() {
        return utilityState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = 6398249709087365851L;
}
