import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation
import org.lsst.ccs.subsystem.rafts.RaftsMain
import org.lsst.ccs.subsystem.rafts.REBDevice
import org.lsst.ccs.subsystem.rafts.DacControl
import org.lsst.ccs.subsystem.rafts.AspicControl
import org.lsst.ccs.subsystem.rafts.BiasControl
import org.lsst.ccs.subsystem.rafts.GlobalProc
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.utilities.ccd.*
import org.lsst.ccs.utilities.image.*
import org.lsst.ccs.subsystem.ts8.TS8Subsystem
import org.lsst.ccs.subsystem.ts8.sim.*
import org.lsst.ccs.subsystem.ts8.sim.TS8ClientFactorySimulation
import org.lsst.ccs.subsystem.rafts.TestClientFactorySimulator
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.drivers.reb.ClientFactory
import org.lsst.ccs.drivers.reb.SlowAdcs
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.daq.utilities.FitsService

CCDType type = new ITLCCDType()

raftGeometry = new Raft(type)
reb0 = Reb.createReb(type)
raftGeometry.addChildGeometry(reb0, 0, 0)


Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal")
System.out.println("Building TS8 test in run mode: "+runMode)


taskConfig = ["monitor-update/taskPeriodMillis":1000,"monitor-publish/taskPeriodMillis":10000,
            "agentStatusAggregatorService/patternConfigList":[
                "[pattern:.*,predicate:[agentName:ts],alias:teststand]",
                "[pattern:.*,predicate:[agentName:${System.getProperty('org.lsst.ccs.subsystem.rebps', 'ccs-rebps')}]]",
                "[pattern:.*,predicate:[agentName:${System.getProperty('org.lsst.ccs.subsystem.ts8', 'ts8')}]]",
                "[pattern:.*,predicate:[agentName:${System.getProperty('org.lsst.ccs.subsystem.ts8-bench', 'ts8-bench')}]]"
                ]]


ClientFactory mainClientFactory = runMode.equals("simulation") ? new ClientFactorySimulation() : new ClientFactory();

CCSBuilder builder = ["ts8_tests"]
builder.
    "main" (TS8Subsystem, geometry:raftGeometry, clientFactory:mainClientFactory, nodeTags:taskConfig) { 
    
        globalProc(GlobalProc, partition: "", dfltFolder: "")
    
        for (Reb rebGeometry : raftGeometry.getChildrenList() ) {
            def rebCount = rebGeometry.getParallelPosition();
            def reb = rebGeometry.getUniqueId();
            def dreb = "D$reb"
            
            "${reb}.fitsService" (FitsService, headerFilesList:["primary:primary", "extended", "reb_cond", "test_cond"])

//            clientFactory = runMode.equals("simulation") ? new TS8ClientFactorySimulation(rebGeometry) : null;
            clientFactory = runMode.equals("simulation") ? new TestClientFactorySimulator() : null;

            "$reb" (REBDevice, hdwType:"daq1", id:rebCount, ifcName:"", clientFactory:clientFactory) {

            "${reb}.DAC" (DacControl)    // All REBs, physical values

            
            for (int j = 0; j < 6; j++) {
                def apc = "ASPIC$j"
                //"${reb}.${apc}" (AspicControl, description: "", hwChan: j, gain: 0, rc: 0, clamp: 0, af1: 0, tm: 0)
                "${reb}.${apc}" (AspicControl, hwChan: j)
            }

            for (int j = 0; j < 3; j++) {
                //"${reb}.Bias$j" (BiasControl, hwChan: j, raw: true)   // All REBs. raw DAC values
                "${reb}.Bias$j" (BiasControl, hwChan: j)   // All REBs, physical values
            }
        }

        for (int j = 1; j <= 2; j++) {
                "${dreb}.Temp$j" (Channel, description: "${dreb} temperature $j", units: "\u00b0C",
                        devcName: "${reb}", hwChan: j - 1, type: "TEMP")
        }

        for (int j = 1; j <= 8; j++) {
                "${reb}.Temp$j" (Channel, description: "${reb} temperature $j", units: "\u00b0C",
                        devcName: "${reb}", hwChan: j + 1, type: "TEMP")
        }
                
        "${dreb}.6Vv"   (Channel, description: "${dreb} 6V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:0, type: "POWER")
                    
        "${dreb}.6Vi"   (Channel, description: "${dreb} 6V current", units: "Amps",
                        devcName: "${reb}", hwChan:1, type: "POWER")
                    
        "${dreb}.9Vv"   (Channel, description: "${dreb} 9V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:2, type: "POWER")
                    
        "${dreb}.9Vi"   (Channel, description: "${dreb} 9V current", units: "Amps",
                        devcName: "${reb}", hwChan:3, type: "POWER")
                         
        "${dreb}.24Vv"  (Channel, description: "${dreb} 24V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:4, type: "POWER")

        "${dreb}.24Vi"  (Channel, description: "${dreb} 24V current", units: "Amps",
                        devcName: "${reb}", hwChan:5, type: "POWER")
                    
        "${dreb}.40Vv"  (Channel, description: "${dreb} 40V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:6, type: "POWER")

        "${dreb}.40Vi"  (Channel, description: "${dreb} 40V current", units: "Amps",
                        devcName: "${reb}", hwChan:7, type: "POWER")

        }
         
     }

