/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.HashMap;
import java.util.Properties;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.classname.ClassComponentNodeFactory;
import org.lsst.ccs.description.groovy.GroovyComponentNodeFactory;

public class ComponentNodeBuilder {
    private static final HashMap<String, ComponentNodeFactory> factories = new HashMap();

    private ComponentNodeBuilder() {
    }

    public static void registerComponentNodeFactory(ComponentNodeFactory factory) {
        factories.put(factory.getProtocol(), factory);
    }

    public static ComponentLookup buildComponentNode(String fullDescription) {
        return ComponentNodeBuilder.buildComponentNode(fullDescription, null, new Properties());
    }

    public static ComponentLookup buildComponentNode(String fullDescription, String startupConfig, Properties props) {
        ComponentNodeFactory factory;
        String descriptionProtocol = "groovy";
        String descriptionString = fullDescription;
        if (fullDescription.contains(":")) {
            descriptionProtocol = fullDescription.substring(0, fullDescription.indexOf(58));
            descriptionString = fullDescription.substring(fullDescription.indexOf(58) + 1);
        }
        if ((factory = factories.get(descriptionProtocol)) == null) {
            throw new IllegalArgumentException("There is no registered ComponentNodeFactory for protocol " + descriptionProtocol);
        }
        ComponentLookup lookup = factory.buildComponentNode(descriptionString, props);
        lookup.getTopComponentNode().addTag("descriptionName", descriptionString);
        lookup.getTopComponentNode().addTag("startupConfig", startupConfig);
        return lookup;
    }

    static {
        ComponentNodeBuilder.registerComponentNodeFactory(new GroovyComponentNodeFactory());
        ComponentNodeBuilder.registerComponentNodeFactory(new ClassComponentNodeFactory());
    }

    public static interface ComponentNodeFactory {
        public ComponentLookup buildComponentNode(String var1, Properties var2);

        public String getProtocol();
    }
}

