/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class FitsHeaderUtilities {
    private static String pair(String a, String b) {
        return "[" + a + "," + b + "]";
    }

    private static String range(int a, int b) {
        return a + ":" + b;
    }

    public static ImageSet createImageSetForCCD(CCD ccd) {
        CCDType type = ccd.getType();
        ReadOutParameters readOutParameters = new ReadOutParameters(type);
        DefaultImageSet imageSet = new DefaultImageSet(ccd, readOutParameters);
        return imageSet;
    }

    public static Map<String, Object> getCCDPrimaryHeaders(CCD ccd) {
        Geometry raft;
        HashMap<String, Object> primaryMetaData = new HashMap<String, Object>();
        primaryMetaData.put("DETSIZE", FitsHeaderUtilities.getDETSIZE(ccd.getType()));
        primaryMetaData.put("CCDSlot", ccd.getName());
        Geometry reb = ccd.getParent();
        if (reb != null && (raft = reb.getParent()) != null) {
            primaryMetaData.put("RAFTBay", raft.getName());
        }
        return primaryMetaData;
    }

    public static Map<String, Object> getSegmentHeaders(Segment segment, ReadOutParameters readOutParameters) {
        Raft raft;
        HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
        imageMetaData.put("NAXIS", 2);
        imageMetaData.put("NAXIS1", readOutParameters.getSerialReadPixels());
        imageMetaData.put("NAXIS2", readOutParameters.getParallelReadPixels());
        imageMetaData.put("EXTNAME", String.format("Segment%01d%01d", FitsHeaderUtilities.getSegmentParallelPosition(segment), FitsHeaderUtilities.getSegmentSerialPosition(segment)));
        imageMetaData.put("CHANNEL", segment.getChannel());
        imageMetaData.put("CCDSUM", "1 1");
        CCD ccd = (CCD)segment.findParentOfType(CCD.class);
        CCDType type = ccd.getType();
        boolean isE2V = type instanceof E2VCCDType;
        imageMetaData.put("DTM1_1", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("DTM2_2", -1.0 * FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("DTV1", FitsHeaderUtilities.getDTV1(segment, readOutParameters));
        imageMetaData.put("DTV2", FitsHeaderUtilities.getDTV2(segment));
        imageMetaData.put("DETSIZE", FitsHeaderUtilities.getDETSIZE(type));
        imageMetaData.put("DATASEC", FitsHeaderUtilities.pair(FitsHeaderUtilities.range(1 + readOutParameters.getSerialPrescan(), readOutParameters.getSerialPrescan() + type.getCCDGeometryConstants().getSegmentSerialActiveSize()), FitsHeaderUtilities.range(1, type.getCCDGeometryConstants().getSegmentParallelActiveSize())));
        imageMetaData.put("DETSEC", FitsHeaderUtilities.getDETSEC(segment));
        imageMetaData.put("PC1_2A", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1A", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_2C", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1C", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_2R", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1R", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_2F", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1F", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_1B", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC2_2B", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC1_1Q", isE2V ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC2_2Q", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("CRVAL1A", FitsHeaderUtilities.getCRVAL1A(segment));
        imageMetaData.put("CRVAL2A", FitsHeaderUtilities.getCRVAL2A(segment, readOutParameters));
        imageMetaData.put("CRVAL1C", FitsHeaderUtilities.getCRVAL1C(segment));
        imageMetaData.put("CRVAL2C", FitsHeaderUtilities.getCRVAL2C(segment, readOutParameters));
        imageMetaData.put("CRVAL1B", FitsHeaderUtilities.getCRVAL2C(segment, readOutParameters));
        imageMetaData.put("CRVAL2B", FitsHeaderUtilities.getCRVAL1C(segment));
        if (ccd != null && (raft = (Raft)ccd.findParentOfType(Raft.class)) != null) {
            imageMetaData.put("CRVAL1R", FitsHeaderUtilities.getCRVAL1R(segment, ccd, raft));
            imageMetaData.put("CRVAL2R", FitsHeaderUtilities.getCRVAL2R(segment, ccd, raft, readOutParameters));
            imageMetaData.put("CRVAL1Q", FitsHeaderUtilities.getCRVAL2R(segment, ccd, raft, readOutParameters));
            imageMetaData.put("CRVAL2Q", FitsHeaderUtilities.getCRVAL1R(segment, ccd, raft));
            imageMetaData.put("CRVAL1F", FitsHeaderUtilities.getCRVAL1F(segment, ccd, raft));
            imageMetaData.put("CRVAL2F", FitsHeaderUtilities.getCRVAL2F(segment, ccd, raft, readOutParameters));
        }
        return imageMetaData;
    }

    private static int getSegmentParallelPosition(Segment seg) {
        return seg.getParallelPosition();
    }

    private static int getSegmentSerialPosition(Segment seg) {
        return seg.getSerialPosition();
    }

    private static boolean isReadoutDown(Segment seg) {
        return seg.isReadoutDown();
    }

    private static boolean isReadoutLeft(Segment seg) {
        return seg.isReadoutLeft();
    }

    private static double getOneMinusTwoSx(Segment seg) {
        return 1 - 2 * seg.getParallelPosition();
    }

    private static String getDETSIZE(CCDType type) {
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(1, 8 * type.getCCDGeometryConstants().getSegmentSerialActiveSize()), FitsHeaderUtilities.range(1, 2 * type.getCCDGeometryConstants().getSegmentParallelActiveSize()));
    }

    private static double getCRVAL1A(Segment seg) {
        return seg.getParallelPosition() * (((CCD)seg.findParentOfType(CCD.class)).getType().getCCDGeometryConstants().getSegmentParallelActiveSize() + 1);
    }

    private static double getCRVAL2A(Segment seg, ReadOutParameters readOutParameters) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        double sx = seg.getParallelPosition();
        if (type instanceof E2VCCDType) {
            return sx * (double)(type.getCCDGeometryConstants().getSegmentSerialActiveSize() + 1) + (2.0 * sx - 1.0) * (double)readOutParameters.getSerialPrescan();
        }
        return type.getCCDGeometryConstants().getSegmentSerialActiveSize() + 1 - readOutParameters.getSerialPrescan();
    }

    private static double getCRVAL1C(Segment seg) {
        return seg.getParallelPosition() * (2 * ((CCD)seg.findParentOfType(CCD.class)).getType().getCCDGeometryConstants().getSegmentParallelActiveSize() + 1);
    }

    private static double getCRVAL2C(Segment seg, ReadOutParameters readOutParameters) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        double sy = seg.getSerialPosition();
        return FitsHeaderUtilities.getCRVAL2A(seg, readOutParameters) + sy * (double)type.getCCDGeometryConstants().getSegmentSerialActiveSize();
    }

    private static double getCRVAL1R(Segment seg, CCD ccd, Raft raft) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        return FitsHeaderUtilities.getCRVAL1C(seg) + raft.getRaftGeometryConstants().getGap_outx() + 0.5 * (double)(type.getCCDGeometryConstants().getPhysicalAreaParallelSize() - type.getCCDGeometryConstants().getActiveAreaParallelSize()) + (double)(ccd.getParallelPosition() * (2 * type.getCCDGeometryConstants().getSegmentParallelActiveSize() + raft.getRaftGeometryConstants().getGap_inx() + type.getCCDGeometryConstants().getPhysicalAreaParallelSize() - type.getCCDGeometryConstants().getActiveAreaParallelSize()));
    }

    private static double getCRVAL2R(Segment seg, CCD ccd, Raft raft, ReadOutParameters readOutParameters) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        return FitsHeaderUtilities.getCRVAL2C(seg, readOutParameters) + raft.getRaftGeometryConstants().getGap_outy() + 0.5 * (double)(type.getCCDGeometryConstants().getPhysicalAreaSerialSize() - type.getCCDGeometryConstants().getActiveAreaSerialSize()) + (double)(ccd.getSerialPosition() * (8 * type.getCCDGeometryConstants().getSegmentSerialActiveSize() + raft.getRaftGeometryConstants().getGap_iny() + type.getCCDGeometryConstants().getPhysicalAreaSerialSize() - type.getCCDGeometryConstants().getActiveAreaSerialSize()));
    }

    private static double getCRVAL1F(Segment seg, CCD ccd, Raft raft) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        return FitsHeaderUtilities.getCRVAL1R(seg, ccd, raft) + (double)(raft.getParallelPosition() * raft.getRaftGeometryConstants().getRaftx());
    }

    private static double getCRVAL2F(Segment seg, CCD ccd, Raft raft, ReadOutParameters readOutParameters) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        return FitsHeaderUtilities.getCRVAL2R(seg, ccd, raft, readOutParameters) + (double)(raft.getSerialPosition() * raft.getRaftGeometryConstants().getRafty());
    }

    private static int getDTV1(Segment seg, ReadOutParameters readOutParameters) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        int sx = type instanceof E2VCCDType ? seg.getParallelPosition() : 1;
        return (type.getCCDGeometryConstants().getSegmentSerialActiveSize() + 1 + 2 * readOutParameters.getSerialPrescan()) * sx + seg.getSerialPosition() * type.getCCDGeometryConstants().getSegmentSerialActiveSize() - readOutParameters.getSerialPrescan();
    }

    private static int getDTV2(Segment seg) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        return (1 - seg.getParallelPosition()) * (2 * type.getCCDGeometryConstants().getSegmentParallelActiveSize() + 1);
    }

    private static int getDSX1(Segment seg) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        int sx = seg.getParallelPosition();
        int sy = seg.getSerialPosition();
        if (type instanceof E2VCCDType) {
            int res = (sy + 1) * type.getCCDGeometryConstants().getSegmentSerialActiveSize() * sx;
            return res + (sy * type.getCCDGeometryConstants().getSegmentSerialActiveSize() + 1) * (1 - sx);
        }
        return (sy + 1) * type.getCCDGeometryConstants().getSegmentSerialActiveSize();
    }

    private static int getDSX2(Segment seg) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        int sx = seg.getParallelPosition();
        int sy = seg.getSerialPosition();
        if (type instanceof E2VCCDType) {
            int res = (sy * type.getCCDGeometryConstants().getSegmentSerialActiveSize() + 1) * sx;
            return res + (sy + 1) * type.getCCDGeometryConstants().getSegmentSerialActiveSize() * (1 - sx);
        }
        return sy * type.getCCDGeometryConstants().getSegmentSerialActiveSize() + 1;
    }

    private static int getDSY1(Segment seg) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        int sx = seg.getParallelPosition();
        return 2 * type.getCCDGeometryConstants().getSegmentParallelActiveSize() * (1 - sx) + sx;
    }

    private static int getDSY2(Segment seg) {
        CCDType type = ((CCD)seg.findParentOfType(CCD.class)).getType();
        int sx = seg.getParallelPosition();
        return (type.getCCDGeometryConstants().getSegmentParallelActiveSize() + 1) * (1 - sx) + type.getCCDGeometryConstants().getSegmentParallelActiveSize() * sx;
    }

    private static String getDETSEC(Segment segment) {
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(FitsHeaderUtilities.getDSX1(segment), FitsHeaderUtilities.getDSX2(segment)), FitsHeaderUtilities.range(FitsHeaderUtilities.getDSY1(segment), FitsHeaderUtilities.getDSY2(segment)));
    }
}

