/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class Reb
extends Geometry<CCD>
implements RawImageDataProvider {
    private final int gap_iny;
    private static final RawImageData.BitsPerPixel bits = RawImageData.BitsPerPixel.BIT32;
    private final RaftGeometryConstants raftConstants;

    Reb(RaftGeometryConstants raftGeometryConstants) {
        super("Reb", new Dimension(raftGeometryConstants.getPhysicalAreaParallelSize(), raftGeometryConstants.getRafty() - (int)(2.0 * raftGeometryConstants.getGap_outy())), 1, 3);
        this.gap_iny = raftGeometryConstants.getGap_iny();
        this.raftConstants = raftGeometryConstants;
    }

    Reb(CCDType type) {
        this(RaftGeometryConstants.createRaftGeometryConstants(type));
    }

    @Override
    public String getName() {
        return this.name + this.getParallelPosition();
    }

    @Override
    protected void addGeometryToGrid(CCD child, int p, int s) {
        if (p != 0) {
            throw new IllegalArgumentException("Rebs only allow one row of CCDs in it");
        }
        int yCoord = (this.getSerialChildrenCount() - 1 - s) * (child.getHeight() + this.gap_iny);
        this.addGeometry(child, 0, yCoord);
    }

    @Override
    protected void setParallelPosition(int parallelPosition) {
        super.setParallelPosition(parallelPosition);
        for (CCD ccd : this.getChildrenList()) {
            ccd.setParallelPosition(parallelPosition);
        }
    }

    public static Reb createReb(CCDType type, BitSet ccdBitSet) {
        Reb reb = new Reb(type);
        for (int i = 0; i < 3; ++i) {
            if (!ccdBitSet.get(i)) continue;
            CCD ccd = CCD.createCCD(type);
            reb.addChildGeometry(ccd, 0, i);
        }
        return reb;
    }

    public static Reb createReb(CCDType type) {
        BitSet s = new BitSet(3);
        s.set(0, 3);
        return Reb.createReb(type, s);
    }

    protected RaftGeometryConstants getRaftGeometryConstants() {
        return this.raftConstants;
    }

    @Override
    public RawImageData getRawImageData(ReadOutParameters readOutParameters) {
        int totalSize = 0;
        ArrayList<ByteBuffer> availableData = new ArrayList<ByteBuffer>();
        int segCount = 0;
        for (int s = 0; s < this.getSerialChildrenCount(); ++s) {
            CCD ccd = (CCD)this.getChild(0, s);
            for (Segment segment : ccd.getSegments()) {
                RawImageData imageData = segment.getRawImageData(readOutParameters);
                availableData.add(imageData.getImageData());
                totalSize += imageData.getImageData().limit();
                ++segCount;
            }
        }
        ByteBuffer result = ByteBuffer.allocateDirect(totalSize);
        result.order(ByteOrder.nativeOrder());
        int segmentData = totalSize / segCount / bits.bytes();
        for (int i = 0; i < segmentData; ++i) {
            for (ByteBuffer byteBuffer : availableData) {
                result.putInt(byteBuffer.getInt());
            }
        }
        result.flip();
        return new RawImageData(bits, result);
    }
}

