/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8.sim;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.drivers.reb.sim.DataProvider;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataListener;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class TS8ClientFactorySimulation
extends ClientFactorySimulation {
    private final InnerDataProvider dataProvider = new InnerDataProvider();
    private Geometry geom;

    public TS8ClientFactorySimulation(Geometry geom) {
        RawImageDataProvider.addRawImageDataListener((RawImageDataListener)this.dataProvider, (RawImageDataProvider)((RawImageDataProvider)geom));
        this.geom = geom;
    }

    protected DataProvider createDataProvider() {
        return this.dataProvider;
    }

    private class InnerDataProvider
    implements RawImageDataListener,
    DataProvider {
        private RawImageData data;
        private final Random random = new Random();

        private InnerDataProvider() {
        }

        public ByteBuffer getData(ImageMetadata metadata) {
            int dataLength = metadata.getRegisters()[0] * metadata.getRegisters()[1];
            ByteBuffer result = ByteBuffer.allocate(dataLength *= 192);
            result.order(ByteOrder.nativeOrder());
            int count = 0;
            int multiplier = dataLength / 16;
            int increment = 0;
            while (result.hasRemaining()) {
                if (count > 15) {
                    count = 0;
                }
                result.putInt(++count * 10000000 ^ 0x1FFFF);
                ++increment;
            }
            result.flip();
            return result;
        }

        public void rawImageDataAvailable(RawImageDataProvider imageDataProvider) {
            ReadOutParameters readOutParameters = new ReadOutParameters((CCDType)new E2VCCDType());
            this.data = imageDataProvider.getRawImageData(readOutParameters);
        }
    }
}

