/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.TempControl;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.DACS;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.states.SequencerMainState;
import org.lsst.ccs.subsystem.ts8.FitsUtilities;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.GeometryUtils;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.logging.Logger;

public class TS8Subsystem
implements HasLifecycle,
Monitor.AlarmHandler {
    private final FitsUtilities fitsUtils = new FitsUtilities();
    private static final Logger LOG = Logger.getLogger((String)"org.lsst.ccs.subsystem.ts8");
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<REBDevice> rebDevices = new ArrayList<REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevicesMap = new HashMap<String, REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<TempControl> tempCtrlList = new ArrayList<TempControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Monitor.AlarmHandler alarmHandler;
    protected final String outputDirectory = "${output_base_dir}/rafts/${raftId}/${runId}/${acq_type}/${test_version}/${job_id}/s${sensorLoc}";
    protected final String fileNamePattern = "${CCDSerialLSST}_${TestType}_${ImageType}_${SequenceInfo}_${RunNumber}_${timestamp}.fits";
    @ConfigurationParameter(isFinal=true)
    private String shutterREB = "R00.Reb0";
    @ConfigurationParameter(isFinal=true)
    private String xedREB = "R00.Reb1";
    @ConfigurationParameter(category="Rafts")
    private String ccdType = null;
    private final Geometry geometry;
    private final Logger sLog;
    private long exposureTimeInMillis = 2000L;
    private boolean openShutter = true;
    private boolean actuateXED = false;
    private String imageType = "";
    private final Map<String, ChanParams> monChans = new HashMap<String, ChanParams>();
    private final ClientFactory clientFactory;
    private RaftsCommands raftsCommands;
    private String last_alertStr;
    private final GlobalProc globalProc = new GlobalProc();
    private TempControl tempCtrl;
    private boolean useInfoAlerts = System.getProperty("org.lsst.ccs.subsystem.ts8PowerInfoAlerts", "false").contains("true");
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStatusAggregatorService aggregatorService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    public TS8Subsystem(Geometry geometry, ClientFactory clientFactory) {
        this.geometry = geometry;
        this.clientFactory = clientFactory;
        this.sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.ts8");
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, TS8Subsystem.class.getCanonicalName());
        if (!this.tempCtrlList.isEmpty()) {
            this.tempCtrl = this.tempCtrlList.get(0);
            this.tempCtrl.initialize(this.sLog);
        } else {
            this.sLog.info((Object)"No temperature control available");
        }
        this.raftsCommands = new RaftsCommands(this.subsys, this.rebDevices, this.globalProc, this.geometry, this.tempCtrl);
        ((AgentCommandDictionaryService)this.subsys.getAgentService(AgentCommandDictionaryService.class)).addCommandSetToObject((Object)this.raftsCommands, (Object)"");
        this.sLog.info((Object)("Configured the status aggregator to listen to subsystems: " + System.getProperty("org.lsst.ccs.subsystem.teststand", "ts") + " " + System.getProperty("org.lsst.ccs.subsystem.rebps", "ccs-rebps") + " " + System.getProperty("org.lsst.ccs.subsystem.ts8", "ts8")));
        this.globalProc.initialize(this.rebDevices, this.clientFactory, this.sLog);
        Properties filePatternProperties = BootstrapResourceUtils.getBootstrapProperties((String)"output_location");
        for (Object key : BootstrapResourceUtils.getAllKeysInProperties((Properties)filePatternProperties)) {
            String propertyName = (String)key;
            this.raftsCommands.setPatternProperty(propertyName, filePatternProperties.getProperty(propertyName));
        }
        this.raftsCommands.setFitsFileNamePattern("${CCDSerialLSST}_${TestType}_${ImageType}_${SequenceInfo}_${RunNumber}_${timestamp}.fits");
        this.raftsCommands.setDefaultImageDirectory("${output_base_dir}/rafts/${raftId}/${runId}/${acq_type}/${test_version}/${job_id}/s${sensorLoc}");
        this.monChans.put("Temp1", new ChanParams(0, 0));
        this.monChans.put("Temp2", new ChanParams(0, 1));
        this.monChans.put("Temp3", new ChanParams(0, 2));
        this.monChans.put("Temp4", new ChanParams(0, 3));
        this.monChans.put("Temp5", new ChanParams(0, 4));
        this.monChans.put("Temp6", new ChanParams(0, 5));
        this.monChans.put("Temp7", new ChanParams(0, 6));
        this.monChans.put("Temp8", new ChanParams(0, 7));
        this.monChans.put("Temp9", new ChanParams(0, 8));
        this.monChans.put("Temp10", new ChanParams(0, 9));
        this.monChans.put("Atemp2U", new ChanParams(3, 4));
        this.monChans.put("Atemp1U", new ChanParams(3, 2));
        this.monChans.put("Atemp0U", new ChanParams(3, 0));
        this.monChans.put("Atemp2L", new ChanParams(3, 5));
        this.monChans.put("Atemp1L", new ChanParams(3, 3));
        this.monChans.put("Atemp0L", new ChanParams(3, 1));
        this.monChans.put("CCDTemp0", new ChanParams(2, 0));
        this.monChans.put("CCDTemp1", new ChanParams(2, 1));
        this.monChans.put("CCDTemp2", new ChanParams(2, 2));
        this.monChans.put("RTDTemp", new ChanParams(2, 3));
        this.monChans.put("DigI", new ChanParams(1, 1));
        this.monChans.put("AnaI", new ChanParams(1, 3));
        this.monChans.put("ClkHI", new ChanParams(1, 5));
        this.monChans.put("ClkLI", new ChanParams(1, 9));
        this.monChans.put("ODI", new ChanParams(1, 7));
        this.monChans.put("OD0V", new ChanParams(4, 0));
        this.monChans.put("OG0V", new ChanParams(4, 1));
        this.monChans.put("RD0V", new ChanParams(4, 2));
        this.monChans.put("GD0V", new ChanParams(4, 3));
        this.monChans.put("OD1V", new ChanParams(4, 4));
        this.monChans.put("OG1V", new ChanParams(4, 5));
        this.monChans.put("RD1V", new ChanParams(4, 6));
        this.monChans.put("GD1V", new ChanParams(4, 7));
        this.monChans.put("OD2V", new ChanParams(4, 8));
        this.monChans.put("OG2V", new ChanParams(4, 9));
        this.monChans.put("RD2V", new ChanParams(4, 10));
        this.monChans.put("GD2V", new ChanParams(4, 11));
        for (int iccd = 0; iccd < 3; ++iccd) {
            for (int ihalf = 0; ihalf < 2; ++ihalf) {
                String tb = ihalf == 0 ? "upper" : "lower";
                for (int jc = 0; jc < 8; ++jc) {
                    int ch = jc + 8 * ihalf + 16 * iccd;
                    String name = "CCDI" + iccd + ihalf + jc;
                    this.monChans.put(name, new ChanParams(5, ch));
                }
            }
        }
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("sequencerMonitor", () -> this.checkSequencerState()).withIsFixedRate(false).withPeriod(Duration.ofSeconds(5L)));
    }

    private void checkSequencerState() {
        if (this.raftsCommands == null) {
            throw new RuntimeException("RaftsCommands have not been initialized");
        }
        this.raftsCommands.checkSequencerState();
    }

    public void postStart() {
        this.sLog.info((Object)"TS8 subsystem started");
        ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{SequencerMainState.UNKNOWN});
        if (this.ccdType == null) {
            this.raftsCommands.setCcdType(((Raft)this.geometry).getType().getName());
        } else {
            this.raftsCommands.changeCcdType(this.ccdType);
        }
    }

    @ConfigurationParameterChanger
    public void setCcdType(String ccdType) {
        if (this.raftsCommands != null) {
            this.raftsCommands.changeCcdType(ccdType);
        }
        this.ccdType = ccdType;
    }

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        if (this.alarmHandler != null) {
            return this.alarmHandler.processAlarm(event, parm, cause, alarmName);
        }
        return false;
    }

    @Command(description="Print Header specifications", type=Command.CommandType.QUERY)
    @Deprecated
    public String printHeaderSpecifications() {
        StringBuilder sb = new StringBuilder();
        Map config = FitsHeadersSpecifications.getHeaderSpecifications();
        for (String header : config.keySet()) {
            sb.append("***************************\n");
            sb.append("     Header: ").append(header).append("\n");
            sb.append("***************************\n");
            HeaderSpecification spec = (HeaderSpecification)config.get(header);
            for (HeaderSpecification.HeaderLine line : spec.getHeaders()) {
                sb.append("## ").append(line.getKeyword()).append(" ").append(line.getMetaName()).append(" ").append(line.getDataType()).append(" ").append(line.getComment()).append("\n");
            }
        }
        return sb.toString();
    }

    @Command(description="Print Geometry", type=Command.CommandType.QUERY)
    public String printGeometry(@Argument(defaultValue="0") int depth) {
        return GeometryUtils.showGeometryTree((Geometry)this.geometry, (int)depth);
    }

    @Command(description="Set the name of the raft", type=Command.CommandType.QUERY)
    public void setRaftName(String raftName) {
        this.setHeader("RaftName", raftName, true);
    }

    @Command(description="Set the name of the reb at a given parallel position", type=Command.CommandType.QUERY)
    public void setRebName(int parallel, String rebName) throws IllegalArgumentException {
        Reb reb = (Reb)this.geometry.getChild(parallel, 0);
        if (reb == null) {
            throw new RuntimeException("Could not find Reb for parallel position " + parallel);
        }
        for (CCD ccd : reb.getChildrenList()) {
            this.setCCDHeader(ccd.getUniqueId(), "RebName", rebName, true);
        }
    }

    @Command(description="Set the run number", type=Command.CommandType.QUERY)
    public void setRunNumber(String runNumber) {
        this.setHeader("RunNumber", runNumber, true);
    }

    @Command(type=Command.CommandType.ACTION, description="clear REB config for a given REB ID")
    public String clearREBCfg(int rebnum) throws Exception {
        StringBuilder outstr = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            outstr.append(this.resetREBCfg(rebDevice));
        }
        return outstr.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="reset REB config")
    public String resetREBCfg(REBDevice rebDevice) throws Exception {
        BiasDACS[] biases;
        LOG.info((Object)("state before reset = " + this.showREBCfg(rebDevice)));
        REB reb = rebDevice.getREBConfig();
        for (BiasDACS bias : biases = reb.getBiases()) {
            double[] values = bias.getPValues();
            values[0] = 0.0;
            values[1] = 0.0;
            values[2] = 0.0;
            values[5] = 0.0;
            values[4] = 0.0;
        }
        DACS dacs = reb.getDacs();
        double[] dacvalues = dacs.getPValues();
        dacvalues[3] = 0.0;
        dacvalues[2] = 0.0;
        dacvalues[1] = 0.0;
        dacvalues[0] = 0.0;
        dacvalues[5] = 0.0;
        dacvalues[4] = 0.0;
        LOG.info((Object)"setting new config");
        rebDevice.setREBConfig(reb);
        String msg = "state after reset:\n" + this.showREBCfg(rebDevice);
        return msg;
    }

    @Command(type=Command.CommandType.QUERY, description="raise subsystem alert")
    public void raiseAlert(String alertmsg, AlertState severity) {
        Alert a = new Alert("TS8 Alert", "information");
        if (severity != AlertState.NOMINAL || severity == AlertState.NOMINAL && this.useInfoAlerts) {
            for (String line : alertmsg.split("\n")) {
                this.alertService.raiseAlert(a, severity, line.substring(0, Math.min(254, line.length())));
            }
        }
        this.last_alertStr = alertmsg;
    }

    @Command(type=Command.CommandType.ACTION, description="show REB config for all REBS")
    public String showAllREBCfg() {
        StringBuilder outstr = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            outstr.append(this.showREBCfg(rebDevice));
        }
        return outstr.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="show REB config for a given REB ID")
    public String showREBCfg(int rebnum) {
        StringBuilder outstr = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            outstr.append(this.showREBCfg(rebDevice));
        }
        return outstr.toString();
    }

    private String showREBCfg(REBDevice rebDevice) {
        StringBuilder newcfgsstr = new StringBuilder("\nShowing config for REB:").append(rebDevice.getRebNumber()).append(" : \n");
        REB reb = rebDevice.getREBConfig();
        BiasDACS[] biases = reb.getBiases();
        int i_ccd = 0;
        for (BiasDACS bias : biases) {
            newcfgsstr.append("CCD").append(i_ccd).append(":\n");
            newcfgsstr.append("The BiasDACS voltage settings are (V):\n").append("GD=").append(bias.getPValues()[0]).append(" ,\n").append("RD=").append(bias.getPValues()[5]).append(" ,\n").append("OD=").append(bias.getPValues()[1]).append(" ,\n").append("OG=").append(bias.getPValues()[2]).append(" ,\n");
            ++i_ccd;
        }
        DACS dacs = reb.getDacs();
        newcfgsstr.append("new DACS config:\nPCLK_HIGH=").append(dacs.getPValues()[3]).append(" ,\n").append("PCLK_LOW=").append(dacs.getPValues()[2]).append(" ,\n").append("SCLK_HIGH=").append(dacs.getPValues()[1]).append(" ,\n").append("SCLK_LOW=").append(dacs.getPValues()[0]).append(" ,\n").append("RG_HIGH=").append(dacs.getPValues()[5]).append(" ,\n").append("RG_LOW=").append(dacs.getPValues()[4]).append(" ,\n");
        ++i_ccd;
        return newcfgsstr.toString();
    }

    public double chooseTestVolt(double proposedVoltage, double full_target) {
        return Math.abs(proposedVoltage) < Math.abs(full_target) ? Math.copySign(proposedVoltage, full_target) : full_target / 5.0;
    }

    private String dateStr() {
        return new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(System.currentTimeMillis()));
    }

    @Command(description="Read a register address", type=Command.CommandType.QUERY)
    public int readRegister(String rebId, int address) {
        REBDevice reb = this.rebDevicesMap.get(rebId);
        if (reb == null || !(reb instanceof REBDevice)) {
            throw new IllegalArgumentException("Reb id : " + rebId + " is not valid.");
        }
        try {
            return reb.getRegister(address, 1).getValues()[0];
        }
        catch (Exception x) {
            throw new RuntimeException("Error during register read ", x);
        }
    }

    @Command(description="load sequencer and adjust row and col parameters")
    public List<Integer> loadSequencerAndReDimension(@Argument(description="sequencer filename") String seq, @Argument(description="Number of rows to skip before window") int prerows, @Argument(description="Number of rows of the window") int readrows, @Argument(description="Number of rows after window") int postrows, @Argument(description="Number of columns to skip before readout window, including prescan") int precols, @Argument(description="Number of columns to read") int readcols, @Argument(description="Number of columns to discard after window ") int postcols) throws Exception {
        List seqrply = this.raftsCommands.loadSequencer(seq);
        this.getRaftsCommands().setSequencerParameter("PreRows", prerows);
        this.getRaftsCommands().setSequencerParameter("ReadRows", readrows);
        this.getRaftsCommands().setSequencerParameter("PostRows", postrows);
        this.getRaftsCommands().setSequencerParameter("PreCols", precols);
        this.getRaftsCommands().setSequencerParameter("ReadCols", readcols);
        this.getRaftsCommands().setSequencerParameter("PostCols", postcols);
        return seqrply;
    }

    @Command(description="Write a register address", type=Command.CommandType.ACTION)
    public void writeRegister(String rebId, int address, int value) {
        REBDevice reb = this.rebDevicesMap.get(rebId);
        if (reb == null || !(reb instanceof REBDevice)) {
            throw new IllegalArgumentException("Reb id : " + rebId + " is not valid.");
        }
        try {
            reb.setRegister(address, new int[]{value});
        }
        catch (Exception x) {
            throw new RuntimeException("Error during register write ", x);
        }
    }

    @Command(description="Set a header value for all extensions", type=Command.CommandType.QUERY)
    public void setHeader(String headerName, Object headerValue, @Argument(defaultValue="true") boolean sticky) {
        this.raftsCommands.setHeaderKeyword("all", headerName, (Serializable)headerValue, sticky);
    }

    @Command(description="Set a header value for a given CCD", type=Command.CommandType.QUERY)
    public void setCCDHeader(String ccdId, String headerName, Object headerValue, @Argument(defaultValue="true") boolean sticky) {
        this.raftsCommands.setHeaderKeywordForCCD(ccdId, headerName, (Serializable)headerValue, sticky);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave() throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(this.exposureTimeInMillis);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis) throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(exposureTimeInMillis, this.openShutter);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis, boolean openShutter) throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(exposureTimeInMillis, openShutter, this.actuateXED);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis, boolean openShutter, boolean actuateXED) throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(exposureTimeInMillis, openShutter, actuateXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis, boolean openShutter, boolean actuateXED, String filePattern) throws REBException, IOException, InterruptedException {
        boolean bl;
        LOG.info((Object)("Exposure requested: exptime = " + exposureTimeInMillis + ", shutter = " + openShutter + ", XED = " + actuateXED));
        List mainmap = this.getRaftsCommands().getMainMap();
        boolean hasExposeMain = false;
        boolean hasBiasMain = false;
        boolean hasPocketPumpMain = false;
        boolean hasAcquireMain = false;
        this.setHeader("TemperatureSetPoint", this.raftsCommands.getControlTemp(), true);
        if (this.imageType == null || this.imageType.isEmpty()) {
            LOG.info((Object)"No image type set.");
        }
        for (REBDevice rEBDevice : this.rebDevices) {
            this.setRebName(rEBDevice.getRebNumber(), rEBDevice.getName());
        }
        String mainRoutine = this.raftsCommands.getSequencerStart();
        for (Map mymain : mainmap) {
            if (mymain.keySet().contains("PocketPump")) {
                hasPocketPumpMain = true;
            }
            if (mymain.keySet().contains("Expose")) {
                hasExposeMain = true;
            }
            if (mymain.keySet().contains("Acquire")) {
                hasAcquireMain = true;
            }
            if (!mymain.keySet().contains("Bias")) continue;
            hasBiasMain = true;
        }
        boolean bl2 = bl = exposureTimeInMillis > 0L;
        if (hasPocketPumpMain && hasExposeMain && hasAcquireMain && hasBiasMain) {
            if (exposureTimeInMillis > 0L) {
                mainRoutine = "Acquire";
            } else {
                LOG.info((Object)"selecting bias mains");
                mainRoutine = "Bias";
            }
        } else {
            throw new RuntimeException("Required main routine missing!");
        }
        Predicate imageStateStatusListenerFilter = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(BusMessageFilterFactory.messageOrigin((String)this.subsys.getName()));
        ImageStatusDataListener imageStateListener = new ImageStatusDataListener(this.rebDevices.size());
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)imageStateListener, imageStateStatusListenerFilter);
        ArrayList<String> fitsFiles = new ArrayList<String>();
        try {
            try {
                this.getRaftsCommands().setSequencerParameter("ExposureTime", (int)((double)exposureTimeInMillis / 25.0));
                this.getRaftsCommands().setExposureTime((double)exposureTimeInMillis / 1000.0);
                LOG.info((Object)("ExposureTime " + (int)((double)exposureTimeInMillis / 25.0) + " x 25ms periods"));
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not set exposure time on sequencer");
            }
            ArrayList<SequencerProc> sequencersToStartBeforeAcquisition = new ArrayList<SequencerProc>();
            if (bl) {
                try {
                    if (!this.imageType.toLowerCase().contains("pump")) {
                        LOG.info((Object)"Setting Expose main for all devices ");
                        this.raftsCommands.setSequencerStart("Expose");
                    } else {
                        LOG.info((Object)"Setting PocketPump main for all devices ");
                        this.raftsCommands.setSequencerStart("PocketPump");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while setting the expose main ", e);
                }
                LOG.info((Object)("Exposure main setup: XED REB = " + this.xedREB + " , Shutter REB = " + this.shutterREB));
                for (REBDevice rebDevice : this.rebDevices) {
                    String rebname = rebDevice.getName();
                    try {
                        if (openShutter && rebname.toLowerCase().contains(this.shutterREB.toLowerCase()) || actuateXED && rebname.toLowerCase().contains(this.xedREB.toLowerCase())) {
                            int ExposureFlushPntr = -1;
                            try {
                                ExposureFlushPntr = (Integer)rebDevice.getSequencer().getFunctionMap().get("ExposureFlush");
                            }
                            catch (NullPointerException ne) {
                                ExposureFlushPntr = (Integer)rebDevice.getSequencer().getSubroutineMap().get("ExposureFlush");
                            }
                            LOG.info((Object)("ExposureFlushPntr = " + ExposureFlushPntr));
                            rebDevice.getSequencer().setParameter("Exposure", ExposureFlushPntr);
                            LOG.info((Object)((String)rebname + " sequence set to actuate LVDS during exposure"));
                        } else {
                            int SerialFlushPntr = -1;
                            try {
                                SerialFlushPntr = (Integer)rebDevice.getSequencer().getFunctionMap().get("SerialFlush");
                            }
                            catch (NullPointerException ne) {
                                SerialFlushPntr = (Integer)rebDevice.getSequencer().getSubroutineMap().get("SerialFlush");
                            }
                            LOG.info((Object)("SerialFlushPntr = " + SerialFlushPntr));
                            rebDevice.getSequencer().setParameter("Exposure", SerialFlushPntr);
                            LOG.info((Object)((String)rebname + " sequence set to NOT actuate LVDS during exposure"));
                        }
                        sequencersToStartBeforeAcquisition.add(rebDevice.getSequencer());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while setting parameters ", e);
                    }
                }
            }
            for (SequencerProc sequencerToStart : sequencersToStartBeforeAcquisition) {
                sequencerToStart.startSequencer();
            }
            if (exposureTimeInMillis > 0L) {
                long waitForShutter = exposureTimeInMillis + 2000L;
                if (sequencersToStartBeforeAcquisition.size() > 0) {
                    LOG.info((Object)("Waiting " + waitForShutter + " ms for exposure sequencers to terminate"));
                    for (SequencerProc sequencerToStart : sequencersToStartBeforeAcquisition) {
                        sequencerToStart.waitDone((int)waitForShutter);
                    }
                }
            }
            try {
                this.raftsCommands.setSequencerStart(mainRoutine);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while setting the " + mainRoutine, e);
            }
            for (REBDevice reb : this.rebDevices) {
                reb.getSequencer().resetError();
            }
            LOG.info((Object)("starting image acquisition at " + System.currentTimeMillis() + " millis"));
            this.globalProc.acquireImage();
            imageStateListener.waitForImages(30000L);
            LOG.info((Object)("finished image acquisition at " + System.currentTimeMillis() + " millis"));
            try {
                boolean writeFits = true;
                for (REBDevice reb : this.rebDevices) {
                    if (filePattern != null) {
                        if (!filePattern.isEmpty()) {
                            reb.getImageProc().setFitsFileNamePattern(filePattern);
                        } else {
                            writeFits = false;
                        }
                    }
                    if (!writeFits) continue;
                    List rebFiles = reb.getImageProc().saveFitsImage(null, null);
                    for (String rebFile : rebFiles) {
                        fitsFiles.add(rebFile);
                    }
                }
            }
            catch (RaftException x) {
                throw new IOException("Error while writing FITS files", x);
            }
            LOG.info((Object)"exposure complete");
        }
        finally {
            LOG.info((Object)("Removing listener " + imageStateListener));
            this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)imageStateListener);
            LOG.info((Object)"Clearing non sticky header keywords");
        }
        LOG.info((Object)("Returning " + fitsFiles));
        return fitsFiles;
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public String exposeAcquireAndSaveVerbose(long exposureTimeInMillis, boolean openShutter, boolean actuateXED, String filePattern) throws IOException, InterruptedException, REBException {
        List<String> msg = this.exposeAcquireAndSave(exposureTimeInMillis, openShutter, actuateXED, filePattern);
        return this.aggregatorService.getAllLast().toString();
    }

    @Command(description="Set the default exposure time.", type=Command.CommandType.ACTION)
    public void setDefaultExposureTime(int millis) throws Exception {
        if (millis < 0) {
            throw new IllegalArgumentException("Illegal exposure time: it cannot be negative.");
        }
        this.exposureTimeInMillis = millis;
    }

    @Command(description="Set the sequencer exposure time.", type=Command.CommandType.ACTION)
    public void setSequencerExposureTime(int millis) throws Exception {
        if (millis < 0) {
            throw new IllegalArgumentException("Illegal exposure time: it cannot be negative.");
        }
        this.getRaftsCommands().setSequencerParameter("ExposureTime", (int)((double)millis / 25.0));
    }

    @Command(description="Set the exposure default open shutter flag.", type=Command.CommandType.ACTION)
    public void setDefaultOpenShutter(boolean open) {
        this.openShutter = open;
    }

    @Command(description="Set the exposure default XED actuation.", type=Command.CommandType.ACTION)
    public void setDefaultActuateXED(boolean actuate) {
        this.actuateXED = actuate;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the full Raft module state")
    public RaftState getFullState() {
        return new RaftState(this.getTickPeriod());
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    List<REBDevice> getRebDevices() {
        return this.rebDevices;
    }

    Geometry getGeometry() {
        return this.geometry;
    }

    RaftsCommands getRaftsCommands() {
        return this.raftsCommands;
    }

    @Command(type=Command.CommandType.QUERY, description="Set the LSST assigned CCD Serial Number")
    public void setLsstSerialNumber(String ccdId, String serialNumber) {
        this.setCCDHeader(ccdId, "CCDSerialLSST", serialNumber, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Measured CCD Temperature")
    public void setMeasuredCCDTemperature(String ccdId, double ccdtemp) {
        LOG.info((Object)("Setting measured CCD temperature to " + ccdtemp));
        this.setCCDHeader(ccdId, "MeasuredTemperature", ccdtemp, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Measured CCD HVBias")
    public void setMeasuredCCDBSS(String ccdId, double hvbss) {
        LOG.info((Object)("Setting measured CCDBSS to " + hvbss));
        this.setCCDHeader(ccdId, "MeasuredCCDBSS", hvbss, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Monochromator Wavelength")
    public void setMonoWavelength(double wl) {
        LOG.info((Object)("Setting header MonochromatorWL to " + wl));
        this.setHeader("MonochromatorWavelength", wl, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Manufacturer assigned CCD Serial Number")
    public void setManufacturerSerialNumber(String ccdId, String serialNumber) {
        this.setCCDHeader(ccdId, "CCDSerialManufacturer", serialNumber, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the test type property for the output filename")
    public void setTestType(String ttype) {
        this.setHeader("TestType", ttype, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the name of the test stand station")
    public void setTestStand(String tsname) {
        this.setHeader("TestStand", tsname, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the image type property for the output filename")
    public void setImageType(String itype) {
        this.imageType = itype;
        this.setHeader("ImageType", itype, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the sequence info property for the output filename")
    public void setSeqInfo(Integer seqNum) {
        this.setHeader("SequenceInfo", String.format("%03d", seqNum), true);
        this.raftsCommands.setSequenceNumber(seqNum.intValue());
    }

    @Command
    public void showPhotoDiodeAnalysis(String pddatfile) throws IOException, FitsException {
        this.fitsUtils.showPhotoDiodeAnalysis(new File(pddatfile));
    }

    @Command
    public void addBinaryTable(String pddatfile, String fitsfile, String extnam, String c1name, String c2name, double tstart) throws IOException, FitsException {
        this.fitsUtils.updatePhotoDiodeValues(new File(pddatfile), new File(fitsfile), extnam, c1name, c2name, tstart);
    }

    @Command
    public double getFluxStats(String fitsfile) throws FitsException, IOException {
        return this.fitsUtils.getFluxStats(new File(fitsfile));
    }

    public void Sleep(double secs) {
        if (secs <= 0.0) {
            return;
        }
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            LOG.error((Object)("Rude awakening!" + ex));
        }
    }

    class ChanParams {
        private final int type;
        private final int addr;

        ChanParams(int type, int addr) {
            this.type = type;
            this.addr = addr;
        }
    }

    private class ImageStatusDataListener
    implements StatusMessageListener {
        private final CountDownLatch latch;

        ImageStatusDataListener(int nImages) {
            this.latch = new CountDownLatch(nImages);
        }

        public void onStatusMessage(StatusMessage msg) {
            StatusSubsystemData statusData = (StatusSubsystemData)msg;
            if (statusData.getDataKey().equals("ImageState")) {
                this.latch.countDown();
            }
        }

        public void waitForImages(long timeout) throws InterruptedException {
            boolean done = this.latch.await(timeout, TimeUnit.MILLISECONDS);
            if (!done) {
                throw new RuntimeException("Exceeded " + timeout + "mS wait period to receive all images. " + this.latch.getCount() + " images have not been received.");
            }
        }
    }
}

