/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.Source;

public class ImageName
implements Serializable,
Comparable<ImageName> {
    private static final Pattern namePattern = Pattern.compile("(\\w\\w)_(\\w)_(\\d{8})_(\\d+)");
    static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final long serialVersionUID = 8767898207051188380L;
    private final Source source;
    private final Controller controller;
    private final LocalDate date;
    private final int number;

    public ImageName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid null image name ");
        }
        Matcher matcher = namePattern.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid image name " + name);
        }
        this.source = Source.fromCode(matcher.group(1));
        this.controller = Controller.fromCode(matcher.group(2));
        this.number = Integer.parseInt(matcher.group(4));
        if (this.number <= 0) {
            throw new IllegalArgumentException("Image number must be > 0");
        }
        try {
            this.date = LocalDate.parse(matcher.group(3), formatter);
        }
        catch (DateTimeParseException x) {
            throw new IllegalArgumentException("Invalid date field", x);
        }
    }

    ImageName(Source source, Controller controller, LocalDate date, int imageNumber) {
        this.source = source;
        this.controller = controller;
        this.date = date;
        this.number = imageNumber;
    }

    public Source getSource() {
        return this.source;
    }

    public Controller getController() {
        return this.controller;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public String getDateString() {
        return formatter.format(this.date);
    }

    public int getNumber() {
        return this.number;
    }

    public String getNumberString() {
        return String.format("%06d", this.number);
    }

    public String toString() {
        return String.format("%s_%s_%s_%06d", this.source.getCode(), this.controller.getCode(), formatter.format(this.date), this.number);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.source);
        hash = 97 * hash + Objects.hashCode((Object)this.controller);
        hash = 97 * hash + Objects.hashCode(this.date);
        hash = 97 * hash + this.number;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageName other = (ImageName)obj;
        if (this.number != other.number) {
            return false;
        }
        if (this.source != other.source) {
            return false;
        }
        if (this.controller != other.controller) {
            return false;
        }
        return Objects.equals(this.date, other.date);
    }

    @Override
    public int compareTo(ImageName other) {
        return this.toString().compareTo(other.toString());
    }
}

