/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.treetable;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.freehep.swing.treetable.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected EventListenerList listenerList = new EventListenerList();
    protected Object root;

    public AbstractTreeTableModel(Object root) {
        this.root = root;
    }

    public boolean isCellEditable(Object node, int column) {
        return this.getColumnClass(column) == TreeTableModel.class;
    }

    @Override
    public boolean isCellEditable(TreePath path, int column) {
        return this.isCellEditable(path.getLastPathComponent(), column);
    }

    @Override
    public Class getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public void setValueAt(Object aValue, TreePath path, int column) {
        this.setValueAt(aValue, path.getLastPathComponent(), column);
    }

    @Override
    public Object getValueAt(TreePath path, int column) {
        return this.getValueAt(path.getLastPathComponent(), column);
    }

    public abstract Object getValueAt(Object var1, int var2);

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected void fireTreeNodesChanged(Object source, TreePath path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, TreePath path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, TreePath path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, TreePath path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }
}

