/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.TempControl;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.DACS;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.states.SequencerMainState;
import org.lsst.ccs.subsystem.ts8.FitsUtilities;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.GeometryUtils;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.logging.Logger;

public class TS8Subsystem
implements HasLifecycle,
Monitor.AlarmHandler {
    private final FitsUtilities fitsUtils = new FitsUtilities();
    private static final Logger LOG = Logger.getLogger((String)"org.lsst.ccs.subsystem.ts8");
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<REBDevice> rebDevices = new ArrayList<REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevicesMap = new HashMap<String, REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<TempControl> tempCtrlList = new ArrayList<TempControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Monitor.AlarmHandler alarmHandler;
    protected final String outputDirectory = "${output_base_dir}/rafts/${raftId}/${runId}/${acq_type}/${test_version}/${job_id}/s${sensorLoc}";
    protected final String fileNamePattern = "${CCDSerialLSST}_${TestType}_${ImageType}_${SequenceInfo}_${RunNumber}_${timestamp}.fits";
    @ConfigurationParameter(isFinal=true)
    private String shutterREB = "R00.Reb0";
    @ConfigurationParameter(isFinal=true)
    private String xedREB = "R00.Reb1";
    @ConfigurationParameter(category="PowerOnSleep")
    private double powerOnMethodSleep = 0.1;
    @ConfigurationParameter(category="PowerOnSleep")
    private double biasDACChanOnSleep = 0.0;
    @ConfigurationParameter(category="PowerOnSleep")
    private double dacChanOnSleep = 0.0;
    @ConfigurationParameter(category="InternalLimits")
    private double temp_Max = 0.045;
    @ConfigurationParameter(category="InternalLimits")
    private double odI_Max = 0.25;
    @ConfigurationParameter(category="InternalLimits")
    private double clkI_Max = 0.3;
    @ConfigurationParameter(category="InternalLimits")
    private double anaI_Max = 0.67;
    @ConfigurationParameter(category="InternalLimits")
    private double digI_Max = 0.75;
    @ConfigurationParameter(category="InternalLimits")
    private double odI_Min = 0.06;
    @ConfigurationParameter(category="InternalLimits")
    private double clkI_Min = 0.1;
    @ConfigurationParameter(category="InternalLimits")
    private double anaI_Min = 0.4;
    @ConfigurationParameter(category="InternalLimits")
    private double digI_Min = 0.4;
    @ConfigurationParameter(category="InternalLimits")
    private double CCDI_Max = 0.005;
    @ConfigurationParameter(category="InternalLimits")
    private double CCDI_Min = 8.0E-4;
    @ConfigurationParameter(category="Rafts")
    private String ccdType = null;
    @ConfigurationParameter(category="InternalLimits")
    private double biasDacVBand = 0.5;
    @ConfigurationParameter(category="InternalLimits")
    private double biasDacVWideBand_OD = 1.5;
    private final Geometry geometry;
    private final Logger sLog;
    private long exposureTimeInMillis = 2000L;
    private boolean openShutter = true;
    private boolean actuateXED = false;
    private String imageType = "";
    private final Map<String, ChanParams> monChans = new HashMap<String, ChanParams>();
    private final ClientFactory clientFactory;
    private RaftsCommands raftsCommands;
    private String last_alertStr;
    private final GlobalProc globalProc = new GlobalProc();
    private TempControl tempCtrl;
    private boolean useInfoAlerts = System.getProperty("org.lsst.ccs.subsystem.ts8PowerInfoAlerts", "false").contains("true");
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStatusAggregatorService aggregatorService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    public TS8Subsystem(Geometry geometry, ClientFactory clientFactory) {
        this.geometry = geometry;
        this.clientFactory = clientFactory;
        this.sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.ts8");
    }

    public void postInit() {
        this.subsys.setAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, TS8Subsystem.class.getCanonicalName());
        if (!this.tempCtrlList.isEmpty()) {
            this.tempCtrl = this.tempCtrlList.get(0);
            this.tempCtrl.initialize(this.sLog);
        } else {
            this.sLog.info((Object)"No temperature control available");
        }
        this.raftsCommands = new RaftsCommands(this.subsys, this.rebDevices, this.globalProc, this.geometry, this.tempCtrl);
        this.subsys.addCommandsFromObject((Object)this.raftsCommands, "");
        this.sLog.info((Object)("Configured the status aggregator to listen to subsystems: " + System.getProperty("org.lsst.ccs.subsystem.teststand", "ts") + " " + System.getProperty("org.lsst.ccs.subsystem.rebps", "ccs-rebps") + " " + System.getProperty("org.lsst.ccs.subsystem.ts8", "ts8")));
        this.globalProc.initialize(this.rebDevices, this.clientFactory, this.sLog);
        Properties filePatternProperties = BootstrapResourceUtils.getBootstrapProperties((String)"output_location");
        for (Object key : BootstrapResourceUtils.getAllKeysInProperties((Properties)filePatternProperties)) {
            String propertyName = (String)key;
            this.raftsCommands.setPatternProperty(propertyName, filePatternProperties.getProperty(propertyName));
        }
        this.raftsCommands.setFitsFileNamePattern("${CCDSerialLSST}_${TestType}_${ImageType}_${SequenceInfo}_${RunNumber}_${timestamp}.fits");
        this.raftsCommands.setDefaultImageDirectory("${output_base_dir}/rafts/${raftId}/${runId}/${acq_type}/${test_version}/${job_id}/s${sensorLoc}");
        this.monChans.put("Temp1", new ChanParams(0, 0));
        this.monChans.put("Temp2", new ChanParams(0, 1));
        this.monChans.put("Temp3", new ChanParams(0, 2));
        this.monChans.put("Temp4", new ChanParams(0, 3));
        this.monChans.put("Temp5", new ChanParams(0, 4));
        this.monChans.put("Temp6", new ChanParams(0, 5));
        this.monChans.put("Temp7", new ChanParams(0, 6));
        this.monChans.put("Temp8", new ChanParams(0, 7));
        this.monChans.put("Temp9", new ChanParams(0, 8));
        this.monChans.put("Temp10", new ChanParams(0, 9));
        this.monChans.put("Atemp2U", new ChanParams(3, 4));
        this.monChans.put("Atemp1U", new ChanParams(3, 2));
        this.monChans.put("Atemp0U", new ChanParams(3, 0));
        this.monChans.put("Atemp2L", new ChanParams(3, 5));
        this.monChans.put("Atemp1L", new ChanParams(3, 3));
        this.monChans.put("Atemp0L", new ChanParams(3, 1));
        this.monChans.put("CCDTemp0", new ChanParams(2, 0));
        this.monChans.put("CCDTemp1", new ChanParams(2, 1));
        this.monChans.put("CCDTemp2", new ChanParams(2, 2));
        this.monChans.put("RTDTemp", new ChanParams(2, 3));
        this.monChans.put("DigI", new ChanParams(1, 1));
        this.monChans.put("AnaI", new ChanParams(1, 3));
        this.monChans.put("ClkHI", new ChanParams(1, 5));
        this.monChans.put("ClkLI", new ChanParams(1, 9));
        this.monChans.put("ODI", new ChanParams(1, 7));
        this.monChans.put("OD0V", new ChanParams(4, 0));
        this.monChans.put("OG0V", new ChanParams(4, 1));
        this.monChans.put("RD0V", new ChanParams(4, 2));
        this.monChans.put("GD0V", new ChanParams(4, 3));
        this.monChans.put("OD1V", new ChanParams(4, 4));
        this.monChans.put("OG1V", new ChanParams(4, 5));
        this.monChans.put("RD1V", new ChanParams(4, 6));
        this.monChans.put("GD1V", new ChanParams(4, 7));
        this.monChans.put("OD2V", new ChanParams(4, 8));
        this.monChans.put("OG2V", new ChanParams(4, 9));
        this.monChans.put("RD2V", new ChanParams(4, 10));
        this.monChans.put("GD2V", new ChanParams(4, 11));
        for (int iccd = 0; iccd < 3; ++iccd) {
            for (int ihalf = 0; ihalf < 2; ++ihalf) {
                String tb = ihalf == 0 ? "upper" : "lower";
                for (int jc = 0; jc < 8; ++jc) {
                    int ch = jc + 8 * ihalf + 16 * iccd;
                    String name = "CCDI" + iccd + ihalf + jc;
                    this.monChans.put(name, new ChanParams(5, ch));
                }
            }
        }
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("sequencerMonitor", () -> this.checkSequencerState()).withIsFixedRate(false).withPeriod(Duration.ofSeconds(5L)));
    }

    private void checkSequencerState() {
        if (this.raftsCommands == null) {
            throw new RuntimeException("RaftsCommands have not been initialized");
        }
        this.raftsCommands.checkSequencerState();
    }

    public void postStart() {
        this.sLog.info((Object)"TS8 subsystem started");
        this.subsys.updateAgentState(new Enum[]{SequencerMainState.UNKNOWN});
        if (this.ccdType == null) {
            this.raftsCommands.setCcdType(((Raft)this.geometry).getType().getName());
        } else {
            this.raftsCommands.changeCcdType(this.ccdType);
        }
    }

    @ConfigurationParameterChanger
    public void setCcdType(String ccdType) {
        if (this.raftsCommands != null) {
            this.raftsCommands.changeCcdType(ccdType);
        }
        this.ccdType = ccdType;
    }

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        if (this.alarmHandler != null) {
            return this.alarmHandler.processAlarm(event, parm, cause, alarmName);
        }
        return false;
    }

    @Command(description="Print Header specifications", type=Command.CommandType.QUERY)
    @Deprecated
    public String printHeaderSpecifications() {
        StringBuilder sb = new StringBuilder();
        Map config = FitsHeadersSpecifications.getHeaderSpecifications();
        for (String header : config.keySet()) {
            sb.append("***************************\n");
            sb.append("     Header: ").append(header).append("\n");
            sb.append("***************************\n");
            HeaderSpecification spec = (HeaderSpecification)config.get(header);
            for (HeaderSpecification.HeaderLine line : spec.getHeaders()) {
                sb.append("## ").append(line.getKeyword()).append(" ").append(line.getMetaName()).append(" ").append(line.getDataType()).append(" ").append(line.getComment()).append("\n");
            }
        }
        return sb.toString();
    }

    @Command(description="Print Geometry", type=Command.CommandType.QUERY)
    public String printGeometry(@Argument(defaultValue="0") int depth) {
        return GeometryUtils.showGeometryTree((Geometry)this.geometry, (int)depth);
    }

    @Command(description="Set the name of the raft", type=Command.CommandType.QUERY)
    public void setRaftName(String raftName) {
        this.setHeader("RaftName", raftName, true);
    }

    @Command(description="Set the name of the reb at a given parallel position", type=Command.CommandType.QUERY)
    public void setRebName(int parallel, String rebName) throws IllegalArgumentException {
        Reb reb = (Reb)this.geometry.getChild(parallel, 0);
        if (reb == null) {
            throw new RuntimeException("Could not find Reb for parallel position " + parallel);
        }
        for (CCD ccd : reb.getChildrenList()) {
            this.setCCDHeader(ccd.getUniqueId(), "RebName", rebName, true);
        }
    }

    @Command(description="Set the run number", type=Command.CommandType.QUERY)
    public void setRunNumber(String runNumber) {
        this.setHeader("RunNumber", runNumber, true);
    }

    @Command(type=Command.CommandType.ACTION, description="checks all currents")
    public String checkCurrentsAndTemperatures() {
        StringBuilder results = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            results.append(this.checkCurrentsAndTemperatures(rebDevice.getRebNumber(), false));
        }
        return results.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="checks all currents")
    public String checkTemperatures(int rebnum) {
        StringBuilder results = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            String rebname = "REB" + rebnum;
            results.append("Checking temperatures for REB").append(rebnum).append(":\n");
            try {
                String[] temps;
                for (String temp : temps = new String[]{"RTDTemp", "Atemp0U", "Atemp0L", "Atemp1U", "Atemp1L", "Atemp2U", "Atemp2L", "CCDTemp0", "CCDTemp1", "CCDTemp2", "Temp1", "Temp2", "Temp3", "Temp4", "Temp5", "Temp6", "Temp7", "Temp8", "Temp9", "Temp10"}) {
                    this.last_alertStr = "";
                    this.getChanValue(rebDevice, temp, -1.0, this.temp_Max);
                    results.append(rebname).append(": ").append(this.last_alertStr);
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)(rebname + results.toString() + "\nSAFE CHANNEL READINGS CHECK FAILED WITH ERROR " + e));
                this.powerOff(rebnum);
                throw e;
            }
        }
        return results.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="checks all currents")
    public String checkCurrentsAndTemperatures(int rebnum) {
        return this.checkCurrentsAndTemperatures(rebnum, false);
    }

    @Command(type=Command.CommandType.ACTION, description="checks all currents")
    public String checkCurrentsAndTemperatures(int rebnum, boolean checkCCDI) {
        StringBuilder results = new StringBuilder();
        results.append(this.checkCurrents(rebnum, checkCCDI));
        results.append(this.checkTemperatures(rebnum));
        return results.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="checks all currents")
    public String checkCurrents(int rebnum) {
        return this.checkCurrents(rebnum, false);
    }

    @Command(type=Command.CommandType.ACTION, description="checks all currents")
    public String checkCurrents(int rebnum, boolean checkCCDI) {
        StringBuilder results = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            String rebname = "REB" + rebnum;
            results.append("Checking currents for REB").append(rebnum).append(":\n");
            try {
                this.getChanValue(rebDevice, "ODI", this.odI_Min, this.odI_Max);
                results.append(rebname).append(": ").append(this.last_alertStr);
                this.getChanValue(rebDevice, "DigI", this.digI_Min, this.digI_Max);
                results.append(rebname).append(": ").append(this.last_alertStr);
                this.getChanValue(rebDevice, "AnaI", this.anaI_Min, this.anaI_Max);
                results.append(rebname).append(": ").append(this.last_alertStr);
                this.getChanValue(rebDevice, "ClkLI", this.clkI_Min, this.clkI_Max);
                this.getChanValue(rebDevice, "ClkHI", this.clkI_Min, this.clkI_Max);
                results.append(rebname).append(": ").append(this.last_alertStr);
                if (!checkCCDI) continue;
                for (int iccd = 0; iccd < 3; ++iccd) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(this.getChanValue(rebDevice, stringBuilder.append("OD").append(iccd).append("V").toString(), -0.5, 40.0) > 15.0)) continue;
                    for (int ihalf = 0; ihalf < 2; ++ihalf) {
                        for (int jc = 0; jc < 8; ++jc) {
                            int ch = jc + 8 * ihalf + 16 * iccd;
                            String name = "CCDI" + iccd + ihalf + jc;
                            this.getChanValue(rebDevice, name, this.CCDI_Min, this.CCDI_Max);
                            results.append(rebname).append(": ").append(this.last_alertStr);
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)(rebname + results.toString() + "\nSAFE CHANNEL READINGS CHECK FAILED WITH ERROR " + e + "\n setting all dacs to nominal levels!"));
                this.powerOff(rebnum);
                throw e;
            }
        }
        return results.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private double getChanValue(REBDevice rebDevice, String name, double lowLimit, double highLimit) {
        double value = rebDevice.readChannelNow(this.monChans.get(name).addr, this.monChans.get(name).type);
        String rebname = rebDevice.getName();
        if (name.toLowerCase().contains("temp") || name.toLowerCase().contains("rtd")) {
            if (!(value > 50.0 || value < -150.0 || Double.isNaN(value))) {
                String alertStr = rebname + ": " + name + " - OK temperature reading for " + name + " with value " + String.format("%8.3f", value) + " C\n";
                LOG.info((Object)alertStr);
                this.raiseAlert(alertStr, AlertState.NOMINAL);
                return value;
            }
            String alertStr = rebname + ": " + name + " - Anomolous temperature reading for " + name + " with value " + String.format("%8.3f", value) + " C\n";
            LOG.info((Object)alertStr);
            this.raiseAlert(alertStr, AlertState.NOMINAL);
            return -999.0;
        }
        if (value < lowLimit) {
            String alertStr = rebname + ": " + name + " - I = " + String.format("%10.5f", value) + " is BELOW range " + lowLimit + " to " + highLimit + " Amps ";
            if (name.contains("CCDI")) {
                alertStr = alertStr + " LOW CURRENT CCD CHANNEL!\n";
                LOG.warning((Object)alertStr);
                this.raiseAlert(alertStr, AlertState.WARNING);
                return value;
            }
            alertStr = alertStr + "\n";
            LOG.error((Object)alertStr);
            this.raiseAlert(alertStr, AlertState.ALARM);
            throw new RuntimeException("ALERT! Channel " + name + " reading " + value + " is below the limit " + lowLimit);
        }
        if (value > highLimit) {
            String alertStr = rebname + ": " + name + " = " + String.format("%10.5f", value) + " EXCEEDS range " + lowLimit + " to " + highLimit + "\n";
            LOG.error((Object)alertStr);
            this.raiseAlert(alertStr, AlertState.ALARM);
            throw new RuntimeException("ALERT! Channel " + name + " reading " + value + " is above the limit " + highLimit);
        }
        String alertStr = rebname + ": " + name + " = " + String.format("%10.5f", value) + " is within range " + lowLimit + " to " + highLimit + "\n";
        LOG.info((Object)alertStr);
        this.raiseAlert(alertStr, AlertState.NOMINAL);
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="clear REB config for a given REB ID")
    public String clearREBCfg(int rebnum) throws Exception {
        StringBuilder outstr = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            outstr.append(this.resetREBCfg(rebDevice));
        }
        return outstr.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="reset REB config")
    public String resetREBCfg(REBDevice rebDevice) throws Exception {
        BiasDACS[] biases;
        LOG.info((Object)("state before reset = " + this.showREBCfg(rebDevice)));
        REB reb = rebDevice.getREBConfig();
        for (BiasDACS bias : biases = reb.getBiases()) {
            double[] values = bias.getPValues();
            values[0] = 0.0;
            values[1] = 0.0;
            values[2] = 0.0;
            values[5] = 0.0;
            values[4] = 0.0;
        }
        DACS dacs = reb.getDacs();
        double[] dacvalues = dacs.getPValues();
        dacvalues[3] = 0.0;
        dacvalues[2] = 0.0;
        dacvalues[1] = 0.0;
        dacvalues[0] = 0.0;
        dacvalues[5] = 0.0;
        dacvalues[4] = 0.0;
        LOG.info((Object)"setting new config");
        rebDevice.setREBConfig(reb);
        String msg = "state after reset:\n" + this.showREBCfg(rebDevice);
        return msg;
    }

    @Command(type=Command.CommandType.QUERY, description="raise subsystem alert")
    public void raiseAlert(String alertmsg, AlertState severity) {
        Alert a = new Alert("TS8 Alert", "information");
        if (severity != AlertState.NOMINAL || severity == AlertState.NOMINAL && this.useInfoAlerts) {
            for (String line : alertmsg.split("\n")) {
                this.alertService.raiseAlert(a, severity, line.substring(0, Math.min(254, line.length())));
            }
        }
        this.last_alertStr = alertmsg;
    }

    @Command(type=Command.CommandType.ACTION, description="show REB config for all REBS")
    public String showAllREBCfg() {
        StringBuilder outstr = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            outstr.append(this.showREBCfg(rebDevice));
        }
        return outstr.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="show REB config for a given REB ID")
    public String showREBCfg(int rebnum) {
        StringBuilder outstr = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            outstr.append(this.showREBCfg(rebDevice));
        }
        return outstr.toString();
    }

    private String showREBCfg(REBDevice rebDevice) {
        StringBuilder newcfgsstr = new StringBuilder("\nShowing config for REB:").append(rebDevice.getRebNumber()).append(" : \n");
        REB reb = rebDevice.getREBConfig();
        BiasDACS[] biases = reb.getBiases();
        int i_ccd = 0;
        for (BiasDACS bias : biases) {
            newcfgsstr.append("CCD").append(i_ccd).append(":\n");
            newcfgsstr.append("The BiasDACS voltage settings are (V):\n").append("GD=").append(bias.getPValues()[0]).append(" ,\n").append("RD=").append(bias.getPValues()[5]).append(" ,\n").append("OD=").append(bias.getPValues()[1]).append(" ,\n").append("OG=").append(bias.getPValues()[2]).append(" ,\n");
            ++i_ccd;
        }
        DACS dacs = reb.getDacs();
        newcfgsstr.append("new DACS config:\nPCLK_HIGH=").append(dacs.getPValues()[3]).append(" ,\n").append("PCLK_LOW=").append(dacs.getPValues()[2]).append(" ,\n").append("SCLK_HIGH=").append(dacs.getPValues()[1]).append(" ,\n").append("SCLK_LOW=").append(dacs.getPValues()[0]).append(" ,\n").append("RG_HIGH=").append(dacs.getPValues()[5]).append(" ,\n").append("RG_LOW=").append(dacs.getPValues()[4]).append(" ,\n");
        ++i_ccd;
        return newcfgsstr.toString();
    }

    public double chooseTestVolt(double proposedVoltage, double full_target) {
        return Math.abs(proposedVoltage) < Math.abs(full_target) ? Math.copySign(proposedVoltage, full_target) : full_target / 5.0;
    }

    private String dateStr() {
        return new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date(System.currentTimeMillis()));
    }

    @Command(type=Command.CommandType.ACTION, description="safe power on")
    public String powerOn() {
        StringBuilder outmsg = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            outmsg.append(this.powerOn(rebDevice.getRebNumber()));
        }
        return outmsg.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="safe power on")
    public String powerOn(int rebnum) {
        StringBuilder outmsg = new StringBuilder();
        this.useInfoAlerts = System.getProperty("org.lsst.ccs.subsystem.ts8PowerInfoAlerts", "false").contains("true");
        for (REBDevice rebDevice : this.rebDevices) {
            double volts_lo;
            double volts_hi;
            DACS dacsOriginal;
            DACS dacs;
            double volts_og;
            block18: {
                block17: {
                    if (rebDevice.getRebNumber() != rebnum) continue;
                    double noLim = 100.0;
                    if (Math.abs(this.getChanValue(rebDevice, "RD" + rebnum + "V", -noLim, noLim)) > 1.0 || Math.abs(this.getChanValue(rebDevice, "OD" + rebnum + "V", -noLim, noLim)) > 1.5 || Math.abs(this.getChanValue(rebDevice, "GD" + rebnum + "V", -noLim, noLim)) > 1.0) break block17;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(Math.abs(this.getChanValue(rebDevice, stringBuilder.append("OG").append(rebnum).append("V").toString(), -noLim, noLim)) > 1.0)) break block18;
                }
                String AbrtMsg = "Check of biases indicates sensors are not in an unpowered state.\n ABORTING powerOn procedure for REB" + rebnum + " !\n";
                LOG.error((Object)AbrtMsg);
                this.raiseAlert(AbrtMsg, AlertState.NOMINAL);
                outmsg.append(AbrtMsg);
                continue;
            }
            String rebname = "REB" + rebnum;
            String msg = "Checking " + rebname + " at " + this.dateStr();
            LOG.warn((Object)msg);
            this.raiseAlert(msg, AlertState.NOMINAL);
            this.showREBCfg(rebDevice);
            outmsg.append("REB ").append(rebDevice.getRebNumber()).append(" :         " + this.dateStr() + "\n");
            REB reb = rebDevice.getREBConfig();
            REB rebOriginal = new REB();
            rebOriginal.copyFrom(reb);
            int n_ccd = reb.getBiases().length;
            BiasDACS[] biasesOriginal = new BiasDACS[n_ccd];
            for (int idx = 0; idx < n_ccd; ++idx) {
                biasesOriginal[idx] = new BiasDACS();
                biasesOriginal[idx].copyFrom(reb.getBiases()[idx]);
            }
            BiasDACS[] biases = reb.getBiases();
            msg = "\n" + rebname + ": resetting config of all DACS to unpowered levels at " + this.dateStr() + "\n";
            outmsg.append(msg);
            this.raiseAlert(msg, AlertState.NOMINAL);
            LOG.info((Object)msg);
            try {
                this.resetREBCfg(rebDevice);
                rebDevice.loadBiasDacs(true);
                rebDevice.loadDacs(true);
            }
            catch (Exception x) {
                throw new RuntimeException(rebname + ": Error while loading dacs", x);
            }
            msg = rebname + ": Checking all currents with nominal levels\n";
            outmsg.append(msg);
            this.raiseAlert(msg, AlertState.NOMINAL);
            LOG.info((Object)msg);
            LOG.info((Object)(rebname + ": Checking all currents with nominal DAC levels at " + this.dateStr()));
            try {
                this.checkCurrentsAndTemperatures(rebnum);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(outmsg.toString() + e);
            }
            double test_voltage = 0.5;
            double volts = 0.0;
            double target = 0.0;
            if (this.raftsCommands.getCcdType().toLowerCase().contains("e2v")) {
                for (int idx = 0; idx < biases.length; ++idx) {
                    BiasDACS bias = biases[idx];
                    outmsg.append("\n" + rebname + ": CCD ").append(idx).append(" :\n");
                    outmsg.append(rebname + ": Testing RD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    target = biasesOriginal[idx].getPValues()[5];
                    volts = this.biasDACChanOn("RD", rebDevice, idx, this.chooseTestVolt(test_voltage, target));
                    outmsg.append(rebname + ": RD set to " + volts + " V - status OK\n");
                    target = biasesOriginal[idx].getPValues()[0];
                    outmsg.append(rebname + ": Testing GD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    volts = this.biasDACChanOn("GD", rebDevice, idx, this.chooseTestVolt(test_voltage, target));
                    outmsg.append(rebname + ": GD set to " + volts + " V - status OK\n");
                    outmsg.append(rebname + ": Testing OG for CCD " + idx + " at " + this.dateStr() + " - \n");
                    target = biasesOriginal[idx].getPValues()[2];
                    volts = this.biasDACChanOn("OG", rebDevice, idx, this.chooseTestVolt(test_voltage, target));
                    outmsg.append(rebname + ": OG set to " + volts + " V - status OK\n");
                    outmsg.append(rebname + ": Applying RD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    double volts_rd = this.biasDACChanOn("RD", rebDevice, idx, biasesOriginal[idx].getPValues()[5]);
                    outmsg.append(rebname + ": RD set to " + volts_rd + " V - status OK\n");
                    outmsg.append(rebname + ": Applying OD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    double volts_od = this.biasDACChanOn("OD", rebDevice, idx, biasesOriginal[idx].getPValues()[1]);
                    outmsg.append(rebname + ": OD set to " + volts_od + " V - status OK\n");
                    outmsg.append(rebname + ": Applying GD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    double volts_gd = this.biasDACChanOn("GD", rebDevice, idx, biasesOriginal[idx].getPValues()[0]);
                    outmsg.append(rebname + ": GD set to " + volts_gd + " V - status OK\n");
                    outmsg.append(rebname + ": Applying OG for CCD " + idx + " at " + this.dateStr() + " - \n");
                    volts_og = this.biasDACChanOn("OG", rebDevice, idx, biasesOriginal[idx].getPValues()[2]);
                    outmsg.append(rebname + ": OG set to " + volts_og + " V - status OK\n");
                    outmsg.append(rebname + ": Turning on CSGATE for CCD " + idx + " at " + this.dateStr() + " - \n");
                    volts = this.biasDACChanOn("CS_GATE", rebDevice, idx, biasesOriginal[idx].getPValues()[4]);
                    this.Sleep(this.powerOnMethodSleep);
                    outmsg.append(rebname + ": RD measured = " + this.getChanValue(rebDevice, "RD" + idx + "V", volts_rd - this.biasDacVBand, volts_rd + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": OD measured = " + this.getChanValue(rebDevice, "OD" + idx + "V", volts_od - this.biasDacVBand, volts_od + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": GD measured = " + this.getChanValue(rebDevice, "GD" + idx + "V", volts_gd - this.biasDacVBand, volts_gd + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": OG measured = " + this.getChanValue(rebDevice, "OG" + idx + "V", volts_og - this.biasDacVBand, volts_og + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": CSGATE set to " + volts + " V - status OK\n");
                }
                dacs = reb.getDacs();
                dacsOriginal = rebOriginal.getDacs();
                msg = rebname + ": bringing up serials at " + this.dateStr() + "\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                outmsg.append(rebname).append(": testing serial lines\n");
                volts_hi = this.dacChanOn("SCLK_HIGH", rebDevice, dacsOriginal, test_voltage);
                volts_lo = this.dacChanOn("SCLK_LOW", rebDevice, dacsOriginal, test_voltage);
                outmsg.append(rebname).append(": serials set to ").append(volts_hi).append("/").append(volts_lo).append(" V - status OK\n");
                msg = rebname + ": bringing up parallels at " + this.dateStr() + "\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                outmsg.append(rebname).append(": testing parallel lines\n");
                volts_hi = this.dacChanOn("PCLK_HIGH", rebDevice, dacsOriginal, test_voltage);
                volts_lo = this.dacChanOn("PCLK_LOW", rebDevice, dacsOriginal, test_voltage);
                outmsg.append(rebname).append(": parallels set to ").append(volts_hi).append("/").append(volts_lo).append(" V - status OK\n");
                msg = rebname + ": bringing up RG at " + this.dateStr() + "\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                outmsg.append(rebname).append(": testing RG lines\n");
                volts_hi = this.dacChanOn("RG_HIGH", rebDevice, dacsOriginal, test_voltage);
                volts_lo = this.dacChanOn("RG_LOW", rebDevice, dacsOriginal, test_voltage);
                outmsg.append(rebname).append(": RG set to ").append(volts_hi).append("/").append(volts_lo).append(" V - status OK\n");
            } else if (this.raftsCommands.getCcdType().toLowerCase().contains("itl")) {
                dacs = reb.getDacs();
                dacsOriginal = rebOriginal.getDacs();
                msg = rebname + ": bringing up serials at " + this.dateStr() + "\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                outmsg.append(rebname).append(": testing serial lines\n");
                volts_hi = this.dacChanOn("SCLK_HIGH", rebDevice, dacsOriginal, test_voltage);
                volts_lo = this.dacChanOn("SCLK_LOW", rebDevice, dacsOriginal, test_voltage);
                outmsg.append(rebname).append(": serials set to ").append(volts_hi).append("/").append(volts_lo).append(" V - status OK\n");
                msg = rebname + ": bringing up parallels at " + this.dateStr() + "\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                outmsg.append(rebname).append(": testing parallel lines\n");
                volts_hi = this.dacChanOn("PCLK_HIGH", rebDevice, dacsOriginal, test_voltage);
                volts_lo = this.dacChanOn("PCLK_LOW", rebDevice, dacsOriginal, test_voltage);
                outmsg.append(rebname).append(": parallels set to ").append(volts_hi).append("/").append(volts_lo).append(" V - status OK\n");
                msg = rebname + ": bringing up RG\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                outmsg.append(rebname).append(": testing RG lines at " + this.dateStr() + "\n");
                volts_hi = this.dacChanOn("RG_HIGH", rebDevice, dacsOriginal, test_voltage);
                volts_lo = this.dacChanOn("RG_LOW", rebDevice, dacsOriginal, test_voltage);
                outmsg.append(rebname).append(": RG set to ").append(volts_hi).append("/").append(volts_lo).append(" V - status OK\n");
                for (int idx = 0; idx < biases.length; ++idx) {
                    BiasDACS bias = biases[idx];
                    outmsg.append("\n" + rebname + ": CCD ").append(idx).append(" :\n");
                    outmsg.append(rebname + ": Testing OG for CCD " + idx + " at " + this.dateStr() + " - \n");
                    target = biasesOriginal[idx].getPValues()[2];
                    volts = this.biasDACChanOn("OG", rebDevice, idx, this.chooseTestVolt(test_voltage, target));
                    outmsg.append(rebname + ": OG set to " + volts + " V - status OK\n");
                    target = biasesOriginal[idx].getPValues()[0];
                    outmsg.append(rebname + ": Testing GD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    volts = this.biasDACChanOn("GD", rebDevice, idx, this.chooseTestVolt(test_voltage, target));
                    outmsg.append(rebname + ": GD set to " + volts + " V - status OK\n");
                    outmsg.append(rebname + ": Testing RD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    target = biasesOriginal[idx].getPValues()[5];
                    volts = this.biasDACChanOn("RD", rebDevice, idx, this.chooseTestVolt(test_voltage, target));
                    outmsg.append(rebname + ": RD set to " + volts + " V - status OK\n");
                    outmsg.append(rebname + ": Applying OG for CCD " + idx + " at " + this.dateStr() + " - \n");
                    volts_og = this.biasDACChanOn("OG", rebDevice, idx, biasesOriginal[idx].getPValues()[2]);
                    outmsg.append(rebname + ": OG set to " + volts_og + " V - status OK\n");
                    outmsg.append(rebname + ": Applying GD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    double volts_gd = this.biasDACChanOn("GD", rebDevice, idx, biasesOriginal[idx].getPValues()[0]);
                    outmsg.append(rebname + ": GD set to " + volts_gd + " V - status OK\n");
                    outmsg.append(rebname + ": Applying RD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    double volts_rd = this.biasDACChanOn("RD", rebDevice, idx, biasesOriginal[idx].getPValues()[5]);
                    outmsg.append(rebname + ": RD set to " + volts_rd + " V - status OK\n");
                    outmsg.append(rebname + ": Applying OD for CCD " + idx + " at " + this.dateStr() + " - \n");
                    double volts_od = this.biasDACChanOn("OD", rebDevice, idx, biasesOriginal[idx].getPValues()[1]);
                    outmsg.append(rebname + ": OD set to " + volts_od + " V - status OK\n");
                    outmsg.append(rebname + ": Turning on CSGATE for CCD " + idx + " at " + this.dateStr() + " - \n");
                    volts = this.biasDACChanOn("CS_GATE", rebDevice, idx, biasesOriginal[idx].getPValues()[4]);
                    this.Sleep(this.powerOnMethodSleep);
                    outmsg.append(rebname + ": OG measured = " + this.getChanValue(rebDevice, "OG" + idx + "V", volts_og - this.biasDacVBand, volts_og + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": GD measured = " + this.getChanValue(rebDevice, "GD" + idx + "V", volts_gd - this.biasDacVBand, volts_gd + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": RD measured = " + this.getChanValue(rebDevice, "RD" + idx + "V", volts_rd - this.biasDacVBand, volts_rd + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": OD measured = " + this.getChanValue(rebDevice, "OD" + idx + "V", volts_od - this.biasDacVBand, volts_od + this.biasDacVBand) + " V\n");
                    outmsg.append(rebname + ": CSGATE set to " + volts + " V - status OK\n");
                }
            } else {
                throw new RuntimeException("unrecognizable ccdType!!!");
            }
            try {
                int pulled_firm = rebDevice.getHwVersion();
                long pulled_id = rebDevice.getSerialNumber();
                msg = "\n ------- " + rebname + " is now powered and reporting 1-wire ID " + String.format("%x", pulled_id) + " and firmware version " + String.format("%x", pulled_firm) + " ------- \n\n";
                outmsg.append(msg);
                this.raiseAlert(msg, AlertState.NOMINAL);
                LOG.info((Object)msg);
                rebDevice.loadAspics(true);
                rebDevice.loadBiasDacs(true);
                rebDevice.loadDacs(true);
            }
            catch (Exception e) {
                LOG.info((Object)outmsg.toString());
                LOG.info((Object)"FAILED WHILE TRYING TO GET FIRMWARE VERSION AND 1-WIRE ID");
                throw new RuntimeException(e);
            }
        }
        return outmsg.append(this.checkCurrentsAndTemperatures(rebnum, true)).toString();
    }

    @Command(type=Command.CommandType.ACTION, description="check state of REB biases")
    public boolean checkREBState(int rebnum) {
        boolean REBStateOK = true;
        StringBuilder outmsg = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            if (rebDevice.getRebNumber() != rebnum) continue;
            String rebname = "REB" + rebnum;
            String msg = "Checking " + rebname + " at " + this.dateStr();
            LOG.warn((Object)msg);
            this.raiseAlert(msg, AlertState.NOMINAL);
            BiasDACS[] biases = rebDevice.getREBConfig().getBiases();
            for (int idx = 0; idx < biases.length; ++idx) {
                BiasDACS bias = biases[idx];
                outmsg.append("\n" + rebname + ": CCD ").append(idx).append(" :\n");
                for (int idac = 0; idac < 4; ++idac) {
                    double band = this.biasDacVBand;
                    String dacname = "";
                    double volts = 0.0;
                    if (idac == 0) {
                        dacname = "RD";
                        volts = biases[idx].getPValues()[5];
                    } else if (idac == 1) {
                        dacname = "OD";
                        volts = biases[idx].getPValues()[1];
                        band = this.biasDacVWideBand_OD;
                    } else if (idac == 2) {
                        dacname = "GD";
                        volts = biases[idx].getPValues()[0];
                    } else if (idac == 3) {
                        dacname = "OG";
                        volts = biases[idx].getPValues()[2];
                    }
                    try {
                        outmsg.append(rebname + ": " + dacname + " measured = " + this.getChanValue(rebDevice, dacname + idx + "V", volts - band, volts + band) + " V\n");
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("FAILED " + dacname + " STATE CHECK FOR REB " + rebnum + "CCD " + idx));
                        REBStateOK = false;
                    }
                }
            }
        }
        return REBStateOK;
    }

    @Command(type=Command.CommandType.ACTION, description="safe power off")
    public String powerOff() {
        StringBuilder outmsg = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            outmsg.append(this.powerOff(rebDevice.getRebNumber()));
        }
        return outmsg.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="safe power off")
    public String powerOff(int rebnum) {
        StringBuilder outmsg = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            BiasDACS bias;
            int idx;
            block8: {
                if (rebDevice.getRebNumber() != rebnum) continue;
                try {
                    if (rebDevice.isBackBiasOn()) {
                        LOG.error((Object)("REB " + rebDevice.getRebNumber() + ": Attempted to to power off clocks while HV bias switch still ON. ABORTING!"));
                        outmsg.append("REB " + rebDevice.getRebNumber() + ": Attempted to to power off clocks while HV bias switch still ON. ABORTING!");
                    }
                    break block8;
                }
                catch (Exception ex) {
                    LOG.error((Object)("REB " + rebDevice.getRebNumber() + ": Unable to determine if HV bias is on ... ABORTING!"));
                }
                continue;
            }
            double noLim = 100.0;
            StringBuilder stringBuilder = new StringBuilder();
            if (Math.abs(this.getChanValue(rebDevice, stringBuilder.append("OD").append(rebnum).append("V").toString(), -noLim, noLim)) < this.biasDacVWideBand_OD) {
                String AbrtMsg = "Check of biases indicates sensors are in an unpowered state already.\n ABORTING powerOff procedure for REB" + rebnum + " !\n";
                LOG.error((Object)AbrtMsg);
                this.raiseAlert(AbrtMsg, AlertState.NOMINAL);
                outmsg.append(AbrtMsg);
                continue;
            }
            LOG.warn((Object)("Powering OFF REB " + rebDevice.getRebNumber()));
            outmsg.append("REB ").append(rebDevice.getRebNumber()).append(" : \n");
            REB reb = rebDevice.getREBConfig();
            BiasDACS[] biases = reb.getBiases();
            DACS dacs = reb.getDacs();
            if (this.raftsCommands.getCcdType().toLowerCase().contains("e2v")) {
                LOG.warn((Object)"turning off RG");
                this.dacChanOff("RG_HIGH", rebDevice, dacs);
                this.dacChanOff("RG_LOW", rebDevice, dacs);
                outmsg.append("RG OFF\n");
                LOG.warn((Object)"turning off parallels");
                this.dacChanOff("PCLK_HIGH", rebDevice, dacs);
                this.dacChanOff("PCLK_LOW", rebDevice, dacs);
                outmsg.append("parallels OFF\n");
                LOG.warn((Object)"turning off serials");
                this.dacChanOff("SCLK_HIGH", rebDevice, dacs);
                this.dacChanOff("SCLK_LOW", rebDevice, dacs);
                outmsg.append("serials OFF\n");
                for (idx = 0; idx < biases.length; ++idx) {
                    bias = biases[idx];
                    outmsg.append("CCD ").append(idx).append(" :\n");
                    LOG.warn((Object)("Turning off CSGATE for CCD " + idx));
                    this.biasDACChanOff("CS_GATE", rebDevice, idx, bias);
                    outmsg.append("CSGATE OFF\n");
                    LOG.warn((Object)("Turning off OG for CCD " + idx));
                    this.biasDACChanOff("OG", rebDevice, idx, bias);
                    outmsg.append("OG OFF\n");
                    LOG.warn((Object)("Turning off GD for CCD " + idx));
                    this.biasDACChanOff("GD", rebDevice, idx, bias);
                    outmsg.append("GD OFF\n");
                    LOG.warn((Object)("Turning off OD for CCD " + idx));
                    this.biasDACChanOff("OD", rebDevice, idx, bias);
                    outmsg.append("OD OFF\n");
                    LOG.warn((Object)("Turning off RD for CCD " + idx));
                    this.biasDACChanOff("RD", rebDevice, idx, bias);
                    outmsg.append("RD OFF\n");
                }
                continue;
            }
            for (idx = 0; idx < biases.length; ++idx) {
                bias = biases[idx];
                outmsg.append("CCD ").append(idx).append(" :\n");
                LOG.warn((Object)("Turning off CSGATE for CCD " + idx));
                this.biasDACChanOff("CS_GATE", rebDevice, idx, bias);
                outmsg.append("CSGATE OFF\n");
                LOG.warn((Object)("Turning off OD for CCD " + idx));
                this.biasDACChanOff("OD", rebDevice, idx, bias);
                outmsg.append("OD OFF\n");
                LOG.warn((Object)("Turning off RD for CCD " + idx));
                this.biasDACChanOff("RD", rebDevice, idx, bias);
                outmsg.append("RD OFF\n");
                LOG.warn((Object)("Turning off OG for CCD " + idx));
                this.biasDACChanOff("OG", rebDevice, idx, bias);
                outmsg.append("OG OFF\n");
                LOG.warn((Object)("Turning off GD for CCD " + idx));
                this.biasDACChanOff("GD", rebDevice, idx, bias);
                outmsg.append("GD OFF\n");
            }
            LOG.warn((Object)"turning off RG");
            this.dacChanOff("RG_HIGH", rebDevice, dacs);
            this.dacChanOff("RG_LOW", rebDevice, dacs);
            outmsg.append("RG OFF\n");
            LOG.warn((Object)"turning off parallels");
            this.dacChanOff("PCLK_HIGH", rebDevice, dacs);
            this.dacChanOff("PCLK_LOW", rebDevice, dacs);
            outmsg.append("parallels OFF\n");
            LOG.warn((Object)"turning off serials");
            this.dacChanOff("SCLK_HIGH", rebDevice, dacs);
            this.dacChanOff("SCLK_LOW", rebDevice, dacs);
            outmsg.append("serials OFF\n");
        }
        return outmsg.toString();
    }

    @Command(type=Command.CommandType.ACTION, description="immediate power off")
    public String powerOffNow(int rebnum) {
        StringBuilder outmsg = new StringBuilder();
        for (REBDevice rebDevice : this.rebDevices) {
            block6: {
                if (rebDevice.getRebNumber() != rebnum) continue;
                try {
                    if (rebDevice.isBackBiasOn()) {
                        LOG.error((Object)("REB " + rebDevice.getRebNumber() + ": Attempted to to power off clocks while HV bias switch still ON. ABORTING!"));
                        outmsg.append("REB " + rebDevice.getRebNumber() + ": Attempted to to power off clocks while HV bias switch still ON. ABORTING!");
                    }
                    break block6;
                }
                catch (Exception ex) {
                    LOG.error((Object)("REB " + rebDevice.getRebNumber() + ": Unable to determine if HV bias is on ... ABORTING!"));
                }
                continue;
            }
            LOG.warn((Object)("Powering OFF REB " + rebDevice.getRebNumber()));
            try {
                outmsg.append(this.resetREBCfg(rebDevice));
                outmsg.append("\n#BIAS DACs loaded = " + rebDevice.loadBiasDacs(true) + "\n");
                outmsg.append("#DACS loaded = " + rebDevice.loadDacs(true) + "\n");
            }
            catch (Exception e) {
                LOG.error((Object)(outmsg.toString() + "\nFailed to power OFF REB!\n " + e));
            }
        }
        return outmsg.toString();
    }

    @Command(description="Read a register address", type=Command.CommandType.QUERY)
    public int readRegister(String rebId, int address) {
        REBDevice reb = this.rebDevicesMap.get(rebId);
        if (reb == null || !(reb instanceof REBDevice)) {
            throw new IllegalArgumentException("Reb id : " + rebId + " is not valid.");
        }
        try {
            return reb.getRegister(address, 1).getValues()[0];
        }
        catch (Exception x) {
            throw new RuntimeException("Error during register read ", x);
        }
    }

    @Command(description="load sequencer and adjust row and col parameters")
    public List<Integer> loadSequencerAndReDimension(@Argument(description="sequencer filename") String seq, @Argument(description="Number of rows to skip before window") int prerows, @Argument(description="Number of rows of the window") int readrows, @Argument(description="Number of rows after window") int postrows, @Argument(description="Number of columns to skip before readout window, including prescan") int precols, @Argument(description="Number of columns to read") int readcols, @Argument(description="Number of columns to discard after window ") int postcols) throws Exception {
        List seqrply = this.raftsCommands.loadSequencer(seq);
        this.getRaftsCommands().setSequencerParameter("PreRows", prerows);
        this.getRaftsCommands().setSequencerParameter("ReadRows", readrows);
        this.getRaftsCommands().setSequencerParameter("PostRows", postrows);
        this.getRaftsCommands().setSequencerParameter("PreCols", precols);
        this.getRaftsCommands().setSequencerParameter("ReadCols", readcols);
        this.getRaftsCommands().setSequencerParameter("PostCols", postcols);
        return seqrply;
    }

    @Command(description="Write a register address", type=Command.CommandType.ACTION)
    public void writeRegister(String rebId, int address, int value) {
        REBDevice reb = this.rebDevicesMap.get(rebId);
        if (reb == null || !(reb instanceof REBDevice)) {
            throw new IllegalArgumentException("Reb id : " + rebId + " is not valid.");
        }
        try {
            reb.setRegister(address, new int[]{value});
        }
        catch (Exception x) {
            throw new RuntimeException("Error during register write ", x);
        }
    }

    @Command(description="Set a header value for all extensions", type=Command.CommandType.QUERY)
    public void setHeader(String headerName, Object headerValue, @Argument(defaultValue="true") boolean sticky) {
        this.raftsCommands.setHeaderKeyword("all", headerName, (Serializable)headerValue, sticky);
    }

    @Command(description="Set a header value for a given CCD", type=Command.CommandType.QUERY)
    public void setCCDHeader(String ccdId, String headerName, Object headerValue, @Argument(defaultValue="true") boolean sticky) {
        this.raftsCommands.setHeaderKeywordForCCD(ccdId, headerName, (Serializable)headerValue, sticky);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave() throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(this.exposureTimeInMillis);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis) throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(exposureTimeInMillis, this.openShutter);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis, boolean openShutter) throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(exposureTimeInMillis, openShutter, this.actuateXED);
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis, boolean openShutter, boolean actuateXED) throws IOException, InterruptedException, REBException {
        return this.exposeAcquireAndSave(exposureTimeInMillis, openShutter, actuateXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public List<String> exposeAcquireAndSave(long exposureTimeInMillis, boolean openShutter, boolean actuateXED, String filePattern) throws REBException, IOException, InterruptedException {
        boolean bl;
        LOG.info((Object)("Exposure requested: exptime = " + exposureTimeInMillis + ", shutter = " + openShutter + ", XED = " + actuateXED));
        List mainmap = this.getRaftsCommands().getMainMap();
        boolean hasExposeMain = false;
        boolean hasBiasMain = false;
        boolean hasPocketPumpMain = false;
        boolean hasAcquireMain = false;
        this.setHeader("TemperatureSetPoint", this.raftsCommands.getControlTemp(), true);
        if (this.imageType == null || this.imageType.isEmpty()) {
            LOG.info((Object)"No image type set.");
        }
        for (REBDevice rEBDevice : this.rebDevices) {
            this.setRebName(rEBDevice.getRebNumber(), rEBDevice.getName());
        }
        String mainRoutine = this.raftsCommands.getSequencerStart();
        for (Map mymain : mainmap) {
            if (mymain.keySet().contains("PocketPump")) {
                hasPocketPumpMain = true;
            }
            if (mymain.keySet().contains("Expose")) {
                hasExposeMain = true;
            }
            if (mymain.keySet().contains("Acquire")) {
                hasAcquireMain = true;
            }
            if (!mymain.keySet().contains("Bias")) continue;
            hasBiasMain = true;
        }
        boolean bl2 = bl = exposureTimeInMillis > 0L;
        if (hasPocketPumpMain && hasExposeMain && hasAcquireMain && hasBiasMain) {
            if (exposureTimeInMillis > 0L) {
                mainRoutine = "Acquire";
            } else {
                LOG.info((Object)"selecting bias mains");
                mainRoutine = "Bias";
            }
        } else {
            throw new RuntimeException("Required main routine missing!");
        }
        Predicate imageStateStatusListenerFilter = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(BusMessageFilterFactory.messageOrigin((String)this.subsys.getName()));
        ImageStatusDataListener imageStateListener = new ImageStatusDataListener(this.rebDevices.size());
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)imageStateListener, imageStateStatusListenerFilter);
        ArrayList<String> fitsFiles = new ArrayList<String>();
        try {
            try {
                this.getRaftsCommands().setSequencerParameter("ExposureTime", (int)((double)exposureTimeInMillis / 25.0));
                this.getRaftsCommands().setExposureTime((double)exposureTimeInMillis / 1000.0);
                LOG.info((Object)("ExposureTime " + (int)((double)exposureTimeInMillis / 25.0) + " x 25ms periods"));
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not set exposure time on sequencer");
            }
            ArrayList<SequencerProc> sequencersToStartBeforeAcquisition = new ArrayList<SequencerProc>();
            if (bl) {
                try {
                    if (!this.imageType.toLowerCase().contains("pump")) {
                        LOG.info((Object)"Setting Expose main for all devices ");
                        this.raftsCommands.setSequencerStart("Expose");
                    } else {
                        LOG.info((Object)"Setting PocketPump main for all devices ");
                        this.raftsCommands.setSequencerStart("PocketPump");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while setting the expose main ", e);
                }
                LOG.info((Object)("Exposure main setup: XED REB = " + this.xedREB + " , Shutter REB = " + this.shutterREB));
                for (REBDevice rebDevice : this.rebDevices) {
                    String rebname = rebDevice.getName();
                    try {
                        if (openShutter && rebname.toLowerCase().contains(this.shutterREB.toLowerCase()) || actuateXED && rebname.toLowerCase().contains(this.xedREB.toLowerCase())) {
                            int ExposureFlushPntr = -1;
                            try {
                                ExposureFlushPntr = (Integer)rebDevice.getSequencer().getFunctionMap().get("ExposureFlush");
                            }
                            catch (NullPointerException ne) {
                                ExposureFlushPntr = (Integer)rebDevice.getSequencer().getSubroutineMap().get("ExposureFlush");
                            }
                            LOG.info((Object)("ExposureFlushPntr = " + ExposureFlushPntr));
                            rebDevice.getSequencer().setParameter("Exposure", ExposureFlushPntr);
                            LOG.info((Object)((String)rebname + " sequence set to actuate LVDS during exposure"));
                        } else {
                            int SerialFlushPntr = -1;
                            try {
                                SerialFlushPntr = (Integer)rebDevice.getSequencer().getFunctionMap().get("SerialFlush");
                            }
                            catch (NullPointerException ne) {
                                SerialFlushPntr = (Integer)rebDevice.getSequencer().getSubroutineMap().get("SerialFlush");
                            }
                            LOG.info((Object)("SerialFlushPntr = " + SerialFlushPntr));
                            rebDevice.getSequencer().setParameter("Exposure", SerialFlushPntr);
                            LOG.info((Object)((String)rebname + " sequence set to NOT actuate LVDS during exposure"));
                        }
                        sequencersToStartBeforeAcquisition.add(rebDevice.getSequencer());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while setting parameters ", e);
                    }
                }
            }
            for (SequencerProc sequencerToStart : sequencersToStartBeforeAcquisition) {
                sequencerToStart.startSequencer();
            }
            if (exposureTimeInMillis > 0L) {
                long waitForShutter = exposureTimeInMillis + 2000L;
                if (sequencersToStartBeforeAcquisition.size() > 0) {
                    LOG.info((Object)("Waiting " + waitForShutter + " ms for exposure sequencers to terminate"));
                    for (SequencerProc sequencerToStart : sequencersToStartBeforeAcquisition) {
                        sequencerToStart.waitDone((int)waitForShutter);
                    }
                }
            }
            try {
                this.raftsCommands.setSequencerStart(mainRoutine);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while setting the " + mainRoutine, e);
            }
            for (REBDevice reb : this.rebDevices) {
                reb.getSequencer().resetError();
            }
            LOG.info((Object)("starting image acquisition at " + System.currentTimeMillis() + " millis"));
            this.globalProc.acquireImage();
            imageStateListener.waitForImages(30000L);
            LOG.info((Object)("finished image acquisition at " + System.currentTimeMillis() + " millis"));
            try {
                boolean writeFits = true;
                for (REBDevice reb : this.rebDevices) {
                    if (filePattern != null) {
                        if (!filePattern.isEmpty()) {
                            reb.getImageProc().setFitsFileNamePattern(filePattern);
                        } else {
                            writeFits = false;
                        }
                    }
                    if (!writeFits) continue;
                    List rebFiles = reb.getImageProc().saveFitsImage(null, null);
                    for (String rebFile : rebFiles) {
                        fitsFiles.add(rebFile);
                    }
                }
            }
            catch (RaftException x) {
                throw new IOException("Error while writing FITS files", x);
            }
            LOG.info((Object)"exposure complete");
        }
        finally {
            LOG.info((Object)("Removing listener " + imageStateListener));
            this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)imageStateListener);
            LOG.info((Object)"Clearing non sticky header keywords");
        }
        LOG.info((Object)("Returning " + fitsFiles));
        return fitsFiles;
    }

    @Command(description="Start an acquisition and save the images to fits.", type=Command.CommandType.ACTION)
    public String exposeAcquireAndSaveVerbose(long exposureTimeInMillis, boolean openShutter, boolean actuateXED, String filePattern) throws IOException, InterruptedException, REBException {
        List<String> msg = this.exposeAcquireAndSave(exposureTimeInMillis, openShutter, actuateXED, filePattern);
        return this.aggregatorService.getAllLast().toString();
    }

    @Command(description="Set the default exposure time.", type=Command.CommandType.ACTION)
    public void setDefaultExposureTime(int millis) throws Exception {
        if (millis < 0) {
            throw new IllegalArgumentException("Illegal exposure time: it cannot be negative.");
        }
        this.exposureTimeInMillis = millis;
    }

    @Command(description="Set the sequencer exposure time.", type=Command.CommandType.ACTION)
    public void setSequencerExposureTime(int millis) throws Exception {
        if (millis < 0) {
            throw new IllegalArgumentException("Illegal exposure time: it cannot be negative.");
        }
        this.getRaftsCommands().setSequencerParameter("ExposureTime", (int)((double)millis / 25.0));
    }

    @Command(description="Set the exposure default open shutter flag.", type=Command.CommandType.ACTION)
    public void setDefaultOpenShutter(boolean open) {
        this.openShutter = open;
    }

    @Command(description="Set the exposure default XED actuation.", type=Command.CommandType.ACTION)
    public void setDefaultActuateXED(boolean actuate) {
        this.actuateXED = actuate;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the full Raft module state")
    public RaftState getFullState() {
        return new RaftState(this.getTickPeriod());
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private double biasDACChanOn(String name, REBDevice rebDevice, int idx, double voltage) {
        int dacidx;
        REB reb = rebDevice.getREBConfig();
        switch (name) {
            case "GD": {
                dacidx = 0;
                break;
            }
            case "OD": {
                dacidx = 1;
                break;
            }
            case "RD": {
                dacidx = 5;
                break;
            }
            case "OG": {
                dacidx = 2;
                break;
            }
            case "CSGATE": {
                dacidx = 4;
                break;
            }
            case "CS_GATE": {
                dacidx = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Bias DAC name:  " + name);
            }
        }
        reb.getBiases()[idx].getPValues()[dacidx] = voltage;
        LOG.info((Object)("setting new config with " + name + " voltage at " + voltage + "V"));
        try {
            rebDevice.setREBConfig(reb);
        }
        catch (RaftException re) {
            throw new RuntimeException("Failed to load REB configuration", re);
        }
        LOG.info((Object)this.showREBCfg(rebDevice));
        try {
            int ndacs_loaded = rebDevice.loadBiasDacs(true);
            LOG.info((Object)("#dacs successfully loaded = " + ndacs_loaded));
            if (!name.contains("OD")) {
                this.checkCurrents(rebDevice.getRebNumber());
            } else {
                this.checkCurrents(rebDevice.getRebNumber(), true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("FAILED CHECK AT VOLTAGE : ", e);
        }
        double new_volt = reb.getBiases()[idx].getPValues()[dacidx];
        String msg = rebDevice.getName() + ": " + name + " set to " + new_volt + " V - status OK\n";
        this.raiseAlert(msg, AlertState.NOMINAL);
        LOG.info((Object)msg);
        this.Sleep(this.biasDACChanOnSleep);
        return new_volt;
    }

    private double dacChanOn(String name, REBDevice rebDevice, DACS dacsOriginal, double mag_test_voltage) {
        REB reb = rebDevice.getREBConfig();
        int dacidx = -1;
        switch (name) {
            case "PCLK_HIGH": {
                dacidx = 3;
                break;
            }
            case "PCLK_LOW": {
                dacidx = 2;
                break;
            }
            case "SCLK_HIGH": {
                dacidx = 1;
                break;
            }
            case "SCLK_LOW": {
                dacidx = 0;
                break;
            }
            case "RG_HIGH": {
                dacidx = 5;
                break;
            }
            case "RG_LOW": {
                dacidx = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal DAC name: " + name);
            }
        }
        double test_voltage = Math.copySign(mag_test_voltage, dacsOriginal.getPValues()[dacidx]);
        try {
            reb.getDacs().getPValues()[dacidx] = test_voltage;
            LOG.info((Object)("setting new config with " + name + " test_voltage at " + test_voltage + "V"));
            rebDevice.setREBConfig(reb);
            LOG.info((Object)this.showREBCfg(rebDevice));
            rebDevice.loadDacs(true);
            this.checkCurrents(rebDevice.getRebNumber());
        }
        catch (Exception e) {
            throw new RuntimeException("FAILED CHECK OF " + name + " AT TEST VOLTAGE\n ALERT: " + this.last_alertStr + "\n : ", e);
        }
        try {
            reb.getDacs().getPValues()[dacidx] = dacsOriginal.getPValues()[dacidx];
            LOG.info((Object)("setting new config with " + name + " voltage at " + dacsOriginal.getPValues()[dacidx] + "V"));
            rebDevice.setREBConfig(reb);
            LOG.info((Object)this.showREBCfg(rebDevice));
            rebDevice.loadDacs(true);
        }
        catch (Exception e) {
            throw new RuntimeException("FAILED CHECK OF " + name + " AT FULL VOLTAGE\n ALERT: " + this.last_alertStr + "\n : ", e);
        }
        this.Sleep(this.dacChanOnSleep);
        return reb.getDacs().getPValues()[dacidx];
    }

    private void biasDACChanOff(String name, REBDevice rebDevice, int idx, BiasDACS bias) {
        REB reb = rebDevice.getREBConfig();
        int dacidx = 0;
        switch (name) {
            case "GD": {
                dacidx = 0;
                break;
            }
            case "OD": {
                dacidx = 1;
                break;
            }
            case "RD": {
                dacidx = 5;
                break;
            }
            case "OG": {
                dacidx = 2;
                break;
            }
            case "CSGATE": {
                dacidx = 4;
                break;
            }
            case "CS_GATE": {
                dacidx = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Bias DAC name: " + name);
            }
        }
        try {
            reb.getBiases()[idx].getPValues()[dacidx] = 0.0;
            LOG.info((Object)("setting new config with " + name + " DAC set to at 0"));
            rebDevice.setREBConfig(reb);
            this.showREBCfg(rebDevice);
            rebDevice.loadBiasDacs(true);
        }
        catch (Exception e) {
            throw new RuntimeException("FAILED CHECK AT DAC==0 : ", e);
        }
    }

    private void dacChanOff(String name, REBDevice rebDevice, DACS dacs) {
        REB reb = rebDevice.getREBConfig();
        int dacidx = -1;
        switch (name) {
            case "PCLK_HIGH": {
                dacidx = 3;
                break;
            }
            case "PCLK_LOW": {
                dacidx = 2;
                break;
            }
            case "SCLK_HIGH": {
                dacidx = 1;
                break;
            }
            case "SCLK_LOW": {
                dacidx = 0;
                break;
            }
            case "RG_HIGH": {
                dacidx = 5;
                break;
            }
            case "RG_LOW": {
                dacidx = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal DAC name! " + name);
            }
        }
        try {
            reb.getDacs().getPValues()[dacidx] = 0.0;
            LOG.info((Object)("setting new config with " + name + " DAC voltage = 0.0"));
            rebDevice.setREBConfig(reb);
            this.showREBCfg(rebDevice);
            rebDevice.loadDacs(true);
        }
        catch (Exception e) {
            throw new RuntimeException("FAILED CHECK AT DAC voltage 0.0 : ", e);
        }
    }

    List<REBDevice> getRebDevices() {
        return this.rebDevices;
    }

    Geometry getGeometry() {
        return this.geometry;
    }

    RaftsCommands getRaftsCommands() {
        return this.raftsCommands;
    }

    @Command(type=Command.CommandType.QUERY, description="Set the LSST assigned CCD Serial Number")
    public void setLsstSerialNumber(String ccdId, String serialNumber) {
        this.setCCDHeader(ccdId, "CCDSerialLSST", serialNumber, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Measured CCD Temperature")
    public void setMeasuredCCDTemperature(String ccdId, double ccdtemp) {
        LOG.info((Object)("Setting measured CCD temperature to " + ccdtemp));
        this.setCCDHeader(ccdId, "MeasuredTemperature", ccdtemp, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Measured CCD HVBias")
    public void setMeasuredCCDBSS(String ccdId, double hvbss) {
        LOG.info((Object)("Setting measured CCDBSS to " + hvbss));
        this.setCCDHeader(ccdId, "MeasuredCCDBSS", hvbss, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Monochromator Wavelength")
    public void setMonoWavelength(double wl) {
        LOG.info((Object)("Setting header MonochromatorWL to " + wl));
        this.setHeader("MonochromatorWavelength", wl, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Set the Manufacturer assigned CCD Serial Number")
    public void setManufacturerSerialNumber(String ccdId, String serialNumber) {
        this.setCCDHeader(ccdId, "CCDSerialManufacturer", serialNumber, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the test type property for the output filename")
    public void setTestType(String ttype) {
        this.setHeader("TestType", ttype, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the name of the test stand station")
    public void setTestStand(String tsname) {
        this.setHeader("TestStand", tsname, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the image type property for the output filename")
    public void setImageType(String itype) {
        this.imageType = itype;
        this.setHeader("ImageType", itype, true);
    }

    @Command(type=Command.CommandType.QUERY, description="Sets the sequence info property for the output filename")
    public void setSeqInfo(Integer seqNum) {
        this.setHeader("SequenceInfo", String.format("%03d", seqNum), true);
        this.raftsCommands.setSequenceNumber(seqNum.intValue());
    }

    @Command
    public void showPhotoDiodeAnalysis(String pddatfile) throws IOException, FitsException {
        this.fitsUtils.showPhotoDiodeAnalysis(new File(pddatfile));
    }

    @Command
    public void addBinaryTable(String pddatfile, String fitsfile, String extnam, String c1name, String c2name, double tstart) throws IOException, FitsException {
        this.fitsUtils.updatePhotoDiodeValues(new File(pddatfile), new File(fitsfile), extnam, c1name, c2name, tstart);
    }

    @Command
    public double getFluxStats(String fitsfile) throws FitsException, IOException {
        return this.fitsUtils.getFluxStats(new File(fitsfile));
    }

    public void Sleep(double secs) {
        if (secs <= 0.0) {
            return;
        }
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            LOG.error((Object)("Rude awakening!" + ex));
        }
    }

    class ChanParams {
        private final int type;
        private final int addr;

        ChanParams(int type, int addr) {
            this.type = type;
            this.addr = addr;
        }
    }

    private class ImageStatusDataListener
    implements StatusMessageListener {
        private final CountDownLatch latch;

        ImageStatusDataListener(int nImages) {
            this.latch = new CountDownLatch(nImages);
        }

        public void onStatusMessage(StatusMessage msg) {
            StatusSubsystemData statusData = (StatusSubsystemData)msg;
            if (statusData.getDataKey().equals("ImageState")) {
                this.latch.countDown();
            }
        }

        public void waitForImages(long timeout) throws InterruptedException {
            boolean done = this.latch.await(timeout, TimeUnit.MILLISECONDS);
            if (!done) {
                throw new RuntimeException("Exceeded " + timeout + "mS wait period to receive all images. " + this.latch.getCount() + " images have not been received.");
            }
        }
    }
}

