/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8;

import java.nio.ByteBuffer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.TestClientFactorySimulator;
import org.lsst.ccs.subsystem.ts8.TS8FitsHeaderMetadataProvider;
import org.lsst.ccs.subsystem.ts8.TS8Subsystem;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class TS8FitsFileWritingTest
extends CcsTestCaseTemplate {
    private static Subsystem testSubsystem = null;
    private static TS8Subsystem ts8Main = null;
    private static ConcurrentMessagingUtils cmu;
    private static Agent listener;
    private final Object imageReadyLock = new Object();

    @BeforeClass
    public static void createSubsystem() throws Exception {
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.config.WriterProvier", "");
        testSubsystem = BootUtils.getSubsystemFromFile((String)"ts8_fits_files_writing", (String)"");
        testSubsystem.startAgent();
        ts8Main = (TS8Subsystem)testSubsystem.getComponentLookup().getComponentByPath("main");
        ts8Main.getRaftsCommands().setFitsFileNamePattern("testFits");
        listener = new Agent("agent_listner", AgentInfo.AgentType.CONSOLE);
        listener.startAgent();
        cmu = new ConcurrentMessagingUtils(listener.getMessagingAccess());
    }

    @AfterClass
    public static void shutdownSubsystem() throws Exception {
        testSubsystem.shutdownAgent();
        listener.shutdownAgent();
        System.setProperty("org.lsst.ccs.run.mode", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImageDataContent() throws Exception {
        ImageStateListener imageStateListener = new ImageStateListener(ts8Main.getRebDevices().size());
        listener.getMessagingAccess().addStatusMessageListener((StatusMessageListener)imageStateListener);
        ts8Main.getRaftsCommands().loadSequencer("sequencer-reb4.xml");
        ts8Main.setRaftName("LCA-11021_RTM-001");
        ts8Main.setRebName(0, "LCA-10753_RSA-001");
        ts8Main.setRunNumber("1235446D");
        Object object = this.imageReadyLock;
        synchronized (object) {
            ts8Main.getRaftsCommands().startSequencer();
            this.imageReadyLock.wait();
        }
        TestClientFactorySimulator.TestSegmentDataProvider dataProvider = TestClientFactorySimulator.dataProvider;
        ByteBuffer generatedData = dataProvider.getGeneratedData();
        for (REBDevice reb : ts8Main.getRebDevices()) {
            String rebName = reb.getName();
            ByteBuffer[][] imageData = reb.getImageProc().splitImage();
            Reb currentReb = (Reb)ts8Main.getGeometry().findGeometry(rebName);
            Assert.assertEquals((long)3L, (long)imageData.length);
            Assert.assertEquals((long)16L, (long)imageData[0].length);
            int size = generatedData.capacity() / 4 / 48;
            Assert.assertEquals((long)size, (long)(imageData[0][0].capacity() / 4));
            for (int j = 0; j < size; ++j) {
                for (int ccd = 0; ccd < 3; ++ccd) {
                    for (int adc = 0; adc < 16; ++adc) {
                        ByteBuffer bb = imageData[3 - ccd][adc];
                        Assert.assertEquals((long)bb.getInt(), (long)(generatedData.getInt() ^ 0x1FFFF));
                    }
                }
            }
            generatedData.flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFitsFile() throws Exception {
        ImageStateListener imageStateListener = new ImageStateListener(ts8Main.getRebDevices().size());
        listener.getMessagingAccess().addStatusMessageListener((StatusMessageListener)imageStateListener);
        ts8Main.setMeasuredCCDTemperature("R00.Reb0.Sen01", 32.3);
        ts8Main.getRaftsCommands().loadSequencer("sequencer-reb4.xml");
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)ts8Main.getGeometry(), (String)"image", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)ts8Main.getGeometry(), (GeneratedImage)generatedImage);
        Object object = this.imageReadyLock;
        synchronized (object) {
            ts8Main.getRaftsCommands().startSequencer();
            this.imageReadyLock.wait();
        }
        ts8Main.getRaftsCommands().saveFitsImage(null, (FitsHeaderMetadataProvider)new TS8FitsHeaderMetadataProvider(ts8Main, ts8Main.getCommonMedaDataSet()));
    }

    private class ImageStateListener
    implements StatusMessageListener {
        private int msgCount = 0;
        private final int msgLimit;

        public ImageStateListener(int nRebs) {
            this.msgLimit = nRebs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            StatusSubsystemData ssdata;
            if (msg.getOriginAgentInfo().getName().equals("ts8_tests") && msg instanceof StatusSubsystemData && (ssdata = (StatusSubsystemData)msg).getDataKey().equals("ImageState")) {
                Object object = TS8FitsFileWritingTest.this.imageReadyLock;
                synchronized (object) {
                    ++this.msgCount;
                    if (this.msgCount == this.msgLimit) {
                        TS8FitsFileWritingTest.this.imageReadyLock.notifyAll();
                    }
                }
            }
        }
    }
}

