/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class HeaderSpecification {
    private String name;
    private final Map<String, HeaderLine> headers = new LinkedHashMap<String, HeaderLine>();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(.*)}");
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile(".*(\\[System\\(([^,]+)(,.*)?\\)\\]).*");
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*(\\S+)\\s+(\\w+)\\s+(?:\"(.*)\"|(\\S+))\\s*(.*)");

    public HeaderSpecification(String name, InputStream in) throws IOException {
        this(name, new InputStreamReader(in));
    }

    public HeaderSpecification(String name, Reader in) throws IOException {
        this.name = name;
        this.loadHeaderSpecification(in);
    }

    final void loadHeaderSpecification(InputStream in) throws IOException {
        this.loadHeaderSpecification(new InputStreamReader(in));
    }

    final void loadHeaderSpecification(Reader in) throws IOException {
        String line;
        BufferedReader reader;
        BufferedReader bufferedReader = reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            try {
                Matcher sysPropMatcher;
                while ((sysPropMatcher = SYSTEM_PROPERTY_PATTERN.matcher(line)).matches()) {
                    String def = sysPropMatcher.group(3);
                    def = def == null ? "" : def.substring(1);
                    line = line.replace(sysPropMatcher.group(1), System.getProperty(sysPropMatcher.group(2), def));
                }
                HeaderLine headerLine = new HeaderLine(line);
                this.headers.put(headerLine.getKeyword(), headerLine);
            }
            catch (IOException x) {
                throw new IOException("Error while reading line:\n\t" + line, x);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public HeaderLine getHeader(String keyWord) {
        return this.headers.get(keyWord);
    }

    public Collection<HeaderLine> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    public static class HeaderLine {
        private final String keyword;
        private final DataType dataType;
        private final String comment;
        private final String metaName;
        private final Object value;
        private final String metaMap;
        private final boolean isExpression;
        private final boolean isWarning;

        HeaderLine(String line) throws IOException {
            String origLine = line;
            try {
                Matcher lineMatcher = LINE_PATTERN.matcher(line);
                if (!lineMatcher.matches()) {
                    throw new IOException("Invalid line in header specification");
                }
                this.keyword = lineMatcher.group(1);
                this.dataType = DataType.valueOf(lineMatcher.group(2));
                String valueExpression = lineMatcher.group(3) == null ? lineMatcher.group(4) : lineMatcher.group(3);
                Matcher matcher = EXPRESSION_PATTERN.matcher(valueExpression);
                this.isExpression = matcher.matches();
                if (this.isExpression) {
                    String expression = matcher.group(1);
                    int dotIndex = expression.indexOf(".");
                    int slashIndex = expression.indexOf("/");
                    if (dotIndex == -1 || dotIndex != -1 && slashIndex != -1 && slashIndex < dotIndex) {
                        this.metaMap = null;
                        this.metaName = expression;
                    } else {
                        this.metaMap = expression.substring(0, dotIndex);
                        this.metaName = expression.substring(dotIndex + 1);
                    }
                    this.value = null;
                    boolean bl = this.isWarning = (this.metaMap == null || this.metaMap.isEmpty()) && this.metaName.contains("/");
                    if (this.isWarning) {
                        FitsHeadersSpecificationsBuilder.log.warn((Object)("Path like format to identify trending quantities has been discontinued.\nUse " + this.metaName.replaceFirst("/", ".") + " instead of " + this.metaName));
                    }
                } else {
                    this.metaMap = null;
                    this.metaName = null;
                    this.value = this.coerce(valueExpression, this.dataType);
                    this.isWarning = false;
                }
                this.comment = lineMatcher.group(5);
            }
            catch (IllegalArgumentException | FitsException x) {
                throw new IOException("Illegal token found while reading header specification", x);
            }
            FitsHeadersSpecificationsBuilder.log.debug((Object)("HeaderLine " + this.keyword + " " + this.metaMap + " " + this.metaName + " [" + origLine + "]"));
        }

        public String getKeyword() {
            return this.keyword;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getMetaName() {
            return this.metaName;
        }

        String getMetaMap() {
            return this.metaMap;
        }

        public String getComment() {
            return this.comment;
        }

        Object getValue(MetaDataSet metaDataSet) {
            if (this.isExpression) {
                return this.findMetaDataValue(this.metaMap, this.metaName, metaDataSet);
            }
            return this.value;
        }

        boolean isWarning() {
            return this.isWarning;
        }

        private Object findMetaDataValue(String map, String name, MetaDataSet metaDataSet) {
            Object obj = metaDataSet.getValue(map, name);
            if (obj instanceof String) {
                try {
                    obj = this.coerce((String)obj, this.dataType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return obj;
        }

        private Object coerce(String valueExpression, DataType dataType) throws FitsException, NumberFormatException {
            switch (dataType) {
                case Integer: {
                    return Integer.decode(valueExpression);
                }
                case Float: {
                    return Double.valueOf(valueExpression);
                }
                case Boolean: {
                    return Boolean.valueOf(valueExpression);
                }
                case Date: {
                    return DateUtils.convertStringToDate(valueExpression);
                }
                case MJD: {
                    return Double.valueOf(valueExpression);
                }
            }
            return valueExpression;
        }
    }

    public static enum DataType {
        Boolean,
        Integer,
        String,
        Float,
        Date,
        MJD;

    }
}

