/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.DACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class DacControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String SCLK_LOW_P = "sclkLowP";
    public static final String SCLK_HIGH_P = "sclkHighP";
    public static final String PCLK_LOW_P = "pclkLowP";
    public static final String PCLK_HIGH_P = "pclkHighP";
    public static final String RG_LOW_P = "rgLowP";
    public static final String RG_HIGH_P = "rgHighP";
    public static final String SCLK_LOW = "sclkLow";
    public static final String SCLK_LOW_SH = "sclkLowSh";
    public static final String SCLK_HIGH = "sclkHigh";
    public static final String SCLK_HIGH_SH = "sclkHighSh";
    public static final String PCLK_LOW = "pclkLow";
    public static final String PCLK_LOW_SH = "pclkLowSh";
    public static final String PCLK_HIGH = "pclkHigh";
    public static final String PCLK_HIGH_SH = "pclkHighSh";
    public static final String RG_LOW = "rgLow";
    public static final String RG_LOW_SH = "rgLowSh";
    public static final String RG_HIGH = "rgHigh";
    public static final String RG_HIGH_SH = "rgHighSh";
    public static final String CS_GATE = "csGate";
    private static final int SCLK_LOW_CH = 1;
    private static final int SCLK_LOW_SH_CH = 2;
    private static final int SCLK_HIGH_CH = 4;
    private static final int SCLK_HIGH_SH_CH = 8;
    private static final int PCLK_LOW_CH = 16;
    private static final int PCLK_LOW_SH_CH = 32;
    private static final int PCLK_HIGH_CH = 64;
    private static final int PCLK_HIGH_SH_CH = 128;
    private static final int RG_LOW_CH = 256;
    private static final int RG_LOW_SH_CH = 512;
    private static final int RG_HIGH_CH = 1024;
    private static final int RG_HIGH_SH_CH = 2048;
    private static final int CS_GATE_CH = 4096;
    private static final String[] checkList = new String[]{"sclkLow", "sclkHigh", "pclkLow", "pclkHigh", "rgLow", "rgHigh"};
    private static final double DAC_TOLERANCE = 0.4;
    private static final int DEFAULT_LOAD_WAIT = 200;
    private static final int DEFAULT_CLEAR_WAIT = 50;
    private static final double TEST_VOLTS = 0.5;
    private static final double ZERO_ERROR = 0.2;
    private static final double VALUE_ERROR = 0.2;
    private static final double CHANGE_ERROR = 0.1;
    private static final double CLK_SHORTS_LIMIT = 0.002;
    private static final int ADC_PCLK_L = 0;
    private static final int ADC_PCLK_U = 1;
    private static final int ADC_SCLK_L = 2;
    private static final int ADC_SCLK_U = 3;
    private static final int ADC_RG_L = 4;
    private static final int ADC_RG_U = 5;
    private static final int NUM_ADCS = 6;
    private static final String[] adcName = new String[]{"PCLK_L", "PCLK_U", "SCLK_L", "SCLK_U", "RG_L", "RG_U"};
    private static final int[] seqLines = new int[]{3840, 0, 112, 0, 128, 0};
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(category="Rafts", description="Serial clock low", units="volts")
    private double sclkLowP;
    @ConfigurationParameter(category="Rafts", description="Serial clock high", units="volts")
    private double sclkHighP;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low", units="volts")
    private double pclkLowP;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high", units="volts")
    private double pclkHighP;
    @ConfigurationParameter(category="Rafts", description="Reset gate low", units="volts")
    private double rgLowP;
    @ConfigurationParameter(category="Rafts", description="Reset gate high", units="volts")
    private double rgHighP;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock low min", units="volts")
    private double sclkLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock low max", units="volts")
    private double sclkLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock high min", units="volts")
    private double sclkHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock high max", units="volts")
    private double sclkHighMax;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock low min", units="volts")
    private double pclkLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock low max", units="volts")
    private double pclkLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock high min", units="volts")
    private double pclkHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock high max", units="volts")
    private double pclkHighMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate low min", units="volts")
    private double rgLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate low max", units="volts")
    private double rgLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate high min", units="volts")
    private double rgHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate high max", units="volts")
    private double rgHighMax;
    @ConfigurationParameter(category="Rafts", description="Serial clock low", units="DAC counts")
    private int sclkLow;
    @ConfigurationParameter(category="Rafts", description="Serial clock low shifted", units="DAC counts")
    private int sclkLowSh;
    @ConfigurationParameter(category="Rafts", description="Serial clock high", units="DAC counts")
    private int sclkHigh;
    @ConfigurationParameter(category="Rafts", description="Serial clock high shifted", units="DAC counts")
    private int sclkHighSh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low", units="DAC counts")
    private int pclkLow;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low shifted", units="DAC counts")
    private int pclkLowSh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high", units="DAC counts")
    private int pclkHigh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high shifted", units="DAC counts")
    private int pclkHighSh;
    @ConfigurationParameter(category="Rafts", description="Reset gate low", units="DAC counts")
    private int rgLow;
    @ConfigurationParameter(category="Rafts", description="Reset gate low shifted", units="DAC counts")
    private int rgLowSh;
    @ConfigurationParameter(category="Rafts", description="Reset gate high", units="DAC counts")
    private int rgHigh;
    @ConfigurationParameter(category="Rafts", description="Reset gate high shifted", units="DAC counts")
    private int rgHighSh;
    @ConfigurationParameter(category="Rafts", description="Current source", units="DAC counts")
    private final int[] csGate = new int[3];
    private boolean raw = false;
    private static final Logger LOG = Logger.getLogger((String)DacControl.class.getName());
    private boolean cfgValid;
    private boolean isCurrent;
    private boolean isCorner;
    private int hwVersion;
    private REBDevice rebDevc;
    private BoardDacs dac;
    private int changed = -1;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private double railShiftConvH;
    private double railConvH;
    private double railShiftConvL;
    private double railConvL;
    private int adcType;

    public DacControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.rebDevc = (REBDevice)devc;
        this.dac = this.rebDevc.getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = DacControl.getHwVersion(this.dac);
        this.isCurrent = this.hwVersion >= 1;
        boolean bl = this.isCorner = this.hwVersion == 1 || this.hwVersion == 3;
        if (!this.raw) {
            double shiftGainH = this.hwVersion == 1 ? 2.0 : 2.4899999999999998;
            double shiftGainL = this.hwVersion == 2 ? 2.4677898909811695 : shiftGainH;
            double fudge = this.hwVersion == 1 ? 1.0 : 1.04;
            this.railShiftConvH = fudge * 819.0 / shiftGainH;
            this.railConvH = fudge * 819.0 / (1.0 + shiftGainH);
            this.railShiftConvL = fudge * 819.0 / shiftGainL;
            this.railConvL = fudge * 819.0 / (1.0 + shiftGainL);
        } else {
            this.cfgValid = true;
        }
        this.adcType = this.isCorner ? 6 : 4;
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        version = version == 0 || version == 1 ? 0 : (version == 2 || version == 4 || version == 5 ? 1 : (version == 3 || version == 6 ? 2 : (version == 7 || version == 8 ? 3 : -1)));
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        String errMsg = null;
        if (!this.raw) {
            for (String pName : checkList) {
                double max;
                double value = (Double)params.get(pName + "P");
                if (value > (max = ((Double)params.get(pName + "Max")).doubleValue())) {
                    errMsg = String.format("%s: %sP (%5.5g) is above high limit (%5.5g)", this.getName(), pName, value, max);
                    break;
                }
                double min = (Double)params.get(pName + "Min");
                if (!(value < min)) continue;
                errMsg = String.format("%s: %sP (%5.5g) is below low limit (%5.5g)", this.getName(), pName, value, min);
                break;
            }
        }
        if (errMsg != null) {
            LOG.severe((Object)("Configuration failure: " + errMsg));
            throw new IllegalArgumentException(errMsg);
        }
        this.cfgValid = true;
    }

    @ConfigurationParameterChanger
    public void setPclkLowP(double value) {
        this.pclkLowP = value;
    }

    public double getPclkLowP() {
        return this.pclkLowP;
    }

    @ConfigurationParameterChanger
    public void setPclkLowMax(double value) {
        this.pclkLowMax = value;
        this.highLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLowMin(double value) {
        this.pclkLowMin = value;
        this.lowLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLow(int value) {
        this.pclkLow = value;
        this.changed |= 0x10;
    }

    public int getPclkLow() {
        return this.pclkLow;
    }

    @ConfigurationParameterChanger
    public void setPclkLowSh(int value) {
        this.pclkLowSh = value;
        this.changed |= 0x20;
    }

    public int getPclkLowSh() {
        return this.pclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighP(double value) {
        this.pclkHighP = value;
    }

    public double getPclkHighP() {
        return this.pclkHighP;
    }

    @ConfigurationParameterChanger
    public void setPclkHighMax(double value) {
        this.pclkHighMax = value;
        this.highLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHighMin(double value) {
        this.pclkHighMin = value;
        this.lowLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHigh(int value) {
        this.pclkHigh = value;
        this.changed |= 0x40;
    }

    public int getPclkHigh() {
        return this.pclkHigh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighSh(int value) {
        this.pclkHighSh = value;
        this.changed |= 0x80;
    }

    public int getPclkHighSh() {
        return this.pclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setSclkLowP(double value) {
        this.sclkLowP = value;
    }

    public double getSclkLowP() {
        return this.sclkLowP;
    }

    @ConfigurationParameterChanger
    public void setSclkLowMax(double value) {
        this.sclkLowMax = value;
        this.highLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLowMin(double value) {
        this.sclkLowMin = value;
        this.lowLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLow(int value) {
        this.sclkLow = value;
        this.changed |= 1;
    }

    public int getSclkLow() {
        return this.sclkLow;
    }

    @ConfigurationParameterChanger
    public void setSclkLowSh(int value) {
        this.sclkLowSh = value;
        this.changed |= 2;
    }

    public int getSclkLowSh() {
        return this.sclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighP(double value) {
        this.sclkHighP = value;
    }

    public double getSclkHighP() {
        return this.sclkHighP;
    }

    @ConfigurationParameterChanger
    public void setSclkHighMax(double value) {
        this.sclkHighMax = value;
        this.highLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHighMin(double value) {
        this.sclkHighMin = value;
        this.lowLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHigh(int value) {
        this.sclkHigh = value;
        this.changed |= 4;
    }

    public int getSclkHigh() {
        return this.sclkHigh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighSh(int value) {
        this.sclkHighSh = value;
        this.changed |= 8;
    }

    public int getSclkHighSh() {
        return this.sclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setRgLowP(double value) {
        this.rgLowP = value;
    }

    public double getRgLowP() {
        return this.rgLowP;
    }

    @ConfigurationParameterChanger
    public void setRgLowMax(double value) {
        this.rgLowMax = value;
        this.highLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLowMin(double value) {
        this.rgLowMin = value;
        this.lowLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLow(int value) {
        this.rgLow = value;
        this.changed |= 0x100;
    }

    public int getRgLow() {
        return this.rgLow;
    }

    @ConfigurationParameterChanger
    public void setRgLowSh(int value) {
        this.rgLowSh = value;
        this.changed |= 0x200;
    }

    public int getRgLowSh() {
        return this.rgLowSh;
    }

    @ConfigurationParameterChanger
    public void setRgHighP(double value) {
        this.rgHighP = value;
    }

    public double getRgHighP() {
        return this.rgHighP;
    }

    @ConfigurationParameterChanger
    public void setRgHighMax(double value) {
        this.rgHighMax = value;
        this.highLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHighMin(double value) {
        this.rgHighMin = value;
        this.lowLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHigh(int value) {
        this.rgHigh = value;
        this.changed |= 0x400;
    }

    public int getRgHigh() {
        return this.rgHigh;
    }

    @ConfigurationParameterChanger
    public void setRgHighSh(int value) {
        this.rgHighSh = value;
        this.changed |= 0x800;
    }

    public int getRgHighSh() {
        return this.rgHighSh;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int[] value) {
        System.arraycopy(value, 0, this.csGate, 0, this.csGate.length);
        this.changed |= 0x1000;
    }

    public int[] getCsGate() {
        return this.csGate;
    }

    void setConfig(DACS dacs) throws RaftException {
        String name = this.getName();
        if (!this.raw) {
            double[] values = dacs.getPValues();
            this.sce.submitChange(name, RG_HIGH_P, (Object)values[5]);
            this.sce.submitChange(name, RG_LOW_P, (Object)values[4]);
            this.sce.submitChange(name, PCLK_HIGH_P, (Object)values[3]);
            this.sce.submitChange(name, PCLK_LOW_P, (Object)values[2]);
            this.sce.submitChange(name, SCLK_HIGH_P, (Object)values[1]);
            this.sce.submitChange(name, SCLK_LOW_P, (Object)values[0]);
        } else {
            int[] values = dacs.getValues();
            this.sce.submitChange(name, RG_HIGH, (Object)values[5]);
            this.sce.submitChange(name, RG_LOW, (Object)values[4]);
            this.sce.submitChange(name, PCLK_HIGH, (Object)values[3]);
            this.sce.submitChange(name, PCLK_LOW, (Object)values[2]);
            this.sce.submitChange(name, SCLK_HIGH, (Object)values[1]);
            this.sce.submitChange(name, SCLK_LOW, (Object)values[0]);
            if (this.isCurrent) {
                this.sce.submitChange(name, RG_LOW_SH, (Object)values[10]);
                this.sce.submitChange(name, PCLK_LOW_SH, (Object)values[8]);
                this.sce.submitChange(name, SCLK_LOW_SH, (Object)values[6]);
                if (this.isCorner) {
                    this.sce.submitChange(name, RG_HIGH_SH, (Object)values[11]);
                    this.sce.submitChange(name, PCLK_HIGH_SH, (Object)values[9]);
                    this.sce.submitChange(name, SCLK_HIGH_SH, (Object)values[7]);
                }
            } else {
                this.sce.submitChange(name, CS_GATE, (Object)new int[]{values[12], values[13], values[14]});
            }
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (BulkValidationException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw new RaftException("Bulk configuration validation failed");
        }
    }

    void getConfig(DACS dacs) {
        if (!this.raw) {
            double[] values = dacs.getPValues();
            values[5] = this.rgHighP;
            values[4] = this.rgLowP;
            values[3] = this.pclkHighP;
            values[2] = this.pclkLowP;
            values[1] = this.sclkHighP;
            values[0] = this.sclkLowP;
        } else {
            int[] values = dacs.getValues();
            values[5] = this.rgHigh;
            values[4] = this.rgLow;
            values[3] = this.pclkHigh;
            values[2] = this.pclkLow;
            values[1] = this.sclkHigh;
            values[0] = this.sclkLow;
            if (this.isCurrent) {
                values[10] = this.rgLowSh;
                values[8] = this.pclkLowSh;
                values[6] = this.sclkLowSh;
                if (this.isCorner) {
                    values[11] = this.rgHighSh;
                    values[9] = this.pclkHighSh;
                    values[7] = this.sclkHighSh;
                }
            } else {
                values[12] = this.csGate[0];
                values[13] = this.csGate[1];
                values[14] = this.csGate[2];
            }
        }
    }

    public int loadConfig(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadConfig(200, check, dataList);
    }

    public int loadConfig(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        count += this.loadSclkHigh(wait, check, dataList);
        count += this.loadSclkLow(wait, check, dataList);
        count += this.loadPclkHigh(wait, check, dataList);
        count += this.loadPclkLow(wait, check, dataList);
        count += this.loadRgHigh(wait, check, dataList);
        count += this.loadRgLow(wait, check, dataList);
        if (!this.isCurrent) {
            this.setDac(17, this.csGate[0]);
            this.setDac(19, this.csGate[1]);
            this.setDac(20, this.csGate[2]);
            this.loadDac(wait);
            count += 3;
        }
        this.changed = 0;
        return count;
    }

    public int loadChanged(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadChanged(200, check, dataList);
    }

    public int loadChanged(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        if ((this.changed & 4) != 0) {
            count += this.loadSclkHigh(wait, check, dataList);
        }
        if ((this.changed & 1) != 0) {
            count += this.loadSclkLow(wait, check, dataList);
        }
        if ((this.changed & 0x40) != 0) {
            count += this.loadPclkHigh(wait, check, dataList);
        }
        if ((this.changed & 0x10) != 0) {
            count += this.loadPclkLow(wait, check, dataList);
        }
        if ((this.changed & 0x400) != 0) {
            count += this.loadRgHigh(wait, check, dataList);
        }
        if ((this.changed & 0x100) != 0) {
            count += this.loadRgLow(wait, check, dataList);
        }
        if (!this.isCurrent && (this.changed & 0x1000) != 0) {
            this.setDac(17, this.csGate[0]);
            this.setDac(19, this.csGate[1]);
            this.setDac(20, this.csGate[2]);
            this.loadDac(wait);
            count += 3;
        }
        this.changed = 0;
        return count;
    }

    public void clear() throws RaftException {
        this.clear(50);
    }

    public void clear(int wait) throws RaftException {
        this.clearRgLow(wait);
        this.clearRgHigh(wait);
        this.clearPclkLow(wait);
        this.clearPclkHigh(wait);
        this.clearSclkLow(wait);
        this.clearSclkHigh(wait);
        if (!this.isCurrent) {
            this.setDac(17, 0);
            this.setDac(19, 0);
            this.setDac(20, 0);
            this.loadDac(wait);
        }
        this.changed = -1;
    }

    public boolean testShorts(String rebName, List adcDataList, List pwrDataList) throws RaftException {
        boolean failed = this.testShorts(rebName, 2, 0, 3, 2, adcDataList, pwrDataList);
        failed |= this.testShorts(rebName, 6, 4, 5, 4, adcDataList, pwrDataList);
        return failed |= this.testShorts(rebName, 10, 8, 1, 0, adcDataList, pwrDataList);
    }

    private boolean testShorts(String rebName, int dacUp, int dacLo, int adcUp, int adcLo, List adcDataList, List pwrDataList) throws RaftException {
        int seqState = this.rebDevc.readSeqIdleState();
        long tstamp = this.rebDevc.getTime();
        seqState = this.rebDevc.readSeqIdleState();
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d SeqIdleState= %#x", tstamp, seqState));
        this.readSlowAdcs(adcDataList);
        double[] origPower = this.readPowerAdcs(pwrDataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d initial reading done", tstamp));
        int savedState = this.rebDevc.readSeqIdleState();
        this.rebDevc.writeSeqIdleState(savedState & ~seqLines[adcLo]);
        seqState = this.rebDevc.readSeqIdleState();
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d %s sequencer lines set to low: SeqIdleState= %#x", tstamp, adcName[adcLo], seqState));
        this.setDac(dacUp, 0);
        this.setDac(dacLo, 0);
        this.loadDac(50);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d set both rails to 0", tstamp));
        LOG.fine((Object)String.format("%d %s,%s set to 0.0 with %d ms wait", tstamp, adcName[adcLo], adcName[adcUp], 50));
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d settled for %d ms", tstamp, 50));
        double[] lowerPower = this.readPowerAdcs(pwrDataList);
        double[] lowerAdcs = this.readSlowAdcs(adcDataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d recorded lower values", tstamp));
        this.setDac(dacUp, (int)(this.railConvH * 0.5));
        this.setDac(dacLo, (int)(this.railConvL * 0.5));
        this.loadDac(200);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d %s,%s set to %.2f with %d ms wait", tstamp, adcName[adcLo], adcName[adcUp], 0.5, 200));
        double[] upperPower = this.readPowerAdcs(pwrDataList);
        double[] upperAdcs = this.readSlowAdcs(adcDataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d recorded at test voltage", tstamp));
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.readPowerAdcs(pwrDataList);
        this.readSlowAdcs(adcDataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d pedestal reading", tstamp));
        this.setDac(dacUp, 0);
        this.setDac(dacLo, 0);
        this.loadDac(50);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d set both rails to 0", tstamp));
        LOG.fine((Object)String.format("%d %s clock rails set to 0.0 with %d ms wait", tstamp, adcName[adcLo], 50));
        this.readPowerAdcs(pwrDataList);
        this.readSlowAdcs(adcDataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d final reading", tstamp));
        this.rebDevc.writeSeqIdleState(savedState);
        seqState = this.rebDevc.readSeqIdleState();
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d SeqIdleState= %#x", tstamp, seqState));
        return this.checkValues(rebName, adcUp, adcLo, lowerAdcs, upperAdcs, origPower, lowerPower, upperPower);
    }

    private boolean checkValues(String rebName, int adcUp, int adcLo, double[] baseAdcs, double[] measAdcs, double[] origPower, double[] basePower, double[] measPower) {
        boolean failed = false;
        for (int ad = 0; ad < 6; ++ad) {
            double basevalue = baseAdcs[ad];
            double measvalue = measAdcs[ad];
            if (ad == adcUp || ad == adcLo) {
                if (Math.abs(basevalue) > 0.2) {
                    LOG.severe((Object)String.format("%s %s baseline value (%.2f) is out of bounds (%.2f)", rebName, adcName[ad], basevalue, 0.2));
                    failed = true;
                }
                if (!(Math.abs(measvalue - 0.5) > 0.2)) continue;
                LOG.severe((Object)String.format("%s %s measured value (%.2f) is out of bounds (%.2f +/- %.2f)", rebName, adcName[ad], measvalue, 0.5, 0.2));
                failed = true;
                continue;
            }
            if (!(Math.abs(measvalue - basevalue) > 0.1)) continue;
            LOG.severe((Object)String.format("%s %s change of (%.2f) is out of bounds (+/- %.2f)", rebName, adcName[ad], measvalue - basevalue, 0.1));
            failed = true;
        }
        if (basePower[5] > origPower[5] + 0.002) {
            LOG.severe((Object)String.format("%s ClkHi base current increased excessively from %.2f mA to %.2f mA while testing %s", rebName, 1000.0 * origPower[5], 1000.0 * basePower[5], adcName[adcUp]));
            failed = true;
        }
        if (measPower[5] > basePower[5] + 0.002) {
            LOG.severe((Object)String.format("%s ClkHi meas current increased excessively from %.2f mA to %.2f mA while testing %s", rebName, 1000.0 * basePower[5], 1000.0 * measPower[5], adcName[adcUp]));
            failed = true;
        }
        if (basePower[9] > origPower[9] + 0.002) {
            LOG.severe((Object)String.format("%s ClkLo base current increased excessively from %.2f mA to %.2f mA while testing %s", rebName, 1000.0 * origPower[9], 1000.0 * basePower[9], adcName[adcUp]));
            failed = true;
        }
        if (measPower[9] > basePower[9] + 0.002) {
            LOG.severe((Object)String.format("%s ClkLo meas current increased excessively from %.2f mA to %.2f mA while testing %s", rebName, 1000.0 * basePower[9], 1000.0 * measPower[9], adcName[adcUp]));
            failed = true;
        }
        return failed;
    }

    private double[] readSlowAdcs(List dataList) {
        double[] values = new double[6];
        CCSTimeStamp tstamp = CCSTimeStamp.currentTime();
        values[0] = this.rebDevc.readChannelNow(26, this.adcType);
        dataList.add(new REBDevice.AdcData(26, values[0], tstamp));
        values[1] = this.rebDevc.readChannelNow(27, this.adcType);
        dataList.add(new REBDevice.AdcData(27, values[1], tstamp));
        values[2] = this.rebDevc.readChannelNow(20, this.adcType);
        dataList.add(new REBDevice.AdcData(20, values[2], tstamp));
        values[3] = this.rebDevc.readChannelNow(21, this.adcType);
        dataList.add(new REBDevice.AdcData(21, values[3], tstamp));
        values[4] = this.rebDevc.readChannelNow(22, this.adcType);
        dataList.add(new REBDevice.AdcData(22, values[4], tstamp));
        values[5] = this.rebDevc.readChannelNow(23, this.adcType);
        dataList.add(new REBDevice.AdcData(23, values[5], tstamp));
        return values;
    }

    private double[] readPowerAdcs(List dataList) throws RaftException {
        CCSTimeStamp tstamp = CCSTimeStamp.currentTime();
        double[] values = this.rebDevc.readPowerAdcs();
        for (int chan = 0; chan < values.length; ++chan) {
            dataList.add(new REBDevice.AdcData(chan, values[chan], tstamp));
        }
        return values;
    }

    private int loadPclkLow(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            int adcChan = 26;
            this.readAdc(adcChan, this.isCorner ? null : dataList);
            this.setDac(8, this.pclkLowP >= 0.0 ? (int)(this.railConvL * this.pclkLowP) : 0);
            this.setDac(9, this.pclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.pclkLowP) : 0);
            ++count;
            this.loadDac(wait);
            this.checkAdc(adcChan, this.isCorner ? null : dataList, check && !this.isCorner, this.pclkLowP, "PClkLow");
        } else {
            this.setDac(8, this.pclkLow);
            if (this.isCurrent) {
                this.setDac(9, this.pclkLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadPclkHigh(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            int adcChan = 27;
            this.readAdc(adcChan, this.isCorner ? null : dataList);
            this.setDac(10, this.pclkHighP >= 0.0 ? (int)(this.railConvH * this.pclkHighP) : 0);
            if (this.isCorner) {
                this.setDac(11, this.pclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.pclkHighP) : 0);
                ++count;
            }
            this.loadDac(wait);
            this.checkAdc(adcChan, this.isCorner ? null : dataList, check && !this.isCorner, this.pclkHighP, "PClkHigh");
        } else {
            this.setDac(10, this.pclkHigh);
            if (this.isCorner) {
                this.setDac(11, this.pclkHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadSclkLow(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            int adcChan = 20;
            this.readAdc(adcChan, dataList);
            this.setDac(0, this.sclkLowP >= 0.0 ? (int)(this.railConvL * this.sclkLowP) : 0);
            this.setDac(1, this.sclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.sclkLowP) : 0);
            ++count;
            this.loadDac(wait);
            this.checkAdc(adcChan, dataList, check, this.sclkLowP, "SClkLow");
        } else {
            this.setDac(0, this.sclkLow);
            if (this.isCurrent) {
                this.setDac(1, this.sclkLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadSclkHigh(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            int adcChan = 21;
            this.readAdc(adcChan, dataList);
            this.setDac(2, this.sclkHighP >= 0.0 ? (int)(this.railConvH * this.sclkHighP) : 0);
            if (this.isCorner) {
                this.setDac(3, this.sclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.sclkHighP) : 0);
                ++count;
            }
            this.loadDac(wait);
            this.checkAdc(adcChan, dataList, check, this.sclkHighP, "SClkHigh");
        } else {
            this.setDac(2, this.sclkHigh);
            if (this.isCorner) {
                this.setDac(3, this.sclkHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadRgLow(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            int adcChan = 22;
            this.readAdc(adcChan, dataList);
            this.setDac(4, this.rgLowP >= 0.0 ? (int)(this.railConvL * this.rgLowP) : 0);
            this.setDac(5, this.rgLowP <= 0.0 ? (int)(-this.railShiftConvL * this.rgLowP) : 0);
            ++count;
            this.loadDac(wait);
            this.checkAdc(adcChan, dataList, check, this.rgLowP, "RGLow");
        } else {
            this.setDac(4, this.rgLow);
            if (this.isCurrent) {
                this.setDac(5, this.rgLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadRgHigh(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            int adcChan = 23;
            this.readAdc(adcChan, dataList);
            this.setDac(6, this.rgHighP >= 0.0 ? (int)(this.railConvH * this.rgHighP) : 0);
            if (this.isCorner) {
                this.setDac(7, this.rgHighP <= 0.0 ? (int)(-this.railShiftConvH * this.rgHighP) : 0);
                ++count;
            }
            this.loadDac(wait);
            this.checkAdc(adcChan, dataList, check, this.rgHighP, "RGHigh");
        } else {
            this.setDac(6, this.rgHigh);
            if (this.isCorner) {
                this.setDac(7, this.rgHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private void readAdc(int adcChan, List dataList) throws RaftException {
        if (dataList != null) {
            double value = this.rebDevc.readChannelNow(adcChan, this.adcType);
            dataList.add(new REBDevice.AdcData(adcChan, value, CCSTimeStamp.currentTime()));
        }
    }

    private void checkAdc(int adcChan, List dataList, boolean check, double value, String name) throws RaftException {
        if (check || dataList != null) {
            double adcValue = this.rebDevc.readChannelNow(adcChan, this.adcType);
            if (dataList != null) {
                dataList.add(new REBDevice.AdcData(adcChan, adcValue, CCSTimeStamp.currentTime()));
            }
            if (check && !DacControl.isValueOkay(adcValue, value)) {
                throw new RaftException(String.format("%s value incorrect - set: %.2f, read: %.2f", name, value, adcValue));
            }
        }
    }

    private static boolean isValueOkay(double read, double set) {
        return Math.abs(read - set) <= 0.4;
    }

    private void clearPclkLow(int wait) throws RaftException {
        this.setDac(8, 0);
        if (this.isCurrent) {
            this.setDac(9, 0);
        }
        this.loadDac(wait);
    }

    private void clearPclkHigh(int wait) throws RaftException {
        this.setDac(10, 0);
        if (this.isCorner) {
            this.setDac(11, 0);
        }
        this.loadDac(wait);
    }

    private void clearSclkLow(int wait) throws RaftException {
        this.setDac(0, 0);
        if (this.isCurrent) {
            this.setDac(1, 0);
        }
        this.loadDac(wait);
    }

    private void clearSclkHigh(int wait) throws RaftException {
        this.setDac(2, 0);
        if (this.isCorner) {
            this.setDac(3, 0);
        }
        this.loadDac(wait);
    }

    private void clearRgLow(int wait) throws RaftException {
        this.setDac(4, 0);
        if (this.isCurrent) {
            this.setDac(5, 0);
        }
        this.loadDac(wait);
    }

    private void clearRgHigh(int wait) throws RaftException {
        this.setDac(6, 0);
        if (this.isCorner) {
            this.setDac(7, 0);
        }
        this.loadDac(wait);
    }

    private void setDac(int chan, int value) throws RaftException {
        this.testOnline();
        try {
            this.dac.set(chan, Math.max(0, Math.min(value, 4095)));
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    private void loadDac(int wait) throws RaftException {
        this.testOnline();
        try {
            this.dac.loadGlobal();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

