/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.logging.Logger;

public class FitsService
implements HasLifecycle,
StatusMessageListener,
FitsHeaderMetadataProvider {
    @ConfigurationParameter(isFinal=true)
    private List<String> headerFilesList = new ArrayList<String>();
    private Geometry geometry;
    private String uniqueId = "notSet";
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.fits");
    private final FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
    private final Map<String, Map<String, HeaderKeywordValue>> headerKeywordValuesMap = new HashMap<String, Map<String, HeaderKeywordValue>>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService aggregatorService;

    @ConfigurationParameterChanger(propertyName="headerFilesList")
    public void setHeaderFilesList(List<String> list) {
        this.log.info((Object)("Configuring Fits Header Service with " + list));
        this.headerFilesList.addAll(list);
    }

    public void setGeometry(Geometry geometry) {
        this.log.info((Object)("Configuring Fits Header for geometry " + geometry.getUniqueId()));
        this.geometry = geometry;
        this.uniqueId = geometry.getUniqueId();
        this.fillHeaderKeywordMaps(geometry);
    }

    public void postInit() {
        for (String headerFile : this.headerFilesList) {
            String headerName;
            int index = headerFile.indexOf(":");
            String fileName = index >= 0 ? headerFile.substring(0, index) : headerFile;
            String string = headerName = index >= 0 ? headerFile.substring(index + 1) : null;
            if (headerName == null) {
                headerName = fileName.replace(".spec", "");
            }
            this.log.info((Object)("Loading spec file: " + fileName + " for extension " + headerName));
            this.headerSpecsBuilder.addSpecFile(fileName, headerName);
            if (this.headerKeywordValuesMap.containsKey(headerName)) continue;
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
    }

    public void start() {
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        if (d.getDataKey().equals("fitsHeaderKeywordData")) {
            FitsHeaderKeywordData fitsHeaderKeywordData = (FitsHeaderKeywordData)((KeyValueData)d.getObject()).getValue();
            if (!fitsHeaderKeywordData.getDataId().equals(this.uniqueId)) {
                return;
            }
            for (FitsHeaderKeywordData.HeaderKeywordValue value : fitsHeaderKeywordData.getHeaderKeywordValues()) {
                this.setHeaderKeywordValue(value);
            }
        }
    }

    public Map<String, HeaderSpecification> getHeaderSpecificationMap() {
        return this.headerSpecsBuilder.getHeaderSpecifications();
    }

    protected void printHeaderSpecifications() {
        StringBuilder sb = new StringBuilder();
        Map<String, HeaderSpecification> config = this.headerSpecsBuilder.getHeaderSpecifications();
        for (String header : config.keySet()) {
            sb.append("***************************\n");
            sb.append("     Header: ").append(header).append("\n");
            sb.append("***************************\n");
            HeaderSpecification spec = config.get(header);
            for (HeaderSpecification.HeaderLine line : spec.getHeaders()) {
                sb.append("## ").append(line.getKeyword()).append(" ").append(line.getMetaName()).append(" ").append((Object)line.getDataType()).append(" ").append(line.getComment()).append("\n");
            }
        }
        System.out.println("Header specifications\n" + sb.toString());
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue("primary", headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.setHeaderKeywordValue("primary", headerKeywordName, headerKeywordValue, sticky);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue(headerName, headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.log.info((Object)("Setting for header: " + headerName + " (" + headerKeywordName + "," + headerKeywordValue + ") " + sticky));
        this.getHeaderKeywordMapForHeader(headerName).put(headerKeywordName, new HeaderKeywordValue(headerKeywordValue, sticky));
    }

    private void setHeaderKeywordValue(FitsHeaderKeywordData.HeaderKeywordValue value) {
        this.setHeaderKeywordValue(value.getHeaderName(), value.getHeaderKeywordName(), value.getHeaderKeywordValue(), value.isSticky());
    }

    private void fillHeaderKeywordMaps(Geometry geometry) {
        if (geometry instanceof Raft) {
            Raft raft = (Raft)geometry;
            for (Reb reb : raft.getChildrenList()) {
                this.fillHeaderKeywordMapsForReb(reb);
            }
        } else if (geometry instanceof Reb) {
            this.fillHeaderKeywordMapsForReb((Reb)geometry);
        } else {
            throw new RuntimeException("This class is currently designed to support a single Raft.");
        }
    }

    private void fillHeaderKeywordMapsForReb(Reb reb) {
        for (CCD ccd : reb.getChildrenList()) {
            if (this.headerKeywordValuesMap.containsKey(ccd.getUniqueId())) continue;
            this.headerKeywordValuesMap.put(ccd.getUniqueId(), new HashMap());
        }
    }

    private Map<String, HeaderKeywordValue> getHeaderKeywordMapForHeader(String headerName) {
        if (!this.headerKeywordValuesMap.containsKey(headerName)) {
            this.log.warn((Object)("The FitsService is not configured to store data for header " + headerName));
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        return this.headerKeywordValuesMap.get(headerName);
    }

    private Map<String, Object> buildMapOfHeaderKeywordValues(Map<String, HeaderKeywordValue> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String headerKeyword : map.keySet()) {
            result.put(headerKeyword, map.get(headerKeyword).getValue());
        }
        return result;
    }

    public void clearNonStickyHeaderKeywordValues() {
        for (Map<String, HeaderKeywordValue> map : this.headerKeywordValuesMap.values()) {
            this.clearNonStickyHeaderKeywordValuesFromMap(map);
        }
    }

    private void clearNonStickyHeaderKeywordValuesFromMap(Map<String, HeaderKeywordValue> map) {
        Iterator<Map.Entry<String, HeaderKeywordValue>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, HeaderKeywordValue> entry = iter.next();
            if (entry.getValue().isSticky()) continue;
            iter.remove();
        }
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        return this.buildMetaDataSetForExtension(extendedKeyword);
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        return this.buildMetaDataSetForExtension(imageSet.getCCD().getUniqueId());
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        MetaDataSet m = this.buildMetaDataSetForExtension("primary");
        return m;
    }

    private MetaDataSet buildMetaDataSetForExtension(String extension) {
        MetaDataSet m = new MetaDataSet();
        m.addMetaDataMap("StatusAggregator", this.aggregatorService.getAllLast());
        m.addMetaDataMap(extension, this.buildMapOfHeaderKeywordValues(this.getHeaderKeywordMapForHeader(extension)));
        return m;
    }

    private class HeaderKeywordValue {
        private final Object value;
        private final boolean sticky;

        HeaderKeywordValue(Object value, boolean sticky) {
            this.value = value;
            this.sticky = sticky;
        }

        Object getValue() {
            return this.value;
        }

        boolean isSticky() {
            return this.sticky;
        }
    }
}

