package org.lsst.ccs.subsystem.ts8;

import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

/**
 * A provider for fits header meta-data.
 * 
 * @author The LSST CCS Team
 */
class TS8FitsHeaderMetadataProvider implements FitsHeaderMetadataProvider {

    private final TS8Subsystem ts8Subsystem;
    private final MetaDataSet metaDataSet;

    TS8FitsHeaderMetadataProvider(TS8Subsystem ts8Subsystem, MetaDataSet metaDataSet) {
        this.ts8Subsystem = ts8Subsystem;
        this.metaDataSet = metaDataSet;
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        return getTS8MetaDataSet(imageSet);
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        return getTS8MetaDataSet(imageSet);
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        return getTS8MetaDataSet(imageSet);
    }
    
    private synchronized MetaDataSet getTS8MetaDataSet(ImageSet imageSet) {
        MetaDataSet m = new MetaDataSet();
        m.addMetaDataSet(metaDataSet);
        m.addMetaDataMap("TS8SpecificKeywords", ts8Subsystem.getPrimaryHeaderKeywordsMapForCCD(imageSet.getCCD().getUniqueId()));
        m.addMetaData("CCDInfo", "CCDManufacturer", imageSet.getCCD().getType().getName().toUpperCase());
        m.addMetaData("CCDInfo", "CCDModel", imageSet.getCCD().getType().getType());
        return m;
    }
        
}
