/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.comp.rise;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import nom.tam.image.comp.rise.BitBuffer;

public abstract class RiseCompress {
    private static final Logger LOG = Logger.getLogger(RiseCompress.class.getName());
    private static final int BITS_OF_1_BYTE = 8;
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_SHORT = 16;
    private static final int BYTE_MASK = 255;
    private static final int FS_BITS_FOR_BYTE = 3;
    private static final int FS_BITS_FOR_INT = 5;
    private static final int FS_BITS_FOR_SHORT = 4;
    private static final int FS_MAX_FOR_BYTE = 6;
    private static final int FS_MAX_FOR_INT = 25;
    private static final int FS_MAX_FOR_SHORT = 14;
    private static final int[] NONZERO_COUNT = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private final int bBits;
    private final int bitsPerPixel;
    private final int blockSize;
    private final int fsBits;
    private final int fsMax;

    public static RiseCompress createCompressor(Object data, int blockSize) {
        if (data instanceof int[]) {
            return new IntArrayRiseCompress(blockSize);
        }
        if (data instanceof short[]) {
            return new ShortArrayRiseCompress(blockSize);
        }
        if (data instanceof byte[]) {
            return new ByteArrayRiseCompress(blockSize);
        }
        return null;
    }

    private RiseCompress(int fsBits, int fsMax, int blockSize, int bitsPerPixel) {
        this.fsBits = fsBits;
        this.fsMax = fsMax;
        this.blockSize = blockSize;
        this.bitsPerPixel = bitsPerPixel;
        this.bBits = 1 << fsBits;
    }

    public void compress(Object dataToCompress, ByteBuffer writeBuffer) {
        BitBuffer buffer = new BitBuffer(writeBuffer);
        int lastpix = this.get(dataToCompress, 0);
        buffer.putInt(lastpix, this.bitsPerPixel);
        int thisblock = this.blockSize;
        int dataLength = this.length(dataToCompress);
        for (int i = 0; i < dataLength; i += this.blockSize) {
            if (dataLength - i < this.blockSize) {
                thisblock = dataLength - i;
            }
            long[] diff = new long[this.blockSize];
            double pixelsum = 0.0;
            for (int j = 0; j < thisblock; ++j) {
                int nextpix = this.get(dataToCompress, i + j);
                long pdiff = nextpix - lastpix;
                diff[j] = Math.abs(pdiff < 0L ? pdiff << 1 ^ 0xFFFFFFFFFFFFFFFFL : pdiff << 1);
                pixelsum += (double)diff[j];
                lastpix = nextpix;
            }
            double dpsum = (pixelsum - (double)thisblock / 2.0 - 1.0) / (double)thisblock;
            if (dpsum < 0.0) {
                dpsum = 0.0;
            }
            long psum = (long)dpsum >> 1;
            int fs = 0;
            while (psum > 0L) {
                psum >>= 1;
                ++fs;
            }
            if (fs >= this.fsMax) {
                buffer.putInt(this.fsMax + 1, this.fsBits);
                for (int j = 0; j < thisblock; ++j) {
                    buffer.putLong(diff[j], this.bBits);
                }
                continue;
            }
            if (fs == 0 && pixelsum == 0.0) {
                buffer.putInt(0, this.fsBits);
                continue;
            }
            buffer.putInt(fs + 1, this.fsBits);
            int fsmask = (1 << fs) - 1;
            int bitsToGo = buffer.missingBitsInCurrentByte();
            int bitBuffer = buffer.bitbuffer() >> bitsToGo;
            buffer.movePosition(bitsToGo - 8);
            for (int j = 0; j < thisblock; ++j) {
                int v = (int)diff[j];
                int top = v >> fs;
                if (bitsToGo >= top + 1) {
                    bitBuffer <<= top + 1;
                    bitBuffer |= 1;
                    bitsToGo -= top + 1;
                } else {
                    buffer.putByte((byte)((bitBuffer <<= bitsToGo) & 0xFF));
                    top -= bitsToGo;
                    while (top >= 8) {
                        buffer.putByte((byte)0);
                        top -= 8;
                    }
                    bitBuffer = 1;
                    bitsToGo = 7 - top;
                }
                if (fs <= 0) continue;
                bitBuffer <<= fs;
                bitBuffer |= v & fsmask;
                bitsToGo -= fs;
                while (bitsToGo <= 0) {
                    buffer.putByte((byte)(bitBuffer >> -bitsToGo & 0xFF));
                    bitsToGo += 8;
                }
            }
            buffer.putByte((byte)(bitBuffer & 0xFF), 8 - bitsToGo);
        }
        buffer.close();
    }

    public void decompress(ByteBuffer readBuffer, Object array) {
        int lastpix = this.readOnePixel(readBuffer);
        int b = readBuffer.get();
        int nbits = 8;
        int nx = this.length(array);
        int i = 0;
        while (i < nx) {
            int diff;
            nbits -= this.fsBits;
            while (nbits < 0) {
                b = b << 8 | readBuffer.get() & 0xFF;
                nbits += 8;
            }
            int fs = (b >> nbits) - 1;
            b &= (1 << nbits) - 1;
            int imax = i + this.blockSize;
            if (imax > nx) {
                imax = nx;
            }
            if (fs < 0) {
                while (i < imax) {
                    this.set(array, i, lastpix);
                    ++i;
                }
            } else if (fs == this.fsMax) {
                while (i < imax) {
                    int k = this.bBits - nbits;
                    diff = b << k;
                    k -= 8;
                    while (k >= 0) {
                        b = readBuffer.get() & 0xFF;
                        diff |= b << k;
                        k -= 8;
                    }
                    if (nbits > 0) {
                        b = readBuffer.get() & 0xFF;
                        diff |= b >> -k;
                        b &= (1 << nbits) - 1;
                    } else {
                        b = 0;
                    }
                    diff = (diff & 1) == 0 ? (diff >>= 1) : ~(diff >> 1);
                    lastpix = diff + lastpix;
                    this.set(array, i, lastpix);
                    ++i;
                }
            } else {
                while (i < imax) {
                    while (b == 0) {
                        nbits += 8;
                        b = readBuffer.get() & 0xFF;
                    }
                    int nzero = nbits - NONZERO_COUNT[b & 0xFF];
                    b ^= 1 << (nbits -= nzero + 1);
                    nbits -= fs;
                    while (nbits < 0) {
                        b = b << 8 | readBuffer.get() & 0xFF;
                        nbits += 8;
                    }
                    diff = nzero << fs | b >> nbits;
                    b &= (1 << nbits) - 1;
                    diff = (diff & 1) == 0 ? (diff >>= 1) : ~(diff >> 1);
                    lastpix = diff + lastpix;
                    this.set(array, i, lastpix);
                    ++i;
                }
            }
            if (readBuffer.limit() >= readBuffer.position()) continue;
            LOG.severe("decompressing failed, no more bytes to decompress reached: " + readBuffer.limit() + " but only reached index " + i + " of " + nx);
            throw new IllegalStateException("decompressing failed, no more bytes to decompress");
        }
        if (readBuffer.limit() > readBuffer.position()) {
            LOG.warning("decompressing left over some extra bytes got: " + readBuffer.limit() + " but needed only " + readBuffer.position());
        }
    }

    protected abstract int readOnePixel(ByteBuffer var1);

    protected abstract int get(Object var1, int var2);

    protected abstract int length(Object var1);

    protected abstract void set(Object var1, int var2, int var3);

    private static class ShortArrayRiseCompress
    extends RiseCompress {
        public ShortArrayRiseCompress(int blockSize) {
            super(4, 14, blockSize, 16);
        }

        @Override
        protected int get(Object array, int index) {
            return ((short[])array)[index];
        }

        @Override
        protected int length(Object array) {
            return ((short[])array).length;
        }

        @Override
        protected void set(Object array, int index, int pixel) {
            ((short[])array)[index] = (short)pixel;
        }

        @Override
        protected int readOnePixel(ByteBuffer readBuffer) {
            return readBuffer.getShort();
        }
    }

    private static class IntArrayRiseCompress
    extends RiseCompress {
        public IntArrayRiseCompress(int blockSize) {
            super(5, 25, blockSize, 32);
        }

        @Override
        protected int get(Object array, int index) {
            return ((int[])array)[index];
        }

        @Override
        protected int length(Object array) {
            return ((int[])array).length;
        }

        @Override
        protected void set(Object array, int index, int pixel) {
            ((int[])array)[index] = pixel;
        }

        @Override
        protected int readOnePixel(ByteBuffer readBuffer) {
            return readBuffer.getInt();
        }
    }

    private static class ByteArrayRiseCompress
    extends RiseCompress {
        public ByteArrayRiseCompress(int blockSize) {
            super(3, 6, blockSize, 8);
        }

        @Override
        protected int get(Object array, int index) {
            return ((byte[])array)[index];
        }

        @Override
        protected int length(Object array) {
            return ((byte[])array).length;
        }

        @Override
        protected void set(Object array, int index, int pixel) {
            ((byte[])array)[index] = (byte)pixel;
        }

        @Override
        protected int readOnePixel(ByteBuffer readBuffer) {
            return readBuffer.get();
        }
    }
}

