/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.comp.hcompress;

import java.nio.ByteBuffer;
import nom.tam.util.ArrayFuncs;

public abstract class HCompress {
    private static final int HTRANS_START_MASK = -2;
    protected static final double ROUNDING_HALF = 0.5;
    protected static final int BITS_OF_1_BYTE = 8;
    protected static final int BITS_OF_1_NYBBLE = 4;
    protected static final int BYTE_MASK = 255;
    protected static final int NYBBLE_MASK = 15;
    private static final int N3 = 3;
    private static final int[] BITS_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private static final int[] CODE = new int[]{62, 0, 1, 8, 2, 9, 26, 27, 3, 28, 10, 29, 11, 30, 63, 12};
    private static final byte[] CODE_MAGIC = new byte[]{-35, -103};
    private static final int[] NCODE = new int[]{6, 3, 3, 4, 3, 4, 5, 5, 3, 5, 4, 5, 4, 5, 6, 4};
    private int bitbuffer;
    private int bitsToGo2;
    private int bitsToGo3;
    private int buffer2;

    public static HCompress createCompressor(Object data) {
        if (data instanceof int[]) {
            return new IntHCompress();
        }
        if (data instanceof short[]) {
            return new ShortHCompress();
        }
        if (data instanceof byte[]) {
            return new ByteHCompress();
        }
        return null;
    }

    private int b2i(boolean b) {
        return b ? 1 : 0;
    }

    private int bufcopy(byte[] a, int n, byte[] buffer, int b, long bmax) {
        for (int i = 0; i < n; ++i) {
            if (a[i] == 0) continue;
            this.bitbuffer |= CODE[a[i]] << this.bitsToGo3;
            this.bitsToGo3 += NCODE[a[i]];
            if (this.bitsToGo3 < 8) continue;
            buffer[b] = (byte)(this.bitbuffer & 0xFF);
            if ((long)(++b) >= bmax) {
                return b;
            }
            this.bitbuffer >>= 8;
            this.bitsToGo3 -= 8;
        }
        return b;
    }

    protected void compress(long[] aa, int ny, int nx, int scale, ByteBuffer output) {
        this.htrans(aa, nx, ny);
        LongArrayPointer a = new LongArrayPointer();
        LongArrayPointer.access$402(a, aa);
        a.offset = 0;
        this.digitize(a, 0, nx, ny, scale);
        this.encode(output, a, nx, ny, scale);
    }

    protected abstract void compress(Object var1, int var2, int var3, int var4, ByteBuffer var5);

    private void digitize(LongArrayPointer a, int aOffset, int nx, int ny, long scale) {
        if (scale <= 1L) {
            return;
        }
        long d = (scale + 1L) / 2L - 1L;
        for (int index = 0; index < a.a.length; ++index) {
            long current = a.get(index);
            a.set(index, (current > 0L ? current + d : current - d) / scale);
        }
    }

    private void doencode(ByteBuffer outfile, LongArrayPointer a, int nx, int ny, byte[] nbitplanes) {
        int nx2 = (nx + 1) / 2;
        int ny2 = (ny + 1) / 2;
        this.startOutputingBits();
        this.qtreeEncode(outfile, a.copy(), ny, nx2, ny2, nbitplanes[0]);
        this.qtreeEncode(outfile, a.copy(ny2), ny, nx2, ny / 2, nbitplanes[1]);
        this.qtreeEncode(outfile, a.copy(ny * nx2), ny, nx / 2, ny2, nbitplanes[1]);
        this.qtreeEncode(outfile, a.copy(ny * nx2 + ny2), ny, nx / 2, ny / 2, nbitplanes[2]);
        this.outputNybble(outfile, 0);
        this.doneOutputingBits(outfile);
    }

    private void doneOutputingBits(ByteBuffer outfile) {
        if (this.bitsToGo2 < 8) {
            outfile.put((byte)(this.buffer2 << this.bitsToGo2));
        }
    }

    private int encode(ByteBuffer outfile, LongArrayPointer a, int nx, int ny, int scale) {
        int q;
        int i;
        long[] vmax = new long[3];
        byte[] nbitplanes = new byte[3];
        long noutchar = 0L;
        int nel = nx * ny;
        outfile.put(CODE_MAGIC);
        outfile.putInt(nx);
        outfile.putInt(ny);
        outfile.putInt(scale);
        outfile.putLong(a.get());
        a.set(0L);
        byte[] signbits = new byte[(nel + 8 - 1) / 8];
        int nsign = 0;
        int bitsToGo = 8;
        signbits[0] = 0;
        for (i = 0; i < nel; ++i) {
            if (a.get(i) > 0L) {
                int n = nsign;
                signbits[n] = (byte)(signbits[n] << 1);
                --bitsToGo;
            } else if (a.get(i) < 0L) {
                int n = nsign;
                signbits[n] = (byte)(signbits[n] << 1);
                int n2 = nsign;
                signbits[n2] = (byte)(signbits[n2] | 1);
                --bitsToGo;
                a.set(i, -a.get(i));
            }
            if (bitsToGo != 0) continue;
            bitsToGo = 8;
            signbits[++nsign] = 0;
        }
        if (bitsToGo != 8) {
            int n = nsign++;
            signbits[n] = (byte)(signbits[n] << bitsToGo);
        }
        for (q = 0; q < 3; ++q) {
            vmax[q] = 0L;
        }
        int nx2 = (nx + 1) / 2;
        int ny2 = (ny + 1) / 2;
        int j = 0;
        int k = 0;
        for (i = 0; i < nel; ++i) {
            q = (j >= ny2 ? 1 : 0) + (k >= nx2 ? 1 : 0);
            if (vmax[q] < a.get(i)) {
                vmax[q] = a.get(i);
            }
            if (++j < ny) continue;
            j = 0;
            ++k;
        }
        for (q = 0; q < 3; ++q) {
            nbitplanes[q] = 0;
            while (vmax[q] > 0L) {
                "".toString();
                vmax[q] = vmax[q] >> 1;
                int n = q;
                nbitplanes[n] = (byte)(nbitplanes[n] + 1);
            }
        }
        outfile.put(nbitplanes, 0, nbitplanes.length);
        this.doencode(outfile, a, nx, ny, nbitplanes);
        if (nsign > 0) {
            outfile.put(signbits, 0, nsign);
        }
        return (int)noutchar;
    }

    private int htrans(long[] a, int nx, int ny) {
        int log2n;
        int nmax = nx > ny ? nx : ny;
        if (nmax > 1 << (log2n = this.log2n(nmax))) {
            ++log2n;
        }
        long[] tmp = new long[(nmax + 1) / 2];
        long shift = 0L;
        long mask = -2L;
        long mask2 = mask << 1;
        long prnd = 1L;
        long prnd2 = prnd << 1;
        long nrnd2 = prnd2 - 1L;
        int nxtop = nx;
        int nytop = ny;
        for (int k = 0; k < log2n; ++k) {
            long hy;
            long h0;
            int j;
            int s00;
            int i;
            int oddx = nxtop % 2;
            int oddy = nytop % 2;
            for (i = 0; i < nxtop - oddx; i += 2) {
                long hx;
                s00 = i * ny;
                int s10 = s00 + ny;
                for (j = 0; j < nytop - oddy; j += 2) {
                    long hc;
                    h0 = a[s10 + 1] + a[s10] + a[s00 + 1] + a[s00] >> (int)shift;
                    hx = a[s10 + 1] + a[s10] - a[s00 + 1] - a[s00] >> (int)shift;
                    hy = a[s10 + 1] - a[s10] + a[s00 + 1] - a[s00] >> (int)shift;
                    a[s10 + 1] = hc = a[s10 + 1] - a[s10] - a[s00 + 1] + a[s00] >> (int)shift;
                    a[s10] = (hx >= 0L ? hx + prnd : hx) & mask;
                    a[s00 + 1] = (hy >= 0L ? hy + prnd : hy) & mask;
                    a[s00] = (h0 >= 0L ? h0 + prnd2 : h0 + nrnd2) & mask2;
                    s00 += 2;
                    s10 += 2;
                }
                if (oddy == 0) continue;
                h0 = a[s10] + a[s00] << (int)(1L - shift);
                hx = a[s10] - a[s00] << (int)(1L - shift);
                a[s10] = (hx >= 0L ? hx + prnd : hx) & mask;
                a[s00] = (h0 >= 0L ? h0 + prnd2 : h0 + nrnd2) & mask2;
                ++s00;
                ++s10;
            }
            if (oddx != 0) {
                s00 = i * ny;
                for (j = 0; j < nytop - oddy; j += 2) {
                    h0 = a[s00 + 1] + a[s00] << (int)(1L - shift);
                    hy = a[s00 + 1] - a[s00] << (int)(1L - shift);
                    a[s00 + 1] = (hy >= 0L ? hy + prnd : hy) & mask;
                    a[s00] = (h0 >= 0L ? h0 + prnd2 : h0 + nrnd2) & mask2;
                    s00 += 2;
                }
                if (oddy != 0) {
                    h0 = a[s00] << (int)(2L - shift);
                    a[s00] = (h0 >= 0L ? h0 + prnd2 : h0 + nrnd2) & mask2;
                }
            }
            for (i = 0; i < nxtop; ++i) {
                this.shuffle(a, ny * i, nytop, 1, tmp);
            }
            for (j = 0; j < nytop; ++j) {
                this.shuffle(a, j, nxtop, ny, tmp);
            }
            nxtop = nxtop + 1 >> 1;
            nytop = nytop + 1 >> 1;
            shift = 1L;
            mask = mask2;
            prnd = prnd2;
            mask2 <<= 1;
            nrnd2 = (prnd2 <<= 1) - 1L;
        }
        return 0;
    }

    private int log2n(int nqmax) {
        return (int)(Math.log(nqmax) / Math.log(2.0) + 0.5);
    }

    private void outputNbits(ByteBuffer outfile, int bits, int n) {
        this.buffer2 <<= n;
        this.buffer2 |= bits & BITS_MASK[n];
        this.bitsToGo2 -= n;
        if (this.bitsToGo2 <= 0) {
            outfile.put((byte)(this.buffer2 >> -this.bitsToGo2 & 0xFF));
            this.bitsToGo2 += 8;
        }
    }

    private void outputNnybble(ByteBuffer outfile, int n, byte[] array) {
        int kk = 0;
        if (n == 1) {
            this.outputNybble(outfile, array[0]);
            return;
        }
        if (this.bitsToGo2 <= 4) {
            this.outputNybble(outfile, array[0]);
            ++kk;
            if (n == 2) {
                this.outputNybble(outfile, array[1]);
                return;
            }
        }
        int shift = 8 - this.bitsToGo2;
        int jj = (n - kk) / 2;
        if (this.bitsToGo2 == 8) {
            this.buffer2 = 0;
            for (int ii = 0; ii < jj; ++ii) {
                outfile.put((byte)((array[kk] & 0xF) << 4 | array[kk + 1] & 0xF));
                kk += 2;
            }
        } else {
            for (int ii = 0; ii < jj; ++ii) {
                this.buffer2 = this.buffer2 << 8 | (array[kk] & 0xF) << 4 | array[kk + 1] & 0xF;
                kk += 2;
                outfile.put((byte)(this.buffer2 >> shift & 0xFF));
            }
        }
        if (kk != n) {
            this.outputNybble(outfile, array[n - 1]);
        }
    }

    private void outputNybble(ByteBuffer outfile, int bits) {
        this.buffer2 = this.buffer2 << 4 | bits & 0xF;
        this.bitsToGo2 -= 4;
        if (this.bitsToGo2 <= 0) {
            outfile.put((byte)(this.buffer2 >> -this.bitsToGo2 & 0xFF));
            this.bitsToGo2 += 8;
        }
    }

    private int qtreeEncode(ByteBuffer outfile, LongArrayPointer a, int n, int nqx, int nqy, int nbitplanes) {
        int log2n;
        int nqmax = nqx > nqy ? nqx : nqy;
        if (nqmax > 1 << (log2n = this.log2n(nqmax))) {
            ++log2n;
        }
        int nqx2 = (nqx + 1) / 2;
        int nqy2 = (nqy + 1) / 2;
        long bmax = (nqx2 * nqy2 + 1) / 2;
        byte[] scratch = new byte[(int)(2L * bmax)];
        byte[] buffer = new byte[(int)bmax];
        block0: for (int bit = nbitplanes - 1; bit >= 0; --bit) {
            int b = 0;
            this.bitbuffer = 0;
            this.bitsToGo3 = 0;
            this.qtreeOnebit(a, n, nqx, nqy, scratch, bit);
            int nx = nqx + 1 >> 1;
            int ny = nqy + 1 >> 1;
            b = this.bufcopy(scratch, nx * ny, buffer, b, bmax);
            if ((long)b >= bmax) {
                this.writeBdirect(outfile, a, n, nqx, nqy, scratch, bit);
                continue;
            }
            for (int k = 1; k < log2n; ++k) {
                this.qtreeReduce(scratch, ny, nx, ny, scratch);
                nx = nx + 1 >> 1;
                ny = ny + 1 >> 1;
                b = this.bufcopy(scratch, nx * ny, buffer, b, bmax);
                if ((long)b < bmax) continue;
                this.writeBdirect(outfile, a, n, nqx, nqy, scratch, bit);
                continue block0;
            }
            this.outputNybble(outfile, 15);
            if (b == 0) {
                if (this.bitsToGo3 > 0) {
                    this.outputNbits(outfile, this.bitbuffer & (1 << this.bitsToGo3) - 1, this.bitsToGo3);
                    continue;
                }
                this.outputNbits(outfile, CODE[0], NCODE[0]);
                continue;
            }
            if (this.bitsToGo3 > 0) {
                this.outputNbits(outfile, this.bitbuffer & (1 << this.bitsToGo3) - 1, this.bitsToGo3);
            }
            for (int i = b - 1; i >= 0; --i) {
                this.outputNbits(outfile, buffer[i], 8);
            }
        }
        return 0;
    }

    private void qtreeOnebit(LongArrayPointer a, int n, int nx, int ny, byte[] b, int bit) {
        int j;
        int s00;
        int i;
        long b0 = 1L << bit;
        long b1 = b0 << 1;
        long b2 = b1 << 1;
        long b3 = b2 << 1;
        int k = 0;
        for (i = 0; i < nx - 1; i += 2) {
            s00 = n * i;
            int s10 = s00 + n;
            for (j = 0; j < ny - 1; j += 2) {
                b[k] = (byte)((a.get(s10 + 1) & b0 | a.get(s10) << 1 & b1 | a.get(s00 + 1) << 2 & b2 | a.get(s00) << 3 & b3) >> bit);
                ++k;
                s00 += 2;
                s10 += 2;
            }
            if (j >= ny) continue;
            b[k] = (byte)((a.get(s10) << 1 & b1 | a.get(s00) << 3 & b3) >> bit);
            ++k;
        }
        if (i < nx) {
            s00 = n * i;
            for (j = 0; j < ny - 1; j += 2) {
                b[k] = (byte)((a.get(s00 + 1) << 2 & b2 | a.get(s00) << 3 & b3) >> bit);
                ++k;
                s00 += 2;
            }
            if (j < ny) {
                b[k] = (byte)((a.get(s00) << 3 & b3) >> bit);
                ++k;
            }
        }
    }

    private void qtreeReduce(byte[] a, int n, int nx, int ny, byte[] b) {
        int j;
        int s00;
        int i;
        int k = 0;
        for (i = 0; i < nx - 1; i += 2) {
            s00 = n * i;
            int s10 = s00 + n;
            for (j = 0; j < ny - 1; j += 2) {
                b[k] = (byte)(this.b2i(a[s10 + 1] != 0) | this.b2i(a[s10] != 0) << 1 | this.b2i(a[s00 + 1] != 0) << 2 | this.b2i(a[s00] != 0) << 3);
                ++k;
                s00 += 2;
                s10 += 2;
            }
            if (j >= ny) continue;
            b[k] = (byte)(this.b2i(a[s10] != 0) << 1 | this.b2i(a[s00] != 0) << 3);
            ++k;
        }
        if (i < nx) {
            s00 = n * i;
            for (j = 0; j < ny - 1; j += 2) {
                b[k] = (byte)(this.b2i(a[s00 + 1] != 0) << 2 | this.b2i(a[s00] != 0) << 3);
                ++k;
                s00 += 2;
            }
            if (j < ny) {
                b[k] = (byte)(this.b2i(a[s00] != 0) << 3);
                ++k;
            }
        }
    }

    private void shuffle(long[] a, int aOffet, int n, int n2, long[] tmp) {
        int i;
        int p1Offset = 0;
        int ptOffset = 0;
        int p2Offset = 0;
        long[] pt = tmp;
        ptOffset = 0;
        long[] p1 = a;
        p1Offset = aOffet + n2;
        for (i = 1; i < n; i += 2) {
            pt[ptOffset] = p1[p1Offset];
            ++ptOffset;
            p1Offset += n2 + n2;
        }
        p1 = a;
        p1Offset = aOffet + n2;
        long[] p2 = a;
        p2Offset = aOffet + n2 + n2;
        for (i = 2; i < n; i += 2) {
            p1[p1Offset] = p2[p2Offset];
            p1Offset += n2;
            p2Offset += n2 + n2;
        }
        pt = tmp;
        ptOffset = 0;
        for (i = 1; i < n; i += 2) {
            p1[p1Offset] = pt[ptOffset];
            p1Offset += n2;
            ++ptOffset;
        }
    }

    private void startOutputingBits() {
        this.buffer2 = 0;
        this.bitsToGo2 = 8;
    }

    private void writeBdirect(ByteBuffer outfile, LongArrayPointer a, int n, int nqx, int nqy, byte[] scratch, int bit) {
        this.outputNybble(outfile, 0);
        this.qtreeOnebit(a, n, nqx, nqy, scratch, bit);
        this.outputNnybble(outfile, (nqx + 1) / 2 * ((nqy + 1) / 2), scratch);
    }

    private static class LongArrayPointer {
        private long[] a;
        private int offset;

        private LongArrayPointer() {
        }

        public LongArrayPointer copy() {
            LongArrayPointer intAP = new LongArrayPointer();
            intAP.a = this.a;
            intAP.offset = this.offset;
            return intAP;
        }

        public LongArrayPointer copy(int extraOffset) {
            LongArrayPointer intAP = new LongArrayPointer();
            intAP.a = this.a;
            intAP.offset = this.offset + extraOffset;
            return intAP;
        }

        public long get() {
            return this.a[this.offset];
        }

        public long get(int i) {
            return this.a[this.offset + i];
        }

        public void set(int i, long value) {
            this.a[this.offset + i] = value;
        }

        public void set(long value) {
            this.a[this.offset] = value;
        }

        static /* synthetic */ long[] access$402(LongArrayPointer x0, long[] x1) {
            x0.a = x1;
            return x1;
        }
    }

    private static class ByteHCompress
    extends HCompress {
        private static final long BYTE_MASK_FOR_LONG = 255L;

        private ByteHCompress() {
        }

        @Override
        protected void compress(Object array, int ny, int nx, int scale, ByteBuffer compressed) {
            byte[] byteArray = (byte[])array;
            long[] longArray = new long[byteArray.length];
            for (int index = 0; index < longArray.length; ++index) {
                longArray[index] = (long)byteArray[index] & 0xFFL;
            }
            this.compress(longArray, ny, nx, scale, compressed);
        }
    }

    private static class ShortHCompress
    extends HCompress {
        private ShortHCompress() {
        }

        @Override
        protected void compress(Object array, int ny, int nx, int scale, ByteBuffer compressed) {
            short[] shortArray = (short[])array;
            long[] longArray = new long[shortArray.length];
            ArrayFuncs.copyInto(shortArray, longArray);
            this.compress(longArray, ny, nx, scale, compressed);
        }
    }

    private static class IntHCompress
    extends HCompress {
        private IntHCompress() {
        }

        @Override
        protected void compress(Object array, int ny, int nx, int scale, ByteBuffer compressed) {
            int[] intArray = (int[])array;
            long[] longArray = new long[intArray.length];
            ArrayFuncs.copyInto(intArray, longArray);
            this.compress(longArray, ny, nx, scale, compressed);
        }
    }
}

