/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.utilities;

import nom.tam.fits.utilities.FitsSubString;

public class FitsLineAppender {
    private static final String FULL_CARD_AS_SPACES = "                                                                                ";
    private final StringBuffer buffer = new StringBuffer(80);
    private int charCount;

    public void append(char character) {
        this.buffer.append(character);
        ++this.charCount;
    }

    public void append(FitsSubString stringValue) {
        stringValue.appendTo(this.buffer);
        this.charCount += stringValue.length();
    }

    public void append(String string) {
        this.charCount %= 80;
        int newLength = this.charCount + string.length();
        if (newLength > 80) {
            this.buffer.append(string, 0, 80 - this.charCount);
            this.charCount = 0;
        } else {
            this.charCount = newLength;
            this.buffer.append(string);
        }
    }

    public void appendRepacing(String key, char toReplace, char with) {
        int size = key.length();
        for (int index = 0; index < size; ++index) {
            char character = key.charAt(index);
            if (character == toReplace) {
                this.buffer.append(with);
                continue;
            }
            this.buffer.append(character);
        }
        this.charCount += size;
    }

    public void appendSpacesTo(int count) {
        int spaces;
        this.charCount %= 80;
        if (this.charCount != 0 && (spaces = count - this.charCount) > 0) {
            this.buffer.append(FULL_CARD_AS_SPACES, 0, spaces);
            this.charCount += spaces;
        }
    }

    public void completeLine() {
        int count = 80 - this.charCount % 80;
        if (count < 80) {
            this.buffer.append(FULL_CARD_AS_SPACES, 0, count);
        }
        this.charCount = 0;
    }

    public int length() {
        this.charCount %= 80;
        return this.charCount;
    }

    public int spaceLeftInLine() {
        this.charCount %= 80;
        return 80 - this.charCount;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

