/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.data.CcdType;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.logging.Logger;

public class BiasControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String GD_P = "gdP";
    public static final String OD_P = "odP";
    public static final String OG_P = "ogP";
    public static final String RD_P = "rdP";
    public static final String CS_GATE_P = "csGateP";
    public static final String GD = "gd";
    public static final String OD = "od";
    public static final String OG = "og";
    public static final String OG_SH = "ogSh";
    public static final String RD = "rd";
    public static final String CS_GATE = "csGate";
    private static final int GD_CH = 1;
    private static final int OD_CH = 2;
    private static final int OG_CH = 4;
    private static final int OG_SH_CH = 8;
    private static final int RD_CH = 16;
    private static final int CSGATE_CH = 32;
    private static final String[] checkList = new String[]{"gd", "od", "og", "rd"};
    private static final int DEFAULT_LOAD_WAIT = 200;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(category="Rafts", description="Guard diode", units="volts")
    private double gdP;
    @ConfigurationParameter(category="Rafts", description="Output drain", units="volts")
    private double odP;
    @ConfigurationParameter(category="Rafts", description="Output gate", units="volts")
    private double ogP;
    @ConfigurationParameter(category="Rafts", description="Reset drain", units="volts")
    private double rdP;
    @ConfigurationParameter(category="Rafts", description="Current source", units="mA")
    private double csGateP;
    @ConfigurationParameter(category="RaftsLimits", description="Guard diode min", units="volts")
    private double gdMin;
    @ConfigurationParameter(category="RaftsLimits", description="Guard diode max", units="volts")
    private double gdMax;
    @ConfigurationParameter(category="RaftsLimits", description="Output drain min", units="volts")
    private double odMin;
    @ConfigurationParameter(category="RaftsLimits", description="Output drain max", units="volts")
    private double odMax;
    @ConfigurationParameter(category="RaftsLimits", description="Output gate min", units="volts")
    private double ogMin;
    @ConfigurationParameter(category="RaftsLimits", description="Output gate max", units="volts")
    private double ogMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset drain min", units="volts")
    private double rdMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset drain max", units="volts")
    private double rdMax;
    @ConfigurationParameter(category="Rafts", description="Guard diode", units="DAC counts")
    private int gd;
    @ConfigurationParameter(category="Rafts", description="Output drain", units="DAC counts")
    private int od;
    @ConfigurationParameter(category="Rafts", description="Output gate", units="DAC counts")
    private int og;
    @ConfigurationParameter(category="Rafts", description="Output gate shifted", units="DAC counts")
    private int ogSh;
    @ConfigurationParameter(category="Rafts", description="Reset drain", units="DAC counts")
    private int rd;
    @ConfigurationParameter(category="Rafts", description="Current source", units="DAC counts")
    private int csGate;
    private boolean raw = false;
    private final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private REBDevice rebDevc;
    private boolean cfgValid;
    private int hwVersion;
    private BoardDacs dac;
    private int changed = -1;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private String configError;
    private double gdConv;
    private double odConv;
    private double rdConv;
    private double ogConv;
    private double ogShiftConv;
    private double csConv;
    private double csOffset;

    public BiasControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    @Deprecated
    public BiasControl(String desc, int hwChan, int gd, int od, int og, int ogSh, int rd, int csGate) {
        this.description = desc;
        this.hwChan = hwChan;
        this.gd = gd;
        this.od = od;
        this.og = og;
        this.ogSh = ogSh;
        this.rd = rd;
        this.csGate = csGate;
        this.raw = true;
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        if (this.configError != null) {
            this.sLog.error((Object)("Config error (startup): " + this.getName() + ": " + this.configError));
        }
        this.rebDevc = (REBDevice)devc;
        this.dac = this.rebDevc.getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = BiasControl.getHwVersion(this.dac);
        if (this.hwVersion == -1) {
            this.sLog.error((Object)("BIAS " + this.hwChan + " configuration incompatible with the firmware"));
            return false;
        }
        try {
            if (this.hwChan < 0 || this.hwChan >= this.dac.getNumStrips()) {
                MonitorLogUtils.reportError((Logger)this.sLog, (String)this.getName(), (String)"HW channel", (Object)this.hwChan);
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)"Error getting number of strips");
            return false;
        }
        catch (Exception e) {
            return false;
        }
        if (!this.raw) {
            switch (this.hwVersion) {
                case 1: {
                    this.gdConv = this.odConv = 136.7278797996661;
                    this.rdConv = this.odConv;
                    break;
                }
                case 2: {
                    this.odConv = 112.769123783032;
                    this.gdConv = 113.75;
                    this.rdConv = 163.14741035856574;
                    break;
                }
                default: {
                    this.gdConv = this.odConv = 113.75;
                    this.rdConv = 163.14741035856574;
                }
            }
            double ogGain = 1.0;
            double fudge = this.hwVersion == 3 ? 1.0 : 1.1;
            this.ogShiftConv = fudge * 819.0 / ogGain;
            this.ogConv = fudge * 819.0 / (1.0 + ogGain);
            this.csConv = 1638.0;
            this.csOffset = -0.95;
        } else {
            this.cfgValid = true;
        }
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        switch (version) {
            case 2: 
            case 4: 
            case 5: {
                version = 1;
                break;
            }
            case 3: 
            case 6: {
                version = 2;
                break;
            }
            case 7: 
            case 8: {
                version = 3;
                break;
            }
            default: {
                version = -1;
            }
        }
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        String errMsg = null;
        for (String pName : checkList) {
            Double max;
            double value = (Double)params.get(pName + "P");
            if (value > (max = (Double)params.get(pName + "Max"))) {
                errMsg = String.format("%sP (%5.5g) is above high limit (%5.5g)", pName, value, max);
                break;
            }
            Double min = (Double)params.get(pName + "Min");
            if (!(value < min)) continue;
            errMsg = String.format("%sP (%5.5g) is below low limit (%5.5g)", pName, value, min);
            break;
        }
        if (errMsg != null) {
            this.sLog.error((Object)("Config error: " + errMsg));
            throw new IllegalArgumentException(errMsg);
        }
        this.cfgValid = true;
    }

    @ConfigurationParameterChanger
    public void setGdP(double value) {
        this.gdP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Guard Diode voltage")
    public double getGdP() {
        return this.gdP;
    }

    @ConfigurationParameterChanger
    public void setGdMax(double value) {
        this.gdMax = value;
        this.highLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setGdMin(double value) {
        this.gdMin = value;
        this.lowLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setOdP(double value) {
        this.odP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the readout mode Output Drain voltage")
    public double getOdP() {
        return this.odP;
    }

    @ConfigurationParameterChanger
    public void setOdMax(double value) {
        this.odMax = value;
        this.highLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOdMin(double value) {
        this.odMin = value;
        this.lowLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOgP(double value) {
        this.ogP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate voltage")
    public double getOgP() {
        return this.ogP;
    }

    @ConfigurationParameterChanger
    public void setOgMax(double value) {
        this.ogMax = value;
        this.highLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setOgMin(double value) {
        this.ogMin = value;
        this.lowLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setRdP(double value) {
        this.rdP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Drain voltage")
    public double getRdP() {
        return this.rdP;
    }

    @ConfigurationParameterChanger
    public void setRdMax(double value) {
        this.rdMax = value;
        this.highLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setRdMin(double value) {
        this.rdMin = value;
        this.lowLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setCsGateP(double value) {
        this.csGateP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Current Source gate")
    public double getCsGateP() {
        return this.csGateP;
    }

    @ConfigurationParameterChanger
    public void setGd(int value) {
        this.gd = value;
        this.changed |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Guard Diode DAC value")
    public int getGd() {
        return this.gd;
    }

    @ConfigurationParameterChanger
    public void setOd(int value) {
        this.od = value;
        this.changed |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the readout mode Output Drain DAC value")
    public int getOd() {
        return this.od;
    }

    @ConfigurationParameterChanger
    public void setOg(int value) {
        this.og = value;
        this.changed |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate DAC value")
    public int getOg() {
        return this.og;
    }

    @ConfigurationParameterChanger
    public void setOgSh(int value) {
        this.ogSh = value;
        this.changed |= 8;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate shift DAC value")
    public int getOgSh() {
        return this.ogSh;
    }

    @ConfigurationParameterChanger
    public void setRd(int value) {
        this.rd = value;
        this.changed |= 0x10;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Drain DAC value")
    public int getRd() {
        return this.rd;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int value) {
        this.csGate = value;
        this.changed |= 0x20;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Current Source gate")
    public int getCsGate() {
        return this.csGate;
    }

    void setConfig(BiasDACS bias) {
        Object[] values;
        String name = this.getName();
        if (!this.raw) {
            values = bias.getPValues();
            this.sce.submitChange(name, GD_P, (Object)values[0]);
            this.sce.submitChange(name, OD_P, (Object)values[1]);
            this.sce.submitChange(name, OG_P, (Object)values[2]);
            this.sce.submitChange(name, RD_P, (Object)values[5]);
            this.sce.submitChange(name, CS_GATE_P, (Object)values[4]);
        } else {
            values = bias.getValues();
            this.sce.submitChange(name, GD, (Object)((int)values[0]));
            this.sce.submitChange(name, OD, (Object)((int)values[1]));
            this.sce.submitChange(name, OG, (Object)((int)values[2]));
            this.sce.submitChange(name, OG_SH, (Object)((int)values[3]));
            this.sce.submitChange(name, RD, (Object)((int)values[5]));
            this.sce.submitChange(name, CS_GATE, (Object)((int)values[4]));
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (IllegalArgumentException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw e;
        }
    }

    BiasDACS getConfig() {
        BiasDACS bias = new BiasDACS();
        if (!this.raw) {
            double[] values = bias.getPValues();
            values[0] = this.gdP;
            values[1] = this.odP;
            values[2] = this.ogP;
            values[5] = this.rdP;
            values[4] = this.csGateP;
        } else {
            int[] values = bias.getValues();
            values[0] = this.gd;
            values[1] = this.od;
            values[2] = this.og;
            values[3] = this.ogSh;
            values[5] = this.rd;
            values[4] = this.csGate;
        }
        return bias;
    }

    int load() throws Exception {
        return this.load(200);
    }

    int load(int wait) throws Exception {
        if (!this.cfgValid) {
            throw new RaftException(this.getName() + " load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException(this.getName() + " load error: invalid REB serial number");
        }
        if (this.isItlCcd()) {
            this.loadOg(wait);
            this.loadGd(wait);
            this.loadRd(wait);
            this.loadOd(wait);
        } else {
            this.loadRd(wait);
            this.loadOd(wait);
            this.loadGd(wait);
            this.loadOg(wait);
        }
        this.loadCsGate(wait);
        this.changed = 0;
        return 6;
    }

    int loadChanged() throws Exception {
        return this.loadChanged(200);
    }

    int loadChanged(int wait) throws Exception {
        if (!this.cfgValid) {
            throw new RaftException(this.getName() + " load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException(this.getName() + " load error: invalid REB serial number");
        }
        int count = 0;
        if (this.isItlCcd()) {
            if ((this.changed & 4) != 0) {
                this.loadOg(wait);
                count += 2;
            }
            if ((this.changed & 1) != 0) {
                this.loadGd(wait);
                ++count;
            }
            if ((this.changed & 0x10) != 0) {
                this.loadRd(wait);
                ++count;
            }
            if ((this.changed & 2) != 0) {
                this.loadOd(wait);
                ++count;
            }
        } else {
            if ((this.changed & 0x10) != 0) {
                this.loadRd(wait);
                ++count;
            }
            if ((this.changed & 2) != 0) {
                this.loadOd(wait);
                ++count;
            }
            if ((this.changed & 1) != 0) {
                this.loadGd(wait);
                ++count;
            }
            if ((this.changed & 4) != 0) {
                this.loadOg(wait);
                count += 2;
            }
        }
        if ((this.changed & 0x20) != 0) {
            this.loadCsGate(wait);
            ++count;
        }
        this.changed = 0;
        return count;
    }

    void clear() throws Exception {
        this.clear(0);
    }

    void clear(int wait) throws Exception {
        this.clearCsGate(wait);
        if (this.isItlCcd()) {
            this.clearOd(wait);
            this.clearRd(wait);
            this.clearGd(wait);
            this.clearOg(wait);
        } else {
            this.clearOd(wait);
            this.clearGd(wait);
            this.clearOg(wait);
            this.clearRd(wait);
        }
        this.changed = -1;
    }

    private void loadGd(int wait) throws Exception {
        if (!this.raw) {
            this.setDac(13, (int)(this.gdConv * this.gdP));
        } else {
            this.setDac(13, this.gd);
        }
        this.loadDac(wait);
    }

    private void loadOd(int wait) throws Exception {
        if (!this.raw) {
            this.setDac(12, (int)(this.odConv * this.odP));
        } else {
            this.setDac(12, this.od);
        }
        this.loadDac(wait);
    }

    private void loadOg(int wait) throws Exception {
        if (!this.raw) {
            this.setDac(15, this.ogP > 0.0 ? (int)(this.ogConv * this.ogP) : 0);
            this.setDac(16, this.ogP < 0.0 ? (int)(-this.ogShiftConv * this.ogP) : 0);
        } else {
            this.setDac(15, this.og);
            this.setDac(16, this.ogSh);
        }
        this.loadDac(wait);
    }

    private void loadRd(int wait) throws Exception {
        if (!this.raw) {
            this.setDac(14, (int)(this.rdConv * this.rdP));
        } else {
            this.setDac(14, this.rd);
        }
        this.loadDac(wait);
    }

    private void loadCsGate(int wait) throws Exception {
        if (!this.raw) {
            this.setDac(17, (int)(this.csConv * (this.csGateP + this.csOffset)));
        } else {
            this.setDac(17, this.csGate);
        }
        this.loadDac(wait);
    }

    private void clearGd(int wait) throws Exception {
        this.setDac(13, 0);
        this.loadDac(wait);
    }

    private void clearOd(int wait) throws Exception {
        this.setDac(12, 0);
        this.loadDac(wait);
    }

    private void clearOg(int wait) throws Exception {
        this.setDac(15, 0);
        this.setDac(16, 0);
        this.loadDac(wait);
    }

    private void clearRd(int wait) throws Exception {
        this.setDac(14, 0);
        this.loadDac(wait);
    }

    private void clearCsGate(int wait) throws Exception {
        this.setDac(17, 0);
        this.loadDac(wait);
    }

    private void setDac(int chan, int value) throws Exception {
        this.testOnline();
        try {
            this.dac.set(this.hwChan, chan, value < 0 ? 0 : (value > 4095 ? 4095 : value));
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
        }
    }

    private void loadDac(int wait) throws Exception {
        this.testOnline();
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.dac.loadStrip(this.hwChan);
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
        }
    }

    private boolean isItlCcd() {
        return this.rebDevc.getCcdType() == CcdType.ITL;
    }
}

