package org.lsst.ccs.subsystem.ts8.sim;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.drivers.reb.sim.DataProvider;
import org.lsst.ccs.subsystem.rafts.data.SequencerData;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataListener;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;
import org.lsst.ccs.utilities.image.ReadOutParameters;

/**
 * A ClientFactorySimulation for Teststand 8
 */
public class TS8ClientFactorySimulation extends ClientFactorySimulation {

    private final InnerDataProvider dataProvider;
    private Geometry geom;

    /**
     * Constructor the the TS8 Simulation Client Factory.
     *
     * @param geom The overall Geometry.
     *
     */
    public TS8ClientFactorySimulation(Geometry geom) {
        super();
        dataProvider = new InnerDataProvider();
        RawImageDataProvider.addRawImageDataListener(dataProvider, (RawImageDataProvider) geom);
        this.geom = geom;
    }

    @Override
    protected DataProvider createDataProvider() {
        return dataProvider;
    }

    private class InnerDataProvider implements RawImageDataListener, DataProvider {

        private RawImageData data;

        private final Random random = new Random();

        @Override
        public ByteBuffer getData(ImageMetadata metadata) {

            //TO-DO Fill a buffer with size metadata.getLength() from
            //the generated data. For now just random numbers.
            
            
            int dataLength = metadata.getRegisters()[SequencerData.REG_READ_ROWS]*metadata.getRegisters()[SequencerData.REG_READ_COLS];
            dataLength *= 16*3*4;
            
            ByteBuffer result = ByteBuffer.allocate(dataLength);
            result.order(ByteOrder.nativeOrder());
//            result.put(data.getImageData());


            int count = 0;
            int multiplier = dataLength/16;
            int increment = 0;
            while (result.hasRemaining()) {
                if ( count > 15 ) {
                    count = 0;
                }
                count++;
                result.putInt(count*10000000 ^ 0x1ffff);
                increment++;
            }
            result.flip();
            return result;
        }

        @Override
        public void rawImageDataAvailable(RawImageDataProvider imageDataProvider) {
            //TODO: Fix this!!!
            ReadOutParameters readOutParameters = new ReadOutParameters(new E2VCCDType());
            this.data = imageDataProvider.getRawImageData(readOutParameters);

        }

    }

}
