/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.viewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.ImageSensitiveArea;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImagePixelData;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;
import org.lsst.ccs.utilities.image.viewer.GeometryRenderer;

public class ImageWithGeometryViewer {
    private String imagePattern = "ripples";
    private final HashMap<String, String> parameters = new HashMap();
    private GeneratedImage generatedImage;
    private JFrame frame = new JFrame();
    private final ImagePanel imagePanel = new ImagePanel();
    private static Geometry currentObject;
    private static double scaleFactor;
    private static HashMap<String, CCDType> ccdTypes;

    public ImageWithGeometryViewer() {
        ImageWithGeometryViewer.setGeometry("ccd", "e2v");
        FitsHeadersSpecifications.addSpecFile("primary");
        FitsHeadersSpecifications.addSpecFile("extended");
        FitsHeadersSpecifications.addSpecFile("test_cond");
        ccdTypes.put("e2v", new E2VCCDType());
        ccdTypes.put("itl", new ITLCCDType());
    }

    @Command(description="Expose the current geometry to a simulated image")
    public void exposeGeometry() {
        if (currentObject == null) {
            throw new RuntimeException("Geometry does not exist");
        }
        if (this.generatedImage == null) {
            this.generateImageForGeometry();
        }
        PatternGeneratorFactory.exposeGeometryToGeneratedImage(currentObject, this.generatedImage);
    }

    @Command(description="Set the Geometry to use.")
    public static void setGeometry(@Argument(name="geometry", description="The parameter's value") String geometryName, @Argument(name="type", description="The sensor's type", defaultValue="e2v") String sensorType) {
        switch (geometryName) {
            case "raft": {
                currentObject = Raft.createRaft(ccdTypes.get(sensorType.toUpperCase()));
                break;
            }
            case "reb": {
                currentObject = Reb.createReb(ccdTypes.get(sensorType.toUpperCase()));
                break;
            }
            case "ccd": {
                currentObject = CCD.createCCD(ccdTypes.get(sensorType.toUpperCase()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not instanciate geometry " + geometryName);
            }
        }
        System.out.println("Created Geometry " + geometryName + " of type " + sensorType);
    }

    @Command(description="Set an Image generation parameter.")
    public void setImageGenerationParameter(@Argument(name="parName", description="The parameter's name") String parName, @Argument(name="parValue", description="The parameter's value") String parValue) {
        this.parameters.put(parName, parValue);
    }

    @Command
    public Set<String> listAvailablePatterns() {
        return PatternGeneratorFactory.listAvailablePatterns();
    }

    @Command(description="Set the image pattern. This is used to generate images.")
    public void set(@Argument(name="item") SetGetImagePattern what, @Argument(name="value", defaultValue="") String value) {
        switch (what) {
            case IMAGE_PATTERN: {
                if (this.listAvailablePatterns().contains(value)) {
                    this.imagePattern = value;
                    break;
                }
                throw new RuntimeException("Pattern \"" + value + "\" is not supported.");
            }
        }
    }

    @Command(description="Get various settings")
    public String get(@Argument(name="item") SetGetImagePattern what) {
        switch (what) {
            case IMAGE_PATTERN: {
                return this.imagePattern;
            }
        }
        return null;
    }

    @Command(description="Show the geometry tree.")
    public void showGeometryTree() {
        if (currentObject == null) {
            throw new RuntimeException("There is currently no geometry availabble.");
        }
        ImageWithGeometryViewer.printGeometryTree(currentObject, "", new Point(0, 0));
    }

    private static void printGeometryTree(Geometry geom, String indent, Point p) {
        System.out.println(indent + "-> " + geom.getName() + " at " + p.x + "," + p.y);
        if (geom.hasChildren()) {
            Map<Geometry, Point> children = geom.getChildrenWithAbsoluteCoordinates();
            for (Geometry child : children.keySet()) {
                ImageWithGeometryViewer.printGeometryTree(child, indent + "---", children.get(child));
            }
        }
    }

    @Command(description="Generate an image for the currently loaded Geometry.")
    public void generateImageForGeometry() {
        this.generatedImage = PatternGeneratorFactory.generateImageForGeometry(currentObject, this.imagePattern, this.parameters);
    }

    @Command(description="Show the generated Image.")
    public void showImage() throws Exception {
        if (this.generatedImage == null) {
            throw new RuntimeException("No image has been generated.");
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ImageWithGeometryViewer.this.imagePanel.setImage(ImageWithGeometryViewer.this.convertGeneratedImageForDisplay(ImageWithGeometryViewer.this.generatedImage));
                if (ImageWithGeometryViewer.this.frame.getContentPane() != ImageWithGeometryViewer.this.imagePanel) {
                    ImageWithGeometryViewer.this.frame.setContentPane(ImageWithGeometryViewer.this.imagePanel);
                }
                if (ImageWithGeometryViewer.this.frame.isVisible()) {
                    ImageWithGeometryViewer.this.frame.revalidate();
                    ImageWithGeometryViewer.this.frame.repaint();
                    ImageWithGeometryViewer.this.frame.pack();
                } else {
                    ImageWithGeometryViewer.this.frame.pack();
                    ImageWithGeometryViewer.this.frame.setVisible(true);
                }
            }
        });
    }

    @Command(description="Show the geometry and its data if present.")
    public void showGeometry() throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ImageWithGeometryViewer.this.imagePanel.setImage(ImageWithGeometryViewer.this.createBufferedImageForGeometry(currentObject));
                ImageWithGeometryViewer.this.imagePanel.setGeometry(currentObject);
                if (ImageWithGeometryViewer.this.frame.getContentPane() != ImageWithGeometryViewer.this.imagePanel) {
                    ImageWithGeometryViewer.this.frame.setContentPane(ImageWithGeometryViewer.this.imagePanel);
                }
                if (ImageWithGeometryViewer.this.frame.isVisible()) {
                    ImageWithGeometryViewer.this.frame.revalidate();
                    ImageWithGeometryViewer.this.frame.repaint();
                    ImageWithGeometryViewer.this.frame.pack();
                } else {
                    ImageWithGeometryViewer.this.frame.pack();
                    ImageWithGeometryViewer.this.frame.setVisible(true);
                }
            }
        });
    }

    @Command(description="Show the data streams.")
    public void showDataStreams() throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ImageWithGeometryViewer.this.imagePanel.setImage(ImageWithGeometryViewer.this.createBufferedImageForGeometryFromDataStreams(currentObject));
                ImageWithGeometryViewer.this.imagePanel.setGeometry(currentObject);
                if (ImageWithGeometryViewer.this.frame.getContentPane() != ImageWithGeometryViewer.this.imagePanel) {
                    ImageWithGeometryViewer.this.frame.setContentPane(ImageWithGeometryViewer.this.imagePanel);
                }
                if (ImageWithGeometryViewer.this.frame.isVisible()) {
                    ImageWithGeometryViewer.this.frame.revalidate();
                    ImageWithGeometryViewer.this.frame.repaint();
                    ImageWithGeometryViewer.this.frame.pack();
                } else {
                    ImageWithGeometryViewer.this.frame.pack();
                    ImageWithGeometryViewer.this.frame.setVisible(true);
                }
            }
        });
    }

    @Command(description="Write the fits files with the accumulated images")
    public void writeFitsFiles() throws Exception {
        this.writeFitsFilesForObject(currentObject);
    }

    private void writeFitsFilesForObject(Object obj) throws Exception {
        if (obj instanceof CCD) {
            CCD ccd = (CCD)obj;
            ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD(ccd);
            String raftName = String.format("R99_S00", new Object[0]);
            File raftFile = new File("/tmp/" + raftName + ".fits");
            int channel = 0;
            try (FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet);){
                for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
                    for (int p = 0; p < ccd.getParallelChildrenCount(); ++p) {
                        Segment seg = (Segment)ccd.getChild(p, s);
                        ByteBuffer dataBuffer = seg.getRawImageData(imageSet.getReadOutParameters()).getImageData();
                        ffw.write(channel, dataBuffer);
                        dataBuffer.clear();
                        ++channel;
                    }
                }
            }
        }
    }

    private BufferedImage createBufferedImageForGeometryFromDataStreams(Geometry geom) {
        if (geom instanceof CCD) {
            CCD ccd = (CCD)geom;
            BufferedImage result = new BufferedImage(ccd.getType().getCCDGeometryConstants().getPhysicalAreaParallelSize(), ccd.getType().getCCDGeometryConstants().getPhysicalAreaSerialSize(), 10);
            this.addGeometryDataStreamToRaster(new Point(0, 0), result.getRaster(), geom);
            return result;
        }
        throw new RuntimeException("Currently can only produce images from CCDs.");
    }

    private void addGeometryDataStreamToRaster(Point origin, WritableRaster raster, Geometry geom) {
        if (geom instanceof CCD) {
            CCD ccd = (CCD)geom;
            for (int p = 0; p < ccd.getParallelChildrenCount(); ++p) {
                for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
                    Segment seg = (Segment)ccd.getChild(p, s);
                    Point segmentPoint = ccd.getGeometryPoint(seg);
                    double maxValue = seg.getImagePixelData().getMaxValue();
                    ReadOutParameters readOutParameters = new ReadOutParameters(ccd.getType());
                    ByteBuffer bb = seg.getRawImageData(readOutParameters).getImageData();
                    for (int pp = 0; pp < seg.getSegmentParallelActiveSize(); ++pp) {
                        int j;
                        for (j = 0; j < readOutParameters.getSerialPrescan(); ++j) {
                            bb.getInt();
                        }
                        for (int ss = 0; ss < seg.getSegmentSerialActiveSize(); ++ss) {
                            int val = (int)((double)(256 * bb.getInt()) / maxValue);
                            raster.setSample(segmentPoint.x + pp, segmentPoint.y + ss, 0, val);
                        }
                        for (j = 0; j < readOutParameters.getOverCols(); ++j) {
                            bb.getInt();
                        }
                    }
                }
            }
        } else {
            throw new RuntimeException("Currently can only produce images from CCDs.");
        }
    }

    private final BufferedImage createBufferedImageForGeometry(Geometry geom) {
        int width = geom.getWidth();
        int height = geom.getHeight();
        BufferedImage result = new BufferedImage(width, height, 10);
        this.addGeometryToRaster(new Point(0, 0), result.getRaster(), geom);
        return result;
    }

    private void addGeometryToRaster(Point origin, WritableRaster raster, Geometry<?> geom) {
        ImageSensitiveArea imageSensitiveArea;
        if (geom instanceof ImageSensitiveArea && (imageSensitiveArea = (ImageSensitiveArea)((Object)geom)).hasPixelData()) {
            this.addDataToRaster(origin, raster, imageSensitiveArea.getImagePixelData());
        }
        for (Geometry child : geom.getChildrenList()) {
            this.addGeometryToRaster(child.getGeometryAbsolutePosition(), raster, child);
        }
    }

    private final BufferedImage convertGeneratedImageForDisplay(GeneratedImage generatedImage) {
        int width = generatedImage.getWidth();
        int height = generatedImage.getHeight();
        BufferedImage result = new BufferedImage(width, height, 10);
        this.addDataToRaster(new Point(0, 0), result.getRaster(), generatedImage);
        return result;
    }

    private final void addDataToRaster(Point origin, WritableRaster raster, ImagePixelData data) {
        double maxValue = data.getMaxValue();
        if (Double.isNaN(maxValue)) {
            maxValue = 1.0;
        }
        int width = data.getWidth();
        int height = data.getHeight();
        for (int x = 0; x < width; ++x) {
            int xGlobal = x + origin.x;
            for (int y = 0; y < height; ++y) {
                int yGlobal = y + origin.y;
                raster.setSample(xGlobal, yGlobal, 0, (int)((double)(256 * data.getPixelData(x, y)) / maxValue));
            }
        }
    }

    @Command(description="Save the generated image to file")
    public void saveGeneratedImage(@Argument(name="fullPath", defaultValue="/tmp/generateImage.ser") String fullPath) {
        if (this.generatedImage == null) {
            throw new RuntimeException("No image has been generated.");
        }
        String format = fullPath.substring(fullPath.lastIndexOf(".") + 1);
        System.out.println("Saving image to " + fullPath + " format " + format);
        try {
            File outputfile = new File(fullPath);
            if (format.equals("ser")) {
                ObjectOutputStream obj_out = new ObjectOutputStream(new FileOutputStream(outputfile));
                obj_out.writeObject(this.generatedImage);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save generated image.", e);
        }
    }

    @Command(description="Set the scale factor")
    public void setScaleFactor(@Argument(name="scaleFactor", defaultValue="0.1") double scaleFactor) {
        ImageWithGeometryViewer.scaleFactor = scaleFactor;
    }

    public static void main(String[] arg) throws Exception {
        String[] args = new String[]{"-dc", "org.lsst.ccs.utilities.image.patterns.TestImageWithGeometryGeneration"};
        JLineShell.main((String[])args);
    }

    static {
        scaleFactor = 0.1;
        ccdTypes = new HashMap();
    }

    private static class ImagePanel
    extends JPanel {
        Image i;
        Geometry geom;
        int width = 0;
        int height = 0;

        private ImagePanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.scale(scaleFactor, scaleFactor);
            super.paintComponent(g);
            g.drawImage(this.i, 0, 0, null);
            if (this.geom != null) {
                GeometryRenderer.renderGeometry(currentObject, g, new Point(0, 0), scaleFactor);
            }
        }

        public void setImage(Image i) {
            this.i = i;
            this.updateDimensions();
        }

        public void setGeometry(Geometry g) {
            this.geom = g;
            this.updateDimensions();
        }

        private void updateDimensions() {
            this.width = this.i.getWidth(null);
            this.height = this.i.getHeight(null);
            if (this.geom != null) {
                if (this.geom.getWidth() > this.width) {
                    this.width = this.geom.getWidth();
                }
                if (this.geom.getHeight() > this.height) {
                    this.height = this.geom.getHeight();
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)(scaleFactor * (double)this.width), (int)(scaleFactor * (double)this.height));
        }
    }

    protected static enum SetGetImagePattern {
        IMAGE_PATTERN;

    }
}

