/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ScientificFormat;
import jas.util.SpinBox;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SciFormatPanel
extends JPanel
implements ActionListener {
    private ScientificFormat f;
    private JLabel WidthLabel;
    private JLabel SigLabel;
    private JPanel DisplayStyle;
    private JRadioButton PureSci;
    private JRadioButton StandardSci;
    private SpinBox widthdigits;
    private SpinBox sigdigits;

    public SciFormatPanel(ScientificFormat s) {
        this.f = s;
        this.createPanel();
    }

    private void createPanel() {
        JPanel DisplayOptions = new JPanel(new FlowLayout(1));
        this.SigLabel = new JLabel("Significant Digits");
        this.WidthLabel = new JLabel("Maximum Digits");
        this.sigdigits = new SpinBox(this.f.getSigDigits(), 1, 15);
        this.widthdigits = new SpinBox(this.f.getMaxWidth(), 1, 100);
        this.sigdigits.setValue(this.f.getSigDigits());
        this.widthdigits.setValue(this.f.getMaxWidth());
        this.sigdigits.addActionListener(new MySpinBoxListener());
        this.widthdigits.addActionListener(new MySpinBoxListener());
        if (this.f.getScientificNotationStyle()) {
            this.widthdigits.setEnabled(false);
            this.WidthLabel.setEnabled(false);
        }
        DisplayOptions.add(this.SigLabel);
        DisplayOptions.add(this.sigdigits);
        DisplayOptions.add(this.WidthLabel);
        DisplayOptions.add(this.widthdigits);
        JPanel Style2 = new JPanel(new FlowLayout(1));
        this.PureSci = new JRadioButton("Use Pure Scientific Notation", this.f.getScientificNotationStyle());
        this.PureSci.setActionCommand("PureSci");
        this.PureSci.addActionListener(this);
        this.StandardSci = new JRadioButton("Use Standard Scientific Notation", !this.f.getScientificNotationStyle());
        this.StandardSci.setActionCommand("StandSci");
        this.StandardSci.addActionListener(this);
        Style2.add(this.PureSci);
        Style2.add(this.StandardSci);
        ButtonGroup group = new ButtonGroup();
        group.add(this.PureSci);
        group.add(this.StandardSci);
        this.DisplayStyle = new JPanel();
        this.DisplayStyle.setLayout(new GridLayout(2, 1));
        this.DisplayStyle.add(DisplayOptions);
        this.DisplayStyle.add(Style2);
    }

    public void updateSciFormat() {
        this.f.setMaxWidth(this.widthdigits.getValue());
        this.f.setSigDigits(this.sigdigits.getValue());
        this.f.setScientificNotationStyle(this.PureSci.isSelected());
    }

    public JPanel getPanel() {
        return this.DisplayStyle;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "StandSci") {
            this.WidthLabel.setEnabled(true);
            this.widthdigits.setEnabled(true);
        } else if (e.getActionCommand() == "PureSci") {
            this.WidthLabel.setEnabled(false);
            this.widthdigits.setEnabled(false);
        }
    }

    class MySpinBoxListener
    implements ActionListener {
        MySpinBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SciFormatPanel.this.widthdigits.getValue() < SciFormatPanel.this.sigdigits.getValue()) {
                SciFormatPanel.this.widthdigits.setValue(SciFormatPanel.this.sigdigits.getValue());
            }
        }
    }
}

