/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.jas.services.PlotterProvider;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.plugins.trending.AutoRefreshManager;
import org.lsst.ccs.gconsole.plugins.trending.ControlPanel;
import org.lsst.ccs.gconsole.plugins.trending.RestSource;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPanel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowSelector;
import org.lsst.ccs.gconsole.util.ThreadUtil;

@Plugin(name="LSST Trending Plugin", id="trending", description="Allows plotting time histories for channels from the trending database and other sources", loadAtStart=true)
public class LsstTrendingPlugin
extends ConsolePlugin
implements PlotterProvider,
TrendingService {
    final String PANEL_GROUP = "TrendingPlots";
    private TrendingPreferences prefs;
    private RestSource restSource;
    private volatile PlotFactory plotFactory;
    private volatile AutoRefreshManager refreshMan;
    private TimeWindowSelector timeWindowSelector;
    private JToolBar toolbar;
    private JCheckBoxMenuItem autoRefreshMenu;
    private final ArrayList<ControlPanel> controlPanels = new ArrayList(0);
    private final ArrayList<TrendingPanel> pages = new ArrayList(0);
    private boolean restoring;
    private ThreadPoolExecutor dataFetcher;
    private final int DATA_FETCHER_MAX_THREADS = 3;
    private final int DATA_FETCHER_KEEP_ALIVE = 120;

    @Override
    public void initialize() {
        this.prefs = new TrendingPreferences(this);
        this.getConsole().getConsoleLookup().add((Object)this.prefs);
        AbstractAction trendingAction = new AbstractAction("Trending"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstTrendingPlugin.this.openControlPanel(null);
            }
        };
        this.getServices().addMenu(trendingAction, "400: CCS Tools :-1:3");
    }

    @Override
    public void start() {
        if (this.prefs.isAutoStart()) {
            this.openControlPanel(null);
        }
    }

    @Override
    public void shutdown() {
        if (this.dataFetcher != null) {
            this.dataFetcher.shutdownNow();
        }
    }

    private void startTrending() {
        if (this.restSource != null) {
            return;
        }
        this.plotFactory = (PlotFactory)this.getConsole().getConsoleLookup().lookup(PlotFactory.class);
        if (this.plotFactory == null) {
            throw new RuntimeException("No plot factory available");
        }
        ThreadFactory tFactory = new ThreadFactory(){
            final ThreadFactory delegate = Executors.defaultThreadFactory();
            final AtomicInteger id = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setName("Trending Data Fetcher " + this.id.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
        this.dataFetcher = new ThreadPoolExecutor(3, 3, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tFactory);
        this.dataFetcher.allowCoreThreadTimeOut(true);
        this.showToolbar();
        this.restSource = new RestSource(this);
        this.restSource.start();
    }

    private void stopTrending() {
        if (this.restSource == null) {
            return;
        }
        this.stopAutoRefresh();
        this.restSource.stop();
        this.restSource = null;
        this.dataFetcher.shutdownNow();
        this.dataFetcher = null;
        this.hideToolbar();
        this.plotFactory = null;
        this.controlPanels.trimToSize();
        this.pages.trimToSize();
    }

    private void showToolbar() {
        TimeWindowSelector box;
        Studio app = (Studio)Application.getApplication();
        this.toolbar = new JToolBar("trending");
        box.setEnabled((box = new TimeWindowSelector(app)).getItemCount() > 0);
        JLabel boxLabel = new JLabel("Trending Period: ");
        this.toolbar.add((Component)boxLabel, 0);
        this.toolbar.add((Component)box, 1);
        JMenuBar bar = new JMenuBar();
        bar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createRaisedBevelBorder()));
        bar.setAlignmentY(0.5f);
        JMenu menu = new JMenu("Apply");
        bar.add(menu);
        JMenuItem item = new JMenuItem("All");
        item.addActionListener(e -> {
            PageManager pm = app.getPageManager();
            PageContext selectedPage = pm.getSelectedPage();
            List pcList = pm.pages();
            for (Object o : pcList) {
                try {
                    PlotPage page = (PlotPage)((PageContext)o).getPage();
                    if (page == null) continue;
                    this.refresh(page, this.getSelectedTimeWindow());
                }
                catch (ClassCastException | NullPointerException runtimeException) {}
            }
            selectedPage.requestShow();
        });
        menu.add(item);
        item = new JMenuItem("Page");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                if (page != null) {
                    this.refresh(page, this.getSelectedTimeWindow());
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        item = new JMenuItem("Region");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                this.refresh(page.currentRegion(), this.getSelectedTimeWindow());
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        this.toolbar.add((Component)bar, 2);
        bar = new JMenuBar();
        bar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createRaisedBevelBorder()));
        bar.setAlignmentY(0.5f);
        menu = new JMenu("Refresh");
        bar.add(menu);
        item = new JMenuItem("All");
        item.addActionListener(e -> {
            PageManager pm = app.getPageManager();
            PageContext selectedPage = pm.getSelectedPage();
            List pcList = pm.pages();
            for (Object o : pcList) {
                try {
                    PlotPage page = (PlotPage)((PageContext)o).getPage();
                    if (page == null) continue;
                    this.refresh(page, null);
                }
                catch (ClassCastException | NullPointerException runtimeException) {}
            }
            selectedPage.requestShow();
        });
        menu.add(item);
        item = new JMenuItem("Page");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                if (page != null) {
                    this.refresh(page, null);
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        item = new JMenuItem("Region");
        item.addActionListener(e -> {
            try {
                PlotPage page = (PlotPage)app.getPageManager().getSelectedPage().getPage();
                this.refresh(page.currentRegion(), null);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        });
        menu.add(item);
        menu.addSeparator();
        this.autoRefreshMenu = new JCheckBoxMenuItem("Auto");
        this.autoRefreshMenu.setSelected(false);
        this.autoRefreshMenu.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.startAutoRefresh();
            } else if (e.getStateChange() == 2) {
                this.stopAutoRefresh();
            }
        });
        menu.add(this.autoRefreshMenu);
        this.toolbar.add((Component)bar, 3);
        app.addToolBar(this.toolbar, this.toolbar.getName());
        this.timeWindowSelector = box;
    }

    private void hideToolbar() {
        Studio app = (Studio)Application.getApplication();
        app.removeToolBar(this.toolbar);
        this.toolbar = null;
        this.timeWindowSelector = null;
    }

    private void startAutoRefresh() {
        if (this.refreshMan != null) {
            this.stopAutoRefresh();
        }
        this.refreshMan = new AutoRefreshManager(this);
        this.refreshMan.start();
    }

    private void stopAutoRefresh() {
        if (this.refreshMan == null) {
            return;
        }
        this.refreshMan.stop();
        this.refreshMan = null;
    }

    private void checkState() {
        if (this.controlPanels.isEmpty() && this.pages.isEmpty() && !this.restoring) {
            this.stopTrending();
        }
    }

    private ControlPanel openControlPanel(ControlPanel.Descriptor descriptor) {
        try {
            this.startTrending();
            ControlPanel controlPanel = new ControlPanel(this, descriptor);
            HashMap<Panel, Object> par = new HashMap<Panel, Object>();
            par.put(Panel.TITLE, controlPanel.getName());
            par.put(Panel.TYPE, PanelType.CONTROL);
            Consumer<JComponent> onClose = c -> {
                ControlPanel cp = (ControlPanel)((JScrollPane)c).getViewport().getView();
                cp.stop();
                this.controlPanels.remove(cp);
                this.checkState();
            };
            par.put(Panel.ON_CLOSE, onClose);
            Console.getConsole().getPanelManager().open((Component)new JScrollPane(controlPanel), par);
            this.controlPanels.add(controlPanel);
            controlPanel.start();
            return controlPanel;
        }
        catch (RuntimeException x) {
            this.getConsole().error("Unable to open trending control page", x);
            this.checkState();
            return null;
        }
    }

    private void closeControlPanel(ControlPanel panel) {
        Console.getConsole().getPanelManager().close(panel);
    }

    private TrendingPanel createPage(String name) {
        TrendingPanel panel = new TrendingPanel(this, name);
        this.pages.add(panel);
        return panel;
    }

    void closePage(TrendingPanel page) {
        this.pages.remove((Object)page);
    }

    TrendingPreferences getPreferences() {
        return this.prefs;
    }

    PlotFactory getPlotFactory() {
        return this.plotFactory;
    }

    ThreadPoolExecutor getExecutor() {
        return this.dataFetcher;
    }

    RestSource getTrendingSource() {
        return this.restSource;
    }

    TimeWindowSelector getTimeWindowSelector() {
        return this.timeWindowSelector;
    }

    TimeWindow getSelectedTimeWindow() {
        return this.timeWindowSelector.getSelectedTimeWindow();
    }

    List<TrendingPanel> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    void plot(Trend.Descriptor channel, PlotRegion region, TrendPlotter.Option ... options) {
        TrendPlotter plotter;
        if (channel == null || region == null) {
            return;
        }
        try {
            plotter = (TrendPlotter)region.currentPlot();
        }
        catch (ClassCastException x) {
            return;
        }
        if (plotter == null) {
            plotter = this.create();
            LsstTrendingPlugin.showPlotter(plotter, region);
        }
        if (!plotter.isActive()) {
            return;
        }
        TimeWindow timeWindow = this.getSelectedTimeWindow();
        if (timeWindow == null) {
            return;
        }
        Trend trend = new Trend(channel);
        trend.setTimeWindow(timeWindow);
        int mode = !plotter.isEmpty() && options.length != 0 && Arrays.asList(options).contains((Object)TrendPlotter.Option.OVERLAY) ? 1 : 0;
        plotter.plot(trend, mode);
        Trend finalTrend = trend;
        this.dataFetcher.execute(() -> this.refresh(finalTrend));
    }

    void plot(Trend.Descriptor channel, TrendPlotter.Option ... options) {
        if (channel == null) {
            return;
        }
        EnumSet<TrendPlotter.Option> opts = options.length == 0 ? EnumSet.noneOf(TrendPlotter.Option.class) : EnumSet.copyOf(Arrays.asList(options));
        TimeWindow timeWindow = this.getSelectedTimeWindow();
        if (timeWindow == null) {
            return;
        }
        Trend trend = null;
        if (opts.contains((Object)TrendPlotter.Option.EXIST)) {
            trend = this.findTrend(channel, timeWindow);
        }
        if (trend == null) {
            TrendPlotter plotter;
            Object page = null;
            PlotRegion region = null;
            if (!opts.contains((Object)TrendPlotter.Option.NEWPAGE)) {
                page = this.plotFactory.currentPage();
            }
            if (page == null) {
                page = this.createPage(channel.getTitle());
                if (page == null) {
                    this.getConsole().error("Unable to create a plot page");
                    return;
                }
                region = page.currentRegion();
            }
            if (region == null) {
                if (opts.contains((Object)TrendPlotter.Option.NEWPLOT)) {
                    int n = page.numberOfRegions();
                    for (int i = 0; i < n; ++i) {
                        PlotRegion r = page.region(i);
                        if (r.currentPlot() != null) continue;
                        region = r;
                        break;
                    }
                } else {
                    region = page.currentRegion();
                }
                if (region == null) {
                    region = page.addRegion();
                }
            }
            trend = new Trend(channel);
            trend.setTimeWindow(timeWindow);
            Plotter pl = region.currentPlot();
            if (pl != null && !(pl instanceof TrendPlotter)) {
                pl.clear();
                region.clear();
                pl = null;
            }
            if (pl == null) {
                plotter = this.create();
                LsstTrendingPlugin.showPlotter(plotter, region);
            } else {
                plotter = (TrendPlotter)pl;
            }
            int mode = !plotter.isEmpty() && opts.contains((Object)TrendPlotter.Option.OVERLAY) ? 1 : 0;
            plotter.plot(trend, mode);
        }
        trend.getPlotter().toFront();
        Trend finalTrend = trend;
        this.dataFetcher.execute(() -> this.refresh(finalTrend));
    }

    void refresh(Trend.Descriptor channel) {
        ArrayList<Trend> trends = this.findTrends(channel);
        trends.forEach(trend -> {
            if (!trend.getTimeWindow().isFixed()) {
                this.dataFetcher.execute(() -> this.refresh(trend.getPlotter().getTrends()));
            }
        });
    }

    void refresh(PlotPage page, TimeWindow timeWindow) {
        int n = page.numberOfRegions();
        try {
            for (int i = 0; i < n; ++i) {
                this.refresh(page.region(i), timeWindow);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    void refresh(PlotRegion region, TimeWindow timeWindow) {
        TrendPlotter tp;
        Plotter plotter = region.currentPlot();
        if (plotter != null && plotter instanceof TrendPlotter && (tp = (TrendPlotter)plotter).isActive()) {
            if (timeWindow != null) {
                tp.getTrends().forEach(t -> t.setTimeWindow(timeWindow));
            }
            this.dataFetcher.execute(() -> this.refresh(tp.getTrends()));
        }
    }

    static void showPlotter(TrendPlotter plotter, PlotRegion region) {
        Plotter oldPlotter = region.currentPlot();
        if (oldPlotter != null) {
            oldPlotter.clear();
            region.clear();
        }
        plotter.setRegion(region);
        region.showPlot((Plotter)plotter);
    }

    @Override
    public void show(Trend.Descriptor trendDescriptor) {
        ThreadUtil.invokeLater(() -> this.plot(trendDescriptor, TrendPlotter.Option.EXIST, TrendPlotter.Option.NEWPAGE));
    }

    @Override
    public void show(TrendPlotter.Descriptor plotterDescriptor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void show(TrendingPanel.Descriptor pageDescriptor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean supports(Class klass) {
        return Trend.class.isAssignableFrom(klass);
    }

    public TrendPlotter create() {
        return new TrendPlotter(this);
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (this.restSource == null) {
            return desc;
        }
        TimeWindow tw = this.getSelectedTimeWindow();
        if (tw != null) {
            if (tw.isPersistent()) {
                desc.setTimeWindow(tw.getName());
            } else {
                desc.setTimeWindow(tw.toCompressedString());
            }
        }
        desc.setAutoRefresh(this.refreshMan != null);
        int n = this.pages.size();
        TrendingPanel.Descriptor[] panels = new TrendingPanel.Descriptor[n];
        for (int i = 0; i < n; ++i) {
            panels[i] = this.pages.get(i).save();
        }
        desc.setPages(panels);
        n = this.controlPanels.size();
        ControlPanel.Descriptor[] dd = new ControlPanel.Descriptor[n];
        for (int i = 0; i < n; ++i) {
            dd[i] = this.controlPanels.get(i).save();
        }
        desc.setControlPages(dd);
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        if (!(storageBean instanceof Descriptor)) {
            throw new IllegalArgumentException("Illegal descriptor type: " + storageBean.getClassName());
        }
        Descriptor desc = (Descriptor)storageBean;
        String twString = desc.getTimeWindow();
        if (twString != null) {
            this.restoring = true;
        }
        ArrayList<TrendingPanel> panels = new ArrayList<TrendingPanel>(this.pages);
        panels.forEach(page -> page.hidePage());
        ArrayList<ControlPanel> controls = new ArrayList<ControlPanel>(this.controlPanels);
        controls.forEach(cp -> this.closeControlPanel((ControlPanel)cp));
        this.restoring = false;
        if (twString == null) {
            this.stopTrending();
            return true;
        }
        this.startTrending();
        TimeWindow selectedTimeWindow = this.timeWindowSelector.getTimeWindow(twString);
        if (selectedTimeWindow != null) {
            this.timeWindowSelector.setSelectedTimeWindow(selectedTimeWindow);
        }
        for (ControlPanel.Descriptor descriptor : desc.getControlPages()) {
            this.openControlPanel(descriptor);
        }
        for (Serializable serializable : desc.getPages()) {
            TrendingPanel page2 = this.createPage(((TrendingPanel.Descriptor)serializable).getTitle());
            page2.restore((TrendingPanel.Descriptor)serializable);
        }
        if (desc.isAutoRefresh()) {
            this.autoRefreshMenu.setSelected(true);
        }
        return true;
    }

    private ArrayList<Trend> findTrends(Trend.Descriptor channel) {
        String path = channel.getPath();
        String displayPath = channel.getDisplayPath();
        ArrayList<Trend> out = new ArrayList<Trend>();
        this.pages.forEach(page -> {
            int n = page.numberOfRegions();
            block0: for (int i = 0; i < n; ++i) {
                PlotRegion region = page.region(i);
                Plotter plotter = region.currentPlot();
                if (plotter == null || !(plotter instanceof TrendPlotter)) continue;
                List data = plotter.getData();
                for (Object d : data) {
                    Trend trend = (Trend)d;
                    if (!trend.getDescriptor().getPath().equals(path) || !trend.getDescriptor().getDisplayPath().equals(displayPath)) continue;
                    out.add(trend);
                    continue block0;
                }
            }
        });
        return out;
    }

    private Trend findTrend(Trend.Descriptor channel, TimeWindow timeWindow) {
        ArrayList<Trend> all = this.findTrends(channel);
        Trend best = null;
        int score = 0;
        for (Trend candidate : all) {
            TrendPlotter plotter = candidate.getPlotter();
            if (plotter.getData().size() != 1) continue;
            int candidateScore = candidate.getTimeWindow() == timeWindow ? 1 : 0;
            candidateScore <<= 1 + (candidate.getDescriptor().getPath().equals(channel.getPath()) ? 1 : 0);
            if ((candidateScore <<= 3 + plotter.getRegion().getPage().numberOfRegions()) <= score) continue;
            best = candidate;
            score = candidateScore;
        }
        return best;
    }

    private void refresh(Trend trend) {
        this.refresh(Collections.singletonList(trend));
    }

    void refresh(List<Trend> trends) {
        long now = System.currentTimeMillis();
        ArrayList data = new ArrayList(trends.size());
        RestSource source = this.getTrendingSource();
        if (source != null) {
            trends.forEach(trend -> {
                trend.setLoading(true);
                TimeWindow tw = trend.getTimeWindow();
                TrendData td = source.get(trend.getDescriptor().getPath(), tw.getLowerEdge(now), tw.getUpperEdge(now), null, trend.getData());
                data.add(td);
            });
        }
        Iterator<Trend> it = trends.iterator();
        int i = 0;
        while (it.hasNext()) {
            Trend trend2 = it.next();
            TrendData td = (TrendData)data.get(i);
            trend2.setData(td);
            ++i;
        }
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private String timeWindow;
        private boolean autoRefresh;
        private TrendingPanel.Descriptor[] pages;
        private ControlPanel.Descriptor[] controlPages;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public String getTimeWindow() {
            return this.timeWindow;
        }

        public void setTimeWindow(String timeWindow) {
            this.timeWindow = timeWindow;
        }

        public TrendingPanel.Descriptor[] getPages() {
            return this.pages;
        }

        public void setPages(TrendingPanel.Descriptor[] pages) {
            this.pages = pages;
        }

        public TrendingPanel.Descriptor getPages(int index) {
            return this.pages[index];
        }

        public void setPages(int index, TrendingPanel.Descriptor pages) {
            this.pages[index] = pages;
        }

        public boolean isAutoRefresh() {
            return this.autoRefresh;
        }

        public void setAutoRefresh(boolean autoRefresh) {
            this.autoRefresh = autoRefresh;
        }

        public ControlPanel.Descriptor[] getControlPages() {
            return this.controlPages;
        }

        public void setControlPages(ControlPanel.Descriptor[] controlPages) {
            this.controlPages = controlPages;
        }
    }
}

