/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.astrogrid.samp.SampMap;
import org.astrogrid.samp.SampUtils;

public class ErrInfo
extends SampMap {
    public static final String ERRORTXT_KEY = "samp.errortxt";
    public static final String USERTXT_KEY = "samp.usertxt";
    public static final String DEBUGTXT_KEY = "samp.debugtxt";
    public static final String CODE_KEY = "samp.code";
    private static final String[] KNOWN_KEYS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ErrInfo() {
        super(KNOWN_KEYS);
    }

    public ErrInfo(Throwable e) {
        this();
        String txt = e.getMessage();
        if (txt == null || txt.trim().length() == 0) {
            txt = e.getClass().getName();
        }
        this.put(ERRORTXT_KEY, txt);
        this.put(USERTXT_KEY, e.toString());
        this.put(DEBUGTXT_KEY, ErrInfo.getStackTrace(e));
        this.put(CODE_KEY, e.getClass().getName());
    }

    public ErrInfo(Map map) {
        this();
        this.putAll(map);
    }

    public ErrInfo(String errortxt) {
        this();
        this.put(ERRORTXT_KEY, errortxt);
    }

    public void setErrortxt(String errortxt) {
        this.put(ERRORTXT_KEY, errortxt);
    }

    public String getErrortxt() {
        return this.getString(ERRORTXT_KEY);
    }

    public void setUsertxt(String usertxt) {
        this.put(USERTXT_KEY, usertxt);
    }

    public String getUsertxt() {
        return this.getString(USERTXT_KEY);
    }

    public void setDebugtxt(String debugtxt) {
        this.put(DEBUGTXT_KEY, debugtxt);
    }

    public String getDebugtxt() {
        return this.getString(DEBUGTXT_KEY);
    }

    public void setCode(String code) {
        this.put(CODE_KEY, code);
    }

    public String getCode() {
        return this.getString(CODE_KEY);
    }

    public void check() {
        super.check();
        this.checkHasKeys(new String[]{ERRORTXT_KEY});
    }

    public static ErrInfo asErrInfo(Map map) {
        return map instanceof ErrInfo || map == null ? (ErrInfo)map : new ErrInfo(map);
    }

    private static String getStackTrace(Throwable e) {
        byte[] bbuf;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bOut));
            bOut.close();
            bbuf = bOut.toByteArray();
        }
        catch (IOException ioex) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "error generating stacktrace";
        }
        StringBuffer sbuf = new StringBuffer(bbuf.length);
        for (int ic = 0; ic < bbuf.length; ++ic) {
            char c = (char)bbuf[ic];
            if (!SampUtils.isStringChar(c)) continue;
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    static {
        $assertionsDisabled = !ErrInfo.class.desiredAssertionStatus();
        KNOWN_KEYS = new String[]{ERRORTXT_KEY, USERTXT_KEY, DEBUGTXT_KEY, CODE_KEY};
    }
}

