/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.freehep.application.Application;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;

public class WindowMenu
extends JMenu {
    private int nOriginal = -1;
    private PageManager pm;

    @Override
    public void fireMenuSelected() {
        if (this.nOriginal < 0) {
            this.nOriginal = this.getMenuComponentCount();
        }
        MDIApplication app = (MDIApplication)Application.getApplication();
        this.pm = app.getPageManager();
        app.setSelectedPageManager(this.pm);
        int nn = 0;
        List<PageContext> pages = this.pm.pages();
        if (!pages.isEmpty()) {
            this.addSeparator();
        }
        for (PageContext context : pages) {
            WindowMenuItem item = new WindowMenuItem(context, nn);
            this.add(item);
            ++nn;
        }
        super.fireMenuSelected();
    }

    @Override
    protected void fireMenuDeselected() {
        int n;
        super.fireMenuDeselected();
        int i = n = this.getMenuComponentCount();
        while (i > this.nOriginal) {
            this.remove(--i);
        }
    }

    private class WindowMenuItem
    extends JMenuItem {
        private PageContext context;

        WindowMenuItem(PageContext context, int i) {
            super(i + " " + context.getTitle());
            this.context = context;
            this.setMnemonic(48 + (char)i);
            this.setIcon(context.getIcon());
        }

        @Override
        protected void fireActionPerformed(ActionEvent evt) {
            WindowMenu.this.pm.show(this.context);
        }
    }
}

