/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.util;

import jas.hist.HasSlices;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.SliceParameters;
import jas.hist.util.AbstractSlice;
import jas.hist.util.DefaultSliceParameters;
import jas.hist.util.ScatterAdapter;
import jas.hist.util.SliceAdapter;
import jas.hist.util.SliceEvent;
import jas.hist.util.SliceListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class TwoDSliceAdapter
extends ScatterAdapter
implements HasSlices,
SliceAdapter {
    protected Vector slices = new Vector();
    private EventListenerList listenerList = new EventListenerList();

    public TwoDSliceAdapter(Rebinnable2DHistogramData source) {
        super(source);
    }

    @Override
    public void addSliceListener(SliceListener l) {
        this.listenerList.add(SliceListener.class, l);
    }

    @Override
    public void removeSliceListener(SliceListener l) {
        this.listenerList.remove(SliceListener.class, l);
    }

    protected void fireSliceAdded(int index) {
        SliceEvent sliceEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SliceListener.class) continue;
            if (sliceEvent == null) {
                sliceEvent = new SliceEvent(this, SliceEvent.EventType.SLICEADDED, index);
            }
            ((SliceListener)listeners[i + 1]).sliceAdded(sliceEvent);
        }
    }

    protected void fireSliceRemoved(int index) {
        SliceEvent sliceEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SliceListener.class) continue;
            if (sliceEvent == null) {
                sliceEvent = new SliceEvent(this, SliceEvent.EventType.SLICEREMOVED, index);
            }
            ((SliceListener)listeners[i + 1]).sliceRemoved(sliceEvent);
        }
    }

    @Override
    public int getNSlices() {
        return this.slices.size();
    }

    @Override
    public SliceParameters getSliceParameters(int n) {
        return ((AbstractSlice)this.slices.elementAt(n)).getParameters();
    }

    @Override
    public Rebinnable1DHistogramData getSlice(int n) {
        return (Rebinnable1DHistogramData)this.slices.elementAt(n);
    }

    @Override
    public boolean canAddRemoveSlices() {
        return true;
    }

    @Override
    public int addSlice(double x, double y, double width, double height, double phi) {
        int n = this.slices.size();
        String title = (width == Double.POSITIVE_INFINITY ? "Projection " : "Slice ") + n;
        if (this.source.isRebinnable()) {
            this.slices.addElement(new RebinnableSlice(title, x, y, width, height, phi));
        } else {
            this.slices.addElement(new NonRebinnableSlice(title, x, y, width, height, phi));
        }
        this.fireSliceAdded(n);
        return n;
    }

    @Override
    public void removeSlice(int n) {
        this.fireSliceRemoved(n);
        this.slices.removeElementAt(n);
    }

    private class RebinnableSlice
    extends AbstractSlice {
        RebinnableSlice(String title, double x, double y, double width, double height, double phi) {
            super(title, width == Double.POSITIVE_INFINITY);
            this.parm = new DefaultSliceParameters(x, y, width, height, phi){

                @Override
                public void setPhi(double value) {
                    value += Math.PI * 2;
                    value = (value %= Math.PI) > 0.7853981633974483 && value < 2.356194490192345 ? 1.5707963267948966 : 0.0;
                    super.setPhi(value);
                }

                @Override
                protected void changed() {
                    RebinnableSlice.this.sendUpdate();
                }
            };
        }

        @Override
        public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
            if (this.parm.phi == 0.0) {
                double[][][] data = TwoDSliceAdapter.this.source.rebin(bins, min, max, 1, this.parm.y - this.parm.height, this.parm.y + this.parm.height, wantErrors, hurry, false);
                double[] hist = new double[bins];
                for (int i = 0; i < bins; ++i) {
                    hist[i] = data[0][i][0];
                }
                double[][] result = new double[][]{hist};
                return result;
            }
            double[][][] data = TwoDSliceAdapter.this.source.rebin(1, this.parm.x - this.parm.height, this.parm.x + this.parm.height, bins, min, max, wantErrors, hurry, false);
            return data[0];
        }

        @Override
        public double getMin() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMin() : TwoDSliceAdapter.this.source.getYMin();
            }
            return this.parm.phi == 0.0 ? this.parm.x - this.parm.width : this.parm.y - this.parm.width;
        }

        @Override
        public double getMax() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMax() : TwoDSliceAdapter.this.source.getYMax();
            }
            return this.parm.phi == 0.0 ? this.parm.x + this.parm.width : this.parm.y + this.parm.width;
        }

        @Override
        public int getBins() {
            return 40;
        }

        @Override
        public boolean isRebinnable() {
            return true;
        }
    }

    private class NonRebinnableSlice
    extends AbstractSlice {
        NonRebinnableSlice(String title, double x, double y, double width, double height, double phi) {
            super(title, width == Double.POSITIVE_INFINITY);
            this.parm = new DefaultSliceParameters(x, y, width, height, phi){

                @Override
                public void setPhi(double value) {
                    value += Math.PI * 2;
                    value = (value %= Math.PI) > 0.7853981633974483 && value < 2.356194490192345 ? 1.5707963267948966 : 0.0;
                    super.setPhi(value);
                }

                @Override
                public void setX(double value) {
                    double min = TwoDSliceAdapter.this.source.getXMin();
                    double max = TwoDSliceAdapter.this.source.getXMax();
                    int bins = TwoDSliceAdapter.this.source.getXBins();
                    int bin = Math.round((float)((double)bins * (value - min) / (max - min)));
                    super.setX(min + (double)bin * (max - min) / (double)bins);
                }

                @Override
                public void setY(double value) {
                    double min = TwoDSliceAdapter.this.source.getYMin();
                    double max = TwoDSliceAdapter.this.source.getYMax();
                    int bins = TwoDSliceAdapter.this.source.getYBins();
                    int bin = Math.round((float)((double)bins * (value - min) / (max - min)));
                    super.setY(min + (double)bin * (max - min) / (double)bins);
                }

                @Override
                public void setWidth(double value) {
                    int bins;
                    double max;
                    double min;
                    if (NonRebinnableSlice.this.parm.phi == 0.0) {
                        min = TwoDSliceAdapter.this.source.getXMin();
                        max = TwoDSliceAdapter.this.source.getXMax();
                        bins = TwoDSliceAdapter.this.source.getXBins();
                    } else {
                        min = TwoDSliceAdapter.this.source.getYMin();
                        max = TwoDSliceAdapter.this.source.getYMax();
                        bins = TwoDSliceAdapter.this.source.getYBins();
                    }
                    double binWidth = (max - min) / (double)bins;
                    int w = Math.round((float)(value / binWidth));
                    super.setWidth((double)w * binWidth);
                }

                @Override
                public void setHeight(double value) {
                    int bins;
                    double max;
                    double min;
                    if (NonRebinnableSlice.this.parm.phi == 0.0) {
                        min = TwoDSliceAdapter.this.source.getYMin();
                        max = TwoDSliceAdapter.this.source.getYMax();
                        bins = TwoDSliceAdapter.this.source.getYBins();
                    } else {
                        min = TwoDSliceAdapter.this.source.getXMin();
                        max = TwoDSliceAdapter.this.source.getXMax();
                        bins = TwoDSliceAdapter.this.source.getXBins();
                    }
                    double binWidth = (max - min) / (double)bins;
                    int w = Math.round((float)(value / binWidth));
                    super.setHeight((double)w * binWidth);
                }

                @Override
                protected void changed() {
                    NonRebinnableSlice.this.sendUpdate();
                }
            };
        }

        @Override
        public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
            int minXBin;
            double xmin = TwoDSliceAdapter.this.source.getXMin();
            double xmax = TwoDSliceAdapter.this.source.getXMax();
            double ymin = TwoDSliceAdapter.this.source.getYMin();
            double ymax = TwoDSliceAdapter.this.source.getYMax();
            int xbins = TwoDSliceAdapter.this.source.getXBins();
            int ybins = TwoDSliceAdapter.this.source.getYBins();
            double[][][] sresult = TwoDSliceAdapter.this.source.rebin(xbins, xmin, xmax, ybins, ymin, ymax, wantErrors, hurry, false);
            double[][] sdata = sresult[0];
            double[] hist = new double[bins];
            if (this.parm.phi == 0.0) {
                minXBin = Math.round((float)((min - xmin) * (double)xbins / (xmax - xmin)));
                int maxXBin = Math.round((float)((max - xmin) * (double)xbins / (xmax - xmin)));
                if (maxXBin - minXBin != bins) {
                    throw new RuntimeException("Failed sanity check");
                }
                int minYBin = Math.round((float)((this.parm.y - this.parm.height - ymin) * (double)ybins / (ymax - ymin)));
                int maxYBin = Math.round((float)((this.parm.y + this.parm.height - ymin) * (double)ybins / (ymax - ymin)));
                for (int i = Math.max(minXBin, 0); i < Math.min(maxXBin, xbins); ++i) {
                    for (int j = Math.max(minYBin, 0); j < Math.min(maxYBin, ybins); ++j) {
                        int n = i - minXBin;
                        hist[n] = hist[n] + sdata[i][j];
                    }
                }
            } else {
                minXBin = Math.round((float)((min - ymin) * (double)ybins / (ymax - ymin)));
                int maxXBin = Math.round((float)((max - ymin) * (double)ybins / (ymax - ymin)));
                if (maxXBin - minXBin != bins) {
                    throw new RuntimeException("Failed sanity check");
                }
                int minYBin = Math.round((float)((this.parm.x - this.parm.height - xmin) * (double)xbins / (xmax - xmin)));
                int maxYBin = Math.round((float)((this.parm.x + this.parm.height - xmin) * (double)xbins / (xmax - xmin)));
                for (int i = Math.max(minXBin, 0); i < Math.min(maxXBin, ybins); ++i) {
                    for (int j = Math.max(minYBin, 0); j < Math.min(maxYBin, xbins); ++j) {
                        int n = i - minXBin;
                        hist[n] = hist[n] + sdata[j][i];
                    }
                }
            }
            double[][] result = new double[][]{hist};
            return result;
        }

        @Override
        public double getMin() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMin() : TwoDSliceAdapter.this.source.getYMin();
            }
            return this.parm.phi == 0.0 ? this.parm.x - this.parm.width : this.parm.y - this.parm.width;
        }

        @Override
        public double getMax() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMax() : TwoDSliceAdapter.this.source.getYMax();
            }
            return this.parm.phi == 0.0 ? this.parm.x + this.parm.width : this.parm.y + this.parm.width;
        }

        @Override
        public int getBins() {
            double min = this.getMin();
            double max = this.getMax();
            double binWidth = this.parm.phi == 0.0 ? (TwoDSliceAdapter.this.source.getXMax() - TwoDSliceAdapter.this.source.getXMin()) / (double)TwoDSliceAdapter.this.source.getXBins() : (TwoDSliceAdapter.this.source.getYMax() - TwoDSliceAdapter.this.source.getYMin()) / (double)TwoDSliceAdapter.this.source.getYBins();
            return Math.round((float)((max - min) / binWidth));
        }

        @Override
        public boolean isRebinnable() {
            return false;
        }
    }
}

