/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.data.MonMainState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class MonMainPanel
extends JPanel {
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private int nSubsys;
    private String[] name;
    private double[] period;
    private JLabel[] lblStateValue;
    private JTextField[] tfPeriod;
    private static final long serialVersionUID = 1L;

    public MonMainPanel(CommandSender gui) {
        this.gui = gui;
    }

    public void setSubsystems(String[] names) {
        if (this.nSubsys != names.length) {
            this.nSubsys = names.length;
            this.name = new String[this.nSubsys];
            System.arraycopy(names, 0, this.name, 0, this.nSubsys);
            this.period = new double[this.nSubsys];
            this.lblStateValue = new JLabel[this.nSubsys];
            this.tfPeriod = new JTextField[this.nSubsys];
        }
        this.initComponents();
        for (int j = 0; j < this.nSubsys; ++j) {
            new UpdateStatus(j, new MonMainState(0)).run();
            new DisableSystem(j).run();
        }
    }

    private void initComponents() {
        int j;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridx = 0;
        gc.gridy = 0;
        Dimension dimState = new Dimension(0, 0);
        JLabel[] lblState = new JLabel[this.nSubsys];
        for (j = 0; j < this.nSubsys; ++j) {
            JPanel pnlSubsys = new JPanel();
            JPanel pnlState = new JPanel();
            JPanel pnlPeriod = new JPanel();
            JLabel label = new JLabel(this.name[j] + " state: ");
            Dimension ds = label.getPreferredSize();
            dimState.height = ds.height;
            dimState.width = Math.max(dimState.width, ds.width);
            lblState[j] = label;
            pnlState.add(label);
            label = new JLabel("...");
            Dimension dsv = label.getPreferredSize();
            dsv.width = 70;
            label.setPreferredSize(dsv);
            label.setMinimumSize(dsv);
            this.lblStateValue[j] = label;
            pnlState.add(label);
            pnlPeriod.add(new JLabel("Update Period: "));
            JTextField textf = new JTextField();
            Dimension dp = textf.getPreferredSize();
            dp.width = 50;
            textf.setHorizontalAlignment(0);
            textf.setMinimumSize(dp);
            textf.setPreferredSize(dp);
            textf.setName(String.valueOf(j));
            textf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MonMainPanel.this.tfPeriodAction(evt);
                }
            });
            this.tfPeriod[j] = textf;
            pnlPeriod.add(textf);
            pnlPeriod.add(new JLabel("secs"));
            pnlSubsys.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.gridx = 0;
            pnlSubsys.add((Component)pnlState, gbc);
            gbc.anchor = 13;
            gbc.gridx = 1;
            pnlSubsys.add((Component)pnlPeriod, gbc);
            this.add((Component)pnlSubsys, gc);
            ++gc.gridy;
        }
        for (j = 0; j < this.nSubsys; ++j) {
            lblState[j].setPreferredSize(dimState);
            lblState[j].setMinimumSize(dimState);
        }
    }

    private void tfPeriodAction(ActionEvent evt) {
        int id = Integer.valueOf(((JTextField)evt.getSource()).getName());
        try {
            double value = Double.valueOf(this.tfPeriod[id].getText());
            this.gui.sendCommand(this.name[id], null, "setTickMillis", (int)(1000.0 * value));
            this.tfPeriod[id].setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfPeriod[id].setText(String.valueOf(this.period[id]));
        }
    }

    public void updateControlPanel(int id, MonMainState ms) {
        SwingUtilities.invokeLater(new UpdateStatus(id, ms));
    }

    public void disableSystem(int id) {
        SwingUtilities.invokeLater(new DisableSystem(id));
    }

    private class DisableSystem
    implements Runnable {
        private final int id;

        DisableSystem(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            MonMainPanel.this.lblStateValue[this.id].setText("STOPPED");
            MonMainPanel.this.lblStateValue[this.id].setForeground(RED);
            MonMainPanel.this.tfPeriod[this.id].setEnabled(false);
        }
    }

    private class UpdateStatus
    implements Runnable {
        private final int id;
        private final MonMainState ms;

        UpdateStatus(int id, MonMainState ms) {
            this.id = id;
            this.ms = ms;
        }

        @Override
        public void run() {
            MonMainPanel.this.lblStateValue[this.id].setText("RUNNING");
            MonMainPanel.this.lblStateValue[this.id].setForeground(GREEN);
            ((MonMainPanel)MonMainPanel.this).period[this.id] = (double)this.ms.getTickMillis() / 1000.0;
            MonMainPanel.this.tfPeriod[this.id].setEnabled(true);
            MonMainPanel.this.tfPeriod[this.id].setText(String.valueOf(MonMainPanel.this.period[this.id]));
        }
    }
}

