package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;

/**
 * A default implementation of LimitsInterface, used inside transition algorithm
 * and for testing.
 *
 * @author tonyj
 */
public class Limits implements LimitsInterface {

    private double alarmHigh;
    private double alarmLow;
    private double warnLow;
    private double warnHigh;

    public Limits(List<Double> limits) {
        this.alarmLow = limits.get(0);
        this.warnLow = limits.get(1);
        this.warnHigh = limits.get(2);
        this.alarmHigh = limits.get(3);        
        if (alarmLow > warnLow || warnLow >= warnHigh || warnHigh > alarmHigh || alarmHigh < warnHigh) {
            throw new IllegalArgumentException("Limit values are invalid: " + limits);
        }
    }

    public Limits(LimitsInterface limits) {
        this.alarmHigh = limits.getAlarmHigh();
        this.alarmLow = limits.getAlarmLow();
        this.warnLow = limits.getWarnLow();
        this.warnHigh = limits.getWarnHigh();
    }

    @Override
    public void setLimits(double alarmLow, double warnLow, double warnHigh, double alarmHigh) {
        this.alarmLow = alarmLow;
        this.warnLow = warnLow;
        this.warnHigh = warnHigh;
        this.alarmHigh = alarmHigh;
    }

    @Override
    public double getAlarmHigh() {
        return alarmHigh;
    }

    @Override
    public double getAlarmLow() {
        return alarmLow;
    }

    @Override
    public double getWarnLow() {
        return warnLow;
    }

    @Override
    public double getWarnHigh() {
        return warnHigh;
    }


    @Override
    public String toString() {
        return String.format("Limits{alarmHigh=%5.5g, alarmLow=%5.5g, warnLow=%5.5g, warnHigh=%5.5g}", alarmHigh, alarmLow, warnHigh, warnLow);
    }
}
