package org.lsst.ccs.subsystem.teststand;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.Agent;

//import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;

import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;

import org.lsst.ccs.subsystem.teststand.data.TSConfig;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.BusMessageFilterFactory;

/**
 ***************************************************************************
 **
 ** Contains the state of the test stand 3 system * * @author Homer Neal *
 * **************************************************************************
 */
public class TSConfigCatcher implements Serializable, AgentPresenceListener,
        StatusMessageListener {

    private static TSConfig tsc = null;
    private AgentMessagingLayer agentMessagingLayer = null;
    private static final Logger LOGGER = Logger.getLogger("org.lsst.ccs.subsystem.teststand.main");
    private static String DEST = "ts";
//    private BusMessageFilter filterConfig;
    private ConcurrentMessagingUtils cmu;

    public TSConfigCatcher() {
    }

    public TSConfigCatcher(TSConfig tsc) {
        this.tsc = tsc;
    }

    public void initCatcher(ConfigurationInfo configInfo) {
        agentMessagingLayer = Agent.getEnvironmentMessagingAccess();
        cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
//        filterConfig = BusMessageFilter.messageOrigin(DEST).and(BusMessageFilter.messageClass(StatusConfigurationInfo.class));
        agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener(this);
        Predicate<BusMessage<? extends Serializable, ?>> filter = 
            BusMessageFilterFactory.messageOrigin(DEST).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        agentMessagingLayer.addStatusMessageListener(this,filter);

        // assume that the initial configuration parameters are already available
        // ==> connect
        updateConfig(configInfo);
        /*
         try {
         Future<Object> future = cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
         ConfigurationInfo configInfo = (ConfigurationInfo) future.get();
         updateConfig(configInfo);
         } catch (Exception ex) {
         LOGGER.warn("unable to retrieve configuration information", ex);
         }
         */
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        /*
         Object msgObject = msg.getObject();
         System.out.println("msg type = "+msgObject.toString());
         if (msgObject instanceof KeyValueData) {
         KeyValueData d = (KeyValueData) msgObject;
         System.out.println("TSConfigCatcher: In onStatusMessage method. KEY=" + d.getKey());
         */
        if (msg == null) {
            return;
        }

        ConfigurationInfo configInfo = null;
//        System.out.println("TSConfigCatcher msg text = "+msg.toString());
//        System.out.println("Now getting object");
        if (msg.getObject() instanceof ConfigurationInfo) {
            configInfo = (ConfigurationInfo) msg.getObject();
        } else {
            return;
        }
        updateConfig(configInfo);

    }

    public void updateConfig(ConfigurationInfo configInfo) {
//        System.out.println("update config for " + configInfo.getConfigurationName());

        List<ConfigurationParameterInfo> listChanges = configInfo.getLatestChanges();

        for (String componentName : TSConfig.COMPONENT_NAMES) {
            Map<String, String> configForComponent = configInfo.getCurrentValuesFor(componentName);
            if (!configForComponent.isEmpty()) {
//                LOGGER.info("TSConfigCatcher: " + componentName + " config Map: " + configForComponent.toString());

                int istate = TSConfig.operating_states.valueOf(componentName).ordinal();
                double biasVAcq, cryoTAcq, cryoTAcqTol, minLmpPwr, vacPAcq, lambdaAcq;
//                System.out.println("getting biasVAcq");
                biasVAcq = Double.valueOf(configForComponent.get("bias"));
//                System.out.println("getting cryoTAcq");
                cryoTAcq = Double.valueOf(configForComponent.get("cryo"));
//                System.out.println("getting cryoTAcqTol");
                cryoTAcqTol = Double.valueOf(configForComponent.get("cryotol"));
//                System.out.println("getting minLmpPwr");
                minLmpPwr = Double.valueOf(configForComponent.get("minlmppwr"));
//                System.out.println("getting vacPAcq");
                vacPAcq = Double.valueOf(configForComponent.get("vac"));
//                System.out.println("getting lambdaAcq");
                lambdaAcq = Double.valueOf(configForComponent.get("lambda"));
//                System.out.println("updating local TS Config");
                tsc.update(istate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
            }
        }
        String componentName = "TSCFG";
        Map<String, String> configForComponent = configInfo.getCurrentValuesFor(componentName);
        if (!configForComponent.isEmpty()) {
//            System.out.println("TSConfigCatcher: TSCFG config Map: " + configForComponent.toString());
            double[] filter_edges = new double[6];
            String[] filter_names = new String[6];
            for (int i = 0; i < 6; i++) {
                filter_edges[i] = Double.valueOf(configForComponent.get("filteredge"+(i+1)));
                filter_names[i] = configForComponent.get("filter"+(i+1));
            }
            tsc.setFilter_edges(filter_edges);
            tsc.setFilter_names(filter_names);
            tsc.setBiastype(configForComponent.get("biastype"));
            tsc.setPdtype(configForComponent.get("pdtype"));
            tsc.setSrctype(configForComponent.get("srctype"));
            tsc.setMonotype(configForComponent.get("monotype"));
        }
    }

    public void connecting(AgentInfo agent) {
        System.out.println("Agent name = " + agent.getName());
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");

        if (!agent.getName().equals(DEST)) {
            return;
        }
        LOGGER.info("connecting");
        Future<Object> future = cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            ConfigurationInfo configInfo = (ConfigurationInfo) future.get();
            updateConfig(configInfo);
            DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
            Predicate<BusMessage<? extends Serializable, ?>> filter = 
                    BusMessageFilterFactory.messageOrigin(DEST).and(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class));
            agentMessagingLayer.addStatusMessageListener(this, filter);
        } catch (Exception ex) {
            LOGGER.warn("unable to retrieve configuration information", ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
        System.out.println("Agent name = " + agent.getName());
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");

        if (!agent.getName().equals(DEST)) {
            return;
        }
        LOGGER.info("disconnecting");
        Future<Object> future = cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
            agentMessagingLayer.removeStatusMessageListener(this);
        } catch (Exception ex) {
            LOGGER.warn("failed to stop listening", ex);
        }
    }

}
