package org.lsst.ccs.subsystem.teststand;
//import hep.aida.*;
import hep.aida.IDataPointSetFactory;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Defines a bias power supply interface.
 *
 *  @author Homer Neal
 */

public interface BiasDevice {

    boolean isOnline();
    
    double getRunBias(int cfgstate);
    
    void setRunBias(double runBias, int cfgstate);
    
    void setVoltage(double value) throws DriverException;
    
    void setVoltageAcq(int cfgstate) throws DriverException;
    
    void setVoltageRange(double value) throws DriverException;

    void rampVolts(double duration, double value) throws DriverException;

    void rampVolts(double duration, double value, int nsteps) throws DriverException;

    void setCurrentRange(double value) throws DriverException;

    void setOutput(int value) throws DriverException;

    boolean showOutput() throws DriverException;

    double readVoltage();

    double getLastVoltage();

    double readCurrent();

    double getLastCurrent();

    void reset();

    void softReset();

    void setAbort(boolean astate);

    void setDPSF(IDataPointSetFactory dpsf);

    void setCfg(TSConfig cfg);

    int getState();

    void setState(int state);

    void setCurrentLimit(double curlim) throws DriverException;

    String getCurrentLimit() throws DriverException;
    
    void setTimeout(double nsec);
    
    void setAvgOn(boolean doAvg) throws DriverException;
    
    String getAvgState() throws DriverException;
    
    void setNAvg(int nAvg) throws DriverException;

}

