/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.orielshutter.OrielShutter;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.ShutterDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class OrielShutterDevice
extends Device
implements ShutterDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private OrielShutter oshut = null;
    private boolean isconnected = false;
    private int openshut = -1;
    TSConfig cfg = new TSConfig();
    private String outname = "";
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;

    public OrielShutterDevice(String host, int port, int addr) throws DriverException {
        this.isconnected = true;
        try {
            this.oshut = new OrielShutter();
            if (this.oshut != null) {
                this.oshut.openSerial(host, port, addr);
            }
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to Oriel Shutter device!");
            this.isconnected = false;
        }
    }

    public OrielShutterDevice() {
        this.oshut = new OrielShutter();
    }

    protected void initDevice() {
        this.fullName = "Oriel Shutter module";
    }

    protected void close() {
        try {
            if (this.oshut != null) {
                this.oshut.close();
            }
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"Oriel Shutter device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"Oriel Shutter device is already initialized and connected to:");
            try {
                this.log.debug((Object)this.oshut.getIdent());
            }
            catch (Exception e) {
                if (!this.failedToInitialize) {
                    this.log.error((Object)"Oriel Shutter device failed to respond to ident request! The initialization has FAILED.");
                    this.failedToInitialize = true;
                }
                this.isconnected = false;
            }
            this.log.debug((Object)"Setting device online.");
            this.kstate = TSState.pwrstates.OK;
            this.setOnline(true);
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected LED device!");
            this.failedToInitialize = true;
        }
    }

    @Override
    @Command(name="openShutter", description="open shutter")
    public void openShutter() {
        try {
            if (this.oshut != null) {
                this.oshut.openShutter();
                this.openshut = 1;
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the Oriel Shutter");
        }
    }

    @Override
    @Command(name="closeShutter", description="close shutter")
    public void closeShutter() {
        try {
            if (this.oshut != null) {
                this.oshut.closeShutter();
                this.openshut = 0;
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the Oriel Shutter");
        }
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 3) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type == 3) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    @Command(name="reset", description="reset trips etc...")
    public void reset() throws DriverException {
        if (this.oshut != null) {
            this.oshut.reset();
        }
        this.kstate = TSState.pwrstates.OFF;
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("Oriel ShutterDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            if (type == 3) {
                value = this.openshut;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Command(name="setState", description="set Oriel Shutter device status")
    public void setState(int istate) {
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Command(name="getState", description="get Oriel Shutter device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    static {
        typeMap.put("OPENSHUT", 3);
    }
}

