package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;

/**
 * A base class for all limit algorithms.
 * @author tonyj
 */
public abstract class LimitAlgorithm {

    private LimitsInterface targetLimits, initialLimits;
    private double targetValue, initialValue;

    /**
     * Initialize the algorithm
     * @param parameters The algorithm specific limit parameters
     * @param initialValue The initial value
     * @param initialLimits The initial limits interface, used for setting limits
     * @param targetValue The target value for the algorithm. Some algorithms use this
     * for computing the limits (e.g. DeltaLimitAlgorithm).
     * @param targetLimits The limits at target.
     */
    public void init(List<Double> parameters, double initialValue, LimitsInterface initialLimits, double targetValue, LimitsInterface targetLimits) {
        this.initialLimits = initialLimits;
        this.targetValue = targetValue;
        this.targetLimits = targetLimits;
        this.initialValue = initialValue;        
    }

    public LimitsInterface getInitialLimits() {
        return initialLimits;
    }
    
    public LimitsInterface getTargetLimits() {
        return targetLimits;
    }

    public double getTargetValue() {
        return targetValue;
    }

    public double getInitialValue() {
        return initialValue;
    }
    
    /**
     * Optional method which adjust the limits relative to the current value of the item
     * being monitored.
     * @param currentValue 
     */
    public abstract void adjust(double currentValue, LimitsInterface limits);

}