package org.lsst.ccs.subsystem.teststand.limits;

import java.util.HashMap;
import java.util.Map;

public class AlgorithmFactory {

    static final Map<String, Class<? extends LimitAlgorithm>> limitRegistry = new HashMap<>();
    static final Map<String, Class<? extends TransitionAlgorithm>> transitionRegistry = new HashMap<>();

    static {
        limitRegistry.put("DELTA", DeltaLimitAlgorithm.class);
        limitRegistry.put("PROPORTIONAL", ProportionalLimitAlgorithm.class);

        transitionRegistry.put("RATCHET", RatchetTransitionAlgorithm.class);
    }

    public static LimitAlgorithm createLimitAlgorithm(String name) {
        try {
            final Class<? extends LimitAlgorithm> algorithmClass = limitRegistry.get(name);
            if (algorithmClass == null) {
                throw new RuntimeException("Unregistered limit algorithm: " + name);
            }
            return algorithmClass.newInstance();
        } catch (InstantiationException | IllegalAccessException ex) {
            throw new RuntimeException("Unable to create limit algorithm: " + name, ex);
        }
    }

    public static TransitionAlgorithm createTransitionAlgorithm(String name) {
        try {
            final Class<? extends TransitionAlgorithm> algorithmClass = transitionRegistry.get(name);
            if (algorithmClass == null) {
                throw new RuntimeException("Unregistered transition algorithm: " + name);
            }
            return algorithmClass.newInstance();
        } catch (InstantiationException | IllegalAccessException ex) {
            throw new RuntimeException("Unable to create transition algorithm: " + name, ex);
        }
    }
}
