package org.lsst.ccs.subsystem.teststand;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 ******************************************************************************
 **
 **  Defines a monochromator device interface.
 **
 **  @author Homer Neal
 **
 ******************************************************************************
 */
public interface MonochromatorDevice {

    void open(String host) throws DriverException ;

    void abort() throws DriverException ;

    double getBandpass() throws DriverException ;

    void setBandpass(double bandpass) throws DriverException ;

    void setCalibrate(double val) throws DriverException ;

    String getError() throws DriverException ;

    int getFilter() throws DriverException ;

    void setFilter(int pos) throws DriverException ;

    String getFilterLabel(int filter) ;

    void setFilterLabel(int filter, String label);

    void setFilterLabels(String[] label);
    
    void setFilterEdges(double[] edges);
    
    String getGrating() throws DriverException ;

    void setGrating(int param) throws DriverException ;

    String getGratingLabel(int grat) throws DriverException ;

    void setGratingLabel(int param, String label) throws DriverException ;

    int getGratingLines(int grat) throws DriverException ;

    void setGratingLines(int grat, int param) throws DriverException ;

    double getGratingFactor(int grat) throws DriverException ;

    void setGratingFactor(int grat, double param) throws DriverException ;

    double getGratingOffset(int grat) throws DriverException ;

    void setGratingOffset(int grat, double param) throws DriverException ;

    String getHandshake() throws DriverException ;

    void setHandshake(int flag) throws DriverException ;

    String getInfo() throws DriverException ;

    void setOutport(int num) throws DriverException ;

    String getShutter() throws DriverException ;

    void openShutter() throws DriverException ;

    void closeShutter() throws DriverException ;

    boolean isShutterOpen() throws DriverException ;

    void setShutter(String param) throws DriverException ;

    void setSlitSize(int slit, int microns) throws DriverException ;

    int getSlitSize(int slit) throws DriverException ;

    double getLastwl() throws DriverException ;
    int getLastfltpos() throws DriverException ;
    int getLastSW1() throws DriverException ;
    int getLastSW2() throws DriverException ;
    int getLastshut() throws DriverException ;

    int getErrorCondition() throws DriverException ;

    int getStep() throws DriverException ;

    void advanceSteps(int param) throws DriverException ;

    String getUnits() throws DriverException ;

    void setUnits(String param) throws DriverException ;

    double getWave() throws DriverException ;

    void setWave(double param) throws DriverException ;
    
    double setWaveAndFilter(double param) throws DriverException ;
    
    void setRunWave(double wl);
    
    double getRunWave();

}
