/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.power.distribution.APC7900Device;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84Device;
import org.lsst.ccs.subsystem.common.devices.vacuum.VQMDevice;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.UPSMonitor;
import org.lsst.ccs.subsystem.teststand.alerts.TS7Alerts;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.lsst.ccs.utilities.logging.Logger;

public class TS7
extends Subsystem
implements HasLifecycle,
AlertListener {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    CryoDevice cryoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VQMDevice vqmDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, APC7900Device> pduDevicesMap = new HashMap<String, APC7900Device>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AP9630UPSDevice upsDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService als;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TwisTorr84Device turbo;
    private final Logger LOGGER = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private TransitionAlgorithm vacuumTransitionAlgorithm;
    private TransitionAlgorithm coldTransitionAlgorithm1;
    private TransitionAlgorithm coldTransitionAlgorithm2;
    private TransitionAlgorithm cryoTransitionAlgorithm;
    private volatile boolean alertResponseEnabled = false;
    private UPSMonitor upsMon;

    public TS7() {
        super("ccfcs", AgentInfo.AgentType.WORKER);
    }

    public void init() {
        this.als.registerAlert(TS7Alerts.UPS_DISCONNECTED.getAlert());
        this.als.registerAlert(TS7Alerts.UPS_ON_BATTERY.getAlert());
        this.als.addListener((AlertListener)this);
    }

    public void postInit() {
        if (this.cryoDevc == null) {
            this.LOGGER.warning((Object)"Cryo device not defined");
        }
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS7.class.getCanonicalName());
        this.upsMon = new UPSMonitor(this, this.upsDevc, this.LOGGER, this.pts, this.als);
    }

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("ups-timer", () -> this.upsMon.monitorUPS()).withPeriod(Duration.ofSeconds(1L)));
    }

    public void onAlert(AlertEvent event) {
        Alert raisedAlert = event.getAlert();
        String alertId = raisedAlert.getAlertId();
        if (alertId.equals(TS7Alerts.PRESSURE_TOO_HIGH.getAlert().getAlertId())) {
            if (event.getLevel() == AlertState.ALARM) {
                try {
                    this.turnOutletOff(TS7Outlets.VACUUMVALVE);
                    this.LOGGER.info((Object)("Shutting (Turning off) vacuum valve " + TS7Outlets.VACUUMVALVE.getOutletName()));
                }
                catch (DriverException de) {
                    this.LOGGER.severe((Object)("Failed to turn off VACUUMVALVE outlet -- manual intervention needed" + de));
                }
                Thread t = new Thread(new VacuumAlarmResponse());
                t.start();
            }
        } else if (!alertId.equals(TS7Alerts.PRESSURE_TOO_LOW.getAlert().getAlertId())) {
            if (alertId.equals(TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_LOW.getAlert().getAlertId())) {
                if (event.getLevel() == AlertState.ALARM) {
                    this.LOGGER.info((Object)"COLD_PLATE_TEMPERATURE_TOO_LOW: Turn off Polycold chillers...");
                    Thread t = new Thread(new ColdPlateAlarmLowResponse());
                    t.start();
                }
            } else if (alertId.equals(TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_LOW.getAlert().getAlertId())) {
                if (event.getLevel() == AlertState.ALARM) {
                    this.LOGGER.info((Object)"CRYO_PLATE_TEMPERATURE_TOO_LOW: Turn off Polycold chiller...");
                    Thread t = new Thread(new CryoPlateAlarmLowResponse());
                    t.start();
                }
            } else if (alertId.equals(TS7Alerts.COLD_PLATE_TEMPERATURE_TOO_HIGH.getAlert().getAlertId())) {
                if (event.getLevel() == AlertState.ALARM) {
                    this.LOGGER.info((Object)"COLD_PLATE_TEMPERATURE_TOO_HIGH: Turning off heat sources");
                    if (this.isAlertResponseEnabled()) {
                        try {
                            this.LOGGER.info((Object)("Turning off REB 48V power supply outlet: " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                            this.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                        }
                        catch (DriverException e) {
                            this.LOGGER.error((Object)("Error powering off REB power supply: " + e));
                        }
                    } else {
                        this.LOGGER.info((Object)"Powering off REB power supply was disabled");
                    }
                    this.LOGGER.info((Object)"COLD_PLATE_TEMPERATURE_TOO_HIGH: Alert response initiated");
                }
            } else if (alertId.equals(TS7Alerts.CRYO_PLATE_TEMPERATURE_TOO_HIGH.getAlert().getAlertId())) {
                if (event.getLevel() == AlertState.ALARM) {
                    this.LOGGER.info((Object)"CRYO_PLATE_TEMPERATURE_TOO_HIGH: Turning off heat sources");
                    if (this.isAlertResponseEnabled()) {
                        try {
                            this.LOGGER.info((Object)("Turning off REB 48V power supply outlet: " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                            this.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                        }
                        catch (DriverException e) {
                            this.LOGGER.error((Object)("Error powering off REB power supply: " + e));
                        }
                    } else {
                        this.LOGGER.info((Object)"Powering off REB power supply was disabled");
                    }
                    this.LOGGER.info((Object)"CRYO_PLATE_TEMPERATURE_TOO_HIGH: Turn off REB PS if powerState is not OFF, verify Cryo OTP is enabled");
                }
            } else if (alertId.equals(TS7Alerts.TURBO_PUMP_FAIL.getAlert().getAlertId())) {
                if (event.getLevel() == AlertState.ALARM) {
                    String extraInfo;
                    try {
                        extraInfo = "\n " + this.turbo.readTurboFailCode();
                    }
                    catch (DriverException e) {
                        extraInfo = "\n Exception reading Turbo error code: " + e;
                    }
                    this.LOGGER.info((Object)extraInfo);
                }
            } else if (alertId.equals(TS7Alerts.TURBO_PUMP_SLOW.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                String extraInfo;
                try {
                    extraInfo = "\n New Turbo status = " + this.turbo.readTurboStatus();
                }
                catch (DriverException e) {
                    extraInfo = "\n Exception reading Turbo status: " + e;
                }
                this.LOGGER.info((Object)extraInfo);
            }
        }
    }

    private static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Could not sleep", ie);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU names")
    public List<String> getPduNames() {
        return new ArrayList<String>(this.pduDevicesMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            for (String outletName : this.pduDevicesMap.get(pduName).getOutletNames()) {
                names.add(pduName + "/" + outletName);
            }
        }
        return names;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the map of PDU outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        HashMap<String, Boolean> states = new HashMap<String, Boolean>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            Map pduStates = this.pduDevicesMap.get(pduName).getOutletOnStateMap();
            for (String outletName : pduStates.keySet()) {
                states.put(pduName + "/" + outletName, (Boolean)pduStates.get(outletName));
            }
        }
        return states;
    }

    @Command(type=Command.CommandType.ACTION, description="Turn Off named outlet")
    public void turnOutletOff(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, false);
    }

    @Command(type=Command.CommandType.ACTION, description="Turn On named outlet")
    public void turnOutletOn(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, true);
    }

    private void changeOutletState(TS7Outlets outlet, boolean on) throws DriverException {
        String outletName = outlet.getOutletName();
        for (APC7900Device pdu : this.pduDevicesMap.values()) {
            if (!pdu.getOutletNames().contains(outletName)) continue;
            if (on) {
                pdu.forceOutletOn(outletName);
            } else {
                pdu.forceOutletOff(outletName);
            }
            return;
        }
        throw new IllegalArgumentException("Could not find device to turn off outlet " + outletName);
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }

    class VacuumAlarmResponse
    implements Runnable {
        VacuumAlarmResponse() {
        }

        @Override
        public void run() {
            try {
                TS7.this.LOGGER.info((Object)("Turning off cold plate refrigerator 1 " + TS7Outlets.COLDPLATEREFRIGERATOR_1.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_1);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cold plate refrigerator 1 was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off ColdPlateRefrigerator_1 outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off cold plate refrigerator 2 " + TS7Outlets.COLDPLATEREFRIGERATOR_2.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_2);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cold plate refrigerator 2 was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off ColdPlateRefrigerator_2 outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off cryo plate refrigerator " + TS7Outlets.CRYOPLATEREFRIGERATOR.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cryo plate refrigerator was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off CryoPlateRefrigerator outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off turbo pump " + TS7Outlets.TURBOPUMP.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.TURBOPUMP);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the turbo pump was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off Turbo Pump outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off roughing pump " + TS7Outlets.ROUGHINGPUMP.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.ROUGHINGPUMP);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the roughing pump was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off Roughing Pump outlet -- manual intervention needed");
            }
            try {
                TS7.this.LOGGER.info((Object)("Turning off reb power supply " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the reb power supply was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off REB 48V supply outlet -- manual intervention needed");
            }
        }
    }

    class ColdPlateAlarmLowResponse
    implements Runnable {
        ColdPlateAlarmLowResponse() {
        }

        @Override
        public void run() {
            try {
                TS7.this.LOGGER.info((Object)("Turning off cold plate refrigerator 1 " + TS7Outlets.COLDPLATEREFRIGERATOR_1.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_1);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cold plate refrigerator 1 was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off ColdPlateRefrigerator_1 outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off cold plate refrigerator 2 " + TS7Outlets.COLDPLATEREFRIGERATOR_2.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_2);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cold plate refrigerator 2 was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off ColdPlateRefrigerator_2 outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off cryo plate refrigerator " + TS7Outlets.CRYOPLATEREFRIGERATOR.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cryo plate refrigerator was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off CryoPlateRefrigerator outlet -- manual intervention needed");
            }
            TS7.sleep(2000L);
            try {
                TS7.this.LOGGER.info((Object)("Turning off reb power supply " + TS7Outlets.REB48VOLTPOWERSUPPLY.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the reb power supply was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)"Failed to turn off REB 48V supply outlet -- manual intervention needed");
            }
        }
    }

    class CryoPlateAlarmLowResponse
    implements Runnable {
        CryoPlateAlarmLowResponse() {
        }

        @Override
        public void run() {
            try {
                TS7.this.LOGGER.info((Object)("Turning off cryo plate refrigerator " + TS7Outlets.CRYOPLATEREFRIGERATOR.getOutletName()));
                if (TS7.this.isAlertResponseEnabled()) {
                    TS7.this.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                } else {
                    TS7.this.LOGGER.info((Object)"The action of turning off the cryo plate refrigerator was disabled");
                }
            }
            catch (DriverException e) {
                TS7.this.LOGGER.severe((Object)("Failed to turn off CryoPlateRefrigerator outlet -- manual intervention needed" + e));
            }
            TS7.sleep(2000L);
        }
    }
}

