/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pfeiffer;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.TPG361;

public class TestTPG361
extends TestAscii {
    private final String[] readStat = new String[]{"OK", "Under range", "Over range", "Sensor error", "Sensor off", "No sensor", "ID error"};
    private final TPG361 mydev = (TPG361)this.dev;

    public TestTPG361() {
        super(new TPG361());
    }

    @Command(name="getdeviceinfo", description="Get info about the device")
    public String getDeviceInfo() throws DriverException {
        String[] info = this.mydev.getDeviceInfo();
        return String.format("Type:        %s\nModel:       %s\nSerial:      %s\nHW version:  %s\nFW version:  %s", info[0], info[1], info[2], info[4], info[3]);
    }

    @Command(name="getgaugeid", description="Get ID of the vacuum gauge")
    public String getGaugeID() throws DriverException {
        return this.mydev.getGaugeID();
    }

    @Command(name="setunit", description="Set the pressure unit")
    public void setUnit(@Argument(description="The unit") TPG361.Unit unit) throws DriverException {
        this.mydev.setUnit(unit);
    }

    @Command(name="getunit", description="Get the pressure unit")
    public TPG361.Unit getUnit() throws DriverException {
        return this.mydev.getUnit();
    }

    @Command(name="geterror", description="Get the error status")
    public String getError() throws DriverException {
        return this.mydev.getError();
    }

    @Command(name="gaugeon", description="Turn the vacuum gauge on")
    public void gaugeOn() throws DriverException {
        this.mydev.gaugeOn();
    }

    @Command(name="gaugeoff", description="Turn the vacuum gauge off")
    public void gaugeOff() throws DriverException {
        this.mydev.gaugeOff();
    }

    @Command(name="getgaugestatus", description="Get status of the vacuum gauge")
    public TPG361.GaugeStatus getGaugeStatus() throws DriverException {
        return this.mydev.getGaugeStatus();
    }

    @Command(name="readpressure", description="Read pressure ")
    public String readPressure() throws DriverException {
        double[] press = this.mydev.readPressure();
        return String.format("%s (%s)", press[0], this.readStat[(int)press[1]]);
    }

    @Command(name="readtemperature", description="Read the temperature")
    public double readTemperature() throws DriverException {
        return this.mydev.readTemperature();
    }

    @Command(name="gethours", description="Get the operating hours")
    public int getHours() throws DriverException {
        return this.mydev.getOperatingHours();
    }

    @Command(name="writecommand", description="Write a command")
    public void writeCommand(@Argument(description="The commmand to send") String command) throws DriverException {
        this.mydev.writeCommand(command);
    }

    @Command(name="readresponse", description="Read a response")
    public String readResponse() throws DriverException {
        return this.mydev.readResponse();
    }

    @Command(name="readstring", description="Write a command and read response")
    public String readString(@Argument(description="The commmand to send") String command) throws DriverException {
        return this.mydev.readString(command);
    }
}

