package org.lsst.ccs.subsystem.teststand;

/**
 ******************************************************************************
 **
 **  Defines a vacuum device interface.
 **
 **  @author Homer Neal
 **
 ******************************************************************************
 */
public interface VacuumGaugeDevice {

    double  readPressure();
    
    double  getLastPres();
        
    boolean isVacuumGaugeOn();
    
    void    setGaugeOn();
    
    void    setGaugeOff();

    void    setRunVac(double vac, int cfgstate);
    
    double  getRunVac(int cfgstate);

    int     getState();
    
    void    setState(int istate);
    
}
