package org.lsst.ccs.subsystem.teststand;

import java.util.Map;
import java.util.HashMap;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

/**
 * 
 * Device class for the Cryogenic Temperature Controller 24C driver
 * 
 * @author Heather Kelly / Homer Neal
 ** 
 */
public class CryoCon24cSimDevice extends CryoCon24cDevice implements CryoDevice {

    private final static Map<String,Integer> typeMap = new HashMap<>();
    static {
        typeMap.put("TEMP",   Channel.TYPE_TEMP);
        typeMap.put("VOLTS",  Channel.TYPE_VOLTS);
        typeMap.put("PA", Channel.TYPE_UNKNOWN);
    }
    
    TSConfig cfg = new TSConfig();

    private double RUN_TEMP[] = new double[cfg.MAXSTATES];
    private double IDLE_TEMP = 20.;
    private double simsettmp = .0 ;
    private double[] simData = new double[CryoCon24cDevice.NUM_CHANS] ;

    private String host;

//    private M24C tempDev;

    public CryoCon24cSimDevice() {
     }
    
    /**
    *************************************************************************** 
    ** 
    **  put CryoCon in initial subsystem state
    ** 
     * @param itype
     * @param host
     * @param port
     * @throws org.lsst.ccs.drivers.commons.DriverException
    *************************************************************************** 
    */
    public CryoCon24cSimDevice(int itype, String host, int port) throws DriverException {
        
        System.out.println("CryoCon *** sim *** device ready. itype="+itype+" host="+host+" port="+port);

    }
    
    @Override
    protected void initDevice() {
        
    }
    


    /**
     * 
     * Opens connection to a device.
     */
    @Command(name = "open", description = "Open connection to Model 24C")
    public void open(
            @Argument(name = "type", description = "Communications type") int type,
            @Argument(name = "identity", description = "Device identifier") String ident,
            @Argument(name = "parameter", description = "Device parameter") int param)
            throws DriverException {
//        tempDev = new M24C(type, ident, param);
    }

    /**
     * 
     * Opens connection to a Default BNL Temp Control Model 24C
     * 
     */
    @Command(name = "openDefault", description = "Open connection to Default Model 24C")
    public void openDefault() throws DriverException {
//        tempDev = new M24C();
//        tempDev.openDefault();
    }

    /**
     * 
     * Displays Temp Control 24C identification.
     * 
     */
    @Command(name = "showident", description = "Show Temp Control 24C identification")
    public String showIdentification() throws DriverException {
        String[] ident = {"CryoSim","V1","V2"};
        return "Manufacturer:    " + ident[0] + "\n" + "Model name:      "
                + ident[1] + "\n" + "DCI F/W version: " + ident[2] + "\n"
                + "AI F/W version:  " + ident[3];
    }

    /**
     * 
     * 
     * Get Source for Loop returns Channels A through D
     * 
     */
    @Command(name = "getSetPoint", description = "Retrieve setPoint for loop")
    public double getSetPoint(
            @Argument(name = "loop", description = "loop number [1-4]") int loop)
            throws DriverException {
//        return tempDev.getSetPoint(loop);
        return this.simsettmp;
    }

    /**
     * 
     * Set SetPoint for Loop [1-4]
     * 
     */
    @Command(name = "setSetPoint", description = "setSetPoint for loop")
    public void setSetPoint(
            @Argument(name = "loop", description = "loop number [1-4]") int loop,
            @Argument(name = "temp", description = "temperature") double temp)
            throws DriverException {
//        tempDev.setSetPoint(loop, temp);
        this.simsettmp = temp;
        return;
    }

    /**
     * 
     * Get Source for Loop returns Channels A through D
     * 
     */
    @Command(name = "getLoopSource", description = "Retrieve source channel for loop")
    public char getLoopSource(
            @Argument(name = "loop", description = "loop number [1-4]") int loop)
            throws DriverException {
//        return (tempDev.getSource(loop)).charAt(0);
        return 'a';
    }

    /**
     * 
     * Set Source Channel for Loop
     * 
     */
    @Command(name = "setLoopSource", description = "Set source channel for loop")
    public void setLoopSource(
            @Argument(name = "loop", description = "loop number [1-4]") int loop,
            @Argument(name = "channel", description = "channel [A-D]") String channel)
            throws DriverException {
//        tempDev.setSource(loop, channel.charAt(0));
        return;
    }

    /**
     * 
     * Get Temperature Reading For Channels A through D
     * 
     */
    @Command(name = "getTemp", description = "Retrieve temperature info")
    public double getTemp(
            @Argument(name = "channel", description = "Temp Channel to read") String channel)
            throws DriverException {
        char ch = channel.charAt(0);
//        return tempDev.getTemp(ch);
        return(this.simsettmp+Math.random()*3.0);
    }

    
    /**
     ** 
     ** Get Temperature Units Channels A through D
     ** 
     */
    @Command(name = "getUnit", description = "Retrieve temperature units")
    public char getUnit(
            @Argument(name = "channel", description = "Temp Channel to read") String channel)
            throws DriverException {
        return 'A';
    }


      /**
    ***************************************************************************
    **
    **  Initializes the connection.
    **
    ***************************************************************************
    */
    @Override
    protected void initialize()
    {
        setOnline(true);
    }
    
    @Override
    protected double readChannel(int chan, int type) {
        return simData[chan];
    }
    
    /**
     * 
     * Set simulated temperature.
     */
    @Command(name = "setSimTemp", description = "Set Simulated Data value")
    public void setSimData(
            @Argument(name = "index", description = "data index") int indx,
            @Argument(name = "value", description = "Simulated value") double val) {
        this.simData[indx] = val;
    }
    
    
}
