package org.lsst.ccs.subsystem.teststand.limits;

import org.lsst.ccs.monitor.Channel;

/**
 * Convert a channel into a limit.
 *
 * @author tonyj
 */
public class ChannelLimits implements LimitsInterface {

    private final Channel[] channels;

    public ChannelLimits(Channel... channels) {
        if (channels.length == 0) {
            throw new IllegalArgumentException("At least one channel is required");
        }
        this.channels = channels;
    }

    @Override
    public void setLimits(double alarmLow, double warnLow, double warnHigh, double alarmHigh) {
        for (Channel channel : channels) {
//            channel.setLimitHi(alarmHigh);
//            channel.setLimitLo(alarmLow);
//            channel.setDbandHi(alarmHigh - warnHigh);
//            channel.setDbandLo(warnLow - alarmLow);
        }
    }

    @Override
    public double getAlarmHigh() {
        return channels[0].getLimitHi();
    }

    @Override
    public double getAlarmLow() {
        return channels[0].getLimitLo();
    }

    @Override
    public double getWarnLow() {
        return channels[0].getWarnLo();
    }

    @Override
    public double getWarnHigh() {
        return channels[0].getWarnHi();
    }

    @Override
    public String toString() {
        return String.format("Limits{alarmHigh=%5.5g, alarmLow=%5.5g, warnLow=%5.5g, warnHigh=%5.5g}", getAlarmHigh(), getAlarmLow(), getWarnHigh(), getWarnLow());
    }
}
