package org.lsst.ccs.subsystem.teststand;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;

/**
 ******************************************************************************
 **
 ** Implements the test stand EO sensor modular subsystem.
 *
 * @author The LSST CCS Team *
 * *****************************************************************************
 */
public class TS8Bench extends Subsystem implements HasLifecycle {

    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    Map<String, PhotoDiodeDevice> photoDiodeMap = new HashMap<>();
    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    UniblitzShutter shutter;

    @LookupName
    private String name;

    private final Logger log = Logger.getLogger(getClass().getPackage().getName());

    /**
     *  Constructor
     */
    public TS8Bench() {
        super("ccfcs", AgentInfo.AgentType.WORKER);
        getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    /**
     * Post-initialization
     */
    @Override
    public void postInit() {

        /** 
         * By setting TESTSTAND_TYPE_AGENT_PROPERTY we signal to consoles 
         * that this subsystem is compatible with the teststand subsystm GUI
         */
        getAgentService(AgentPropertiesService.class).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS8Bench.class.getCanonicalName());

    }

    /**
     *  Open TS8 shutter
     *
     *  @throws  DriverException
     */
    @Command(type=Command.CommandType.ACTION, name="openShutter",
             description="open TS8 shutter")
    public void openShutter() throws DriverException {
        if (shutter == null) {
            log.severe("Shutter not configured");
            return;
        }
	shutter.setShutter(true);
    }

    /**
     *  Close TS8 shutter
     *
     *  @throws  DriverException
     */
    @Command(type=Command.CommandType.ACTION, name="closeShutters",
             description="close TS8 shutter")
    public void closeShutter() throws DriverException {
        if (shutter == null) {
            log.severe("Shutter not configured");
            return;
        }
	shutter.setShutter(false);
    }
    
}
