package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cornerstone.C260;

/**
 ***************************************************************************
 **
 ** Provides access to the Cornerstone260 methods for the teststand subsystem
 *
 *
 * * @author Homer Neal *
 * **************************************************************************
 */
public class Cornerstone260SimDevice extends Cornerstone260Device implements MonochromatorDevice {

    int simfln = 1;
    double simwv = 225.;

    private boolean openclose = false;

    private String host = null, connType = "ftdi";
    private int baud = 9600;

    private String[] filter_label = {"", "", "", "", "", ""};

    private double[] filter_edges = new double[6];

    /**
     ***************************************************************************
     **
     ** Constructor *
     * **************************************************************************
     */
    public Cornerstone260SimDevice(String host, int baud) throws DriverException {
        md = null;
    }

    public Cornerstone260SimDevice() throws DriverException {
        md = null;
    }

    @Override
    protected void initialize() {
        log.info("Try to open connection to Cornerstone260 simulated device!");
        log.info("Using host = (" + host + ") and baud = (" + baud + ") connection type: " + connType);

        log.info("Succeeded in opening connection to Simulated C260 monochromator.");
        setOnline(true);
    }

    /**
     ***************************************************************************
     **
     ** Opens connection to a device. *
     * **************************************************************************
     */
    @Command(name = "open", description = "Open connection to device")
    public void open(@Argument(name = "host", description = "Host name") String host
    ) throws DriverException {
//        m260.open(host);
        log.debug("Opened connection to Cornerstone 260 device.");
        return;
    }

    /**
     ***************************************************************************
     **
     ** getFilter: *
     * **************************************************************************
     *
     */
    @Command(name = "getFilter", description = "")
    public int getFilter() throws DriverException {
        return simfln;
    }

    /**
     ***************************************************************************
     **
     ** setFilter: *
     * **************************************************************************
     *
     */
    @Command(name = "setFilter", description = "")
    public void setFilter(int pos) throws DriverException {
        simfln = pos;
    }

    /**
     ***************************************************************************
     **
     ** getShutter: *
     * **************************************************************************
     *
     */
    @Command(name = "getShutter", description = "")
    public String getShutter() throws DriverException {
        String gs = "shutter"; // something more intelligent later
        return gs;
    }

    /**
     ***************************************************************************
     **
     ** openShutter: *
     * **************************************************************************
     *
     */
    @Command(name = "openShutter", description = "")
    public void openShutter() throws DriverException {
        openclose = true;
    }

    /**
     ***************************************************************************
     **
     ** closeShutter: *
     * **************************************************************************
     *
     */
    @Command(name = "closeShutter", description = "")
    public void closeShutter() throws DriverException {
        openclose = false;
    }

    /**
     ***************************************************************************
     **
     ** isShutterOpen: *
     * **************************************************************************
     *
     */
    @Command(name = "isShutterOpen", description = "")
    public boolean isShutterOpen() throws DriverException {
        boolean is = false;
        return (openclose);
    }

    /**
     ***************************************************************************
     **
     ** setShutter: *
     * **************************************************************************
     *
     */
    @Command(name = "setShutter", description = "")
    public void setShutter(String param) throws DriverException {
    }

    /**
     ***************************************************************************
     **
     ** getWave: *
     * **************************************************************************
     *
     */
    @Command(name = "getWave", description = "")
    public double getWave() throws DriverException {
        return (simwv);
    }


    /**
     ***************************************************************************
     **
     ** setWave: *
     * **************************************************************************
     *
     */
    @Command(name = "setWave", description = "")
    public void setWave(double wv) throws DriverException {
        simwv = wv;
    }

    
}
