package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.teststand.data.TSState;

/**
 *  AP9630UPS simulated device class for the teststand subsystem
 *
 *  @author: Owen Saxton
 */
public class AP9630UPSSimDevice extends AP9630UPSDevice {


    /**
     *  Performs configuration.
     */
    @Override
    protected void initDevice()
    {
        fullName = "Simulated AP9630 UPS";
    }


    /**
     *  Initializes the device.
     */
    @Override
    protected void initialize()
    {
        initSensors();
        kstate = TSState.pwrstates.OK;
        sLog.info("Connected to " + fullName);
        inited = true;
        setOnline(true);
    }


    /**
     *  Closes the connection.
     */
    @Override
    protected void close()
    {
        kstate = TSState.pwrstates.NOTCONFIGURED;
    }


   /**
    *  Checks a channel's parameters for validity.
    *
    *  @param  name     The channel name
    *  @param  hwChan   The hardware channel
    *  @param  type     The channel type string
    *  @param  subtype  The channel subtype string
    *  @return  Two-element array containing the encoded type [0] and subtype [1] 
    *  @throws  Exception  If parameters are invalid
    */
    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception
    {
        return new int[]{0, 0};
    }


    /**
     *  Initializes a channel.
     *
     *  @param  name     The channel name
     *  @param  id       The channel ID
     *  @param  hwChan   The hardware channel
     *  @param  type     The encoded channel type
     *  @param  subtype  The encoded channel subtype
     */
    @Override
    protected void initChannel(String name, int id, int hwChan, int type, int subtype)
    {
    }


    /**
     *  Reads a channel.
     *
     *  @param  hwChan  The hardware channel number
     *  @param  type    The encoded channel type
     *  @return  The read value
     */
    @Override
    protected double readChannel(int hwChan, int type)
    {
        switch (hwChan) {
        case CHAN_OUT_VOLTAGE:
            return 111.0;
        case CHAN_OUT_CURRENT:
            return 15.0;
        case CHAN_OUT_POWER:
            return 1650.0;
        case CHAN_BATT_VOLTAGE:
            return 100.0;
        case CHAN_BATT_CHARGE:
            return 100.0;
        case CHAN_BATT_TEMP:
            return 21.0;
        case CHAN_STATUS:
            return 0;
        case CHAN_REM_TIME:
            return 999.0;
        default:
            return 0.0;
        }
    }


    /**
     *  Gets the UPS status.
     *
     *  @return The status
     */
    @Override
    @Command(name="getStatus", description="Get the UPS status")
    public int getStatus()
    {
        return 0;
    }


    /**
     *  Gets the UPS battery time remaining.
     *
     *  @return The remaining time (secs)
     */
    @Override
    @Command(name="getRemTime", description="Get the UPS remaining time")
    public int getRemTime()
    {
        return 999;
    }

}
