/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.python.apache.xml.serialize.ObjectFactory;
import org.python.apache.xml.serialize.OutputFormat;
import org.python.apache.xml.serialize.SecuritySupport;
import org.python.apache.xml.serialize.Serializer;
import org.python.apache.xml.serialize.SerializerFactoryImpl;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "org.python.apache.xml.serialize.factories";
    private static Hashtable _factories = new Hashtable();
    static /* synthetic */ Class class$org$apache$xml$serialize$SerializerFactory;

    public static void registerSerializerFactory(SerializerFactory serializerFactory) {
        Hashtable hashtable = _factories;
        synchronized (hashtable) {
            String string2 = serializerFactory.getSupportedMethod();
            _factories.put(string2, serializerFactory);
        }
    }

    public static SerializerFactory getSerializerFactory(String string2) {
        return (SerializerFactory)_factories.get(string2);
    }

    protected abstract String getSupportedMethod();

    public abstract Serializer makeSerializer(OutputFormat var1);

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SerializerFactory serializerFactory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        String string2 = SecuritySupport.getSystemProperty(FactoriesProperty);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ;,:");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    serializerFactory = (SerializerFactory)ObjectFactory.newInstance(string3, (class$org$apache$xml$serialize$SerializerFactory == null ? SerializerFactory.class$("org.python.apache.xml.serialize.SerializerFactory") : class$org$apache$xml$serialize$SerializerFactory).getClassLoader(), true);
                    if (!_factories.containsKey(serializerFactory.getSupportedMethod())) continue;
                    _factories.put(serializerFactory.getSupportedMethod(), serializerFactory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

