/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.mdi.InternalFramePageManager;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.application.studio.EventSender;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.PluginMap;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commandline.CommandLine;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Lookup;
import org.xml.sax.EntityResolver;

public class Studio
extends MDIApplication {
    private FreeHEPLookup lookup;
    private EventSender sender = new EventSender();
    private boolean debugExtensions = System.getProperty("debugExtensions") != null;
    private SAXBuilder builder;
    private ArrayList<PluginInfo> loadedPlugins = new ArrayList();
    private ExtensionClassLoader extensionLoader;
    public static final String LOADDIR = "loaddir";
    private boolean isApplicationVisible = false;
    private boolean isApplicationInitialized = false;
    private boolean atLeastOnePluginFailedToLoad = false;
    private PluginMap pluginMap;

    protected Studio(String name) {
        super(name);
        this.builder = new SAXBuilder(true);
        this.builder.setEntityResolver((EntityResolver)new ClassPathEntityResolver("plugin.dtd", Studio.class));
        this.getLookup().add((Object)new TabbedPageManager(), "Tabbed Panes");
        this.getLookup().add((Object)new InternalFramePageManager(), "Internal Frames");
    }

    private Studio() {
        this("Studio");
    }

    @Override
    protected CommandLine createCommandLine() {
        CommandLine cl = super.createCommandLine();
        cl.addOption("extdir", null, "directory", "Sets the directory to scan for plugins");
        return cl;
    }

    @Override
    protected void init() {
        super.init();
        this.setStatusMessage("Loading extensions...");
        this.loadExtensions();
        this.setStatusMessage("Setting page manager...");
        this.setPageManager(this.createRealPageManager());
        if (this.atLeastOnePluginFailedToLoad) {
            this.error("At least one plugin failed to load, see Plugin Manager for details");
        }
    }

    private void loadExtensions() {
        this.getPluginMap().purge();
        this.extensionLoader = new ExtensionClassLoader(this.pluginMap.getExtensionClasspath());
        this.createLookup().setClassLoader((ClassLoader)this.extensionLoader);
        Runnable lola = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(Studio.this.extensionLoader);
            }
        };
        lola.run();
        SwingUtilities.invokeLater(lola);
        this.loadPlugins(this.pluginMap.getActivePlugins().values(), this.extensionLoader);
    }

    public static void main(String[] args) {
        new Studio().createFrame(args).setVisible(true);
    }

    public EventSender getEventSender() {
        return this.sender;
    }

    public final FreeHEPLookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    @Deprecated
    public String getUserExtensionsDir() {
        return this.getExtensionsDir(PluginDir.USER);
    }

    @Deprecated
    public String getGroupExtensionsDir() {
        return this.getExtensionsDir(PluginDir.GROUP);
    }

    @Deprecated
    public String getSystemExtensionsDir() {
        return this.getExtensionsDir(PluginDir.SYSTEM);
    }

    public String getExtensionsDir(PluginDir dir) {
        String out = null;
        switch (dir) {
            case SYSTEM: {
                out = this.getAppProperties().getProperty("org.freehep.application.studio.system.extensions", "{java.home}/FreeHEPPlugins");
                break;
            }
            case GROUP: {
                out = this.getAppProperties().getProperty("org.freehep.application.studio.group.extensions");
                break;
            }
            case USER: {
                out = this.getCommandLine().getOption("extdir");
                if (out != null) break;
                out = this.getAppProperties().getProperty("org.freehep.application.studio.user.extensions", "{user.home}/.FreeHEPPlugins");
                break;
            }
            default: {
                return null;
            }
        }
        if (out != null) {
            try {
                out = new File(out).getCanonicalPath();
            }
            catch (IOException x) {
                out = null;
            }
        }
        return out;
    }

    public ExtensionClassLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public List<PluginInfo> getPlugins() {
        return Collections.unmodifiableList(this.loadedPlugins);
    }

    public PluginInfo getPlugin(String name) {
        for (PluginInfo plugin : this.loadedPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public PluginMap getPluginMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new PluginMap(this);
        }
        return this.pluginMap;
    }

    public void stopPlugin(PluginInfo plugin) {
        if ((plugin = this.getPlugin(plugin.getName())) == null) {
            return;
        }
        Plugin plug = plugin.getPlugin();
        if (plug == null || !plug.canBeShutDown()) {
            throw new IllegalArgumentException("Plugin can not be stopped");
        }
        plug.stop();
        plugin.setPlugin(null);
    }

    public void startPlugin(PluginInfo plugin) throws Throwable {
        if ((plugin = this.getPlugin(plugin.getName())) == null) {
            return;
        }
        this.initializePlugin(plugin, this.extensionLoader);
        this.revalidate();
    }

    private Plugin initializePlugin(PluginInfo plugin, ClassLoader loader) throws Throwable {
        try {
            this.getAppProperties().putAll(plugin.getProperties());
            Class<?> c = loader.loadClass(plugin.getMainClass());
            Plugin plug = (Plugin)c.newInstance();
            plug.setContext(this);
            plugin.setPlugin(plug);
            if (this.isApplicationInitialized) {
                plug.postInit();
            }
            if (this.isApplicationVisible) {
                plug.applicationVisible();
            }
            plugin.setErrorStatus(null);
            return plug;
        }
        catch (Throwable t) {
            plugin.setErrorStatus(t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PluginInfo> buildPluginList(InputStream in) throws IOException {
        Properties user = this.getUserProperties();
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        try {
            Document doc = this.builder.build(in);
            List rootChildren = doc.getRootElement().getChildren();
            for (Element node : rootChildren) {
                PluginInfo plugin = new PluginInfo(node);
                plugin.loadUserProperties(user);
                result.add(plugin);
                if (!this.debugExtensions) continue;
                System.out.println("\t\tPlugin: " + plugin.getName());
            }
        }
        catch (JDOMException x) {
            if (this.debugExtensions) {
                x.printStackTrace();
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    public boolean loadPlugins(Collection<PluginInfo> plugins, ClassLoader loader) {
        for (PluginInfo plugin : plugins) {
            if (this.loadedPlugins.contains(plugin)) continue;
            this.loadedPlugins.add(plugin);
            if (!plugin.isLoadAtStart()) continue;
            try {
                this.setStatusMessage("Loading " + plugin.getName() + "...");
                this.initializePlugin(plugin, loader);
                plugin.setErrorStatus(null);
            }
            catch (Throwable t) {
                plugin.setErrorStatus(t);
                this.atLeastOnePluginFailedToLoad = true;
            }
        }
        this.loadedPlugins.trimToSize();
        this.revalidate();
        return this.atLeastOnePluginFailedToLoad;
    }

    @Override
    protected void fireInitializationComplete(ApplicationEvent event) {
        super.fireInitializationComplete(event);
        this.getEventSender().broadcast(event);
        for (PluginInfo info : this.loadedPlugins) {
            Plugin plugin = info.getPlugin();
            if (plugin == null) continue;
            plugin.postInit();
        }
        this.isApplicationInitialized = true;
    }

    @Override
    protected void fireApplicationVisible(ApplicationEvent event) {
        super.fireApplicationVisible(event);
        this.getEventSender().broadcast(event);
        for (PluginInfo info : this.loadedPlugins) {
            Plugin plugin = info.getPlugin();
            if (plugin == null) continue;
            plugin.applicationVisible();
        }
        this.isApplicationVisible = true;
    }

    @Override
    protected void fireAboutToExit(ApplicationEvent event) {
        for (PluginInfo info : this.loadedPlugins) {
            Properties user = this.getUserProperties();
            info.saveUserProperties(user);
        }
        super.fireAboutToExit(event);
        this.getEventSender().broadcast(event);
    }

    protected FreeHEPLookup createLookup() {
        return FreeHEPLookup.instance();
    }

    protected PageManager createRealPageManager() {
        String name = this.getUserProperties().getProperty("pageManagerName", "Tabbed Panes");
        Lookup.Template template = new Lookup.Template(PageManager.class, name, null);
        Lookup.Result result = this.getLookup().lookup(template);
        if (!result.allInstances().isEmpty()) {
            return (PageManager)result.allInstances().iterator().next();
        }
        try {
            return super.createPageManager();
        }
        catch (Throwable t) {
            PageManager pm = (PageManager)this.getLookup().lookup(PageManager.class);
            if (pm != null) {
                return pm;
            }
            return new TabbedPageManager();
        }
    }

    @Override
    protected PageManager createPageManager() {
        return new DummyPageManager();
    }

    private static class DummyPageManager
    extends PageManager {
        private JPanel panel = new JPanel();

        private DummyPageManager() {
        }

        @Override
        protected Component getEmbodiment() {
            return this.panel;
        }

        @Override
        protected void iconChanged(PageContext page) {
        }

        @Override
        protected void show(PageContext page) {
        }

        @Override
        protected void titleChanged(PageContext page) {
        }
    }
}

