/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.TPG261;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.VacuumGaugeDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class TPG261Device
extends Device
implements VacuumGaugeDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private TPG261 microDev;
    TSConfig cfg = new TSConfig();
    private double[] runVac = new double[TSConfig.MAXSTATES];
    TSState.vacstates vstate = TSState.vacstates.NOTCONFIGURED;
    boolean isConnected = false;
    boolean failedToInitialize = false;
    double lastPres = 0.0;

    public TPG261Device() {
    }

    public TPG261Device(int itype, String host, int port) throws DriverException {
        try {
            this.microDev = new TPG261();
            this.microDev.openftdi(host, port);
            this.vstate = TSState.vacstates.OFF;
        }
        catch (DriverException e) {
            System.out.println("Failed to open connection to TPG261 device!");
        }
    }

    @Override
    @Command(name="isVacuumGaugeOn", description="returns whether the TPG261 device is active")
    public boolean isVacuumGaugeOn() {
        boolean state = false;
        try {
            state = this.microDev.getStatus().contains("1");
            if (!this.vstate.equals((Object)TSState.vacstates.TRIPPED)) {
                this.vstate = state ? TSState.vacstates.ON : TSState.vacstates.OFF;
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"TPG261 device failed to close!!!");
        }
        return state;
    }

    @Override
    public void setGaugeOn() {
        this.log.info((Object)"TBD");
    }

    @Override
    public void setGaugeOff() {
        this.log.info((Object)"TBD");
    }

    @Override
    @Command(name="readPressure", description="returns the pressure read from the TPG261 device")
    public double readPressure() {
        double pressure = 0.0;
        try {
            if (this.isConnected) {
                this.lastPres = pressure = this.microDev.getPressure();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"TPG261 device failed to return pressure reading!!!");
        }
        return pressure;
    }

    @Override
    @Command(name="getLastPressure", description="returns the last successful pressure read from the TPG261 device")
    public double getLastPres() {
        return this.lastPres;
    }

    protected void close() {
        try {
            if (this.microDev != null) {
                this.microDev.close();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"TPG261 device failed to close!!!");
        }
    }

    protected void initialize() {
        try {
            this.log.error((Object)("State of of the TPG261 device is" + (this.microDev.getStatus().contains("1") ? "ON" : "OFF")));
            this.log.error((Object)"TPG261 device initialized.");
            this.setOnline(true);
            this.isConnected = true;
            this.vstate = TSState.vacstates.OK;
        }
        catch (DriverException e) {
            if (!this.failedToInitialize) {
                this.log.error((Object)"TPG261 device failed to initialize!!!");
            }
            this.failedToInitialize = true;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != -1) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("TPG261Device readChannel called! chan=" + chan + " type=" + type));
        try {
            value = this.readPressure();
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Override
    @Command(name="setrunvac", description="Sets the vac value for acquisition")
    public void setRunVac(double runVac, int cfgstate) {
        this.runVac[cfgstate] = runVac;
    }

    @Override
    @Command(name="getrunvac", description="Returns the vac value for acquisition")
    public double getRunVac(int cfgstate) {
        return this.runVac[cfgstate];
    }

    @Override
    @Command(name="setState", description="set vacuum device status")
    public void setState(int istate) {
        this.vstate = TSState.vacstates.values()[istate];
    }

    @Override
    @Command(name="getState", description="get vacuum device status")
    public int getState() {
        return this.vstate.ordinal();
    }

    static {
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("CURR", 2);
        typeMap.put("PRESSURE", -1);
        typeMap.put("WAVELENGTH", 3);
        typeMap.put("PA", -1);
    }
}

