package org.lsst.ccs.subsystem.teststand;

import hep.aida.*;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Defines a photo diode readout (picoammeter) interface.
 *
 * @author Homer Neal
 */
public interface PhotoDiodeDevice {

    boolean isOnline();

    void setCurrentRange(double value) throws DriverException;

    void setRate(double value) throws DriverException;

    double readCurrent();

    double getLastCurrent();

    void setDisplay(boolean dstate) throws DriverException;

    double accumBuffer(int nreads, double nplc);

    double accumBuffer(int nreads, double nplc, boolean wait);

    boolean isAccumInProgress();

    void waitAccum(double timeout) throws DriverException;

    double[][] readBuffer() throws DriverException ;

    void reset();

    void softReset();

    void setBuffSize(int size) throws DriverException;

    void setDPSF(IDataPointSetFactory dpsf);

    int getState();

    void setState(int state);

    void setAbort(boolean astate);

    void setDoPDPlot(boolean dopdplot);

    void send(String str) throws DriverException;

    void send(String str1, String str2) throws DriverException;

    String query(String str) throws DriverException;

    String query(String str1, String str2) throws DriverException;

    void setCfg(TSConfig cfg);

    void setTimeout(double nsec);

    void setChannel(int channel);
    
    void setAvgOn(boolean doAvg) throws DriverException;
    
    boolean getAvgState() throws DriverException;
    
    void setNAvg(int nAvg) throws DriverException;
}
