/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.thorlabs.ThorlabsSC10;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.utilities.logging.Logger;

public class ThorlabsSC10Device
extends Device {
    private final ThorlabsSC10 shutr = new ThorlabsSC10();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService stateService;
    private Map<Integer, String> chanMap = new HashMap<Integer, String>();
    private Integer chanKey;
    private Duration exposureDuration;
    private final Duration intervalCheckClosed = Duration.ofMillis(100L);
    @ConfigurationParameter(isFinal=true, description="port Id")
    protected String devcId;
    @ConfigurationParameter(isFinal=true, description="<false|true> for output open/closed line to follow <shutter|controller> ")
    protected Boolean outputMode;

    protected void initDevice() {
        this.chanKey = 0;
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "ThorlabsSC10 " + this.name + " (" + this.devcId + ")";
        if (this.outputMode == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"outputMode", (String)"is missing");
        }
    }

    protected void initialize() {
        try {
            this.shutr.open(this.devcId);
            ThorlabsSC10.TrigMode trgMode = ThorlabsSC10.TrigMode.INTERNAL;
            ThorlabsSC10.OpMode opMode = ThorlabsSC10.OpMode.MANUAL;
            int outputModeVal = this.outputMode != false ? 1 : 0;
            this.shutr.setSC(ThorlabsSC10.CmndSC.TRIG_OUT_MODE, outputModeVal);
            this.shutr.setSC(ThorlabsSC10.CmndSC.TRIGGER_MODE, trgMode.getSetting());
            this.shutr.setSC(ThorlabsSC10.CmndSC.OPERATING_MODE, opMode.getSetting());
            if (!this.isShutterClosed()) {
                this.shutr.enable();
            }
            this.setOnline(true);
            this.initSensors();
            this.log.info((Object)("\n Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to or initializing " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.shutr.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    public boolean isShutterClosed() throws DriverException {
        return Integer.parseInt(this.shutr.querySC(ThorlabsSC10.CmndSC.CLOSED)) == 1;
    }

    private long waitForShutterState(boolean open, Duration timeout) throws TimeoutException, DriverException {
        long start = System.currentTimeMillis();
        long timeoutTime = start + timeout.toMillis();
        while (this.isShutterClosed() == open) {
            try {
                Thread.sleep(this.intervalCheckClosed.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting for Thorlabs shutter state ", ex);
            }
            if (System.currentTimeMillis() <= timeoutTime) continue;
            throw new TimeoutException(this.name + " wait for shutter to " + (open ? "open" : "close") + " timed out");
        }
        return System.currentTimeMillis() - start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="outputMode")
    public void setOutputMode(Boolean mode) throws DriverException {
        if (this.isOnline()) {
            if (mode == null) throw new IllegalArgumentException(this.name + ": improper value for outputMode, not changed");
            this.log.info((Object)(this.name + "config. change request: set TRIG_OUT_MODE = " + mode));
            int outputModeVal = mode != false ? 1 : 0;
            this.shutr.setSC(ThorlabsSC10.CmndSC.TRIG_OUT_MODE, outputModeVal);
            this.outputMode = mode;
            return;
        } else {
            if (mode == null) return;
            this.outputMode = mode;
        }
    }

    @Command(type=Command.CommandType.ACTION, name="openShutter", description="Open shutter", autoAck=false)
    public void openShutter() throws DriverException {
        this.subsys.helper().precondition(this.isShutterClosed(), this.name + "shutter already open", new Object[0]).action(() -> {
            this.shutr.setSC(ThorlabsSC10.CmndSC.TRIGGER_MODE, ThorlabsSC10.TrigMode.INTERNAL.getSetting());
            this.shutr.setSC(ThorlabsSC10.CmndSC.OPERATING_MODE, ThorlabsSC10.OpMode.MANUAL.getSetting());
            this.shutr.enable();
            this.log.info((Object)(this.name + " opened"));
        });
    }

    @Command(type=Command.CommandType.ACTION, name="closeShutter", description="Close shutter", autoAck=false)
    public void closeShutter() throws DriverException {
        this.subsys.helper().precondition(!this.isShutterClosed(), this.name + "shutter already closed", new Object[0]).action(() -> {
            this.shutr.setSC(ThorlabsSC10.CmndSC.TRIGGER_MODE, ThorlabsSC10.TrigMode.INTERNAL.getSetting());
            this.shutr.setSC(ThorlabsSC10.CmndSC.OPERATING_MODE, ThorlabsSC10.OpMode.MANUAL.getSetting());
            this.shutr.enable();
            this.log.info((Object)(this.name + " closed"));
        });
    }

    @Command(type=Command.CommandType.ACTION, name="exposure", description="Open shutter for specified time interval (ms)")
    public void exposure(@Argument(name="<Duration>", description="exposure duration") Duration duration) throws DriverException, TimeoutException {
        this.shutr.setSC(ThorlabsSC10.CmndSC.TRIGGER_MODE, ThorlabsSC10.TrigMode.INTERNAL.getSetting());
        this.shutr.setSC(ThorlabsSC10.CmndSC.OPERATING_MODE, ThorlabsSC10.OpMode.SINGLE.getSetting());
        this.shutr.setSC(ThorlabsSC10.CmndSC.OPEN_DURATION, (int)duration.toMillis());
        this.shutr.enable();
        this.exposureDuration = duration;
        long waitTime = this.waitForShutterState(true, Duration.ofSeconds(5L));
        if ((double)waitTime < 500.0) {
            this.log.info((Object)(this.name + " opened for " + duration + " (took " + waitTime + " ms)"));
        } else {
            this.log.warning((Object)(this.name + " opened for " + duration + " (took " + waitTime + " ms)"));
        }
    }

    @Command(type=Command.CommandType.ACTION, name="waitForClosed", description="Returns when shutter is closed after exposure", autoAck=false)
    public void waitForClosed() throws TimeoutException {
        this.subsys.helper().precondition(this.exposureDuration != null, this.name + ": No exposure in progress", new Object[0]).duration(this.exposureDuration != null ? this.exposureDuration.plusMillis(1500L) : this.exposureDuration).action(() -> {
            Duration timeout = this.exposureDuration.plusMillis(1000L);
            this.exposureDuration = null;
            this.waitForShutterState(false, timeout);
        });
    }

    protected int[] checkChannel(String chName, int hwChan, String type, String subtype) throws Exception {
        try {
            ThorlabsSC10.CmndSC.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            MonitorLogUtils.reportError((Logger)this.log, (String)chName, (String)"type", (Object)type);
        }
        Integer n = this.chanKey;
        Integer n2 = this.chanKey = Integer.valueOf(this.chanKey + 1);
        this.chanMap.put(this.chanKey, type);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        String chanName = this.chanMap.get(type);
        try {
            value = Integer.parseInt(this.shutr.querySC(ThorlabsSC10.CmndSC.valueOf((String)chanName)));
        }
        catch (DriverTimeoutException et) {
            this.log.error((Object)(this.name + " timeout reading " + chanName + ": " + (Object)((Object)et)));
            this.setOnline(false);
        }
        catch (DriverException e) {
            this.log.error((Object)(this.name + " exception reading data " + chanName + ": " + (Object)((Object)e)));
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, name="readAll", description="Read all filter-wheel controller settings and data")
    public String readAll() {
        String table = "Read all shutter settings and data\n\n";
        ThorlabsSC10.CmndSC[] cmndN = ThorlabsSC10.CmndSC.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                String respN = this.shutr.querySC(cmndN[i]);
                table = table + respN;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        return table;
    }
}

