/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSetFactory;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.teststand.BiasDevice;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.EnviroDevice;
import org.lsst.ccs.subsystem.teststand.Fe55Device;
import org.lsst.ccs.subsystem.teststand.LEDDevice;
import org.lsst.ccs.subsystem.teststand.LampDevice;
import org.lsst.ccs.subsystem.teststand.MonochromatorDevice;
import org.lsst.ccs.subsystem.teststand.PDUDevice;
import org.lsst.ccs.subsystem.teststand.PhotoDiodeDevice;
import org.lsst.ccs.subsystem.teststand.ShutterDevice;
import org.lsst.ccs.subsystem.teststand.TSConfigCatcher;
import org.lsst.ccs.subsystem.teststand.VQMDevice;
import org.lsst.ccs.subsystem.teststand.VacuumGaugeDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSFluxCalib;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.utilities.logging.Logger;

public class TSSubSys
implements HasLifecycle,
Monitor.AlarmHandler {
    boolean notify = false;
    TSConfig teststandc = new TSConfig();
    TSConfigCatcher tscc = new TSConfigCatcher(this.teststandc);
    TSFluxCalib teststandf = new TSFluxCalib();
    String stateCorrelId;
    private ConcurrentMessagingUtils cmu;
    private static final Logger LOGGER = Logger.getLogger((String)"org.lsst.ccs.subsystem.metrology.main");
    String configName = "test";
    int state = 0;
    boolean last_systemOK = true;
    int nwarn = 0;
    double last_vac = 0.0;
    private static final String teststand_dest = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    BiasDevice biasDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    PhotoDiodeDevice pdDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    CryoDevice cryoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VacuumGaugeDevice vacDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    LampDevice lmpDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    MonochromatorDevice monoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Fe55Device fe55Devc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    ShutterDevice shDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    EnviroDevice envDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    LEDDevice ledDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    PDUDevice pduDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VQMDevice vqmDevc;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupName
    private String name;
    public static final String BROADCAST_TASK = "publish-data";
    private long lastWarningTMillis = 0L;
    private long warningInterval = 240000L;
    private String lastWarning = "";
    private boolean doTestStandReadyCheck = true;
    private long broadcastMillis = 10000L;

    public TSSubSys(String configName) {
        this.configName = configName;
    }

    public void build() {
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                TSSubSys.this.periodicBroadcast();
            }
        };
        AgentPeriodicTask periodicTask = new AgentPeriodicTask(BROADCAST_TASK, myRunnable).withPeriod(Duration.ofMillis(this.broadcastMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TSSubSys.class.getCanonicalName());
        this.teststandf.TSFluxCalibReader();
    }

    public void postStart() {
        LOGGER.info((Object)"Executing teststand startup procedure");
        this.cmu = new ConcurrentMessagingUtils(this.subsys.getMessagingAccess());
        try {
            this.startSubSys();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error starting Test Stand subsystem: " + e));
        }
        try {
            this.teststandc.setCfgState(TSConfig.operating_states.READY.ordinal());
            this.setStateFlags(TSConfig.operating_states.READY);
        }
        catch (Exception ee) {
            LOGGER.error((Object)"Exception while setting state flags:", (Throwable)ee);
        }
        this.publishState();
        this.state |= 2;
        IAnalysisFactory af = IAnalysisFactory.create();
        IDataPointSetFactory dataPointSetFactory = af.createDataPointSetFactory(null);
        if (this.pdDevc != null) {
            this.pdDevc.setDPSF(dataPointSetFactory);
        }
        if (this.biasDevc != null) {
            this.biasDevc.setDPSF(dataPointSetFactory);
        }
        LOGGER.info((Object)"DPSF started.");
    }

    protected void periodicBroadcast() {
        System.out.print(".");
        if ((this.state & 0x10) != 0) {
            System.exit(0);
        }
        this.publishState();
        ConfigurationInfo configInfo = this.configurationService.getConfigurationInfo();
        this.tscc.updateConfig(configInfo);
        if (this.doTestStandReadyCheck) {
            if (this.pdDevc != null && this.biasDevc != null) {
                int pdState = this.pdDevc.getState();
                int biasState = this.biasDevc.getState();
                LOGGER.info((Object)("The PD and Bias states are:" + TSState.pwrstates.values()[pdState] + " , " + TSState.pwrstates.values()[biasState]));
                if (pdState == TSState.pwrstates.NOTCONFIGURED.ordinal() && biasState == TSState.pwrstates.NOTCONFIGURED.ordinal()) {
                    LOGGER.error((Object)"Both PD and BIAS devices are in the NOTCONFIGURED state. Checking for a possible POWER OUTAGE.");
                    boolean pdOK = true;
                    try {
                        System.out.println("Doing a soft reset of PD device");
                        this.pdDevc.softReset();
                        System.out.println("Trying a current read.");
                        this.pdDevc.readCurrent();
                        System.out.println("PD state is " + TSState.pwrstates.values()[this.pdDevc.getState()]);
                        if (this.pdDevc.getState() == TSState.pwrstates.NOTCONFIGURED.ordinal()) {
                            pdOK = false;
                        }
                    }
                    catch (Exception pp) {
                        pdOK = false;
                    }
                    boolean biasOK = true;
                    try {
                        System.out.println("Doing a soft reset of Bias device");
                        this.biasDevc.softReset();
                        System.out.println("Trying a current read.");
                        this.biasDevc.readCurrent();
                        System.out.println("Bias state is " + TSState.pwrstates.values()[this.biasDevc.getState()]);
                        if (this.biasDevc.getState() == TSState.pwrstates.NOTCONFIGURED.ordinal()) {
                            biasOK = false;
                        }
                    }
                    catch (Exception pp) {
                        biasOK = false;
                    }
                    System.out.println("PD, Bias state summary = " + pdOK + " , " + biasOK);
                    if (!pdOK && !biasOK) {
                        this.powerOutageAction();
                    }
                }
            }
            try {
                this.isTestStandReady();
            }
            catch (Exception ex) {
                LOGGER.error((Object)"There was an error during the tick check of the test stand readiness:", (Throwable)ex);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Put system in safe mode")
    public void powerOutageAction() {
        LOGGER.error((Object)"A POWER OUTAGE SITUATION HAS BEEN IDENTIFIED ... TAKING ACTIONS TO PROTECT SENSOR");
        LOGGER.error((Object)"A POWER OUTAGE SITUATION HAS BEEN IDENTIFIED ... TAKING ACTIONS TO PROTECT SENSOR");
        LOGGER.error((Object)"A POWER OUTAGE SITUATION HAS BEEN IDENTIFIED ... TAKING ACTIONS TO PROTECT SENSOR");
        try {
            this.biasDevc.setVoltage(0.0);
            this.biasDevc.setOutput(0);
        }
        catch (Exception pp) {
            LOGGER.error((Object)"Not surprisingly, we failed to communicate with the bias supply. It is fine that it is down.");
        }
        try {
            LOGGER.fine((Object)"SHUTTING OFF POWER TO THE CRYO PUMP");
            int pd_outlet = Integer.decode(System.getenv("CCS_CRYO_OUTLET"));
            this.pduDevc.setOutletState(pd_outlet, false);
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Failed to power off cryo pump: " + e1));
        }
        KeyValueData kd = new KeyValueData("TS_Hazard", (Serializable)((Object)"SensorHazard: Power Outage"));
        this.subsys.publishSubsystemDataOnStatusBus(kd);
        try {
            this.sendSyncTSCommand("abortInterpreter", new Object[0]);
        }
        catch (Exception e3) {
            LOGGER.error((Object)("Failed to abort script: " + e3));
        }
        try {
            int iloop = this.cryoDevc.getCurrent_loop();
            this.cryoDevc.setHeaterRange(iloop, "LOW");
            this.cryoDevc.setSetPoint(iloop, 20.0);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="raise subsystem alert")
    public void raiseTSAlert(String alertmsg, AlertState severity) {
        LOGGER.info((Object)("sending alert message: " + alertmsg));
        LOGGER.info((Object)("alert message length = " + alertmsg.length()));
        Alert a = new Alert("Teststand " + this.configName + " Alert", alertmsg.substring(0, Math.min(254, alertmsg.length())));
        this.alertService.raiseAlert(a, severity, alertmsg);
    }

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        String alarm_ev = null;
        switch (event) {
            case 0: {
                alarm_ev = "TRIP";
                break;
            }
            case 3: {
                alarm_ev = "RESET";
                break;
            }
            default: {
                alarm_ev = "Unknown";
            }
        }
        LOGGER.error((Object)("Received alarm for " + alarm_ev + " event, where trip=" + 0 + " and reset=" + 3));
        LOGGER.error((Object)("Alarm is from " + TSConfig.EVENT_ID.values()[parm]));
        String alarm_name = this.configName + ":CCS alarm for " + alarm_ev + "event, from " + TSConfig.EVENT_ID.values()[parm];
        String alarm_msg = null;
        switch (event) {
            case 0: {
                if (parm == TSConfig.EVENT_ID.BIAS.ordinal()) {
                    alarm_msg = "***** Over VOLTAGE or CURRENT alarm received! For safety, the bias voltage is being set OFF! ";
                    if (this.biasDevc != null) {
                        alarm_name = alarm_name + " V= " + this.biasDevc.readVoltage() + ", I= " + this.biasDevc.readCurrent();
                        this.biasDevc.setAbort(true);
                        this.biasDevc.setState(TSState.pwrstates.TRIPPED.ordinal());
                        this.raiseTSAlert(alarm_name, AlertState.ALARM);
                        this.sleep(5.0);
                        this.biasDevc.setAbort(false);
                        this.rampBiasVolts(5.0, 0.0);
                        this.setBiasOutput(0);
                    }
                    this.state |= 0x80;
                    this.state &= 0xFFFFFFFD;
                }
                if (parm == TSConfig.EVENT_ID.CRYO.ordinal()) {
                    alarm_msg = "***** Temperature alarm received! Please rectify and reset manually!";
                    try {
                        alarm_name = alarm_name + " T= " + this.cryoDevc.getTemp(this.cryoDevc.getCurrent_channel());
                    }
                    catch (DriverException ex) {
                        LOGGER.error((Object)"Failed to retrieve temperature for alarm message", (Throwable)ex);
                    }
                    this.cryoDevc.setState(TSState.cryostates.TRIPPED.ordinal());
                    this.state |= 0x100;
                    this.state &= 0xFFFFFFFD;
                }
                if (parm == TSConfig.EVENT_ID.VAC.ordinal()) {
                    alarm_msg = "***** Vacuum alarm received! Please rectify and reset manually!";
                    if (this.vacDevc != null) {
                        this.vacDevc.setState(TSState.vacstates.TRIPPED.ordinal());
                    }
                    this.state |= 0x200;
                    this.state &= 0xFFFFFFFD;
                }
                if (parm != TSConfig.EVENT_ID.PD.ordinal()) break;
                alarm_msg = "***** PD over VOLTAGE or CURRENT alarm received! For safety, the photdiode device voltage is being set OFF! ";
                if (this.pdDevc != null) {
                    alarm_name = alarm_name + " I= " + this.pdDevc.readCurrent();
                    this.pdDevc.setAbort(true);
                    this.pdDevc.setState(TSState.pwrstates.TRIPPED.ordinal());
                    this.sleep(5.0);
                    this.pdDevc.setAbort(false);
                }
                this.state |= 0x80;
                this.state &= 0xFFFFFFFD;
                break;
            }
            case 3: {
                int ikstate;
                if (parm == TSConfig.EVENT_ID.BIAS.ordinal()) {
                    alarm_name = alarm_name + " V= " + this.biasDevc.readVoltage() + ", I= " + this.biasDevc.readCurrent();
                    ikstate = 0;
                    if (this.biasDevc != null) {
                        ikstate = this.biasDevc.getState();
                    }
                    if (ikstate == TSState.pwrstates.TRIPPED.ordinal()) {
                        LOGGER.error((Object)"already tripped and a manual RESET is required.");
                    } else {
                        ikstate = TSState.pwrstates.OK.ordinal();
                        if (this.biasDevc != null) {
                            this.biasDevc.setState(ikstate);
                        }
                        LOGGER.info((Object)("BIAS device status set to " + TSState.pwrstates.values()[ikstate]));
                    }
                }
                if (parm == TSConfig.EVENT_ID.CRYO.ordinal()) {
                    this.cryoDevc.setState(TSState.cryostates.OK.ordinal());
                }
                if (parm == TSConfig.EVENT_ID.VAC.ordinal() && this.vacDevc != null) {
                    this.vacDevc.setState(TSState.vacstates.OK.ordinal());
                }
                if (parm == TSConfig.EVENT_ID.PD.ordinal()) {
                    alarm_name = alarm_name + " I= " + this.pdDevc.readCurrent();
                    ikstate = 0;
                    if (this.pdDevc != null) {
                        ikstate = this.pdDevc.getState();
                    }
                    if (ikstate == TSState.pwrstates.TRIPPED.ordinal()) {
                        LOGGER.error((Object)"already tripped and a manual RESET is required.");
                    } else {
                        ikstate = TSState.pwrstates.OK.ordinal();
                        if (this.pdDevc != null) {
                            this.pdDevc.setState(ikstate);
                        }
                        LOGGER.info((Object)("PD device status set to " + TSState.pwrstates.values()[ikstate]));
                    }
                }
                this.alertService.clearAllAlerts();
                break;
            }
            default: {
                this.notify = false;
            }
        }
        long tmillis = System.currentTimeMillis();
        if (this.notify && tmillis - this.lastWarningTMillis > this.warningInterval) {
            this.raiseTSAlert(alarm_name, AlertState.ALARM);
            this.lastWarningTMillis = tmillis;
            LOGGER.error((Object)alarm_msg);
            this.lastWarning = this.lastWarning + alarm_name;
            this.lastWarning = alarm_name;
            this.publishState();
            this.soundAlarm();
        }
        return true;
    }

    @Command(name="soundAlarm")
    public void soundAlarm() {
        Runtime r = Runtime.getRuntime();
        try {
            LOGGER.error((Object)("Sending warning sound as requested by " + this.name));
            Process process = r.exec("./make-warning-sound");
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to exec shell command to send warning sound " + ex));
        }
    }

    @Command(name="soundBleep")
    public void soundBleep() {
        Runtime r = Runtime.getRuntime();
        try {
            LOGGER.severe((Object)("Sending bleep sound as requested by " + this.name));
            Process process = r.exec("./make-bleep-sound");
        }
        catch (IOException ex) {
            LOGGER.severe((Object)("Failed to exec shell command to send bleep sound " + ex));
        }
    }

    @Command(name="resetTrip", description="reset trips etc...")
    public void resetTrip() {
        if ((this.state & 0x80) != 0) {
            this.biasDevc.setState(TSState.pwrstates.OFF.ordinal());
            this.state &= 0xFFFFFF7F;
            if ((this.state & 0x100) == 0) {
                this.state |= 2;
            }
        }
        if ((this.state & 0x100) != 0) {
            this.cryoDevc.setState(TSState.cryostates.OFF.ordinal());
            this.state &= 0xFFFFFEFF;
            if ((this.state & 0x80) == 0) {
                this.state |= 2;
            }
        }
        if ((this.state & 0x80) != 0) {
            this.pdDevc.setState(TSState.pwrstates.OFF.ordinal());
            this.state &= 0xFFFFFF7F;
            if ((this.state & 0x100) == 0) {
                this.state |= 2;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Start the TS sub system in the ready state")
    public void startSubSys() throws Exception {
        int iwstate;
        this.state |= 1;
        LOGGER.info((Object)"Starting SubSystem.");
        Object param = null;
        ConfigurationInfo configInfo = this.configurationService.getConfigurationInfo();
        this.tscc.initCatcher(configInfo);
        LOGGER.info((Object)"====== initializing any BIAS device ====== ");
        if (this.biasDevc == null) {
            LOGGER.info((Object)"Bias device not defined");
        } else {
            this.biasDevc.setCurrentLimit(0.0025);
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
                this.biasDevc.setRunBias(this.teststandc.getBiasVAcq(), iwstate);
            }
            this.biasDevc.setCfg(this.teststandc);
            this.state |= 0x400;
        }
        LOGGER.info((Object)"====== initializing any PhotoDiode device ====== ");
        if (this.pdDevc == null) {
            LOGGER.warning((Object)"PhotoDiode device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
            }
            this.pdDevc.setCfg(this.teststandc);
            this.state |= 0x40000;
            this.pdDevc.softReset();
        }
        LOGGER.info((Object)"====== initializing any LED device ====== ");
        if (this.ledDevc == null) {
            LOGGER.warning((Object)"LED device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
            }
            this.state |= TSState.LEDDEVC_ON;
        }
        LOGGER.info((Object)"====== initializing any PDU device ====== ");
        if (this.pduDevc == null) {
            LOGGER.warning((Object)"PDU device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
            }
        }
        LOGGER.info((Object)"====== initializing any CRYO control device ====== ");
        if (this.cryoDevc == null) {
            LOGGER.warning((Object)"Cryo device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
                this.cryoDevc.setRunTemp(this.teststandc.getCryoTAcq(), iwstate);
                try {
                    for (int i = 1; i <= 4; ++i) {
                        this.cryoDevc.setMaxSetPoint(i, 30.0);
                    }
                }
                catch (DriverException e) {
                    LOGGER.error((Object)"Failed attempt to set the cryo device's Max Set Point!");
                }
                try {
                    this.cryoDevc.setType(this.cryoDevc.getCurrent_channel(), "PTC100");
                }
                catch (DriverException e) {
                    LOGGER.error((Object)"Failed attempt to set the cryo device' calibration curve type!");
                }
            }
            this.state |= 0x800;
        }
        LOGGER.info((Object)"====== initializing any Vacuum Gauge device ====== ");
        if (this.vacDevc == null) {
            LOGGER.warning((Object)"VacuumGauge device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
                this.vacDevc.setRunVac(this.teststandc.getVacPAcq(), iwstate);
            }
            this.state |= 0x1000;
        }
        LOGGER.info((Object)"====== initializing any VQM device ====== ");
        if (this.vqmDevc == null) {
            LOGGER.info((Object)"Vacuum Quality Monitor device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
                this.vqmDevc.setRunVac(this.teststandc.getVacPAcq(), iwstate);
            }
            this.state |= 0x80000;
        }
        LOGGER.info((Object)"====== initializing any LAMP device ====== ");
        if (this.lmpDevc == null) {
            LOGGER.warning((Object)"Lamp device not defined");
        } else {
            this.lmpDevc.setType(this.teststandc.getSrcType());
            this.state |= 0x2000;
        }
        LOGGER.info((Object)"====== initializing any MonoChromator device ====== ");
        if (this.monoDevc == null) {
            LOGGER.warning((Object)"Monochromator device not defined");
        } else {
            for (TSConfig.operating_states wstate : TSConfig.operating_states.values()) {
                iwstate = wstate.ordinal();
                this.teststandc.setCfgState(iwstate);
                LOGGER.debug((Object)("setting mono WL for state" + wstate.toString()));
                this.monoDevc.setRunWave(this.teststandc.getLambdaAcq());
            }
            LOGGER.debug((Object)"setting mono filter labels");
            this.monoDevc.setFilterLabels(this.teststandc.getFilters());
            LOGGER.debug((Object)"setting mono filter validity ranges");
            this.monoDevc.setFilterEdges(this.teststandc.getFilter_edges());
            this.state |= 0x4000;
        }
        LOGGER.info((Object)"====== initializing any XED serial device ====== ");
        if (this.fe55Devc == null) {
            LOGGER.warning((Object)"Fe55 device not defined");
        } else {
            this.fe55Devc.retractFe55();
        }
        if (this.shDevc == null) {
            LOGGER.warning((Object)"Shutter device not defined");
        }
        if (this.envDevc == null) {
            LOGGER.warning((Object)"Enviro device not defined");
        } else {
            this.state |= 0x8000;
        }
        LOGGER.info((Object)"====== Completed device initializations ====== ");
        LOGGER.info((Object)"Initializing bias device configuration.");
        if (this.biasDevc != null) {
            this.biasDevc.setCurrentRange(0.001);
            this.biasDevc.setVoltageRange(100.0);
            this.pdDevc.setCurrentRange(0.001);
            this.pdDevc.setBuffSize(3000);
            this.publishState();
        }
        if (this.cryoDevc != null) {
            this.cryoDevc.setUnit(this.cryoDevc.getCurrent_channel(), "C");
            this.publishState();
        }
        this.state |= 2;
        this.publishState();
    }

    @Command(name="isTestStandReady", description="returns 1 if the teststand subsystem is ready for acquisition")
    public int isTestStandReady() throws Exception {
        double HIGH_PRES_LIMIT = 0.001;
        double HIGH_TEMP_LIMIT = 35.0;
        double LOW_TEMP_LIMIT = -130.0;
        double MAX_TEMP_CHANGE = 2.5;
        double MAX_PARTICLE_COUNT = 4.0;
        double BSSILIM = 0.001;
        double vac = 0.0;
        double temp = 0.0;
        double tempstddev = 999.0;
        double tempchange = 0.0;
        double lmppwr = 0.0;
        double partcnt = 0.0;
        double bsscur = 0.0;
        double bss = 0.0;
        if (this.cryoDevc != null) {
            temp = this.cryoDevc.getTemp(this.cryoDevc.getCurrent_channel());
            tempstddev = this.cryoDevc.getTempStdDev();
            tempchange = this.cryoDevc.getTempChange();
            if (!this.cryoDevc.isInControl()) {
                LOGGER.info((Object)"Found cryo device not in control mode. Setting control mode ON.");
                this.cryoDevc.setToControl();
            }
        }
        if (this.vacDevc != null) {
            vac = this.vacDevc.readPressure();
        } else if (this.vqmDevc != null) {
            vac = this.vqmDevc.getLastPres();
        }
        if (this.lmpDevc != null) {
            lmppwr = this.lmpDevc.getLampPower();
        }
        if (this.envDevc != null) {
            partcnt = this.envDevc.getPartCnt();
        }
        if (this.biasDevc != null) {
            bsscur = this.biasDevc.getLastCurrent();
            bss = this.biasDevc.getLastVoltage();
            if (!this.biasDevc.showOutput()) {
                this.raiseTSAlert("THE BIAS SUPPLY OUTPUT APPEARS TO BE DISABLED!!!! PLEASE CHECK.", AlertState.NOMINAL);
            }
        }
        boolean systemOK = true;
        boolean isAlarm = false;
        LOGGER.debug((Object)("lamp power is " + lmppwr + " minimum is " + this.teststandc.getMinLmpPwr() + " | CCD temperature(T=" + temp + " or stddev=" + tempstddev + "normal range is " + this.teststandc.getCryoTAcq() + "+/-" + this.teststandc.getCryoTAcqTol() + " | Dewar pressure, P = " + vac + " should be above " + this.teststandc.getVacPAcq()));
        String warning = "Warning: " + this.configName + " - " + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())) + " - ";
        this.state &= ~(TSState.CRYO_DEV_WARNING | TSState.VAC_DEV_WARNING);
        if (bsscur > 0.001 && Math.abs(bss) > 0.0 && this.biasDevc.readCurrent() > 0.001) {
            systemOK = false;
            warning = warning.replace("Warning", "ALARM");
            warning = warning + "overcurrent on the BSS line!\n";
            isAlarm = true;
            this.raiseTSAlert(warning, AlertState.ALARM);
            this.biasDevc.setOutput(0);
            this.soundAlarm();
            LOGGER.error((Object)"Identified dangerous conditions for the sensor. BSS output disabled!");
        }
        if (vac > 0.001 && this.last_vac > 0.001 && temp < 5.0 && vac < 2000.0) {
            systemOK = false;
            warning = warning.replace("Warning", "ALARM");
            warning = warning + "DANGEROUS T/P CONDITIONS! T=" + temp + " P=" + vac + "\n";
            isAlarm = true;
            this.raiseTSAlert(warning, AlertState.ALARM);
            this.soundAlarm();
            LOGGER.error((Object)"Identified dangerous conditions for the sensor.");
        }
        if (partcnt > 4.0) {
            systemOK = false;
            warning = warning + "HIGH PARTICLE COUNT! PCNT=" + partcnt + "\n";
            isAlarm = true;
            this.raiseTSAlert(warning, AlertState.ALARM);
            this.soundAlarm();
            LOGGER.error((Object)"ALERT!!! HIGH PARTICLE COUNT DETECTED.");
        }
        if ((tempchange > 2.5 || temp > 35.0 || temp < -130.0) && temp > -274.0) {
            systemOK = false;
            warning = warning + "DANGEROUS TEMP RISE T=" + temp + " delta_T=" + tempchange + "\n";
            this.raiseTSAlert(warning, AlertState.ALARM);
            isAlarm = true;
            this.soundAlarm();
            LOGGER.error((Object)"Identified dangerous temperature or temperature rise.");
            if (temp > -130.0 && temp < 35.0) {
                LOGGER.error((Object)"HALTING temperature change.");
                this.cryoDevc.rampTemp(60.0, temp, 10);
            }
            if (temp > 35.0) {
                LOGGER.error((Object)"Setting controller to achieve room temperature AND  POWERING OFF THE CCD!!!!!");
                warning = warning + "POWERING OFF THE CCD";
                this.cryoDevc.rampTemp(60.0, 25.0, 10);
                KeyValueData kd = new KeyValueData("TS_Hazard", (Serializable)((Object)"SensorHazard: Environment concern."));
                this.subsys.publishSubsystemDataOnStatusBus(kd);
            }
        }
        if (temp > this.teststandc.getCryoTAcq() + this.teststandc.getCryoTAcqTol() || tempstddev > this.teststandc.getCryoTAcqTol()) {
            systemOK = false;
            this.state |= TSState.CRYO_DEV_WARNING;
            warning = warning + "CCD temperature(T=" + temp + " or stddev=" + tempstddev + " not in range " + this.teststandc.getCryoTAcq() + "+/-" + this.teststandc.getCryoTAcqTol() + "\n";
            this.raiseTSAlert(warning, AlertState.WARNING);
        }
        if (vac > this.teststandc.getVacPAcq()) {
            systemOK = false;
            this.state |= TSState.VAC_DEV_WARNING;
            warning = warning + "Dewar pressure too high, P = " + vac + "\n";
        }
        if (lmppwr < this.teststandc.getMinLmpPwr()) {
            warning = warning + "The lamp doesn't appear to be at the requisite power:\nlamp power is " + lmppwr + ", minimum is " + this.teststandc.getMinLmpPwr() + "\n";
        }
        this.last_vac = vac;
        if (systemOK != this.last_systemOK) {
            this.nwarn = 0;
        }
        this.last_systemOK = systemOK;
        long tmillis = System.currentTimeMillis();
        if (!systemOK && tmillis - this.lastWarningTMillis > this.warningInterval) {
            this.lastWarningTMillis = tmillis;
            LOGGER.error((Object)warning);
            if (isAlarm) {
                warning = warning.replace("Warning", "ALARM");
                this.soundAlarm();
                this.publishState();
                System.out.println("About to distribute alarm message.");
                try {
                    String ccsmaillist;
                    String ccsmail = System.getenv("CCSmail");
                    if (ccsmail == null) {
                        ccsmail = "ssh ccdtest@astroracf mail -s ";
                    }
                    if ((ccsmaillist = System.getenv("CCSmaillist")) == null) {
                        ccsmaillist = this.configName.toLowerCase().indexOf("bnl") >= 0 && this.configName.toLowerCase().indexOf("sim") < 0 ? "homer@slac.stanford.edu,homerneal@yahoo.fr,2034356858@tmomail.net" : "homer@slac.stanford.edu,homerneal@yahoo.fr,2034356858@tmomail.net";
                    }
                    String mailalarm = ccsmail + " \"" + warning + "\" " + ccsmaillist;
                    LOGGER.error((Object)("Sending alarm message: " + mailalarm));
                    Runtime r = Runtime.getRuntime();
                    Process p = r.exec(mailalarm);
                    this.sleep(5.0);
                    if (p.isAlive()) {
                        p.destroy();
                    }
                }
                catch (IOException ex) {
                    LOGGER.error((Object)("Failed to exec shell command to send alarm message " + ex));
                }
            }
            this.lastWarning = this.lastWarning + warning;
        }
        if (systemOK && this.alertService.getRaisedAlertSummary().getAlertState() != AlertState.NOMINAL) {
            this.alertService.clearAllAlerts();
        }
        if ((this.state & 0x10000) != 0) {
            systemOK = true;
        }
        return systemOK ? 1 : 0;
    }

    @Command(description="set configured bias target")
    public void setCfgBiasVAcq(double Vacq, int cfgstate) throws Exception {
        this.teststandc.setBiasVAcq(Vacq, cfgstate);
        this.biasDevc.setRunBias(Vacq, cfgstate);
    }

    @Command(description="set configured cryo T target")
    public void setCfgCryoTAcq(double Tacq, int cfgstate) throws Exception {
        this.teststandc.setCryoTAcq(Tacq, cfgstate);
        this.cryoDevc.setRunTemp(Tacq, cfgstate);
    }

    void doStandardVRamp() throws Exception {
        if (this.biasDevc != null) {
            double actual_bias = this.biasDevc.readVoltage();
            double target_bias = this.teststandc.getBiasVAcq();
            double safe_rate = 0.8333333333333334;
            double duration = Math.abs(target_bias - actual_bias) / safe_rate;
            if (!this.biasDevc.showOutput()) {
                LOGGER.error((Object)"***************************************************************");
                LOGGER.error((Object)"***************************************************************");
                LOGGER.error((Object)"***************************************************************");
                LOGGER.error((Object)"THE BIAS SUPPLY OUTPUT APPEARS TO BE DISABLED!!!! PLEASE CHECK.");
                LOGGER.error((Object)"THE BIAS SUPPLY OUTPUT APPEARS TO BE DISABLED!!!! PLEASE CHECK.");
                LOGGER.error((Object)"THE BIAS SUPPLY OUTPUT APPEARS TO BE DISABLED!!!! PLEASE CHECK.");
                LOGGER.error((Object)"***************************************************************");
                LOGGER.error((Object)"***************************************************************");
                LOGGER.error((Object)"***************************************************************");
                this.raiseTSAlert("THE BIAS SUPPLY OUTPUT APPEARS TO BE DISABLED!!!! PLEASE CHECK.", AlertState.ALARM);
            }
            System.out.println("The current bias voltage is " + actual_bias);
            System.out.println("The target bias is " + target_bias);
            System.out.println("The duration chosen for a safe ramp is " + duration);
            if (duration > 0.1) {
                this.biasDevc.rampVolts(duration, target_bias, 10);
            } else {
                this.biasDevc.setVoltage(target_bias);
            }
        }
    }

    @Command(name="goTestStand", description="put in mode for acquisition")
    public int goTestStand() throws Exception {
        LOGGER.error((Object)("We are ready to go and BIAS ramping can now procede: state = " + this.state));
        switch (this.state & 0x3000E) {
            case 2: {
                LOGGER.error((Object)("Ramping BIAS voltage to that set for state READY, V=" + this.teststandc.getBiasVAcq()));
                this.doStandardVRamp();
                break;
            }
            case 4: {
                LOGGER.error((Object)("Ramping BIAS voltage to that set for state ACQ1, V=" + this.teststandc.getBiasVAcq()));
                this.doStandardVRamp();
                break;
            }
            case 8: {
                LOGGER.error((Object)"Ramping BIAS voltage to that set for state WARM");
                this.doStandardVRamp();
                break;
            }
            case 65536: {
                LOGGER.error((Object)"Ramping BIAS voltage to that set for state TEST");
                this.doStandardVRamp();
                break;
            }
            case 131072: {
                LOGGER.error((Object)"Ramping BIAS voltage to that set for state EXPERT");
                this.doStandardVRamp();
                break;
            }
            default: {
                LOGGER.error((Object)"Trying to go to acquisition go state without being in acquisition mode!");
            }
        }
        return 1;
    }

    @Command(description="set flags corresponding to the specified operating state")
    void setStateFlags(TSConfig.operating_states ostate) throws Exception {
        this.teststandc.setCfgState(ostate.ordinal());
        int mask = 196654;
        this.state &= ~mask;
        switch (ostate) {
            case EXPERT: {
                this.state |= 0x20000;
                break;
            }
            case READY: {
                this.state |= 2;
                break;
            }
            case ACQ1: {
                this.state |= 4;
                break;
            }
            case WARM: {
                this.state |= 8;
                break;
            }
            case TEST: {
                this.state |= 0x10000;
                break;
            }
            case IDLE: {
                this.state |= 0x20;
                break;
            }
            default: {
                throw new Exception("INVALID ACQUISITION STATE!");
            }
        }
    }

    void setStandardState() throws Exception {
        if (this.monoDevc != null) {
            this.monoDevc.setWave(this.teststandc.getLambdaAcq());
        }
        double vac = this.getPressure();
        if (this.cryoDevc != null) {
            double target_temp = this.teststandc.getCryoTAcq();
            String chan = this.cryoDevc.getCurrent_channel();
            boolean loop = true;
            double actual_temp = this.cryoDevc.getTemp(chan);
            if (actual_temp < -200.0 || target_temp < -170.0 || target_temp > 25.0) {
                LOGGER.error((Object)"BOGUS current temp. Aborting cryo temp ramp request!!!");
            } else if ((this.vacDevc == null && this.vqmDevc == null || vac > this.teststandc.getVacPAcq()) && target_temp < 0.0) {
                LOGGER.error((Object)"THE VACUUM IS EITHER NOT BEING MONITORED OR THE VACUUM LEVEL IS TOO HIGH\nWE CAN NOT RAMP DOWN THE TEMPERATURE IN THIS CONDITION!!!!");
            } else if (Math.abs(target_temp - actual_temp) > this.teststandc.getCryoTAcqTol()) {
                double safe_rate = 0.016666666666666666;
                double duration = Math.abs(target_temp - actual_temp) / safe_rate;
                System.out.println("The current temperature is " + actual_temp + "C");
                System.out.println("The target temperature is " + target_temp + "C");
                System.out.println("The duration chosen for a safe ramp is " + duration + "s");
                int nsteps = (int)(2.0 * duration / 60.0);
                if (nsteps == 0) {
                    nsteps = 1;
                }
                this.cryoDevc.rampTemp(duration, target_temp, nsteps);
            }
        }
    }

    @Command(name="getPressure", description="return the last pressure reading from whatever gauge is active")
    public double getPressure() {
        double vac = 1000.0;
        if (this.vacDevc != null) {
            vac = this.vacDevc.getLastPres();
        }
        if (this.vqmDevc != null && (vac == 0.0 || vac > 900.0)) {
            vac = this.vqmDevc.getLastPres();
        }
        return vac;
    }

    @Command(name="setTSStateByName", description="set TS subsystem to state indicated by the string")
    public int setTSStateByName(String statename) {
        try {
            if (statename.toUpperCase().contains("IDLE")) {
                return this.setTSIdle();
            }
            if (statename.toUpperCase().contains("READY")) {
                return this.setTSReady();
            }
            if (statename.toUpperCase().contains("WARM")) {
                return this.setTSWarm();
            }
            if (statename.toUpperCase().contains("ACQ1")) {
                return this.setTSAcq1();
            }
            if (statename.toUpperCase().contains("TEST")) {
                return this.setTSTEST();
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to set the requested state: " + ex));
        }
        return -1;
    }

    @Command(type=Command.CommandType.QUERY, name="setTSIdle", description="set TS subsystem to the idle state")
    public int setTSIdle() throws Exception {
        this.setStateFlags(TSConfig.operating_states.IDLE);
        this.setStandardState();
        LOGGER.info((Object)"Set state to IDLE.");
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="setTSReady", description="set TS subsystem to the ready state")
    public int setTSReady() throws Exception {
        this.setStateFlags(TSConfig.operating_states.READY);
        this.setStandardState();
        LOGGER.info((Object)"Set state to READY.");
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="setTSAcq1", description="set TS subsystem to the ACQ1 state")
    public int setTSAcq1() throws Exception {
        this.setStateFlags(TSConfig.operating_states.ACQ1);
        this.setStandardState();
        LOGGER.info((Object)"Set state to ACQ1.");
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="setTSWarm", description="set TS subsystem to the WARM state")
    public int setTSWarm() throws Exception {
        this.setStateFlags(TSConfig.operating_states.WARM);
        this.setStandardState();
        LOGGER.info((Object)"Set state to WARM.");
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="setTSTEST", description="set TS subsystem to the TEST state")
    public int setTSTEST() throws Exception {
        this.setStateFlags(TSConfig.operating_states.TEST);
        this.setStandardState();
        LOGGER.info((Object)"Set state to TEST.");
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="setTSEXPERT", description="EXPERTS ONLY!!")
    public int setTSEXPERT() throws Exception {
        this.setStateFlags(TSConfig.operating_states.EXPERT);
        this.setStandardState();
        LOGGER.info((Object)"Set state to EXPERT.");
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="eoSetupPreCfg", description="prepare for eo acquisition")
    public int eoSetupPreCfg() {
        return this.eoSetupPreCfg("setTSReady");
    }

    @Command(type=Command.CommandType.QUERY, name="eoSetupPreCfg", description="prepare for eo acquisition")
    public int eoSetupPreCfg(@Argument(name="state1", description="IDLE,WARM,READY,TEST,ACQ1") String state1) {
        LOGGER.info((Object)"doing initialization");
        this.pdDevc.softReset();
        LOGGER.info((Object)("setting teststand to state: " + state1));
        this.setTSStateByName(state1);
        try {
            this.goTestStand();
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to finalize acquisition preparation: " + ex));
        }
        return 1;
    }

    @Command(type=Command.CommandType.QUERY, name="eoSetupPostCfg", description="prepare for eo acquisition")
    public int eoSetupPostCfg(@Argument(name="vac_outlet", description="PDU outlet number for the vacuum gauge") int vac_outlet) throws Exception {
        return this.eoSetupPostCfg(vac_outlet, "setTSTEST");
    }

    @Command(type=Command.CommandType.QUERY, name="eoSetupPostCfg", description="prepare for eo acquisition")
    public int eoSetupPostCfg(@Argument(name="vac_outlet", description="PDU outlet number for the vacuum gauge") int vac_outlet, @Argument(name="state2", description="IDLE,WARM,READY,TEST,ACQ1") String state2) throws Exception {
        LOGGER.info((Object)"setting acquisition state");
        this.pduDevc.setOutletState(vac_outlet, false);
        this.setTSStateByName(state2);
        LOGGER.info((Object)"wait for ts state to become ready");
        int tsstate = 0;
        long starttim = this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis();
        while (true) {
            LOGGER.info((Object)"checking for test stand to be ready for acq");
            try {
                tsstate = this.isTestStandReady();
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Failed to accomplish readiness check!");
            }
            if (this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis() - starttim > 10800L) {
                LOGGER.info((Object)"Something is wrong ... we will never make it to a runnable state");
                throw new Exception("Not succeeding in reaching target conditions! ABORTING!");
            }
            if (tsstate != 0) break;
            this.sleep(5.0);
        }
        LOGGER.info((Object)"operating conditions achieved");
        LOGGER.info((Object)"We are ready to go! Ramping the BP bias voltage now.");
        try {
            this.goTestStand();
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to finalize acquisition preparation: " + ex));
        }
        this.sleep(5.0);
        return 1;
    }

    @Command(name="showBiasVAcq", description="returns the acquisition bias voltage set point")
    public double showBiasVAcq() {
        return this.teststandc.getBiasVAcq();
    }

    @Command(name="getReqSlitWidth", description="returns the req. slit width for a given wl")
    public int getReqSlitWidth(double wl) {
        return this.teststandf.getRequiredSlitWidth(wl);
    }

    @Command(name="setSlitWidthFile", description="sets the slit width data file")
    public void setSlitWidthFile(String fl) {
        this.teststandf.setTSFluxCalibFile(fl);
    }

    @Command(name="reconnectVQM", description="reconnect to the VQM port")
    public void reconnectVQM() throws DriverException {
        this.vqmDevc.reconnect();
    }

    @Command(name="stopsubsys", type=Command.CommandType.ACTION, description="Stop and set the TS sub system into the ready state")
    public void stopSubSys() {
        LOGGER.error((Object)"Stop Subsystem message received.");
        this.raiseTSAlert("STOP SUBSYSTEM CALLED", AlertState.ALARM);
        this.state &= 0xFFFFFFFD;
        this.publishState();
        if (this.biasDevc != null) {
            LOGGER.info((Object)"Ramping down bias voltage.");
            this.rampBiasVolts(3.0, 0.0, 10);
            this.setBiasOutput(0);
            LOGGER.error((Object)"BIAS output disabled!");
            this.raiseTSAlert("THE BIAS SUPPLY OUTPUT IS DISABLED!!!!", AlertState.ALARM);
            this.publishState();
        }
        if (this.cryoDevc != null) {
            LOGGER.info((Object)"Stopping any temperature ramp.");
            this.cryoDevc.setState(TSState.cryostates.TRIPPED.ordinal());
        }
        this.state |= 0x20;
        this.publishState();
    }

    @Command(name="saveconfig", type=Command.CommandType.ACTION, description="Saves the current configuration")
    public void saveConfiguration() throws IOException {
        try {
            this.configurationService.saveAllChanges();
        }
        catch (Exception ex) {
            LOGGER.warning((Object)("Failed to save all changes " + ex));
        }
        LOGGER.info((Object)"Saved configuration.");
    }

    @Command(name="printfullstate", type=Command.CommandType.QUERY, description="Prints the full test stand state")
    public String printFullState() {
        TSState teststandState = new TSState(this.state, this.teststandc.getCfgstate(), (int)this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis());
        this.getDevStates(teststandState);
        StringBuilder sb = new StringBuilder();
        sb.append("TSStateStatus :  (");
        sb.append(teststandState.toString());
        sb.append(")");
        return sb.toString();
    }

    @Command(name="getstate", type=Command.CommandType.QUERY, description="Returns the current value of the TS state")
    public int getState() {
        return this.state;
    }

    public TSConfig getTeststandc() {
        return this.teststandc;
    }

    @Command(name="setstate", type=Command.CommandType.QUERY, description="sets the current value of the TS state")
    public void setState(int state) {
        this.state = state;
        this.publishState();
    }

    private void sleep(double secs) {
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            LOGGER.error((Object)("Rude awakening!" + ex));
        }
    }

    @Command(name="publishState", type=Command.CommandType.QUERY, description="publishes the TS state")
    public void publishState() {
        LOGGER.debug((Object)"Entering pubishState");
        TSState teststandState = new TSState(this.state, this.teststandc.getCfgstate(), (int)this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis());
        this.getDevStates(teststandState);
        KeyValueData kd = new KeyValueData("TSState", (Serializable)teststandState);
        this.subsys.publishSubsystemDataOnStatusBus(kd);
        LOGGER.debug((Object)"published state");
        this.lastWarning = "";
    }

    void getDevStates(TSState tst) {
        try {
            if (this.biasDevc != null) {
                tst.setVolts(this.biasDevc.getLastVoltage());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve BIAS device voltage status value for publishing!");
        }
        try {
            if (this.biasDevc != null) {
                tst.setBIAS_curr(this.biasDevc.getLastCurrent());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve BIAS device current status value for publishing!");
        }
        try {
            if (this.biasDevc != null) {
                tst.setBIASon(this.biasDevc.showOutput() ? 1 : 0);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve BIAS device output status value for publishing!");
        }
        try {
            if (this.pdDevc != null) {
                tst.setCurr(this.pdDevc.getLastCurrent());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve PhotoDiode device current value for publishing!");
        }
        try {
            if (this.cryoDevc != null) {
                tst.setTemp(this.cryoDevc.getTemp(this.cryoDevc.getCurrent_channel()));
                tst.setTemp2(this.cryoDevc.getTemp(this.cryoDevc.getCurrent_channel2()));
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"failed to retrieve CRYO device status value for publishing!");
        }
        try {
            if (this.vqmDevc != null) {
                tst.setVac2(this.vqmDevc.getLastPres());
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"failed to retrieve VQM pressure value for publishing!");
        }
        try {
            if (this.vacDevc != null) {
                tst.setVac(this.vacDevc.getLastPres());
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"failed to retrieve VAC device status value for publishing!");
        }
        try {
            if (this.lmpDevc != null) {
                tst.setLmpPwr(this.lmpDevc.getLampPower());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve LAMP I device status value for publishing!");
        }
        try {
            if (this.monoDevc != null) {
                tst.setWl(this.monoDevc.getLastwl());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve MONO WL device status value for publishing!");
        }
        try {
            if (this.monoDevc != null) {
                tst.setSw1((double)this.monoDevc.getLastSW1());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve MONO SW1 device status value for publishing!");
        }
        try {
            if (this.monoDevc != null) {
                tst.setSw2((double)this.monoDevc.getLastSW2());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve MONO SW2 device status value for publishing!");
        }
        int fltpos = 0;
        try {
            if (this.monoDevc != null) {
                fltpos = this.monoDevc.getLastfltpos();
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve MONO FLTR device status value for publishing!");
        }
        try {
            if (this.fe55Devc != null) {
                tst.setXedpos(this.fe55Devc.getExtend_retract());
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"failed to retrieve Fe55 device status value for publishing!");
        }
        try {
            if (this.monoDevc != null) {
                tst.setShutpos(this.monoDevc.getLastshut());
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve MONO SHUTTER device status value for publishing!");
        }
        try {
            tst.setSrctype(this.teststandc.getSrcType());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve LAMP TYPE device status value for publishing!");
        }
        try {
            tst.setMonotype(this.teststandc.getMonoType());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve MONO TYPE device status value for publishing!");
        }
        try {
            tst.setPDcnt(this.teststandc.getPDcnt());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve PD DEVICE count status value for publishing!");
        }
        try {
            tst.setPDnplc(this.teststandc.getPDnplc());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve PD device nplc status value for publishing!");
        }
        try {
            tst.setPDtype(this.teststandc.getPDType());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve PD device type status value for publishing!");
        }
        try {
            tst.setBIAStype(this.teststandc.getBIASType());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve PD DEVICE device status value for publishing!");
        }
        try {
            if (this.monoDevc != null) {
                tst.setFilter(this.monoDevc.getFilterLabel(fltpos));
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to retrieve FILTER LABEL device status value for publishing!");
        }
        try {
            if (this.lastWarning.length() > 0) {
                LOGGER.info((Object)("Writing warning message to DB: " + this.lastWarning));
                LOGGER.info((Object)("Warning message length = " + this.lastWarning.length()));
                tst.setWarning(this.lastWarning.substring(0, Math.min(254, this.lastWarning.length())));
            } else {
                tst.setWarning("");
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed to set warning!");
        }
    }

    @Command(name="isDoTestStandReadyCheck", type=Command.CommandType.QUERY, description="check whether the test stand ready check is being done")
    public boolean isDoTestStandReadyCheck() {
        return this.doTestStandReadyCheck;
    }

    @Command(name="setDoTestStandReadyCheck", type=Command.CommandType.QUERY, description="set the test stand ready check on(true)/off(false)")
    public void setDoTestStandReadyCheck(boolean doTestStandReadyCheck) {
        this.doTestStandReadyCheck = doTestStandReadyCheck;
    }

    protected Object sendSyncTSCommand(String name, Object ... params) {
        try {
            return this.cmu.sendSynchronousCommand(new CommandRequest(teststand_dest, name, params), Duration.ofMillis(30000L));
        }
        catch (Exception e) {
            LOGGER.warning((Object)("Unable to perform jgroup communication with destination + " + teststand_dest + " - Exception " + e));
            return null;
        }
    }

    private void rampBiasVolts(double time, double value) {
        try {
            this.biasDevc.rampVolts(time, value);
        }
        catch (DriverException e) {
            LOGGER.error((Object)"Error while ramping voltage", (Throwable)e);
        }
    }

    private void rampBiasVolts(double time, double value, int nsteps) {
        try {
            this.biasDevc.rampVolts(time, value, nsteps);
        }
        catch (DriverException e) {
            LOGGER.error((Object)"Error while ramping voltage", (Throwable)e);
        }
    }

    private void setBiasOutput(int on) {
        try {
            this.biasDevc.setOutput(on);
        }
        catch (DriverException e) {
            LOGGER.error((Object)"Error while setting output voltage state", (Throwable)e);
        }
    }
}

