/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.N6487;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.BiasDevice;
import org.lsst.ccs.subsystem.teststand.PhotoDiodeDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class KeithleyDevice
extends Device
implements BiasDevice,
PhotoDiodeDevice {
    public static final int CHAN_VOLTAGE = 0;
    public static final int CHAN_CURRENT = 1;
    public static final int NUM_CHANS = 2;
    private static final Map<String, DriverConstants.ConnType> connTypeMap = new HashMap<String, DriverConstants.ConnType>();
    @ConfigurationParameter(isFinal=true, description="connection type (FTDI or SERIAL)")
    private String connType;
    @ConfigurationParameter(isFinal=true, description="port Id")
    private String devName;
    @ConfigurationParameter(isFinal=true, description="baud rate (0 for default)")
    private int baudRate;
    private double[] runBias = new double[TSConfig.MAXSTATES];
    private final N6487 n64 = new N6487();
    private DriverConstants.ConnType connTypeE;
    TSConfig cfg = null;
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    IDataPointSetFactory dpsf = null;
    private double lastCurrent;
    private double lastVoltage;
    private int plotidx = 0;
    private boolean doPDPlot = false;

    protected void initDevice() {
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"connType", (String)"not specified");
        }
        this.connTypeE = connTypeMap.get(this.connType.toUpperCase());
        if (this.connTypeE == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"connType", (String)"is invalid");
        }
        if (this.devName == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"devName", (String)"not specified");
        }
        if (this.baudRate == 0) {
            this.log.info((Object)"Using default baud rate (19200)");
        }
        this.fullName = "Keithley N6487 (" + this.devName + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.n64.open(this.connTypeE, this.devName, this.baudRate);
                this.setOnline(true);
                this.initSensors();
                this.kstate = TSState.pwrstates.OK;
                this.log.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.n64.close();
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 2) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        if (chan == 0) {
            value = this.readVoltage();
            if (value < -998.0 || value > 9.8E36) {
                value = Double.NaN;
            }
        } else if (chan == 1 && ((value = this.readCurrent()) < -998.0 || value > 9.8E36)) {
            value = Double.NaN;
        }
        return value;
    }

    @Override
    public void setCfg(TSConfig cfg) {
        this.cfg = cfg;
    }

    @Override
    public void setDPSF(IDataPointSetFactory dpsf) {
        this.dpsf = dpsf;
    }

    @Command(name="setarmcount", description="Set the ARM count")
    public void setArmCount(@Argument(name="count", description="ARM count") int count) throws DriverException {
        this.n64.setArmCount(count);
    }

    @Command(name="settrigcount", description="Set the trigger count")
    public void setTrigCount(@Argument(name="value", description="trigger count") int value) throws DriverException {
        this.n64.setTrigCount(value);
    }

    @Override
    @Command(name="setdisplay", description="Set the display")
    public void setDisplay(@Argument(name="OnOff", description="true(ON)/false(OFF)") boolean dstate) throws DriverException {
        this.n64.setDisplay(dstate);
    }

    @Command(name="clrbuff", description="Clears the Keithley read buffer")
    public void clearBuffer() throws DriverException {
        this.n64.clrBuff();
    }

    @Command(type=Command.CommandType.QUERY, name="readCurrents", description="Read a set of currents")
    public double[][] readCurrents(@Argument(name="nreads", description="#reads (armcount)") int nreads, @Argument(name="nplc", description="#Pulse Line Counts btwn reads (0.01->60.)") double nplc) throws DriverException {
        return this.n64.readCurrents(nreads, nplc);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="accumBuffer", description="start the buffer accumulation")
    public double accumBuffer(@Argument(name="nreads", description="#reads (armcount)") int nreads, @Argument(name="nplc", description="#Pulse Line Counts btwn reads (0.01->60.)") double nplc) {
        return this.accumBuffer(nreads, nplc, true);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="accumBuffer", description="start the buffer accumulation")
    public double accumBuffer(@Argument(name="nreads", description="#reads (armcount)") int nreads, @Argument(name="nplc", description="#Pulse Line Counts btwn reads (0.01->60.)") double nplc, @Argument(name="wait", description="to wait (true) or not to (false)") boolean wait) {
        if (this.cfg != null) {
            this.cfg.setPDcnt(nreads);
            this.cfg.setPDnplc(nplc);
        }
        try {
            this.n64.accumBuffer(nreads, nplc);
        }
        catch (DriverException e) {
            this.log.error((Object)"Failed to prep device for doing accumulations.", (Throwable)e);
        }
        return nplc / 60.0 * (double)nreads;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="waitAccum", description="wait for accumulation completion")
    public void waitAccum(@Argument(description="Timeout (sec)") double timeout) throws DriverException {
        this.n64.waitAccum(timeout);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="readBuffer", description="read the buffer")
    public double[][] readBuffer() throws DriverException {
        this.waitAccum(60.0);
        double[][] buff = this.n64.readBuffer();
        if (this.isDoPDPlot()) {
            this.log.error((Object)"doing new aidaplots");
            KeyValueDataList plots = new KeyValueDataList();
            this.log.debug((Object)"declaring pdthst");
            this.plotidx = this.plotidx % 3 + 1;
            IDataPointSet pdthst = this.dpsf.create("CurrentHist" + this.plotidx, "Current Reading vs. time(s) - Date:" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())), 2);
            this.log.debug((Object)"filling pdthst");
            for (int i = 0; i < buff[0].length; ++i) {
                pdthst.addPoint();
                pdthst.point(i).coordinate(0).setValue(buff[1][i]);
                pdthst.point(i).coordinate(0).setErrorPlus(0.0);
                pdthst.point(i).coordinate(1).setValue(buff[0][i]);
                pdthst.point(i).coordinate(1).setErrorPlus(0.0);
                pdthst.point(i).coordinate(1).setErrorMinus(0.0);
            }
            try {
                this.log.debug((Object)"doing new addplots");
                plots.addData("dataPointSet", (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)pdthst)));
            }
            catch (IOException ex) {
                this.log.error((Object)"Unable to create XML rep of AidPlot object!", (Throwable)ex);
            }
            this.log.info((Object)"publishing plot");
            KeyValueData kd = new KeyValueData("PDtimeHist", (Serializable)plots);
            this.s.publishSubsystemDataOnStatusBus(kd);
        }
        return buff;
    }

    @Command(type=Command.CommandType.QUERY, name="readBuffer", description="read the buffer and dump to file")
    public double[][] readBuffer(@Argument(name="filename", description="output filename for the Keithley buffered values") String filename) throws DriverException {
        double[][] buff = this.readBuffer();
        FileWriter fstream = null;
        File pdFl = new File(filename);
        try {
            if (pdFl.exists()) {
                pdFl.delete();
            }
            pdFl.createNewFile();
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to create file (" + filename + ") for reason "), (Throwable)e);
        }
        try {
            fstream = new FileWriter(pdFl);
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to open writer stream for file (" + filename + ") for reason "), (Throwable)e);
        }
        try {
            if (fstream != null) {
                this.log.info((Object)"writing file of buffered values from either Bias or PhotoDiode device");
                BufferedWriter out = new BufferedWriter(fstream);
                for (int i = 0; i < buff[0].length; ++i) {
                    String line = buff[1][i] + " " + buff[0][i];
                    try {
                        out.write(line);
                        out.newLine();
                        out.flush();
                        continue;
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Error writing file: " + e));
                    }
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.log.error((Object)("Error closing file: " + e));
                }
            }
        }
        catch (Exception ee) {
            this.log.error((Object)("Failed to remove and create a new file: " + ee));
        }
        return buff;
    }

    @Command(type=Command.CommandType.QUERY, name="readBuffer", description="read the buffer and dump to file")
    public double[][] readBuffer(@Argument(name="filename", description="output filename for the Keithley buffered values") String filename, @Argument(name="host", description="user@host") String host) throws IOException, DriverException {
        String[] fsplit = filename.split("/");
        String flocal = "/tmp/" + fsplit[fsplit.length - 1];
        this.log.info((Object)("Storing temporary data at " + flocal + " then copying to " + filename));
        double[][] data = this.readBuffer(flocal);
        Runtime r = Runtime.getRuntime();
        String execStr = "scp -p " + flocal + " " + host + ":" + filename;
        this.log.info((Object)("Executing: " + execStr));
        Process p = r.exec(execStr);
        return data;
    }

    @Command(name="readBufferStr", description="read the buffer and returns as a string")
    public String readBufferStr() throws DriverException {
        this.n64.waitAccum(60.0);
        double[][] data = this.n64.readBuffer();
        return "Data = " + this.getString(data[0]) + "\n Times = " + this.getString(data[1]) + "\n";
    }

    @Override
    @Command(name="setBuffSize", description="Set the buffer size.")
    public void setBuffSize(@Argument(description="buffer size") int value) throws DriverException {
        this.n64.setBuffSize(value);
    }

    @Override
    @Command(name="setVoltageRange", description="Set the voltage range. Can be 10V, 50V or 500V")
    public void setVoltageRange(@Argument(description="Voltage Range to set") double value) throws DriverException {
        this.n64.setVoltageRange(value);
    }

    @Override
    @Command(name="setVoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        if (this.kstate.equals((Object)TSState.pwrstates.OK) || this.kstate.equals((Object)TSState.pwrstates.OFF) || this.kstate.equals((Object)TSState.pwrstates.ON)) {
            this.n64.setVoltage(value);
        } else {
            this.log.error((Object)("Unable to set output because state = " + this.kstate.toString()));
        }
    }

    @Override
    @Command(name="setChannel", description="not implemented")
    public void setChannel(@Argument(name="value", description="Channel to select") int value) {
    }

    @Override
    @Command(name="setVoltageAcq", description="Set the voltage to the acquisition set point")
    public void setVoltageAcq(int cfgstate) throws DriverException {
        this.rampVolts(5.0, this.getRunBias(cfgstate));
    }

    @Override
    @Command(name="setAvgOn", description="Control whether the averaging is on")
    public void setAvgOn(boolean doAvg) throws DriverException {
        this.n64.setDo_avg(doAvg);
    }

    @Override
    @Command(name="setNAvg", description="Controls have many samples to average over")
    public void setNAvg(int nAvg) throws DriverException {
        this.n64.setnAvg(nAvg);
    }

    @Override
    @Command(name="getAvgState", description="true = averaging on")
    public boolean getAvgState() throws DriverException {
        return this.n64.isDo_avg();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampVolts", description="ramp the voltage")
    public void rampVolts(@Argument(description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(description="Voltage to ramp to") double value) throws DriverException {
        this.n64.rampVolts(duration, value);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampVolts", description="ramp the voltage")
    public void rampVolts(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Voltage to ramp to") double value, @Argument(name="nsteps", description="number of steps") int nsteps) throws DriverException {
        this.n64.rampVolts(duration, value, nsteps);
    }

    @Override
    @Command(description="return last current measurement")
    public double getLastCurrent() {
        return this.lastCurrent;
    }

    @Deprecated
    @Command(description="return last current measurement")
    public double getLast_curr() {
        return this.getLastCurrent();
    }

    @Override
    @Command(description="return last voltage measurement")
    public double getLastVoltage() {
        return this.lastVoltage;
    }

    @Deprecated
    @Command(description="return last voltage measurement")
    public double getLast_volt() {
        return this.getLastVoltage();
    }

    @Command(description="Show the set voltage")
    public double getVoltage() throws DriverException {
        return this.n64.getVoltage();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Read the actual voltage")
    public double readVoltage() {
        double volt = 0.0;
        try {
            if (this.n64.isOkToTalk()) {
                this.lastVoltage = volt = this.n64.readVoltage();
                this.kstate = TSState.pwrstates.ON;
            } else {
                volt = this.lastVoltage;
            }
        }
        catch (DriverException e) {
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
            this.log.error((Object)"Keithley driver failed to read voltage!");
        }
        return volt;
    }

    @Override
    @Command(name="setCurrentRange", description="Set the current range")
    public void setCurrentRange(@Argument(description="Current Range to set") double value) throws DriverException {
        this.n64.setCurrentRange(value);
    }

    @Command(name="zeroCorrectCurrent", description="Zero correct the current")
    public void zeroCorrectCurrent() throws DriverException {
        this.n64.zeroCorrectCurrent();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="readCurrent", description="Read the actual current")
    public double readCurrent() {
        double curr = 0.0;
        try {
            if (this.n64.isOkToTalk()) {
                this.lastCurrent = curr = this.n64.readCurrent();
                this.kstate = TSState.pwrstates.ON;
            } else {
                curr = this.lastCurrent;
            }
        }
        catch (DriverException e) {
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
            this.log.error((Object)"Keithley driver failed to retrieve the current measurement!");
        }
        return curr;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="isAccumInProgress", description="Are the current readings being accumulated")
    public boolean isAccumInProgress() {
        return this.n64.isAccumInProgress();
    }

    @Override
    @Command(name="setCurrentLimit", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(description="Current limit to set") double value) throws DriverException {
        this.n64.setCurrentLimit(value);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException {
        return "Current limit = " + this.n64.getCurrentLimit();
    }

    @Override
    @Command(name="setRate", description="sets the read rate in plc")
    public void setRate(@Argument(description="number of PLC") double rate) throws DriverException {
        this.n64.setRate(rate);
    }

    @Override
    @Command(name="setOutput", description="Turn output on or off. 1 ==> ON")
    public void setOutput(@Argument(description="Output state: on or off") int state) throws DriverException {
        if (this.kstate.equals((Object)TSState.pwrstates.OK) || this.kstate.equals((Object)TSState.pwrstates.OFF) || this.kstate.equals((Object)TSState.pwrstates.ON)) {
            this.n64.setOutput(state == 1);
        } else {
            this.log.error((Object)("Unable to set output because state = " + this.kstate.toString()));
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="showoutput", description="Show the output state")
    public boolean showOutput() throws DriverException {
        return this.n64.getOutput();
    }

    StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    @Override
    @Command(name="setTimeout", description="set timeout for Keithley SCPI communication")
    public void setTimeout(@Argument(name="nsec", description="length of timeout in seconds") double nsec) {
        try {
            this.n64.setTimeout(nsec);
        }
        catch (DriverException ex) {
            this.log.error((Object)"Failed to set keithley scpi timeout:", (Throwable)ex);
        }
    }

    @Override
    @Command(name="reset", description="reset trips etc...")
    public void reset() {
        if (!this.kstate.equals((Object)TSState.pwrstates.TRIPPED)) {
            try {
                this.n64.reset();
                this.n64.setTrip(false);
                this.kstate = TSState.pwrstates.ON;
            }
            catch (Exception ex) {
                this.log.error((Object)"failed attempt to reset device:", (Throwable)ex);
                this.kstate = TSState.pwrstates.NOTCONFIGURED;
            }
        } else {
            this.log.error((Object)("Unable to set output because state = " + this.kstate.toString() + "MUST USE SUBSYSTEM resetTrip COMMAND TO RECOVER"));
        }
        this.kstate = TSState.pwrstates.OFF;
    }

    @Override
    @Command(name="softReset", description="soft reset etc...")
    public void softReset() {
        if (!this.kstate.equals((Object)TSState.pwrstates.TRIPPED)) {
            try {
                this.n64.softReset();
                this.log.info((Object)"Keithley soft reset performed.");
                this.n64.setTrip(false);
                this.n64.setOKTOTALK(true);
                this.kstate = TSState.pwrstates.ON;
            }
            catch (Exception ex) {
                this.log.error((Object)"failed attempt to softreset device:", (Throwable)ex);
                this.kstate = TSState.pwrstates.NOTCONFIGURED;
            }
        } else {
            this.log.error((Object)("Unable to set output because state = " + this.kstate.toString() + "MUST USE SUBSYSTEM resetTrip COMMAND TO RECOVER"));
        }
    }

    @Override
    @Command(name="setrunbias", description="Sets the bias value for acquisition")
    public void setRunBias(double runBias, int cfgstate) {
        this.runBias[cfgstate] = runBias;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getRunBias", description="Returns the bias value for acquisition")
    public double getRunBias(int cfgstate) {
        return this.runBias[cfgstate];
    }

    @Override
    @Command(name="abort", description="abort or clear abort for any long operation")
    public void setAbort(boolean state) {
        this.n64.setAbort(state);
    }

    @Override
    @Command(name="setstate", description="set keithley device status")
    public void setState(int istate) {
        if (istate == TSState.pwrstates.TRIPPED.ordinal()) {
            this.n64.setTrip(true);
        }
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getState", description="get keithley device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    public boolean isDoPDPlot() {
        return this.doPDPlot;
    }

    @Override
    @Command(description="set whether PD plots are produced")
    public void setDoPDPlot(@Argument(description="true for do plots") boolean doPDPlot) {
        this.doPDPlot = doPDPlot;
    }

    @Override
    @Command(name="send", description="write a string to the device")
    public void send(String str) throws DriverException {
        this.n64.writeKthly(str);
    }

    @Override
    @Command(name="send", description="write a string to the device")
    public void send(String str1, String str2) throws DriverException {
        this.n64.writeKthly(str1 + " " + str2);
    }

    @Override
    @Command(name="query", description="write a command and read response")
    public String query(String str) throws DriverException {
        return this.n64.readStringKthly(str);
    }

    @Override
    @Command(name="query", description="write a command and read response")
    public String query(String str1, String str2) throws DriverException {
        return this.n64.readStringKthly(str1 + " " + str2);
    }

    static {
        connTypeMap.put("FTDI", DriverConstants.ConnType.FTDI);
        connTypeMap.put("SERIAL", DriverConstants.ConnType.SERIAL);
    }
}

