import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.TS8Bench;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.KeithleySimDevice;
import org.lsst.ccs.subsystem.teststand.Cornerstone260Device;
import org.lsst.ccs.subsystem.teststand.Cornerstone260SimDevice;
import org.lsst.ccs.subsystem.teststand.NewportLampDevice;
import org.lsst.ccs.subsystem.teststand.NewportLampSimDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["ts8-bench"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");

Class keithleyClass = Class.forName("org.lsst.ccs.subsystem.teststand.Keithley" + (runMode.equals("simulation") ? "Sim" : "") + "Device");
Class monochromatorClass = Class.forName("org.lsst.ccs.subsystem.teststand.Cornerstone260" + (runMode.equals("simulation") ? "Sim" : "") + "Device");
Class lamClass = Class.forName("org.lsst.ccs.subsystem.teststand.NewportLamp" + (runMode.equals("simulation") ? "Sim" : "") + "Device");
Class thorlabsFWClass = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsFWDevice");
Class thorlabsSC10Class = Class.forName("org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device");


taskConfig = ["monitor-update/taskPeriodMillis":60000,"monitor-publish/taskPeriodMillis":60000]

builder.
    main (TS8Bench, nodeTags:taskConfig) {

    Lamp  (lamClass, host:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104RVHX-if00-port0", port:9600) {       
        lamppower  (Channel, description:"Lamp Power", units:"W",devcName:"Lamp", hwChan:0, type:"Watts")
        lampcurrent  (Channel, description:"Lamp Current", units:"A",devcName:"Lamp", hwChan:1, type:"Amps")
    }    
    
    Monitor  (keithleyClass, devName:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104RVHN-if00-port0", baudRate:9600, connType:"serial")
    /*
    {
        mon_voltage  (Channel,
            description:"photodiode supply voltage", units:"V",
            devcName:"Monitor", hwChan:KeithleyDevice.CHAN_VOLTAGE, offset:0.0, scale:1.0,
            checkLo:"alarm", limitLo:-74.0, dbandLo:0.0, alarmLo:"AlarmHDWPD",
            checkHi:"alarm",   limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWPD")
        
        mon_current  (Channel,
            description:"photodiode supply current", units:"I",
            devcName:"Monitor", hwChan:KeithleyDevice.CHAN_CURRENT, offset:0.0, scale:1.0,
            checkLo:"alarm", limitLo:-1.0e6, dbandLo:0.0, alarmLo:"AlarmHDWPD",
            checkHi:"alarm",  limitHi:1.0e6, dbandHi:0.0, alarmHi:"AlarmHDWPD")
    }
            */

    Calibration  (keithleyClass, devName:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104RVHP-if00-port0", baudRate:9600, connType:"serial")
     /*
    {
        cal_voltage  (Channel,
            description:"photodiode supply voltage", units:"V",
            devcName:"Calibration", hwChan:KeithleyDevice.CHAN_VOLTAGE, offset:0.0, scale:1.0,
            checkLo:"alarm", limitLo:-74.0, dbandLo:0.0, alarmLo:"AlarmHDWPD",
            checkHi:"alarm",   limitHi:2.0, dbandHi:0.0, alarmHi:"AlarmHDWPD")
        
        cal_current  (Channel,
            description:"Calibration supply current", units:"I",
            devcName:"Calibration", hwChan:KeithleyDevice.CHAN_CURRENT, offset:0.0, scale:1.0,
            checkLo:"alarm", limitLo:-1.0e6, dbandLo:0.0, alarmLo:"AlarmHDWPD",
            checkHi:"alarm",  limitHi:1.0e6, dbandHi:0.0, alarmHi:"AlarmHDWPD")        
    }
            */

    Monochromator (monochromatorClass, host:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104RVHO-if00-port0", baud:9600, connType:"serial",
        filter_edges:[0.0,1.0,335.0,525.0,620.0,790.0], filter_label:['empty1','empty2','Edge305','Edge495','Edge590','Edge760'])

    {
     /*
 monochromatordefaultwavelength  (Channel,
            description:"Wavelength", units:"A",
            devcName:"Monochromator", hwChan:-1, type:"UNKNOWN", subtype:"A", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2000.0, dbandHi:0.0, alarmHi:null)
*/
        monochromatorwavelength  (Channel,
            description:"Wavelength", units:"A",
            devcName:"Monochromator", hwChan:0, type:"UNKNOWN", subtype:"A", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2000.0, dbandHi:0.0, alarmHi:null)

        monochromatorslit1  (Channel,
            description:"slit 1 width", units:"nm",
            devcName:"Monochromator", hwChan:3, type:"UNKNOWN", subtype:"nm", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2000.0, dbandHi:0.0, alarmHi:null)

        monochromatorslit2  (Channel,
            description:"slit 2 width", units:"nm",
            devcName:"Monochromator", hwChan:4, type:"UNKNOWN", subtype:"nm", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2000.0, dbandHi:0.0, alarmHi:null)

        monochromgrating  (Channel,
            description:"Grating Position", units:"1",
            devcName:"Monochromator", hwChan:5, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:4.0, dbandHi:0.0, alarmHi:null)

        monochromstep  (Channel,
            description:"Grating Steps", units:"1",
            devcName:"Monochromator", hwChan:7, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2000.0, dbandHi:0.0, alarmHi:null)

        monochromband  (Channel,
            description:"bandwidth", units:"1",
            devcName:"Monochromator", hwChan:6, type:"UNKNOWN", subtype:"1", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2000.0, dbandHi:0.0, alarmHi:null)
/*
        shutteropen  (Channel,
            description:"Shutter Open/Closed", units:"S",
            devcName:"Monochromator", hwChan:1, type:"UNKNOWN", subtype:"S", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:2.0, dbandHi:0.0, alarmHi:null)
*/
        filter1position  (Channel,
            description:"Filter Position", units:"F",
            devcName:"Monochromator", hwChan:2, type:"UNKNOWN", subtype:"F", offset:0.0, scale:1.0,
            checkLo:"flag",limitLo:0.0, dbandLo:0.0, alarmLo:null,
            checkHi:"flag", limitHi:7.0, dbandHi:0.0, alarmHi:null)

    }

    SpotProjFWheel (thorlabsFWClass, devcId:"",
        //devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Cable_FT1RAJQE-if00-port0", 
        fwsize:12, speedMode:true, sensorMode:false,
        filterNames:["Mask_grid","Mask_spot","empty3","empty4","empty5","empty6"])
    {
        SpotProjFWheelPos (Channel, 
                           description:"Spot projector filter wheel position",
                           devcName:"SpotProjFWheel", type:"POSITION",
                           format:"%.0f", checkLo:"none", checkHi:"none")
    }

    ProjectorShutter (thorlabsSC10Class, devcId:"",
       //devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Cable_FT1RAJQE-if01-port0", 
       outputMode:false)
    {
    }

//    AlarmHDWPD (Alarm, eventParm:TSConfig.EVENT_ID.PD.ordinal())


}
